/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.delegates;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import org.modellwerkstatt.fx8forms.windows.FX8TraversalHelper;

@Deprecated
public class AutoCompleteContextMenu
extends TextField {
    private ContextMenu contextMenu = new ContextMenu();
    private List<String> items;
    private boolean populateContextMenu = true;
    private IDataUxDelegate delegate;

    @Deprecated
    public AutoCompleteContextMenu() {
        this.contextMenu.addEventFilter(KeyEvent.ANY, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode().equals((Object)KeyCode.ESCAPE)) {
                    keyEvent.consume();
                    if (keyEvent.getEventType().equals(KeyEvent.KEY_RELEASED)) {
                        AutoCompleteContextMenu.this.contextMenu.hide();
                    }
                } else if (keyEvent.getCode().equals((Object)KeyCode.ENTER) && keyEvent.getEventType().equals(KeyEvent.KEY_RELEASED)) {
                    FX8TraversalHelper.traverseNext((Node)AutoCompleteContextMenu.this);
                    keyEvent.consume();
                }
            }
        });
        this.addEventFilter(KeyEvent.ANY, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getEventType().equals(KeyEvent.KEY_TYPED) && keyEvent.isControlDown() && keyEvent.getCharacter().trim().equals("")) {
                    keyEvent.consume();
                    AutoCompleteContextMenu.this.showCompletionAndBind(true, false);
                }
            }
        });
        this.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (AutoCompleteContextMenu.this.populateContextMenu && AutoCompleteContextMenu.this.getScene() != null) {
                    if (newValue.length() == 0) {
                        if (AutoCompleteContextMenu.this.contextMenu != null) {
                            AutoCompleteContextMenu.this.contextMenu.hide();
                        }
                    } else {
                        AutoCompleteContextMenu.this.showCompletionAndBind(false, false);
                    }
                }
            }
        });
        this.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    AutoCompleteContextMenu.this.showCompletionAndBind(false, true);
                    if (AutoCompleteContextMenu.this.contextMenu.isShowing()) {
                        AutoCompleteContextMenu.this.contextMenu.hide();
                    }
                    AutoCompleteContextMenu.this.delegate.isInputValid();
                }
                if (AutoCompleteContextMenu.this.getOnKeyTyped() != null) {
                    AutoCompleteContextMenu.this.getOnKeyTyped().handle(null);
                }
            }
        });
        this.items = ListSequence.fromList(new ArrayList());
    }

    public void setDelegate(IDataUxDelegate dlgt) {
        this.delegate = dlgt;
    }

    private void populateMenu(List<String> items) {
        this.contextMenu.getItems().clear();
        for (String result : items) {
            Label itemLabel = new Label(result);
            CustomMenuItem menuItem = new CustomMenuItem((Node)itemLabel, true);
            menuItem.setUserData((Object)itemLabel.getText());
            this.contextMenu.getItems().add((Object)menuItem);
            menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    AutoCompleteContextMenu.this.setItem((String)((CustomMenuItem)actionEvent.getSource()).getUserData());
                    if (AutoCompleteContextMenu.this.getOnKeyTyped() != null) {
                        AutoCompleteContextMenu.this.getOnKeyTyped().handle(null);
                    }
                }
            });
        }
    }

    public void setItems(List<String> items) {
        this.items = items;
    }

    public String getItem() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.getText().toLowerCase().equals(this.items.get(i).toLowerCase())) continue;
            return this.items.get(i);
        }
        return null;
    }

    public void setItem(String item) {
        if (item != null) {
            for (int i = 0; i < this.items.size(); ++i) {
                if (!item.toLowerCase().equals(this.items.get(i).toLowerCase())) continue;
                this.populateContextMenu = false;
                this.setText(this.items.get(i));
                this.selectAll();
                this.delegate.isInputValid();
                this.populateContextMenu = true;
                return;
            }
            if (this.items.size() > 0) {
                String error = "'" + item + "' not in reference scope (len " + this.items.size() + "). programming error.";
                this.setText(error);
                throw new RuntimeException(error);
            }
            this.populateContextMenu = false;
            this.setText(item);
            this.selectAll();
            this.delegate.isInputValid();
            this.populateContextMenu = true;
        } else {
            this.populateContextMenu = false;
            this.setText("");
            this.populateContextMenu = true;
        }
    }

    public List<String> filterItems(String searchText) {
        searchText = searchText.toLowerCase();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).toLowerCase().contains(searchText)) continue;
            result.add(this.items.get(i));
        }
        return result;
    }

    public void showCompletionAndBind(boolean all, boolean focusChanged) {
        List<String> results;
        String text = this.getText().trim();
        if (text.trim().equals("")) {
            all = true;
        }
        if ((results = all ? this.items : this.filterItems(text)).size() >= 20) {
            results = results.subList(0, 20);
        }
        if (focusChanged && results.size() == 1 && !all) {
            this.setItem(results.get(0));
            if (this.getOnKeyTyped() != null) {
                this.getOnKeyTyped().handle(null);
            }
            if (this.contextMenu.isShowing()) {
                this.contextMenu.hide();
            }
        } else if (!focusChanged) {
            this.populateMenu(results);
            if (!this.contextMenu.isShowing()) {
                this.contextMenu.show((Node)this, Side.BOTTOM, 10.0, -5.0);
            }
            this.contextMenu.requestFocus();
        }
    }
}

