/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.delegates;

import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;

public class DatePatternField
extends TextField {
    private String pattern = "__.__.__";
    private int patternLength = 8;
    private char divisionChar = (char)46;
    private char[] replacementsChars = new char[]{','};
    private IDataUxDelegate delegate;

    public DatePatternField() {
        this.init();
    }

    public DatePatternField(String ptrn, char divChar, char[] rplcmntChars) {
        this.pattern = ptrn;
        this.patternLength = ptrn.length();
        this.divisionChar = divChar;
        this.replacementsChars = rplcmntChars;
        this.init();
    }

    public void init() {
        this.setMinHeight(26.0);
        this.setAlignment(Pos.CENTER_LEFT);
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent moEvent) {
                DatePatternField.this.selectAll();
            }
        });
        this.setPromptText(this.pattern);
    }

    public void replaceText(int start, int end, String text) {
        for (char c : this.replacementsChars) {
            if (text.indexOf(c) < 0) continue;
            text = text.replace(c, this.divisionChar);
        }
        super.replaceText(start, end, text);
        if (text.length() == 1 && this.isOnlyPatternChars(text)) {
            if (++start < this.patternLength) {
                if (start >= this.getText().length()) {
                    start = this.getText().length();
                }
                this.setText(this.getText().substring(0, start) + this.pattern.substring(start));
                if (this.getText().charAt(start) == this.divisionChar) {
                    ++start;
                }
                this.positionCaret(start);
            } else {
                start = this.getText().length();
                if (start >= this.patternLength) {
                    start = this.patternLength;
                }
                this.setText(this.getText().substring(0, start));
                this.selectAll();
            }
        } else if ("".equals(text)) {
            int currentCaretPosition = this.getCaretPosition();
            if (start < this.patternLength) {
                this.setText(this.getText().substring(0, start) + this.pattern.substring(start));
                this.positionCaret(currentCaretPosition);
            } else {
                start = this.patternLength;
                this.setText(this.getText().substring(0, start));
                this.selectAll();
            }
        } else if (text.length() >= this.patternLength) {
            this.setText(text.substring(0, this.patternLength));
            this.selectAll();
        } else {
            this.setText(text + this.pattern.substring(text.length()));
            this.positionCaret(text.length());
        }
        if (this.delegate != null) {
            this.delegate.isInputValid();
        }
    }

    public String getTextOrEmpty() {
        String text = this.getText();
        if (this.pattern.equals(text)) {
            return "";
        }
        return text;
    }

    public boolean isOnlyPatternChars(String st) {
        for (int i = 0; i < st.length(); ++i) {
            if (st.charAt(i) == this.divisionChar || Character.isDigit(st.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void setDelegate(IDataUxDelegate dlgt) {
        this.delegate = dlgt;
    }
}

