/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.delegates;

import java.util.Map;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.fx8forms.delegates.FX8EditorWithOptions;
import org.modellwerkstatt.fx8forms.delegates.FX8TextEditor;
import org.modellwerkstatt.fx8forms.windows.FX8Application;

public class FX8AreaEditor
extends FX8EditorWithOptions
implements IToolkit_TextEditor,
EventHandler<KeyEvent> {
    public static int aproxEditHeigfht = 19;
    protected TextArea textArea;
    protected Label label = new Label();
    protected IDataUxDelegate delegate;
    protected boolean notifyDelegateOnKeyPress = false;

    public FX8AreaEditor(int numLines) {
        this.label.getStyleClass().add((Object)"delegateLabel");
        this.label.setLabelFor((Node)this.textArea);
        this.label.setAlignment(Pos.TOP_RIGHT);
        this.textArea = new TextArea();
        this.textArea.setWrapText(true);
        this.textArea.getStyleClass().add((Object)"delegateControl");
        this.textArea.setPrefHeight((double)(aproxEditHeigfht * numLines));
        this.textArea.setMinHeight((double)(aproxEditHeigfht * numLines));
        this.label.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() == 2 && event.getButton().equals((Object)MouseButton.PRIMARY)) {
                    ClipboardContent allContent = new ClipboardContent();
                    allContent.putString(FX8AreaEditor.this.textArea.getText());
                    Clipboard.getSystemClipboard().setContent((Map)allContent);
                }
            }
        });
        this.textArea.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent p0) {
                if (!FX8AreaEditor.this.textArea.isDisabled() && FX8AreaEditor.this.textArea.getText().contains("\u20ac")) {
                    int pos = FX8AreaEditor.this.textArea.getCaretPosition();
                    FX8AreaEditor.this.textArea.setText(FX8AreaEditor.this.textArea.getText().replace("\u20ac", "EUR"));
                    FX8AreaEditor.this.textArea.positionCaret(pos + 2);
                }
                if (FX8AreaEditor.this.notifyDelegateOnKeyPress && FX8AreaEditor.this.delegate.isInputValid() == null) {
                    FX8AreaEditor.this.delegate.keyReleasedEvent();
                }
            }
        });
        this.textArea.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)this);
    }

    public void handle(KeyEvent event) {
        if (FX8Application.FX8_IS_HOTKEY_TO_FORWARD(event.getCode().getName(), false) && this.textArea.getScene() != null) {
            this.textArea.getScene().getOnKeyPressed().handle((Event)event);
        }
    }

    public void setDelegate(IDataUxDelegate dlgt) {
        this.delegate = dlgt;
    }

    public void enableKeyReleaseEvents() {
        this.notifyDelegateOnKeyPress = true;
    }

    public void setLabelTooltip(String t) {
        this.label.setTooltip(new Tooltip(t));
    }

    public void setValidationErrorText(String text) {
        if (text == null || text.trim().equals("")) {
            this.textArea.setStyle("-fx-border-color: -error-red; -fx-border-width: 0;");
            this.textArea.setTooltip(null);
        } else {
            this.textArea.setStyle("-fx-border-color: -error-red; -fx-border-width: 1;");
            this.textArea.setTooltip(new Tooltip(text));
        }
    }

    public void setLabel(String labelString) {
        this.label.setText(FX8TextEditor.getLabelTextAdjustColon(labelString));
        this.label.setMinWidth(FX8TextEditor.getLabelWidthWRKRND(labelString));
    }

    public void setEditorPrompt(String promptText) {
        this.textArea.setPromptText(promptText);
    }

    public void setEnabled(boolean enabled) {
        this.textArea.setEditable(enabled);
        if (!enabled) {
            this.textArea.setStyle("-fx-text-fill: -lightdark;");
        } else {
            this.textArea.setStyle("-fx-text-fill:  -fx-accent;");
        }
    }

    public void setText(String text) {
        this.textArea.setText(text);
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setIssuesUpdateConclusion() {
        throw new RuntimeException("Update Conclusion not supported for FX8AreaEditor..");
    }

    public Object getEditor() {
        return this.textArea;
    }

    public Object getLabel() {
        return this.label;
    }

    public Object getRightPartComponent() {
        return this.getEditor();
    }

    public void newObjectBound() {
    }

    public void gcClear() {
        this.textArea.setOnKeyReleased(null);
        this.textArea.removeEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)this);
    }
}

