/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.delegates;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.util.StringConverter;
import org.modellwerkstatt.dataux.runtime.delegates.LocalDateDelegate;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_DateOrTimeEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.fx8forms.delegates.FX8TextEditor;
import org.modellwerkstatt.fx8forms.windows.FX8Application;
import org.modellwerkstatt.fx8forms.windows.FX8TraversalHelper;
import org.modellwerkstatt.objectflow.runtime.MoWareFormattersFactory;

public class FX8DatePicker
implements IToolkit_DateOrTimeEditor,
EventHandler<KeyEvent> {
    protected DatePicker datePicker = new DatePicker();
    protected Label label;
    protected IDataUxDelegate delegate;
    protected EventHandler<KeyEvent> keyReleaseHandler;
    protected DateTimeFormatter javaUtilDateTimeFormatter;

    public FX8DatePicker() {
        this.datePicker.setConverter((StringConverter)new StringConverter<LocalDate>(){

            public String toString(LocalDate p1) {
                return p1 == null ? "" : FX8DatePicker.this.javaUtilDateTimeFormatter.format(p1);
            }

            public LocalDate fromString(String p1) {
                if (p1 == null || p1.equals("")) {
                    return null;
                }
                LocalDate notAdjusted = LocalDate.parse(LocalDateDelegate.adjusDateDotInputText((String)p1), FX8DatePicker.this.javaUtilDateTimeFormatter);
                LocalDate adjusted = notAdjusted.withYear(MoWareFormattersFactory.twoToFourDigitYear((int)notAdjusted.getYear()));
                return adjusted;
            }
        });
        this.label = new Label();
        this.label.getStyleClass().add((Object)"delegateLabel");
        this.label.setLabelFor((Node)this.datePicker);
        this.label.setAlignment(Pos.TOP_RIGHT);
        this.datePicker.setMinHeight(26.0);
        this.label.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() == 2 && event.getButton().equals((Object)MouseButton.PRIMARY)) {
                    ClipboardContent allContent = new ClipboardContent();
                    allContent.putString("" + FX8DatePicker.this.datePicker.getValue());
                    Clipboard.getSystemClipboard().setContent((Map)allContent);
                }
            }
        });
        this.datePicker.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)this);
        this.datePicker.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> p1, Boolean old, Boolean newFocus) {
                if (newFocus.booleanValue()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            FX8DatePicker.this.datePicker.getEditor().selectAll();
                        }
                    });
                }
            }
        });
    }

    public void setFormatter(String format, String locale, int langIdx) {
        this.javaUtilDateTimeFormatter = DateTimeFormatter.ofPattern(format, Locale.forLanguageTag(locale));
    }

    public void handle(KeyEvent event) {
        if (FX8Application.FX8_IS_HOTKEY_TO_FORWARD(event.getCode().getName(), false) && this.datePicker.getScene() != null) {
            this.datePicker.getScene().getOnKeyPressed().handle((Event)event);
        } else if (event.getCode() == KeyCode.TAB && !event.isShiftDown() || event.getCode() == KeyCode.ENTER) {
            event.consume();
            FX8TraversalHelper.traverseNext((Node)this.datePicker);
        } else if (event.getCode() == KeyCode.TAB && event.isShiftDown()) {
            event.consume();
            FX8TraversalHelper.traversePrevious((Node)this.datePicker);
        }
    }

    public void setDelegate(IDataUxDelegate dlgt) {
        this.delegate = dlgt;
    }

    public void enableKeyReleaseEvents() {
    }

    public void setLabelTooltip(String t) {
        this.label.setTooltip(new Tooltip(t));
    }

    public void setValidationErrorText(String text) {
        if (text == null || text.trim().equals("")) {
            this.datePicker.setStyle("-fx-border-color: -error-red; -fx-border-width: 0;");
            this.datePicker.setTooltip(null);
        } else {
            this.datePicker.setStyle("-fx-border-color: -error-red; -fx-border-width: 1;");
            this.datePicker.setTooltip(new Tooltip(text));
        }
    }

    public void setLabel(String labelString) {
        this.label.setText(FX8TextEditor.getLabelTextAdjustColon(labelString));
        this.label.setMinWidth(FX8TextEditor.getLabelWidthWRKRND(labelString));
    }

    public void setEnabled(boolean enabled) {
        this.datePicker.setDisable(!enabled);
    }

    public void newObjectBound() {
    }

    public void setText(String text) {
        if (this.noValue(text)) {
            this.datePicker.setValue(null);
        } else {
            this.datePicker.getEditor().setText(text);
            LocalDate notAdjusted = LocalDate.parse(text, this.javaUtilDateTimeFormatter);
            LocalDate adjusted = notAdjusted.withYear(MoWareFormattersFactory.twoToFourDigitYear((int)notAdjusted.getYear()));
            this.datePicker.setValue((Object)adjusted);
        }
    }

    public String getText() {
        LocalDate dateFromPicker = (LocalDate)this.datePicker.getValue();
        String textFieldText = LocalDateDelegate.adjusDateDotInputText((String)this.datePicker.getEditor().getText().trim());
        if (dateFromPicker == null) {
            return textFieldText;
        }
        String pickerFieldText = this.javaUtilDateTimeFormatter.format(dateFromPicker);
        if (!textFieldText.equals(pickerFieldText)) {
            this.datePicker.setValue(null);
            this.datePicker.getEditor().setText(textFieldText);
            return textFieldText;
        }
        return pickerFieldText;
    }

    private boolean noValue(String txt) {
        return txt == null || "".equals(txt.trim());
    }

    public void setIssuesUpdateConclusion() {
    }

    public Object getEditor() {
        return this.datePicker;
    }

    public Object getLabel() {
        return this.label;
    }

    public Object getRightPartComponent() {
        return this.datePicker;
    }

    public void setEditorPrompt(String promptText) {
        this.datePicker.setPromptText(promptText);
    }

    public void setOption(IToolkit_TextEditor.Option ... option) {
    }

    public void gcClear() {
        this.datePicker.getEditor().removeEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)this);
    }
}

