/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.delegates;

import java.util.List;
import java.util.Map;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_ReferenceEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.fx8forms.delegates.AutoCompletePopupField;
import org.modellwerkstatt.fx8forms.delegates.FX8TextEditor;

public class FX8ReferenceEditor
implements IToolkit_ReferenceEditor {
    protected AutoCompletePopupField autoCompleteField;
    protected Node complexRightPart;
    protected Button updateConclusionButton;
    protected Label label = new Label();
    protected IDataUxDelegate delegate;

    public FX8ReferenceEditor() {
        this.label.getStyleClass().add((Object)"delegateLabel");
        this.label.setLabelFor((Node)this.autoCompleteField);
        this.label.setAlignment(Pos.TOP_RIGHT);
        this.autoCompleteField = new AutoCompletePopupField();
        this.autoCompleteField.getStyleClass().add((Object)"delegateControl");
        this.autoCompleteField.setMinHeight(26.0);
        this.autoCompleteField.setPrefWidth(250.0);
        this.complexRightPart = this.autoCompleteField;
        this.label.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() == 2 && event.getButton().equals((Object)MouseButton.PRIMARY)) {
                    ClipboardContent allContent = new ClipboardContent();
                    allContent.putString(FX8ReferenceEditor.this.autoCompleteField.getText());
                    Clipboard.getSystemClipboard().setContent((Map)allContent);
                }
            }
        });
    }

    public void setDelegate(IDataUxDelegate dlgt) {
        this.delegate = dlgt;
        this.autoCompleteField.setDelegate(this.delegate);
    }

    public void enableKeyReleaseEvents() {
        this.autoCompleteField.issueBoundEvent();
    }

    public void setLabelTooltip(String t) {
        this.label.setTooltip(new Tooltip(t));
    }

    public void setValidationErrorText(String text) {
        if (text == null || text.trim().equals("")) {
            this.autoCompleteField.setStyle("-fx-border-color: -error-red; -fx-border-width: 0;");
            this.autoCompleteField.setTooltip(null);
        } else {
            this.autoCompleteField.setStyle("-fx-border-color: -error-red; -fx-border-width: 1;");
            this.autoCompleteField.setTooltip(new Tooltip(text));
        }
    }

    public void setLabel(String labelString) {
        this.label.setText(FX8TextEditor.getLabelTextAdjustColon(labelString));
        this.label.setMinWidth(FX8TextEditor.getLabelWidthWRKRND(labelString));
    }

    public void setEnabled(boolean enabled) {
        this.autoCompleteField.setDisable(!enabled);
        if (this.updateConclusionButton != null) {
            this.updateConclusionButton.setDisable(!enabled);
        }
    }

    public void newObjectBound() {
        this.autoCompleteField.newObjectBound();
    }

    public void setText(String text) {
        this.autoCompleteField.setItem(text);
    }

    public String getText() {
        return this.autoCompleteField.getItem();
    }

    public void setItems(List<String> items) {
        this.autoCompleteField.setItems(items);
    }

    public void setEditorPrompt(String promptText) {
        this.autoCompleteField.setPromptText(promptText);
    }

    public void setIssuesUpdateConclusion() {
        HBox box = new HBox();
        this.updateConclusionButton = FX8TextEditor.createUpdateButton();
        this.updateConclusionButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent p0) {
                String text = FX8ReferenceEditor.this.autoCompleteField.getText().trim();
                if (FX8ReferenceEditor.this.delegate.isInputValid() == null) {
                    String item = FX8ReferenceEditor.this.autoCompleteField.getItem();
                    if (FX8ReferenceEditor.this.autoCompleteField.provideHintEnabled && item == null && !text.equals("")) {
                        FX8ReferenceEditor.this.autoCompleteField.setText(text);
                        FX8ReferenceEditor.this.autoCompleteField.provideHint();
                    } else {
                        FX8ReferenceEditor.this.autoCompleteField.setLastItemIssuedUpdate(item);
                        FX8ReferenceEditor.this.delegate.issueUpdateConclusionAfterContentChange();
                    }
                }
            }
        });
        box.getChildren().addAll((Object[])new Node[]{this.autoCompleteField, this.updateConclusionButton});
        HBox.setHgrow((Node)this.autoCompleteField, (Priority)Priority.ALWAYS);
        this.complexRightPart = box;
        this.autoCompleteField.setIssueUpdate();
    }

    public Object getEditor() {
        return this.autoCompleteField;
    }

    public Object getLabel() {
        return this.label;
    }

    public Object getRightPartComponent() {
        return this.complexRightPart;
    }

    public void setOptionalAfterLoad(boolean optional) {
        this.autoCompleteField.setOptional(optional);
    }

    public void setOption(IToolkit_TextEditor.Option ... option) {
        if (IToolkit_TextEditor.has((IToolkit_TextEditor.Option)IToolkit_TextEditor.Option.PROVIDE_HINT, (IToolkit_TextEditor.Option[])option)) {
            this.autoCompleteField.setProvideHint();
        }
    }

    public void gcClear() {
        this.autoCompleteField.setOnKeyReleased(null);
        this.autoCompleteField.setDelegate(null);
    }
}

