/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.delegates;

import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_StatusEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.fx8forms.delegates.FX8TextEditor;
import org.modellwerkstatt.fx8forms.windows.FX8Application;
import org.modellwerkstatt.fx8forms.windows.FX8TraversalHelper;

public class FX8StatusEditor
implements IToolkit_StatusEditor,
EventHandler<KeyEvent> {
    protected ComboBox comboBox;
    protected Label label = new Label();
    protected Node complexRightPart;
    protected Button updateConclusionButton;
    protected IDataUxDelegate delegate;
    protected boolean notifyDelegateOnKeyPress = false;
    protected boolean issueUpdateConclusion = false;
    protected boolean programmaticValueChange = false;
    protected int lastIndexIssuedUpdate = -1;
    protected ChangeListener<Object> changeListener = null;

    public FX8StatusEditor() {
        this.label.getStyleClass().add((Object)"delegateLabel");
        this.label.setLabelFor((Node)this.comboBox);
        this.label.setAlignment(Pos.TOP_RIGHT);
        this.comboBox = new ComboBox();
        this.comboBox.getStyleClass().add((Object)"delegateControl");
        this.comboBox.setMinHeight(26.0);
        this.comboBox.setMaxHeight(26.0);
        this.comboBox.setPrefWidth(250.0);
        this.complexRightPart = this.comboBox;
        this.label.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() == 2 && event.getButton().equals((Object)MouseButton.PRIMARY)) {
                    ClipboardContent allContent = new ClipboardContent();
                    allContent.putString(FX8StatusEditor.this.comboBox.getSelectionModel().getSelectedItem().toString());
                    Clipboard.getSystemClipboard().setContent((Map)allContent);
                }
            }
        });
        this.comboBox.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)this);
    }

    public void handle(KeyEvent event) {
        if (FX8Application.FX8_IS_HOTKEY_TO_FORWARD(event.getCode().getName(), true) && this.comboBox.getScene() != null) {
            this.comboBox.getScene().getOnKeyPressed().handle((Event)event);
        } else if (event.getCode() == KeyCode.TAB && !event.isShiftDown() || event.getCode() == KeyCode.ENTER) {
            event.consume();
            if (this.issueUpdateConclusion && this.getSelectedIndex() != this.lastIndexIssuedUpdate && !this.comboBox.isDisabled()) {
                this.lastIndexIssuedUpdate = this.getSelectedIndex();
                this.delegate.issueUpdateConclusionAfterContentChange();
            } else {
                FX8TraversalHelper.traverseNext((Node)this.comboBox);
            }
        } else if (event.getCode() == KeyCode.TAB && event.isShiftDown()) {
            event.consume();
            FX8TraversalHelper.traversePrevious((Node)this.comboBox);
        }
    }

    public void setDelegate(IDataUxDelegate dlgt) {
        this.delegate = dlgt;
    }

    public void enableKeyReleaseEvents() {
        this.notifyDelegateOnKeyPress = true;
        this.comboBox.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent p0) {
                if (FX8StatusEditor.this.notifyDelegateOnKeyPress) {
                    FX8StatusEditor.this.delegate.keyReleasedEvent();
                }
            }
        });
    }

    public void setLabelTooltip(String t) {
        this.label.setTooltip(new Tooltip(t));
    }

    public void setEditorPrompt(String promptText) {
        this.comboBox.setPromptText(promptText);
    }

    public void setValidationErrorText(String text) {
        if (text == null || text.trim().equals("")) {
            this.comboBox.setStyle("-fx-border-color: red; -fx-border-width: 0;");
            this.comboBox.setTooltip(null);
        } else {
            this.comboBox.setStyle("-fx-border-color: red; -fx-border-width: 1;");
            this.comboBox.setTooltip(new Tooltip(text));
        }
    }

    public void setLabel(String labelString) {
        this.label.setText(FX8TextEditor.getLabelTextAdjustColon(labelString));
        this.label.setMinWidth(FX8TextEditor.getLabelWidthWRKRND(labelString));
    }

    public void setEnabled(boolean enabled) {
        this.comboBox.setDisable(!enabled);
        if (this.updateConclusionButton != null) {
            this.updateConclusionButton.setDisable(!enabled);
        }
    }

    public void newObjectBound() {
        this.lastIndexIssuedUpdate = -1;
    }

    public void setText(String text) {
        throw new RuntimeException("not implemented.");
    }

    public String getText() {
        throw new RuntimeException("not implemented.");
    }

    public int getSelectedIndex() {
        return this.comboBox.getSelectionModel().getSelectedIndex();
    }

    public void setSelectedIndex(int i) {
        this.programmaticValueChange = true;
        this.comboBox.getSelectionModel().select(i);
        this.programmaticValueChange = false;
    }

    public void setItems(List<String> items) {
        this.programmaticValueChange = true;
        this.comboBox.getItems().clear();
        this.comboBox.getItems().addAll(items);
        this.programmaticValueChange = false;
    }

    public void setIssuesUpdateConclusion() {
        HBox box = new HBox();
        this.updateConclusionButton = FX8TextEditor.createUpdateButton();
        this.updateConclusionButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent p0) {
                FX8StatusEditor.this.lastIndexIssuedUpdate = FX8StatusEditor.this.getSelectedIndex();
                FX8StatusEditor.this.delegate.issueUpdateConclusionAfterContentChange();
            }
        });
        box.getChildren().addAll((Object[])new Node[]{this.comboBox, this.updateConclusionButton});
        HBox.setHgrow((Node)this.comboBox, (Priority)Priority.ALWAYS);
        this.complexRightPart = box;
        this.changeListener = new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> p0, Object p1, Object p2) {
                if (FX8StatusEditor.this.programmaticValueChange) {
                    return;
                }
                if (FX8StatusEditor.this.issueUpdateConclusion && FX8StatusEditor.this.getSelectedIndex() != FX8StatusEditor.this.lastIndexIssuedUpdate && !FX8StatusEditor.this.comboBox.isDisabled()) {
                    FX8StatusEditor.this.lastIndexIssuedUpdate = FX8StatusEditor.this.getSelectedIndex();
                    FX8StatusEditor.this.delegate.issueUpdateConclusionAfterContentChange();
                }
            }
        };
        this.comboBox.valueProperty().addListener(this.changeListener);
        this.issueUpdateConclusion = true;
    }

    public Object getEditor() {
        return this.comboBox;
    }

    public Object getLabel() {
        return this.label;
    }

    public Object getRightPartComponent() {
        return this.complexRightPart;
    }

    public void setOption(IToolkit_TextEditor.Option ... option) {
    }

    public void gcClear() {
        this.comboBox.removeEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)this);
        if (this.changeListener != null) {
            this.comboBox.valueProperty().removeListener(this.changeListener);
        }
        this.delegate = null;
    }
}

