/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.windows;

import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.dataux.runtime.utils.LayoutConstraint;

public class FX8ColFormContainer {
    private GridPane gridPane = new GridPane();
    private List<LayoutConstraint> colConstrains;
    private int colPos;

    public FX8ColFormContainer(List<LayoutConstraint> lc) {
        this.colConstrains = lc;
        this.colPos = 0;
        boolean usePxl = ListSequence.fromList(this.colConstrains).any(it -> it.isPxl());
        ListSequence.fromList(this.colConstrains).visitAll(it -> {
            ColumnConstraints colConstrain = new ColumnConstraints();
            if (it.isPxl()) {
                colConstrain.setPrefWidth((double)it.getPixl());
            } else if (!it.isMinimal()) {
                if (usePxl) {
                    colConstrain.setHgrow(Priority.ALWAYS);
                } else {
                    colConstrain.setPercentWidth((double)it.getInPercent());
                }
            }
            this.gridPane.getColumnConstraints().add((Object)colConstrain);
        });
    }

    public void addChild(Node child) {
        this.gridPane.add(child, this.colPos++, 0);
    }

    public Node getNode() {
        return this.gridPane;
    }
}

