/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.windows;

import java.util.ArrayList;
import java.util.List;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_DelegateForm;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.dataux.runtime.utils.LayoutConstraint;
import org.modellwerkstatt.fx8forms.delegates.FX8EditorWithOptions;
import org.modellwerkstatt.fx8forms.delegates.FX8ImageEditor;
import org.modellwerkstatt.fx8forms.windows.FX8FlagBox;
import org.modellwerkstatt.fx8forms.windows.FX8FormContainer;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;

public class FX8DelegateForm<T>
extends BorderPane
implements IToolkit_DelegateForm<T> {
    private List<LayoutConstraint> colContraints;
    private List<GridPane> colGrindPane;
    private List<IDataUxDelegate> delegates;
    private GridPane gridPane;
    private int curRowIndex;
    private int curColIndex;
    private FX8FlagBox titleLabel;
    private EventHandler<KeyEvent> enterHandler;

    public FX8DelegateForm() {
        this.getStyleClass().add((Object)"FX8DelegateForm");
        this.colGrindPane = ListSequence.fromList(new ArrayList());
        this.delegates = ListSequence.fromList(new ArrayList());
        this.curRowIndex = 0;
        this.curColIndex = 0;
    }

    public void initTitle() {
        this.titleLabel = new FX8FlagBox();
        BorderPane topPane = new BorderPane();
        topPane.setLeft((Node)this.titleLabel);
        this.setTop((Node)topPane);
    }

    public void setTitleText(String text) {
        if (this.getTop() == null) {
            this.initTitle();
        }
        this.titleLabel.setTitle(text);
    }

    public void rootForm() {
        if (this.getTop() == null) {
            this.initTitle();
        }
        this.titleLabel.inRootForm();
    }

    public void setProblems(List<IOFXProblem> listOfProblems) {
        if (this.getTop() == null && ListSequence.fromList(listOfProblems).count() == 0) {
            return;
        }
        if (this.getTop() == null) {
            this.initTitle();
        }
        if (ListSequence.fromList(listOfProblems).count() == 0) {
            this.titleLabel.flag(listOfProblems);
            this.getCenter().getStyleClass().remove((Object)FX8FormContainer.formFlagBorder);
        } else {
            this.getCenter().getStyleClass().add((Object)FX8FormContainer.formFlagBorder);
            this.titleLabel.flag(listOfProblems);
        }
    }

    public void loadList(List<T> objects, IOFXSelection<T> selection) {
    }

    public boolean selectionChanged(IOFXSelection<T> selection) {
        return false;
    }

    public void addDelegate(IDataUxDelegate dlgt) {
        ListSequence.fromList(this.delegates).addElement((Object)dlgt);
        IToolkit_TextEditor cmpt = dlgt.getDelegateUiImpl();
        if (cmpt instanceof FX8EditorWithOptions && ((FX8EditorWithOptions)cmpt).hasWideOption()) {
            ((GridPane)ListSequence.fromList(this.colGrindPane).getElement(this.curColIndex)).add((Node)cmpt.getRightPartComponent(), 0, this.curRowIndex, 2, 1);
        } else {
            ((GridPane)ListSequence.fromList(this.colGrindPane).getElement(this.curColIndex)).add((Node)cmpt.getLabel(), 0, this.curRowIndex);
            GridPane.setHalignment((Node)((Node)cmpt.getLabel()), (HPos)HPos.RIGHT);
            ((GridPane)ListSequence.fromList(this.colGrindPane).getElement(this.curColIndex)).add((Node)cmpt.getRightPartComponent(), 1, this.curRowIndex);
        }
        Node editor = (Node)cmpt.getEditor();
        if (editor instanceof TextArea) {
            GridPane.setValignment((Node)((Node)cmpt.getLabel()), (VPos)VPos.TOP);
        }
        ++this.curColIndex;
        if (this.curColIndex >= ListSequence.fromList(this.colGrindPane).count()) {
            this.curColIndex = 0;
            ++this.curRowIndex;
        }
    }

    public void setColLayoutConstraints(List<String> constraints) {
        this.colContraints = ListSequence.fromList(new ArrayList());
        this.gridPane = new GridPane();
        this.gridPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        ListSequence.fromList(constraints).visitAll(it -> ListSequence.fromList(this.colContraints).addElement((Object)new LayoutConstraint(it)));
        int totalWeight = LayoutConstraint.calcTotalWeight(this.colContraints);
        ListSequence.fromList(this.colContraints).visitAll(it -> it.setTotalWeight(totalWeight));
        Wrappers._T newColGridPane = new Wrappers._T();
        Wrappers._int col = new Wrappers._int(0);
        boolean usedPxl = ListSequence.fromList(this.colContraints).any(it -> it.isPxl());
        ListSequence.fromList(this.colContraints).visitAll(it -> {
            ColumnConstraints colConstrain = new ColumnConstraints();
            if (it.isPxl()) {
                colConstrain.setPrefWidth((double)it.getPixl());
            } else if (!it.isMinimal()) {
                if (usedPxl) {
                    colConstrain.setHgrow(Priority.ALWAYS);
                } else {
                    colConstrain.setPercentWidth((double)it.getInPercent());
                }
            }
            this.gridPane.getColumnConstraints().add((Object)colConstrain);
            newColGridPane.value = new GridPane();
            ((GridPane)newColGridPane.value).setVgap(5.0);
            ((GridPane)newColGridPane.value).getColumnConstraints().add((Object)new ColumnConstraints());
            ColumnConstraints c2 = new ColumnConstraints();
            c2.setHgrow(Priority.ALWAYS);
            ((GridPane)newColGridPane.value).getColumnConstraints().add((Object)c2);
            ListSequence.fromList(this.colGrindPane).addElement((Object)((GridPane)newColGridPane.value));
            this.gridPane.add((Node)newColGridPane.value, col.value++, 0);
        });
        this.setCenter((Node)this.gridPane);
    }

    public void afterFullUiInitialized() {
        for (int i = 0; i < ListSequence.fromList(this.delegates).count(); ++i) {
            if (!(((IDataUxDelegate)ListSequence.fromList(this.delegates).getElement(i)).getDelegateUiImpl() instanceof FX8ImageEditor)) continue;
            ((FX8ImageEditor)((IDataUxDelegate)ListSequence.fromList(this.delegates).getElement(i)).getDelegateUiImpl()).adjustImageSize();
        }
    }

    public Object myRequestFocus() {
        int i;
        Node focussedNode = null;
        for (i = 0; i < ListSequence.fromList(this.delegates).count(); ++i) {
            if (!((IDataUxDelegate)ListSequence.fromList(this.delegates).getElement(i)).isRequestFocus()) continue;
            focussedNode = (Node)((IDataUxDelegate)ListSequence.fromList(this.delegates).getElement(i)).getDelegateUiImpl().getEditor();
            focussedNode.requestFocus();
            if (focussedNode instanceof TextField) {
                ((TextField)focussedNode).selectAll();
                break;
            }
            if (!(focussedNode instanceof DatePicker)) break;
            ((DatePicker)focussedNode).getEditor().selectAll();
            break;
        }
        if (focussedNode == null) {
            for (i = 0; i < ListSequence.fromList(this.delegates).count(); ++i) {
                if (!((IDataUxDelegate)ListSequence.fromList(this.delegates).getElement(i)).isEnabled()) continue;
                focussedNode = (Node)((IDataUxDelegate)ListSequence.fromList(this.delegates).getElement(i)).getDelegateUiImpl().getEditor();
                focussedNode.requestFocus();
                if (focussedNode instanceof TextField) {
                    ((TextField)focussedNode).selectAll();
                    break;
                }
                if (!(focussedNode instanceof DatePicker)) break;
                ((DatePicker)focussedNode).getEditor().selectAll();
                break;
            }
        }
        return focussedNode;
    }

    public String checkDelegatesValidAndFocus() {
        int focussedOnError = -1;
        String firstErr = null;
        for (int i = 0; i < ListSequence.fromList(this.delegates).count(); ++i) {
            String errText = ((IDataUxDelegate)ListSequence.fromList(this.delegates).getElement(i)).isInputValid();
            if (errText == null || focussedOnError != -1) continue;
            focussedOnError = i;
            firstErr = errText;
        }
        if (focussedOnError != -1) {
            ((Node)((IDataUxDelegate)ListSequence.fromList(this.delegates).getElement(focussedOnError)).getDelegateUiImpl().getEditor()).requestFocus();
        }
        return firstErr;
    }

    public void gcClear() {
        ListSequence.fromList(this.delegates).visitAll((_FunctionTypes._void_P1_E0)new _FunctionTypes._void_P1_E0<IDataUxDelegate>(){

            public void invoke(IDataUxDelegate it) {
                IToolkit_TextEditor cmpt = it.getDelegateUiImpl();
            }
        });
        this.enterHandler = null;
    }
}

