/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.windows;

import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.modellwerkstatt.dataux.runtime.extensions.ITableCellStringConverter;
import org.modellwerkstatt.dataux.runtime.utils.ValueObjectReplacementFacility;

public class FX8EditCellBigdeci<T>
extends TableCell<T, Object> {
    private TextField textField;
    private String property;
    private ITableCellStringConverter convert;

    public FX8EditCellBigdeci(String p, ITableCellStringConverter conv) {
        this.convert = conv;
        this.property = p;
        this.getStyleClass().add((Object)"FX8EditCellBigdeci");
    }

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.createTextField();
            this.setText(null);
            this.setGraphic((Node)this.textField);
            this.textField.selectAll();
            this.textField.requestFocus();
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(this.convert.convert(this.getItem()));
        this.setGraphic(null);
    }

    public boolean commitChanges() {
        try {
            Object xxx = this.convert.convertBack(this.textField.getText());
            ValueObjectReplacementFacility.put((Object)this.getTableView().getSelectionModel().getSelectedItem(), (String)this.property, (Object)xxx);
            this.commitEdit(xxx);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void updateItem(Object item, boolean empty) {
        super.updateItem(item, empty);
        this.setAlignment(Pos.BASELINE_RIGHT);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.textField != null) {
                this.textField.setText(this.getString());
            }
            this.setText(null);
            this.setGraphic((Node)this.textField);
        } else {
            this.setText(this.getString());
            this.setGraphic(null);
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue() && FX8EditCellBigdeci.this.isEditing()) {
                    FX8EditCellBigdeci.this.cancelEdit();
                }
            }
        });
        this.textField.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode().equals((Object)KeyCode.ESCAPE)) {
                    keyEvent.consume();
                    FX8EditCellBigdeci.this.cancelEdit();
                } else if (keyEvent.getCode().equals((Object)KeyCode.ENTER)) {
                    keyEvent.consume();
                    FX8EditCellBigdeci.this.adjustPosition(true, 1);
                } else if (keyEvent.getCode().equals((Object)KeyCode.DOWN)) {
                    keyEvent.consume();
                    FX8EditCellBigdeci.this.adjustPosition(true, 1);
                } else if (keyEvent.getCode().equals((Object)KeyCode.UP)) {
                    keyEvent.consume();
                    FX8EditCellBigdeci.this.adjustPosition(true, -1);
                }
            }
        });
    }

    public void adjustPosition(boolean commit, int posdiff) {
        boolean okay = true;
        TablePosition pos = this.getTableView().getEditingCell();
        if (commit) {
            okay = this.commitChanges();
        } else {
            this.cancelEdit();
            okay = false;
        }
        if (okay) {
            final int requestedIndex = pos.getRow() + posdiff;
            final int colIndex = pos.getColumn();
            int total = this.getTableView().getItems().size();
            if (requestedIndex >= total || requestedIndex < 0) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FX8EditCellBigdeci.this.getTableView().requestFocus();
                    }
                });
            } else {
                if (posdiff == 1) {
                    this.getTableView().fireEvent((Event)new KeyEvent((Object)this, (EventTarget)this.getTableView(), KeyEvent.KEY_PRESSED, "DOWN", "DOWN", KeyCode.DOWN, false, false, false, false));
                } else if (posdiff == -1) {
                    this.getTableView().fireEvent((Event)new KeyEvent((Object)this, (EventTarget)this.getTableView(), KeyEvent.KEY_PRESSED, "UP", "UP", KeyCode.UP, false, false, false, false));
                } else {
                    throw new RuntimeException("This can not be true.");
                }
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ObservableList columnList = FX8EditCellBigdeci.this.getTableView().getColumns();
                        if (colIndex < columnList.size()) {
                            FX8EditCellBigdeci.this.getTableView().edit(requestedIndex, (TableColumn)columnList.get(colIndex));
                        }
                    }
                });
            }
        }
    }

    private String getString() {
        return this.getItem() == null ? "" : this.convert.convert(this.getItem());
    }
}

