/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.windows;

import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.dataux.runtime.delegates.TableCellStatusConverter;
import org.modellwerkstatt.dataux.runtime.extensions.ITableCellStringConverter;
import org.modellwerkstatt.dataux.runtime.utils.ValueObjectReplacementFacility;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;

public class FX8EditCellStatus
extends TableCell<Object, IOFXMetaStatus.IOFXStatusElement> {
    private RadioEditor statusField;
    private String property;
    private TableCellStatusConverter statusConverter;

    public FX8EditCellStatus(String p, ITableCellStringConverter conv) {
        this.statusConverter = (TableCellStatusConverter)conv;
        this.property = p;
        this.getStyleClass().add((Object)"FX8EditCellStatus");
    }

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.createRadioEditor();
            this.setText(null);
            this.setGraphic((Node)this.statusField);
            this.statusField.myRequestFocus();
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(((IOFXMetaStatus.IOFXStatusElement)this.getItem()).getShortDesc());
        this.setGraphic(null);
    }

    public boolean commitChanges(String shortDesc) {
        try {
            IOFXMetaStatus.IOFXStatusElement xxx = this.statusConverter.convertBack(shortDesc);
            ValueObjectReplacementFacility.put((Object)this.getTableView().getSelectionModel().getSelectedItem(), (String)this.property, (Object)xxx);
            this.commitEdit(xxx);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void updateItem(IOFXMetaStatus.IOFXStatusElement item, boolean empty) {
        super.updateItem((Object)item, empty);
        this.setAlignment(Pos.BASELINE_RIGHT);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.statusField != null) {
                this.statusField.setValue(this.getString());
            }
            this.setText(null);
            this.setGraphic((Node)this.statusField);
        } else {
            this.setText(this.getString());
            this.setGraphic(null);
        }
    }

    private void createRadioEditor() {
        IListSequence allShortTexts = ListSequence.fromList(new ArrayList());
        for (IOFXMetaStatus.IOFXStatusElement elem : this.statusConverter.getAllElements()) {
            ListSequence.fromList((List)allShortTexts).addElement((Object)elem.getShortDesc());
        }
        this.statusField = new RadioEditor(this.getString(), (List<String>)allShortTexts, this);
        this.statusField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.statusField.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode().equals((Object)KeyCode.ESCAPE)) {
                    keyEvent.consume();
                    FX8EditCellStatus.this.cancelEdit();
                } else if (keyEvent.getCode().equals((Object)KeyCode.ENTER)) {
                    keyEvent.consume();
                    FX8EditCellStatus.this.adjustPosition(true, 1);
                } else if (keyEvent.getCode().equals((Object)KeyCode.DOWN)) {
                    keyEvent.consume();
                    FX8EditCellStatus.this.adjustPosition(true, 1);
                } else if (keyEvent.getCode().equals((Object)KeyCode.UP)) {
                    keyEvent.consume();
                    FX8EditCellStatus.this.adjustPosition(true, -1);
                }
            }
        });
    }

    public void adjustPosition(boolean commit, int posdiff) {
        boolean okay = true;
        TablePosition pos = this.getTableView().getEditingCell();
        if (commit) {
            okay = this.commitChanges(this.statusField.getValue());
        } else {
            this.cancelEdit();
            okay = false;
        }
        if (okay) {
            final int requestedIndex = pos.getRow() + posdiff;
            final int colIndex = pos.getColumn();
            int total = this.getTableView().getItems().size();
            if (requestedIndex >= total || requestedIndex < 0) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FX8EditCellStatus.this.getTableView().requestFocus();
                    }
                });
            } else {
                if (posdiff == 1) {
                    this.getTableView().fireEvent((Event)new KeyEvent((Object)this, (EventTarget)this.getTableView(), KeyEvent.KEY_PRESSED, "DOWN", "DOWN", KeyCode.DOWN, false, false, false, false));
                } else if (posdiff == -1) {
                    this.getTableView().fireEvent((Event)new KeyEvent((Object)this, (EventTarget)this.getTableView(), KeyEvent.KEY_PRESSED, "UP", "UP", KeyCode.UP, false, false, false, false));
                } else {
                    throw new RuntimeException("This can not be true.");
                }
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FX8EditCellStatus.this.getTableView().edit(requestedIndex, (TableColumn)FX8EditCellStatus.this.getTableView().getColumns().get(colIndex));
                    }
                });
            }
        }
    }

    private String getString() {
        return this.getItem() == null ? "(null)" : ((IOFXMetaStatus.IOFXStatusElement)this.getItem()).getShortDesc();
    }

    public static class RadioEditor
    extends HBox {
        private List<ToggleButton> toggleButtons;
        private FX8EditCellStatus editCell;

        public RadioEditor(String currentValue, List<String> values, FX8EditCellStatus eC) {
            this.setAlignment(Pos.BASELINE_RIGHT);
            this.editCell = eC;
            this.toggleButtons = new ArrayList<ToggleButton>();
            this.getStyleClass().add((Object)"FX8EditCellStatusRadioEditor");
            ToggleGroup grp = new ToggleGroup();
            ListSequence.fromList(values).visitAll(val -> {
                ToggleButton r1 = new ToggleButton(val);
                r1.setToggleGroup(grp);
                if (val.equals(currentValue)) {
                    r1.setSelected(true);
                }
                r1.setOnKeyTyped((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent p0) {
                        if (p0.getCode().equals((Object)KeyCode.ENTER)) {
                            p0.consume();
                            editCell.commitChanges(((ToggleButton)p0.getSource()).getText());
                        }
                    }
                });
                r1.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent p0) {
                        editCell.commitChanges(((ToggleButton)p0.getSource()).getText());
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                editCell.getTableView().requestFocus();
                            }
                        });
                    }
                });
                r1.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldValue, Boolean newValue) {
                        if (oldValue.booleanValue() && !newValue.booleanValue() && editCell.isEditing()) {
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    boolean focussed = false;
                                    for (int i = 0; i < toggleButtons.size(); ++i) {
                                        focussed |= toggleButtons.get(i).isFocused();
                                    }
                                    if (!focussed) {
                                        editCell.cancelEdit();
                                    }
                                }
                            });
                        }
                    }
                });
                this.toggleButtons.add(r1);
                this.getChildren().add((Object)r1);
            });
        }

        public void myRequestFocus() {
            for (int i = 0; i < this.toggleButtons.size(); ++i) {
                ToggleButton currentButton = this.toggleButtons.get(i);
                if (!currentButton.isSelected()) continue;
                currentButton.requestFocus();
                return;
            }
        }

        public void setValue(String val) {
            for (int i = 0; i < this.toggleButtons.size(); ++i) {
                ToggleButton currentButton = this.toggleButtons.get(i);
                if (!currentButton.getText().equals(val)) continue;
                currentButton.setSelected(true);
                return;
            }
        }

        public String getValue() {
            for (int i = 0; i < this.toggleButtons.size(); ++i) {
                ToggleButton currentButton = this.toggleButtons.get(i);
                if (!currentButton.isSelected()) continue;
                return currentButton.getText();
            }
            throw new IllegalStateException("This can not happen.");
        }
    }
}

