/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.windows;

import java.util.List;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.modellwerkstatt.dataux.runtime.core.IApplication;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.fx8forms.windows.FX8FormContainer;
import org.modellwerkstatt.fx8forms.windows.FX8Prompt;
import org.modellwerkstatt.fx8forms.windows.FX8UiFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;

public class FX8ErrorReporter
extends FX8Prompt {
    private static final String msgboxTextLabel = "msgboxTextLabel";
    private static final String msgboxImagePadding = "msgboxImagePadding";
    private boolean okButtonPressed = false;
    private Button okButton;
    private BorderPane buttonBox;
    private IToolkit_UiFactory factory;
    private IApplication.DlgRunnable runner;
    private int userLangIndex;
    private EventHandler<ActionEvent> confirmAction;
    private Image warningImg;
    private Image problemImg;

    public FX8ErrorReporter(IToolkit_UiFactory fact, Stage parentStage, int langIndex) {
        super(parentStage, new BorderPane(), FX8Prompt.Size.AUTO_FROMCONTENT);
        this.userLangIndex = langIndex;
        this.factory = fact;
        this.promptContent.setPadding(new Insets(10.0));
        this.buttonBox = new BorderPane();
        this.okButton = new Button(fact.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.OK_BUTTON) + " (F12)");
        this.okButton.getStyleClass().add((Object)"FX8Button");
        this.confirmAction = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                FX8ErrorReporter.this.close();
                FX8ErrorReporter.this.okButtonPressed = true;
                if (FX8ErrorReporter.this.runner != null) {
                    FX8ErrorReporter.this.runner.run(true);
                }
            }
        };
        this.okButton.setOnAction(this.confirmAction);
        this.warningImg = new Image(FX8UiFactory.getImage("warning"));
        this.problemImg = new Image(FX8UiFactory.getImage("problem"));
        this.promptStage.getScene().setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode().equals((Object)KeyCode.F12)) {
                    keyEvent.consume();
                    FX8ErrorReporter.this.close();
                    FX8ErrorReporter.this.okButtonPressed = true;
                    if (FX8ErrorReporter.this.runner != null) {
                        FX8ErrorReporter.this.runner.run(true);
                    }
                }
            }
        });
        this.promptContent.setBottom((Node)this.buttonBox);
    }

    private void buildUi(String heading, List<IOFXProblem> info) {
        TableView table = new TableView();
        TableColumn msgType = new TableColumn("");
        TableColumn message = new TableColumn("Message");
        msgType.setCellValueFactory((Callback)new PropertyValueFactory("warningOnly"));
        message.setCellValueFactory((Callback)new PropertyValueFactory("simpleText_Lgcy"));
        msgType.setCellFactory((Callback)new Callback<TableColumn<Object, Object>, TableCell<Object, Object>>(){

            public TableCell<Object, Object> call(TableColumn<Object, Object> p1) {
                TableCell<Object, Object> cell = new TableCell<Object, Object>(){

                    protected void updateItem(Object object, boolean b) {
                        if (Boolean.TRUE.equals(object)) {
                            this.setGraphic((Node)new ImageView(FX8ErrorReporter.this.warningImg));
                        } else if (Boolean.FALSE.equals(object)) {
                            this.setGraphic((Node)new ImageView(FX8ErrorReporter.this.problemImg));
                        }
                        super.updateItem(object, b);
                    }
                };
                return cell;
            }
        });
        message.setMinWidth(550.0);
        table.getColumns().add((Object)msgType);
        table.getColumns().add((Object)message);
        table.setItems(FXCollections.observableArrayList(info));
        this.promptContent.setCenter((Node)table);
        Label l2 = new Label(heading);
        l2.getStyleClass().add((Object)FX8FormContainer.formTitleLabel);
        this.promptContent.setTop((Node)l2);
        ImageView view = new ImageView(new Image(FX8UiFactory.getImage("big_information")));
        view.getStyleClass().add((Object)msgboxImagePadding);
        BorderPane pane = new BorderPane();
        pane.getStyleClass().add((Object)msgboxImagePadding);
        pane.setTop((Node)view);
        this.promptContent.setLeft((Node)pane);
        this.okButton.setDefaultButton(true);
        this.buttonBox.setRight((Node)this.okButton);
    }

    public void showInformation(List<IOFXProblem> information, IApplication.DlgRunnable runnable) {
        this.buildUi(this.factory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.INFORMATION), information);
        this.runner = runnable;
        this.open();
    }
}

