/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.windows;

import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.fx8forms.windows.FX8FormContainer;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.Workarounds2;

public class FX8FlagBox
extends VBox {
    private Insets oneLineInsets = new Insets(6.0, 0.0, 6.0, 4.0);
    private Insets moreLineInsets = new Insets(0.0, 0.0, 2.0, 4.0);
    private static final int minHeight = 16;
    private String[] splittedTittles = new String[]{"", null};
    private Label defaultLabelForTitle;
    private Label defaultLabelForSubTitle;

    public FX8FlagBox() {
        this.setPadding(this.oneLineInsets);
        this.defaultLabelForTitle = new Label("");
        this.defaultLabelForTitle.getStyleClass().add((Object)FX8FormContainer.formTitleLabel);
        this.defaultLabelForTitle.setMinHeight(16.0);
        this.getChildren().add((Object)this.defaultLabelForTitle);
    }

    public void inRootForm() {
        this.defaultLabelForTitle.getStyleClass().clear();
        this.defaultLabelForTitle.getStyleClass().add((Object)FX8FormContainer.formMainTitleLabel);
    }

    public void setTitle(String t) {
        this.splittedTittles = Workarounds2.getMainAndSubTitle((String)t);
        this.adjustToTitle();
    }

    public void flag(List<IOFXProblem> listOfProblems) {
        if (ListSequence.fromList(listOfProblems).count() == 0) {
            this.adjustToTitle();
        } else {
            this.getChildren().clear();
            int numLines = 0;
            if (!"".equals(this.splittedTittles[0])) {
                ++numLines;
                this.getChildren().add((Object)this.defaultLabelForTitle);
            }
            if (this.splittedTittles[1] != null) {
                ++numLines;
                this.getChildren().add((Object)this.defaultLabelForSubTitle);
            }
            if ((numLines += ListSequence.fromList(listOfProblems).count()) > 1) {
                this.setPadding(this.moreLineInsets);
            } else {
                this.setPadding(this.oneLineInsets);
            }
            boolean shrink = ListSequence.fromList(listOfProblems).count() > 1;
            boolean conntainsAction = ListSequence.fromList(listOfProblems).any(it -> it.getResolveActionOrNull() != null);
            Double extra = 1.5;
            for (IOFXProblem prblm : listOfProblems) {
                Label problemLabel = new Label(prblm.getSimpleUserText());
                if (!conntainsAction && shrink) {
                    problemLabel.setMinHeight(16.0 * extra);
                    problemLabel.setMaxHeight(16.0 * extra);
                }
                if (prblm.isWarningOnly()) {
                    problemLabel.getStyleClass().add((Object)FX8FormContainer.formWarningLabel);
                } else {
                    problemLabel.getStyleClass().add((Object)FX8FormContainer.formFlagLabel);
                }
                if (prblm.getResolveActionOrNull() == null) {
                    this.getChildren().add((Object)problemLabel);
                    continue;
                }
                final IOFXSession.IUxEventActionable resolveActionOrNull = prblm.getResolveActionOrNull();
                HBox vbox = new HBox();
                vbox.setMaxHeight(16.0 * extra);
                vbox.setMinHeight(16.0 * extra);
                vbox.setSpacing(20.0);
                vbox.setAlignment(Pos.BASELINE_LEFT);
                Button btn = new Button(resolveActionOrNull.getLabelText());
                btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent p0) {
                        resolveActionOrNull.performAction();
                    }
                });
                vbox.getChildren().addAll((Object[])new Node[]{problemLabel, btn});
                this.getChildren().add((Object)vbox);
            }
        }
    }

    public void adjustToTitle() {
        this.getChildren().clear();
        this.defaultLabelForTitle.setText(this.splittedTittles[0]);
        this.getChildren().add((Object)this.defaultLabelForTitle);
        if (this.splittedTittles[1] != null) {
            if (this.defaultLabelForSubTitle == null) {
                this.defaultLabelForSubTitle = new Label("");
                this.defaultLabelForSubTitle.getStyleClass().add((Object)FX8FormContainer.formTitleLabel);
                this.defaultLabelForSubTitle.setMinHeight(16.0);
                this.defaultLabelForSubTitle.setPadding(new Insets(2.0, 0.0, 0.0, 0.0));
            }
            this.defaultLabelForSubTitle.setText(this.splittedTittles[1]);
            this.getChildren().add((Object)this.defaultLabelForSubTitle);
            this.setPadding(this.moreLineInsets);
        } else {
            this.setPadding(this.oneLineInsets);
        }
    }

    public static void main(String[] args) {
        String test = "";
        String[] splitted = test.split("\n");
        System.err.println("Len " + splitted.length);
    }
}

