/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.windows;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.dataux.runtime.core.FocusController;
import org.modellwerkstatt.dataux.runtime.genspecifications.Menu;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_FormContainer;
import org.modellwerkstatt.dataux.runtime.utils.LayoutConstraint;
import org.modellwerkstatt.fx8forms.windows.FX8ActionHBox;
import org.modellwerkstatt.fx8forms.windows.FX8ColFormContainer;
import org.modellwerkstatt.fx8forms.windows.FX8FlagBox;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;

public class FX8FormContainer<T>
extends BorderPane
implements IToolkit_FormContainer<T> {
    public static String formTitleLabel = "FX8FormTitleLabel";
    public static String formMainTitleLabel = "FX8FormMainTitleLabel";
    public static String formFlagLabel = "FX8FormFlagLabel";
    public static String formFlagBorder = "FX8FromFlagBorder";
    public static String formWarningLabel = "FX8FormWarningLabel";
    private FX8FlagBox titleLabel;
    private boolean rootFlagBox;
    private BorderPane topPane;
    private List<LayoutConstraint> rowConstraints;
    private List<LayoutConstraint> colConstraints;
    private List<FX8ColFormContainer> rows;
    private List<Double> dividerPositions;
    private Node contentPane;
    private int curRow;
    private int curCol;
    private FX8ActionHBox actions;
    private FocusController focusController;
    private int adjustedDividerCnt = 0;

    public FX8FormContainer() {
        this.getStyleClass().add((Object)"FX8FormContainer");
        this.focusController = new FocusController();
        this.rows = ListSequence.fromList(new ArrayList());
        this.dividerPositions = ListSequence.fromList(new ArrayList());
        this.curRow = -1;
        this.curCol = 0;
        this.rootFlagBox = false;
    }

    public void debug(String methodName) {
        System.err.println("\n\n" + methodName + " -- -- -- -- -- -- -- -- -- -- -- ");
        System.err.println("RowConstrains " + this.rowConstraints);
        System.err.println("ColConstrains " + this.colConstraints);
        System.err.println("DividerPos " + this.dividerPositions);
    }

    public void rootForm() {
        this.rootFlagBox = true;
        if (this.titleLabel != null) {
            this.titleLabel.inRootForm();
        }
    }

    public void skipFocus(int cmptToStartWith) {
        this.focusController.skipFocus(cmptToStartWith);
    }

    public void initTitle() {
        this.titleLabel = new FX8FlagBox();
        if (this.rootFlagBox) {
            this.titleLabel.inRootForm();
        }
        this.topPane = new BorderPane();
        this.topPane.setLeft((Node)this.titleLabel);
        this.setTop((Node)this.topPane);
    }

    public void setTitleText(String text) {
        if (this.getTop() == null) {
            this.initTitle();
        }
        this.titleLabel.setTitle(text);
    }

    public void setProblems(List<IOFXProblem> listOfProblems) {
        if (this.getTop() == null && ListSequence.fromList(listOfProblems).count() == 0) {
            return;
        }
        if (this.getTop() == null) {
            this.initTitle();
        }
        if (ListSequence.fromList(listOfProblems).count() == 0) {
            this.titleLabel.flag(listOfProblems);
            this.getCenter().getStyleClass().remove((Object)formFlagBorder);
        } else {
            this.getCenter().getStyleClass().add((Object)formFlagBorder);
            this.titleLabel.flag(listOfProblems);
        }
    }

    public void addMenuAndSetButtons(Menu folder) {
        if (this.getTop() == null) {
            this.initTitle();
        }
        this.actions = new FX8ActionHBox(folder, null);
        this.topPane.setRight((Node)this.actions);
    }

    public void loadList(List<T> objects, IOFXSelection<T> selection) {
    }

    public boolean selectionChanged(IOFXSelection<T> selection) {
        return false;
    }

    public void setLayoutConstraints(List<String> colConstraints, List<String> rowConstraints) {
        this.rowConstraints = ListSequence.fromList(new ArrayList());
        this.colConstraints = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(rowConstraints).visitAll(it -> ListSequence.fromList(this.rowConstraints).addElement((Object)new LayoutConstraint(it)));
        ListSequence.fromList(colConstraints).visitAll(it -> ListSequence.fromList(this.colConstraints).addElement((Object)new LayoutConstraint(it)));
        int totalRowWeight = LayoutConstraint.calcTotalWeight(this.rowConstraints);
        int totalColWeight = LayoutConstraint.calcTotalWeight(this.colConstraints);
        ListSequence.fromList(this.rowConstraints).visitAll(it -> it.setTotalWeight(totalRowWeight));
        ListSequence.fromList(this.colConstraints).visitAll(it -> it.setTotalWeight(totalColWeight));
        if (ListSequence.fromList(this.rowConstraints).count() <= 1) {
            this.contentPane = new VBox();
            VBox.setVgrow((Node)this.contentPane, (Priority)Priority.ALWAYS);
        } else {
            this.contentPane = new SplitPane();
            ((SplitPane)this.contentPane).setOrientation(Orientation.VERTICAL);
        }
        this.setCenter(this.contentPane);
        if (ListSequence.fromList(this.rowConstraints).count() > 1) {
            Wrappers._double total = new Wrappers._double(0.0);
            ListSequence.fromList(this.rowConstraints).visitAll(row -> {
                if (row.isMinimal() || row.isPxl()) {
                    ListSequence.fromList(this.dividerPositions).addElement((Object)0.0);
                } else {
                    total.value += (double)row.getInPercent() / 100.0;
                    ListSequence.fromList(this.dividerPositions).addElement((Object)total.value);
                }
            });
        }
    }

    public List<?> getHotKeysToRegister() {
        return null;
    }

    public void addChildren(IToolkit_Form child) {
        FX8ColFormContainer cfc;
        this.focusController.addChild(child);
        if (this.contentPane instanceof SplitPane) {
            if (ListSequence.fromList(this.colConstraints).count() > 1) {
                if (this.curCol % ListSequence.fromList(this.colConstraints).count() == 0) {
                    cfc = new FX8ColFormContainer(this.colConstraints);
                    ListSequence.fromList(this.rows).addElement((Object)cfc);
                    ((SplitPane)this.contentPane).getItems().add((Object)cfc.getNode());
                    ++this.curRow;
                    this.curCol = 0;
                }
                ((FX8ColFormContainer)ListSequence.fromList(this.rows).getElement(this.curRow)).addChild((Node)child);
                ++this.curCol;
            } else {
                ++this.curRow;
                ((SplitPane)this.contentPane).getItems().add((Object)((Node)child));
            }
        }
        if (this.contentPane instanceof VBox) {
            if (ListSequence.fromList(this.colConstraints).count() > 1) {
                if (this.curCol % ListSequence.fromList(this.colConstraints).count() == 0) {
                    cfc = new FX8ColFormContainer(this.colConstraints);
                    ListSequence.fromList(this.rows).addElement((Object)cfc);
                    ((VBox)this.contentPane).getChildren().add((Object)cfc.getNode());
                    VBox.setVgrow((Node)cfc.getNode(), (Priority)Priority.ALWAYS);
                    this.curCol = 0;
                    ++this.curRow;
                }
                ((FX8ColFormContainer)ListSequence.fromList(this.rows).getElement(this.curRow)).addChild((Node)child);
                VBox.setVgrow((Node)((Node)child), (Priority)Priority.ALWAYS);
                ++this.curCol;
            } else {
                ++this.curRow;
                ((VBox)this.contentPane).getChildren().add((Object)((Node)child));
                VBox.setVgrow((Node)((Node)child), (Priority)Priority.ALWAYS);
            }
        }
    }

    public void afterFullUiInitialized() {
        if (this.curRow == ListSequence.fromList(this.dividerPositions).count() - 1 && this.adjustedDividerCnt < 2) {
            ++this.adjustedDividerCnt;
            if (this.contentPane instanceof SplitPane) {
                for (int i = 0; i < ListSequence.fromList(this.dividerPositions).count(); ++i) {
                    ((SplitPane)this.contentPane).setDividerPosition(i, ((Double)ListSequence.fromList(this.dividerPositions).getElement(i)).doubleValue());
                    ((SplitPane)this.contentPane).layout();
                }
            }
        }
        this.focusController.afterFullUiInitialized();
    }

    public Object myRequestFocus() {
        return this.focusController.myRequestFocus();
    }

    public void gcClear() {
        if (this.actions != null) {
            this.actions.gcClear();
            this.actions = null;
        }
        this.focusController.gcClear();
        this.actions = null;
        if (this.contentPane instanceof VBox) {
            ((VBox)this.contentPane).getChildren().clear();
        } else if (this.contentPane instanceof SplitPane) {
            ((SplitPane)this.contentPane).getItems().clear();
        }
        this.contentPane = null;
        this.setCenter(null);
        ListSequence.fromList(this.colConstraints).clear();
        ListSequence.fromList(this.rowConstraints).clear();
        this.rowConstraints = null;
        this.colConstraints = null;
    }
}

