/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.windows;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.dataux.runtime.genspecifications.CmdAction;
import org.modellwerkstatt.dataux.runtime.genspecifications.TileAction;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_EnableItem;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.fx8forms.windows.FX8Application;
import org.modellwerkstatt.fx8forms.windows.FX8MenuItem;
import org.modellwerkstatt.fx8forms.windows.FX8TileButton;
import org.modellwerkstatt.fx8forms.windows.FX8UiFactory;

public class FX8MainBorder
extends StackPane {
    private static String fxPreferencesFile = "MoWareFxPreferences.properties";
    private ProgressIndicator progressIndicator = new ProgressIndicator();
    private BorderPane contentArea;
    private TabPane mainTabPane;
    private MenuBar menuBar;
    private Node focussedNodeBeforeLock;
    private TilePane tilePane;
    private MenuItem versionMenuItem;
    private MenuItem quitMenuItem;
    private Label leftLabel;
    private Label rightLabel;

    public FX8MainBorder() {
        this.progressIndicator.setVisible(false);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.menuBar = new MenuBar();
        this.mainTabPane = new TabPane();
        this.leftLabel = new Label("*");
        this.rightLabel = new Label("*");
        BorderPane statusBar = new BorderPane();
        statusBar.setRight((Node)this.rightLabel);
        statusBar.setLeft((Node)this.leftLabel);
        this.contentArea = new BorderPane();
        this.contentArea.setTop((Node)this.menuBar);
        this.contentArea.setBottom((Node)statusBar);
        this.tilePane = new TilePane();
        this.tilePane.setOrientation(Orientation.VERTICAL);
        this.tilePane.vgapProperty().set(10.0);
        this.tilePane.getStyleClass().add((Object)"FX8TilePane");
        this.contentArea.setCenter((Node)this.mainTabPane);
        this.getChildren().addAll((Object[])new Node[]{this.progressIndicator, this.contentArea});
    }

    public void setVersionAndAboutInformation(EventHandler<ActionEvent> versionHandler, EventHandler<ActionEvent> quitHandler) {
        this.versionMenuItem.setOnAction(versionHandler);
        this.quitMenuItem.setOnAction(quitHandler);
    }

    public void setLockInterface(boolean lock) {
        if (lock) {
            this.focussedNodeBeforeLock = this.getScene().getFocusOwner();
        }
        this.contentArea.setDisable(lock);
        this.progressIndicator.setVisible(lock);
        if (lock) {
            this.progressIndicator.toFront();
        } else {
            this.progressIndicator.toBack();
        }
        if (!lock && this.focussedNodeBeforeLock != null) {
            this.focussedNodeBeforeLock.requestFocus();
            this.focussedNodeBeforeLock = null;
        }
    }

    public boolean isInterfaceLocked() {
        return this.progressIndicator.isVisible();
    }

    public void lockMenu(boolean lock) {
        this.menuBar.setDisable(lock);
    }

    public void addLeftText(String text) {
        if (!"*".equals(this.leftLabel.getText())) {
            String currentTooltip = "";
            Tooltip t = this.leftLabel.getTooltip();
            if (t != null) {
                currentTooltip = t.getText();
            }
            this.leftLabel.setTooltip(new Tooltip(currentTooltip + this.leftLabel.getText() + "\n"));
        }
        this.leftLabel.setText(text);
    }

    public void setRightText(String text) {
        this.rightLabel.setText(text);
    }

    public void setMenuAndInit(int langIndex, org.modellwerkstatt.dataux.runtime.genspecifications.Menu startFolder, org.modellwerkstatt.dataux.runtime.genspecifications.Menu extrasFolder, org.modellwerkstatt.dataux.runtime.genspecifications.Menu helpFolder) {
        Menu extraMenu = new Menu(FX8Application.factory.getSystemLabel(langIndex, MoWareTranslations.Key.EXTRA));
        Menu startMenu = new Menu(FX8Application.factory.getSystemLabel(langIndex, MoWareTranslations.Key.START));
        Menu helpMenu = new Menu(FX8Application.factory.getSystemLabel(langIndex, MoWareTranslations.Key.HELP));
        helpMenu.setMnemonicParsing(true);
        this.versionMenuItem = new MenuItem(FX8Application.factory.getSystemLabel(langIndex, MoWareTranslations.Key.VERSION));
        helpMenu.getItems().add((Object)this.versionMenuItem);
        this.menuBar.getMenus().add((Object)startMenu);
        this.menuBar.getMenus().add((Object)extraMenu);
        this.menuBar.getMenus().add((Object)helpMenu);
        Image img = new Image(FX8UiFactory.getImage("exit"));
        this.quitMenuItem = new FX8MenuItem(img, FX8Application.factory.getSystemLabel(langIndex, MoWareTranslations.Key.QUIT) + " (ALT-F4)", FX8Application.factory.getSystemLabel(langIndex, MoWareTranslations.Key.QUIT) + " (ALT-F4)");
        FX8Application.createMenuStructure((ObservableList<MenuItem>)startMenu.getItems(), startFolder, false);
        startMenu.getItems().add((Object)new SeparatorMenuItem());
        startMenu.getItems().add((Object)this.quitMenuItem);
        FX8Application.createMenuStructure((ObservableList<MenuItem>)extraMenu.getItems(), extrasFolder, false);
        FX8Application.createMenuStructure((ObservableList<MenuItem>)helpMenu.getItems(), helpFolder, false);
    }

    public void setOrUpdateTiles(List<TileAction> tiles) {
        if (this.tilePane.getChildren().size() > 0) {
            for (int i = 0; i < this.tilePane.getChildren().size(); ++i) {
                ((FX8TileButton)((Object)this.tilePane.getChildren().get(i))).updateTitle(((TileAction)ListSequence.fromList(tiles).getElement((int)i)).getAction().labelText);
            }
        } else {
            for (TileAction oneTile : tiles) {
                FX8TileButton item = this.createTileButton(oneTile.getAction(), oneTile.getColor());
                this.tilePane.getChildren().add((Object)item);
            }
        }
        this.contentArea.setCenter((Node)this.tilePane);
    }

    public FX8TileButton createTileButton(final CmdAction action, String color) {
        FX8TileButton thisItem;
        String hotKeyLabel = null;
        if (action.hotKey != null && !"".equals(action.hotKey)) {
            if (FX8Application.FX8_HOTKEY_NEEDS_CRTL(action.hotKey)) {
                hotKeyLabel = "CRTL-" + action.hotKey;
            } else {
                throw new RuntimeException("Tiles accept only hotkeys in form of CRTL-[A-Z]. Hotkey is " + action.hotKey + " which does not need a leading CRTL-?.");
            }
        }
        if (action.image != null && !action.image.equals("")) {
            Image img = new Image(FX8UiFactory.getImage(action.image));
            thisItem = new FX8TileButton(img, action.labelText, action.getToolTip(), hotKeyLabel, color);
        } else {
            thisItem = new FX8TileButton(action.labelText, action.getToolTip(), hotKeyLabel, color);
        }
        action.attachButton1((IToolkit_EnableItem)thisItem);
        thisItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                action.startCommand();
            }
        });
        return thisItem;
    }

    public void ensureTabPaneInCenter() {
        if (this.contentArea.getCenter() != this.mainTabPane) {
            this.contentArea.setCenter((Node)this.mainTabPane);
        }
    }

    public TabPane getMainTabPane() {
        return this.mainTabPane;
    }

    public Position loadPosition() {
        File userHome = new File(System.getProperty("user.home"));
        File propertiesFile = new File(userHome, fxPreferencesFile);
        Position pos = new Position();
        Rectangle2D size = Screen.getPrimary().getBounds();
        pos.x = 50;
        pos.y = 50;
        pos.width = (int)size.getWidth() - 100;
        pos.height = (int)size.getHeight() - 100;
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream(propertiesFile));
            pos.x = new Integer(prop.getProperty("mainWindowX"));
            pos.y = new Integer(prop.getProperty("mainWindowY"));
            pos.height = new Integer(prop.getProperty("mainWindowHeight"));
            pos.width = new Integer(prop.getProperty("mainWindowWidth"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (Screen.getScreens().size() == 1 && ((double)pos.x > size.getMaxX() || (double)pos.y > size.getMaxY() || pos.x + pos.width < 0 || pos.y < 0)) {
            pos.x = 50;
            pos.y = 50;
            pos.width = (int)size.getWidth() - 100;
            pos.height = (int)size.getHeight() - 100;
        }
        return pos;
    }

    public void savePosition(Stage stage) {
        File userHome = new File(System.getProperty("user.home"));
        File propertiesFile = new File(userHome, fxPreferencesFile);
        Position pos = new Position();
        pos.x = (int)stage.getX();
        pos.y = (int)stage.getY();
        pos.width = (int)stage.getWidth();
        pos.height = (int)stage.getHeight();
        Properties prop = new Properties();
        try {
            prop.setProperty("mainWindowX", "" + pos.x);
            prop.setProperty("mainWindowY", "" + pos.y);
            prop.setProperty("mainWindowHeight", "" + pos.height);
            prop.setProperty("mainWindowWidth", "" + pos.width);
            prop.store(new FileOutputStream(propertiesFile), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class Position {
        public int x;
        public int y;
        public int width;
        public int height;

        public String toString() {
            return "x=" + this.x + " y=" + this.y + " width=" + this.width + " height=" + this.height;
        }
    }
}

