/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.windows;

import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TreeTableView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.modellwerkstatt.dataux.runtime.core.IApplication;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_MainWindow;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.fx8forms.windows.FX8FormContainer;
import org.modellwerkstatt.fx8forms.windows.FX8GraphDebuggerFactory;
import org.modellwerkstatt.fx8forms.windows.FX8Prompt;
import org.modellwerkstatt.fx8forms.windows.FX8UiFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;

public class FX8MsgBox
extends FX8Prompt {
    private static final String msgboxTextLabel = "msgboxTextLabel";
    private static final String msgboxImagePadding = "msgboxImagePadding";
    private boolean okButtonPressed = false;
    private boolean escAllowed = true;
    private Button okButton;
    private Button cancelButton;
    private BorderPane buttonBox;
    private IToolkit_UiFactory factory;
    private IToolkit_MainWindow.DlgType msgType;
    private IApplication.DlgRunnable runner;
    private int userLangIndex;
    private EventHandler<ActionEvent> confirmAction;

    public FX8MsgBox(IToolkit_UiFactory fact, Stage parentStage, IToolkit_MainWindow.DlgType type, int langIndex) {
        super(parentStage, new BorderPane(), type == IToolkit_MainWindow.DlgType.INFO_LARGE || type == IToolkit_MainWindow.DlgType.ERROR_LARGE ? FX8Prompt.Size.FULLSSCREEN : FX8Prompt.Size.DEFAULT);
        this.userLangIndex = langIndex;
        this.factory = fact;
        this.msgType = type;
        this.promptContent.setPadding(new Insets(10.0));
        this.buttonBox = new BorderPane();
        this.okButton = new Button(fact.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.OK_BUTTON) + " (F12)");
        this.okButton.getStyleClass().add((Object)"FX8Button");
        this.confirmAction = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                FX8MsgBox.this.close();
                FX8MsgBox.this.okButtonPressed = true;
                if (FX8MsgBox.this.runner != null) {
                    FX8MsgBox.this.runner.run(true);
                }
            }
        };
        this.okButton.setOnAction(this.confirmAction);
        this.cancelButton = new Button(fact.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.ESC_BUTTON));
        this.cancelButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                FX8MsgBox.this.close();
                if (FX8MsgBox.this.runner != null && FX8MsgBox.this.msgType == IToolkit_MainWindow.DlgType.QUESTIONCLOSE_SMALL) {
                    FX8MsgBox.this.runner.run(false);
                }
            }
        });
        this.cancelButton.setGraphic((Node)new ImageView(new Image(FX8UiFactory.getImage("arrow_back"))));
        this.promptStage.getScene().setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode().equals((Object)KeyCode.ESCAPE) && FX8MsgBox.this.escAllowed) {
                    keyEvent.consume();
                    FX8MsgBox.this.close();
                    FX8MsgBox.this.okButtonPressed = false;
                    if (FX8MsgBox.this.runner != null && FX8MsgBox.this.msgType == IToolkit_MainWindow.DlgType.QUESTIONCLOSE_SMALL) {
                        FX8MsgBox.this.runner.run(false);
                    }
                }
                if (keyEvent.getCode().equals((Object)KeyCode.F12)) {
                    keyEvent.consume();
                    FX8MsgBox.this.close();
                    FX8MsgBox.this.okButtonPressed = true;
                    if (FX8MsgBox.this.runner != null) {
                        FX8MsgBox.this.runner.run(true);
                    }
                }
            }
        });
        this.promptContent.setBottom((Node)this.buttonBox);
    }

    private void askCloseQuestion(String question, IApplication.DlgRunnable runnable) {
        this.escAllowed = true;
        VBox centerContent = new VBox();
        if (question.contains("\n")) {
            String redPart = question.substring(0, question.indexOf("\n"));
            question = question.substring(question.indexOf("\n"));
            Label red = new Label(redPart);
            red.setWrapText(true);
            red.getStyleClass().add((Object)FX8FormContainer.formFlagLabel);
            centerContent.getChildren().add((Object)red);
        }
        Label notRed = new Label(question);
        notRed.setWrapText(true);
        notRed.getStyleClass().add((Object)msgboxTextLabel);
        centerContent.getChildren().add((Object)notRed);
        this.promptContent.setCenter((Node)centerContent);
        Label l2 = new Label(this.factory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.QUESTION));
        l2.getStyleClass().add((Object)FX8FormContainer.formTitleLabel);
        this.promptContent.setTop((Node)l2);
        ImageView view = new ImageView(new Image(FX8UiFactory.getImage("big_question")));
        BorderPane pane = new BorderPane();
        pane.getStyleClass().add((Object)msgboxImagePadding);
        pane.setCenter((Node)view);
        this.promptContent.setLeft((Node)pane);
        this.cancelButton.setText(this.factory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.NO_BUTTON) + " (ESC)");
        this.okButton.setText(this.factory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.DISCARD_BUTTON) + " (F12)");
        this.okButton.setStyle("-fx-background-color: #4482b6;");
        this.cancelButton.setDefaultButton(true);
        this.buttonBox.setLeft((Node)this.cancelButton);
        this.buttonBox.setRight((Node)this.okButton);
        this.runner = runnable;
        this.open();
    }

    private void small(String img, String heading, String info) {
        Label l = new Label(info);
        l.setWrapText(true);
        l.getStyleClass().add((Object)msgboxTextLabel);
        this.promptContent.setCenter((Node)l);
        Label l2 = new Label(heading);
        l2.getStyleClass().add((Object)FX8FormContainer.formTitleLabel);
        this.promptContent.setTop((Node)l2);
        ImageView view = new ImageView(new Image(FX8UiFactory.getImage(img)));
        view.getStyleClass().add((Object)msgboxImagePadding);
        BorderPane pane = new BorderPane();
        pane.getStyleClass().add((Object)msgboxImagePadding);
        pane.setTop((Node)view);
        this.promptContent.setLeft((Node)pane);
        this.okButton.setDefaultButton(true);
        this.buttonBox.setRight((Node)this.okButton);
    }

    private void large(String img, String heading, final String info) {
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setPadding(new Insets(10.0));
        Label l = new Label(info);
        l.setWrapText(true);
        scrollPane.setContent((Node)l);
        EventHandler<KeyEvent> keyEventHandler = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (!keyEvent.getEventType().equals(KeyEvent.KEY_PRESSED)) {
                    return;
                }
                if (keyEvent.getCode().equals((Object)KeyCode.C) && keyEvent.isControlDown()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            StringBuilder rowContent = new StringBuilder();
                            ClipboardContent allContent = new ClipboardContent();
                            allContent.putString(info);
                            Clipboard.getSystemClipboard().setContent((Map)allContent);
                        }
                    });
                }
            }
        };
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        Label l2 = new Label(heading);
        l2.getStyleClass().add((Object)FX8FormContainer.formTitleLabel);
        this.promptContent.setCenter((Node)scrollPane);
        this.promptContent.setTop((Node)l2);
        ImageView view = new ImageView(new Image(FX8UiFactory.getImage(img)));
        view.getStyleClass().add((Object)msgboxImagePadding);
        BorderPane pane = new BorderPane();
        pane.getStyleClass().add((Object)msgboxImagePadding);
        pane.setTop((Node)view);
        this.promptContent.setLeft((Node)pane);
        this.okButton.setDefaultButton(true);
        this.buttonBox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.buttonBox.setRight((Node)this.okButton);
        this.promptStage.addEventHandler(KeyEvent.ANY, (EventHandler)keyEventHandler);
    }

    public void showGraphDebugger(List<Object> graph, String controllerInfo) {
        this.escAllowed = false;
        FX8GraphDebuggerFactory gdf = new FX8GraphDebuggerFactory();
        TreeTableView<String> ttv = gdf.createGraphAndCrtlInfo(graph, controllerInfo);
        final String asString = gdf.createGraphAndCrtlInfoAsString(graph, controllerInfo);
        EventHandler<KeyEvent> keyEventHandler = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (!keyEvent.getEventType().equals(KeyEvent.KEY_PRESSED)) {
                    return;
                }
                if (keyEvent.getCode().equals((Object)KeyCode.C) && keyEvent.isControlDown()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ClipboardContent allContent = new ClipboardContent();
                            allContent.putString(asString);
                            Clipboard.getSystemClipboard().setContent((Map)allContent);
                        }
                    });
                }
            }
        };
        Label l2 = new Label("MoWare Graph Debugger");
        l2.getStyleClass().add((Object)FX8FormContainer.formTitleLabel);
        this.promptContent.setCenter(ttv);
        this.promptContent.setTop((Node)l2);
        ImageView view = new ImageView(new Image(FX8UiFactory.getImage("big_information")));
        view.getStyleClass().add((Object)msgboxImagePadding);
        BorderPane pane = new BorderPane();
        pane.getStyleClass().add((Object)msgboxImagePadding);
        pane.setTop((Node)view);
        this.promptContent.setLeft((Node)pane);
        this.okButton.setDefaultButton(true);
        this.buttonBox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.buttonBox.setRight((Node)this.okButton);
        this.promptStage.addEventHandler(KeyEvent.ANY, (EventHandler)keyEventHandler);
        this.runner = null;
        this.open();
    }

    public void showInformation(String information, IApplication.DlgRunnable runnable) {
        this.escAllowed = false;
        if (this.msgType == IToolkit_MainWindow.DlgType.INFO_SMALL) {
            this.small("big_information", this.factory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.INFORMATION), information);
        } else if (this.msgType == IToolkit_MainWindow.DlgType.ERROR_SMALL) {
            this.small("big_error", this.factory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.ERROR), information);
        } else if (this.msgType == IToolkit_MainWindow.DlgType.ERROR_LARGE) {
            this.large("big_error", this.factory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.ERROR), information);
        } else if (this.msgType == IToolkit_MainWindow.DlgType.INFO_LARGE) {
            this.large("big_information", this.factory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.INFORMATION), information);
        } else if (this.msgType == IToolkit_MainWindow.DlgType.QUESTIONCLOSE_SMALL) {
            this.askCloseQuestion(information, runnable);
        }
        this.runner = runnable;
        this.open();
    }

    public void showProblems(List<IOFXProblem> problems, IApplication.DlgRunnable runnable) {
        this.escAllowed = false;
        if (this.msgType != IToolkit_MainWindow.DlgType.INFO_SMALL) {
            throw new RuntimeException("This can not happen, Problems Dialog supports only INFO_SMALL");
        }
        this.runner = runnable;
        VBox vBoxForProblemLabels = new VBox();
        vBoxForProblemLabels.setPadding(new Insets(25.0, 0.0, 0.0, 30.0));
        for (IOFXProblem prblm : problems) {
            Label l = new Label(prblm.getSimpleUserText());
            l.setWrapText(true);
            if (prblm.isWarningOnly()) {
                l.getStyleClass().add((Object)FX8FormContainer.formWarningLabel);
            } else {
                l.getStyleClass().add((Object)FX8FormContainer.formFlagLabel);
            }
            vBoxForProblemLabels.getChildren().add((Object)l);
        }
        this.promptContent.setCenter((Node)vBoxForProblemLabels);
        Label l2 = new Label(this.factory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.INFORMATION));
        l2.getStyleClass().add((Object)FX8FormContainer.formTitleLabel);
        this.promptContent.setTop((Node)l2);
        ImageView view = new ImageView(new Image(FX8UiFactory.getImage("big_information")));
        view.getStyleClass().add((Object)msgboxImagePadding);
        BorderPane pane = new BorderPane();
        pane.getStyleClass().add((Object)msgboxImagePadding);
        pane.setTop((Node)view);
        this.promptContent.setLeft((Node)pane);
        this.okButton.setDefaultButton(true);
        this.buttonBox.setRight((Node)this.okButton);
        this.open();
    }
}

