/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.windows;

import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;

public class FX8Prompt {
    protected Stage promptStage;
    protected Scene promptScene;
    protected BorderPane promptContent;
    protected Size promptSize;

    public FX8Prompt(Stage parentStage, BorderPane content, Size size) {
        double width = 700.0;
        double height = 200.0;
        this.promptSize = size;
        this.promptStage = new Stage(StageStyle.UNDECORATED);
        this.promptStage.initModality(Modality.APPLICATION_MODAL);
        this.promptStage.initOwner((Window)parentStage);
        this.promptContent = content;
        this.promptContent.getStyleClass().add((Object)"FX8PromptBorder");
        if (size.equals((Object)Size.FULLSSCREEN)) {
            width = parentStage.getWidth() - 60.0;
            height = parentStage.getHeight() - 40.0;
            if (parentStage.getHeight() <= 400.0) {
                height = parentStage.getHeight() - 10.0;
            }
            this.promptStage.setWidth(width);
            this.promptStage.setHeight(height);
        } else if (size.equals((Object)Size.AUTO_FROMCONTENT)) {
            double parentWidth = parentStage.getWidth();
            double diff = 0.0;
            diff = parentWidth < 800.0 ? 40.0 : (parentWidth < 1000.0 ? 100.0 : parentWidth * 0.8 - 534.0);
            width = parentWidth - diff;
            this.promptStage.setWidth(width);
        } else {
            this.promptStage.setWidth(width);
            this.promptStage.setHeight(height);
        }
        this.promptStage.setX(parentStage.getX() + (parentStage.getWidth() - width) / 2.0);
        this.promptStage.setY(parentStage.getScene().getY() + parentStage.getY() + parentStage.getScene().getRoot().getLayoutY());
        this.promptStage.onCloseRequestProperty().set((Object)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent p0) {
                p0.consume();
            }
        });
        this.promptScene = new Scene((Parent)this.promptContent);
        this.promptStage.setScene(this.promptScene);
    }

    public void open() {
        FadeTransition fadeTransition = new FadeTransition(Duration.millis((double)400.0), (Node)this.promptContent);
        fadeTransition.setFromValue(0.0);
        fadeTransition.setToValue(1.0);
        fadeTransition.play();
        this.promptStage.show();
        this.adjustHeight();
    }

    public Stage getStage() {
        return this.promptStage;
    }

    public void close() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FX8Prompt.this.promptStage.close();
            }
        });
    }

    public void adjustHeight() {
        if (this.promptSize != Size.FULLSSCREEN) {
            double width = this.getStage().getWidth();
            this.promptContent.setPrefWidth(width);
            this.promptContent.setMinHeight(200.0);
            this.getStage().sizeToScene();
        }
    }

    public static enum Size {
        FULLSSCREEN,
        AUTO_FROMCONTENT,
        DEFAULT;

    }
}

