/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.windows;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.Callback;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.dataux.runtime.delegates.TableCellBigDecimalConverter;
import org.modellwerkstatt.dataux.runtime.delegates.TableCellStatusConverter;
import org.modellwerkstatt.dataux.runtime.extensions.ITableCellStringConverter;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenSelControlled;
import org.modellwerkstatt.dataux.runtime.genspecifications.Menu;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TableForm;
import org.modellwerkstatt.dataux.runtime.utils.MoJSON;
import org.modellwerkstatt.fx8forms.windows.FX8ActionHBox;
import org.modellwerkstatt.fx8forms.windows.FX8BeanPropertyValue;
import org.modellwerkstatt.fx8forms.windows.FX8EditCellBigdeci;
import org.modellwerkstatt.fx8forms.windows.FX8EditCellStatus;
import org.modellwerkstatt.fx8forms.windows.FX8FlagBox;
import org.modellwerkstatt.fx8forms.windows.FX8FormContainer;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import org.modellwerkstatt.objectflow.runtime.Selection;

public class FX8TableForm<T>
extends BorderPane
implements IToolkit_TableForm<T> {
    private TableView<T> table;
    private BorderPane topPane;
    private HBox onTheRight;
    private FX8ActionHBox actionHBox;
    private IGenSelControlled genParent;
    private Class elementClass;
    private boolean selectionHandlerEnabled;
    private boolean selectionChangedEnabled;
    private FX8FlagBox titleLabel;
    private Label selectionPosition;
    private List<TableColumn> notVisibleColummns = ListSequence.fromList(new ArrayList());
    private boolean visible;
    private Label selectionSummaryLine;
    private Label tableSummaryLine;
    private ContextMenu contextMenu;
    private TextField searchField;
    private boolean searchEnabled;
    private boolean editEnabled;
    private boolean editPreview;
    private boolean scroll;
    private List<PropertyAndConverter> columnWithConverter = ListSequence.fromList(new ArrayList());
    private ObservableList<T> allItems;
    private ObservableList<T> currentItems = FXCollections.observableArrayList();
    private ListChangeListener<Integer> selectionListener;
    private ChangeListener<Boolean> focusListener;
    private EventHandler<KeyEvent> keyEventHandler;
    private EventHandler<KeyEvent> workaroundKeyHandler;
    private EventHandler<KeyEvent> menuButtonEventHandler;
    private EventHandler<KeyEvent> contextMenuHandler;

    public FX8TableForm(boolean scrollAdjustEnbld) {
        this.allItems = FXCollections.observableArrayList();
        this.scroll = scrollAdjustEnbld;
        this.visible = false;
        this.editEnabled = false;
        this.editPreview = false;
        this.getStyleClass().add((Object)"FX8TableForm");
        this.contextMenu = new ContextMenu();
        this.contextMenuHandler = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode().equals((Object)KeyCode.ESCAPE)) {
                    keyEvent.consume();
                    if (keyEvent.getEventType().equals(KeyEvent.KEY_RELEASED)) {
                        FX8TableForm.this.contextMenu.hide();
                    }
                }
            }
        };
        this.contextMenu.addEventFilter(KeyEvent.ANY, this.contextMenuHandler);
        this.table = new TableView();
        this.table.setEditable(true);
        this.table.setPlaceholder((Node)new Text(""));
        this.table.setItems(FXCollections.observableArrayList());
        this.table.setContextMenu(this.contextMenu);
        this.keyEventHandler = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (!keyEvent.getEventType().equals(KeyEvent.KEY_PRESSED)) {
                    return;
                }
                if (keyEvent.getCode().equals((Object)KeyCode.ESCAPE)) {
                    FX8TableForm.this.table.getScene().getOnKeyPressed().handle((Event)keyEvent);
                }
                if (FX8TableForm.this.editEnabled && keyEvent.getCode().equals((Object)KeyCode.ENTER)) {
                    keyEvent.consume();
                    FX8TableForm.this.myRequestFocus();
                }
                if (keyEvent.getCode().equals((Object)KeyCode.C) && keyEvent.isControlDown()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            HashSet selectedIndices = new HashSet(FX8TableForm.this.table.getSelectionModel().getSelectedIndices());
                            int[] ar = new int[selectedIndices.size()];
                            int someI = 0;
                            for (Object index : selectedIndices.toArray()) {
                                ar[someI++] = (Integer)index;
                            }
                            Arrays.sort(ar);
                            ArrayList<Object> listOfSelectedObjects = new ArrayList<Object>();
                            for (int index : ar) {
                                Object obj = FX8TableForm.this.table.getItems().get(index);
                                listOfSelectedObjects.add(obj);
                            }
                            ObservableList tableCols = FX8TableForm.this.table.getColumns();
                            for (int index = 0; index < ListSequence.fromList(FX8TableForm.this.columnWithConverter).count(); ++index) {
                                ((PropertyAndConverter)((Object)ListSequence.fromList(FX8TableForm.this.columnWithConverter).getElement((int)index))).visible = ((TableColumn)tableCols.get(index)).isVisible();
                            }
                            String csv = FX8TableForm.this.genParent.convertAsCsv(FX8TableForm.this.allItems, listOfSelectedObjects, FX8TableForm.this.columnWithConverter);
                            ClipboardContent allContent = new ClipboardContent();
                            allContent.putString(csv);
                            Clipboard.getSystemClipboard().setContent((Map)allContent);
                        }
                    });
                }
            }
        };
        this.table.addEventHandler(KeyEvent.ANY, this.keyEventHandler);
        this.workaroundKeyHandler = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((Object)KeyCode.ENTER)) {
                    event.consume();
                }
            }
        };
        this.table.addEventHandler(KeyEvent.KEY_PRESSED, this.workaroundKeyHandler);
        this.topPane = new BorderPane();
        this.onTheRight = new HBox();
        this.onTheRight.setAlignment(Pos.BASELINE_RIGHT);
        this.selectionPosition = new Label();
        this.selectionPosition.getStyleClass().add((Object)"titleLabel");
        this.selectionPosition.setPrefWidth(90.0);
        this.selectionPosition.minWidth(90.0);
        this.selectionPosition.setTextAlignment(TextAlignment.RIGHT);
        this.selectionPosition.setAlignment(Pos.BASELINE_RIGHT);
        this.searchField = new TextField();
        this.searchField.getStyleClass().add((Object)"FX8TableSearchField");
        this.searchField.setPrefSize(100.0, 20.0);
        this.searchField.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent p0) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FX8TableForm.this.applyFilter(null);
                    }
                });
            }
        });
        this.searchEnabled = true;
        this.onTheRight.getChildren().addAll((Object[])new Node[]{this.searchField, this.selectionPosition});
        this.topPane.setRight((Node)this.onTheRight);
        this.titleLabel = new FX8FlagBox();
        this.topPane.setLeft((Node)this.titleLabel);
        this.selectionSummaryLine = new Label("");
        this.tableSummaryLine = new Label("");
        this.topPane.getStyleClass().add((Object)"formstopPane");
        this.setTop((Node)this.topPane);
        this.setCenter((Node)this.table);
        this.selectionHandlerEnabled = false;
        this.selectionChangedEnabled = true;
        this.table.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.selectionListener = new ListChangeListener<Integer>(){

            public void onChanged(ListChangeListener.Change<? extends Integer> change) {
                if (FX8TableForm.this.selectionHandlerEnabled) {
                    FX8TableForm.this.selectionHandlerEnabled = false;
                    FX8TableForm.this.setCounterText("");
                    int last = -4711;
                    ArrayList<Object> selectedItems = new ArrayList<Object>();
                    Object[] selectedElements = change.getList().toArray();
                    Arrays.sort(selectedElements);
                    for (Object theIntObject : selectedElements) {
                        int i = (Integer)theIntObject;
                        if (i == last) continue;
                        if (i < 0) {
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    FX8TableForm.this.table.getSelectionModel().clearSelection();
                                    FX8TableForm.this.pushSelection((IOFXSelection)new Selection(FX8TableForm.this.elementClass));
                                    FX8TableForm.this.selectionHandlerEnabled = true;
                                }
                            });
                            return;
                        }
                        last = i;
                        selectedItems.add(FX8TableForm.this.table.getItems().get(i));
                    }
                    if (selectedItems.size() == 0) {
                        FX8TableForm.this.pushSelection((IOFXSelection)new Selection(FX8TableForm.this.elementClass));
                    } else {
                        FX8TableForm.this.pushSelection((IOFXSelection)new Selection(FX8TableForm.this.elementClass, selectedItems));
                    }
                    FX8TableForm.this.selectionHandlerEnabled = true;
                }
            }
        };
        this.table.getSelectionModel().getSelectedIndices().addListener(this.selectionListener);
        this.table.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() == 2 && event.getButton().equals((Object)MouseButton.PRIMARY)) {
                    if (FX8TableForm.this.actionHBox != null) {
                        FX8TableForm.this.actionHBox.doubleClickReceived();
                    }
                } else if (event.getClickCount() == 2) {
                    if (FX8TableForm.this.visible) {
                        ListSequence.fromList(FX8TableForm.this.notVisibleColummns).visitAll((_FunctionTypes._void_P1_E0)new _FunctionTypes._void_P1_E0<TableColumn>(){

                            public void invoke(TableColumn it) {
                                it.setVisible(false);
                            }
                        });
                        FX8TableForm.this.visible = false;
                    } else {
                        ListSequence.fromList(FX8TableForm.this.notVisibleColummns).visitAll((_FunctionTypes._void_P1_E0)new _FunctionTypes._void_P1_E0<TableColumn>(){

                            public void invoke(TableColumn it) {
                                it.setVisible(true);
                            }
                        });
                        FX8TableForm.this.visible = true;
                    }
                    double totalWidth = 1.0;
                    for (TableColumn col : FX8TableForm.this.table.getColumns()) {
                        if (!col.isVisible()) continue;
                        totalWidth += (double)((Integer)col.getUserData()).intValue();
                    }
                    for (TableColumn col : FX8TableForm.this.table.getColumns()) {
                        if (!col.isVisible()) continue;
                        double thisWitdh = (double)((Integer)col.getUserData()).intValue() / totalWidth;
                        col.prefWidthProperty().bind((ObservableValue)FX8TableForm.this.table.widthProperty().multiply(thisWitdh));
                    }
                }
            }
        });
    }

    public void applyFilter(IOFXSelection selection) {
        if (this.searchEnabled && this.allItems != null && this.table != null) {
            boolean foundSelection;
            Object remainingSelections = this.table.getSelectionModel().getSelectedItems();
            this.currentItems = FXCollections.observableArrayList();
            ObservableList tableCols = this.table.getColumns();
            String searchFor = this.searchField.getText().replace(".", "").toLowerCase();
            for (int i = 0; i < this.allItems.size(); ++i) {
                boolean found = false;
                for (int j = 0; j < ListSequence.fromList(this.columnWithConverter).count(); ++j) {
                    if (!((TableColumn)tableCols.get(j)).isVisible() || !((PropertyAndConverter)((Object)ListSequence.fromList(this.columnWithConverter).getElement(j))).contains(this.allItems.get(i), searchFor)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                this.currentItems.add(this.allItems.get(i));
            }
            if (selection != null) {
                remainingSelections = selection.getObjects();
            }
            if (!(foundSelection = this.currentItems.containsAll((Collection)remainingSelections))) {
                this.selectionHandlerEnabled = false;
                this.table.getSelectionModel().clearSelection();
                this.selectionHandlerEnabled = true;
            }
            this.updateTableToCurrentItems();
            if (!foundSelection) {
                this.selectionHandlerEnabled = false;
                this.pushSelection((IOFXSelection)new Selection(this.elementClass));
                this.selectionHandlerEnabled = true;
            }
            this.setCounterText("");
        }
    }

    public void rootForm() {
        this.titleLabel.inRootForm();
    }

    public void setTitleText(String text) {
        this.titleLabel.setTitle(text);
    }

    public void setProblems(List<IOFXProblem> listOfProblems) {
        if (ListSequence.fromList(listOfProblems).count() == 0) {
            this.titleLabel.flag(listOfProblems);
            this.getCenter().getStyleClass().remove((Object)FX8FormContainer.formFlagBorder);
        } else {
            this.getCenter().getStyleClass().add((Object)FX8FormContainer.formFlagBorder);
            this.titleLabel.flag(listOfProblems);
        }
    }

    public void setCounterText(String pre) {
        ObservableList indices = this.table.getSelectionModel().getSelectedIndices();
        if (indices.size() == 1) {
            this.selectionPosition.setText(pre + " " + ((Integer)indices.get(0) + 1) + "/" + this.currentItems.size() + "  ");
        } else if (indices.size() > 1) {
            this.selectionPosition.setText(pre + " M/" + this.currentItems.size() + "  ");
        } else {
            this.selectionPosition.setText(pre + "  /" + this.currentItems.size() + "  ");
        }
    }

    public void setFormController(IGenSelControlled crtl) {
        this.genParent = crtl;
    }

    private void debug(String func, String msg) {
        System.err.println(System.currentTimeMillis() + " " + this.genParent.getClass().getName() + "  " + func + "()  " + msg);
    }

    private void pushSelection(IOFXSelection sel) {
        this.selectionChangedEnabled = false;
        if (this.genParent != null) {
            this.genParent.pushSelection(sel);
        }
        this.selectionChangedEnabled = true;
    }

    public void addMenuAndSetButtons(Menu folder) {
        this.actionHBox = new FX8ActionHBox(folder, this.contextMenu);
        this.onTheRight.getChildren().add((Object)this.actionHBox);
        this.menuButtonEventHandler = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent p0) {
                if (FX8TableForm.this.actionHBox != null) {
                    if (!p0.isControlDown() && p0.getCode().getName().length() == 1) {
                        return;
                    }
                    FX8TableForm.this.actionHBox.hotKeyReceived(p0);
                }
            }
        };
        this.table.removeEventHandler(KeyEvent.KEY_PRESSED, this.workaroundKeyHandler);
        this.table.addEventHandler(KeyEvent.KEY_PRESSED, this.menuButtonEventHandler);
        this.table.addEventHandler(KeyEvent.KEY_PRESSED, this.workaroundKeyHandler);
    }

    @Deprecated
    public List<?> getHotKeysToRegister() {
        return null;
    }

    public boolean selectionChanged(IOFXSelection<T> sel) {
        if (!this.selectionChangedEnabled) {
            return true;
        }
        this.selectionHandlerEnabled = false;
        if (this.currentItems != null) {
            boolean selectionChangeNeeded = false;
            selectionChangeNeeded = true;
            if (selectionChangeNeeded) {
                this.table.getSelectionModel().clearSelection();
                List selection = sel.getObjects();
                int[] indizes = new int[ListSequence.fromList((List)selection).count()];
                int numFound = 0;
                if (this.currentItems.size() == 0 && ListSequence.fromList((List)selection).count() > 0) {
                    this.selectionHandlerEnabled = true;
                    return false;
                }
                if (this.currentItems.size() > 0 && ListSequence.fromList((List)selection).count() > 0) {
                    for (int i = 0; i < this.currentItems.size(); ++i) {
                        if (!ListSequence.fromList((List)selection).contains(this.currentItems.get(i))) continue;
                        indizes[numFound] = i;
                        ++numFound;
                    }
                    if (numFound != ListSequence.fromList((List)selection).count()) {
                        this.setCounterText("* ");
                        this.selectionHandlerEnabled = true;
                        return false;
                    }
                }
                if (indizes.length > 0) {
                    this.table.getSelectionModel().selectIndices(indizes[0], indizes);
                }
                if ((this.editEnabled || this.editPreview || this.scroll) && ListSequence.fromList((List)selection).count() > 0) {
                    int toScrollTo = this.table.getItems().indexOf(ListSequence.fromList((List)selection).last());
                    int total = this.currentItems.size();
                    if (toScrollTo >= 0) {
                        if (toScrollTo < total - 7) {
                            toScrollTo -= 7;
                        }
                        this.table.scrollTo(toScrollTo);
                    }
                }
            }
        }
        this.setCounterText("");
        this.selectionHandlerEnabled = true;
        return true;
    }

    public void loadList(List<T> objects, IOFXSelection<T> selection) {
        this.selectionHandlerEnabled = false;
        this.searchEnabled = false;
        this.allItems = FXCollections.observableArrayList(objects);
        if (this.searchField.getText().equals("")) {
            this.currentItems = this.allItems;
            this.updateTableToCurrentItems();
        } else {
            this.searchEnabled = true;
            this.applyFilter(selection);
        }
        this.selectionChanged(selection);
        this.setCounterText("");
        this.selectionHandlerEnabled = true;
        this.searchEnabled = true;
    }

    public void updateTableToCurrentItems() {
        Object[] sortOrders = this.table.getSortOrder().toArray();
        this.table.setItems(this.currentItems);
        this.table.getSortOrder().clear();
        for (Object o : sortOrders) {
            this.table.getSortOrder().add((Object)((TableColumn)o));
        }
        this.table.refresh();
    }

    public void addColumn(final String property, String label, final ITableCellStringConverter converter, int width, boolean editable, boolean folded, boolean important) {
        if (editable) {
            this.editEnabled = true;
            this.searchField.setText("");
            this.searchField.setDisable(true);
        }
        TableColumn col = new TableColumn(label);
        col.setText(label);
        col.setUserData((Object)width);
        if (folded) {
            ListSequence.fromList(this.notVisibleColummns).addElement((Object)col);
            ListSequence.fromList(this.columnWithConverter).addElement((Object)new PropertyAndConverter(ListSequence.fromList(this.columnWithConverter).count(), property, label, converter, width, !folded));
            col.setVisible(false);
        } else {
            double percent = 0.01 * (double)width;
            if (ListSequence.fromList(this.columnWithConverter).count() - ListSequence.fromList(this.notVisibleColummns).count() == 0) {
                percent -= 0.01;
            }
            col.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().multiply(percent));
            ListSequence.fromList(this.columnWithConverter).addElement((Object)new PropertyAndConverter(ListSequence.fromList(this.columnWithConverter).count(), property, label, converter, width, !folded));
        }
        col.setEditable(editable);
        col.setCellValueFactory(new FX8BeanPropertyValue(property));
        if (!editable) {
            col.setCellFactory((Callback)new MyTableCellFactory(converter));
        } else if (converter instanceof TableCellBigDecimalConverter) {
            col.setCellFactory((Callback)new Callback<TableColumn, TableCell>(){

                public TableCell call(TableColumn p0) {
                    return new FX8EditCellBigdeci(property, converter);
                }
            });
        } else if (converter instanceof TableCellStatusConverter) {
            col.setCellFactory((Callback)new Callback<TableColumn, TableCell>(){

                public TableCell call(TableColumn p0) {
                    return new FX8EditCellStatus(property, converter);
                }
            });
        } else {
            throw new IllegalArgumentException("Only bigdecimal and status are supported as editable by this runtime.");
        }
        this.table.getColumns().add((Object)col);
    }

    public void forceNotEditable() {
        for (int i = 0; i < this.table.getColumns().size(); ++i) {
            if (!((TableColumn)this.table.getColumns().get(i)).isEditable()) continue;
            ((TableColumn)this.table.getColumns().get(i)).setEditable(false);
        }
    }

    public void setEditPreview() {
        this.editPreview = true;
        this.searchField.setEditable(false);
        this.searchField.setDisable(true);
        this.searchField.setVisible(false);
        for (int i = 0; i < this.table.getColumns().size(); ++i) {
            ((TableColumn)this.table.getColumns().get(i)).setSortable(false);
        }
        this.table.setDisable(true);
    }

    public void endOfInitializationForElementClass(Class cls) {
        this.elementClass = cls;
    }

    public Object myRequestFocus() {
        TableView<T> focussedNode = null;
        if (this.editPreview) {
            return null;
        }
        if (this.table == null) {
            return null;
        }
        this.table.requestFocus();
        focussedNode = this.table;
        int i = this.table.getSelectionModel().getSelectedIndices().size();
        if (i == 1 && this.editEnabled) {
            for (TableColumn col : this.table.getColumns()) {
                if (col.getCellFactory() instanceof MyTableCellFactory) continue;
                this.table.edit(this.table.getSelectionModel().getSelectedIndex(), col);
                break;
            }
        }
        return focussedNode;
    }

    public void afterFullUiInitialized() {
    }

    public void addTableItemColor(String property, ITableCellStringConverter converter) {
    }

    public void installBottomLine() {
        this.selectionSummaryLine.setAlignment(Pos.BASELINE_RIGHT);
        this.tableSummaryLine.setAlignment(Pos.BASELINE_LEFT);
        HBox box = new HBox();
        box.setAlignment(Pos.BASELINE_CENTER);
        box.getChildren().addAll((Object[])new Node[]{this.tableSummaryLine, this.selectionSummaryLine});
        this.setBottom((Node)box);
        this.selectionSummaryLine.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().multiply(0.49));
        this.tableSummaryLine.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().multiply(0.49));
    }

    public void setSelectionSummaryLineText(String text) {
        this.selectionSummaryLine.setText(text);
        if (this.getBottom() == null) {
            this.installBottomLine();
        }
    }

    public void setTableSummaryLineText(String text) {
        this.tableSummaryLine.setText(text);
        if (this.getBottom() == null) {
            this.installBottomLine();
        }
    }

    public void gcClear() {
        this.selectionChangedEnabled = false;
        this.selectionHandlerEnabled = false;
        this.table.removeEventHandler(KeyEvent.ANY, this.keyEventHandler);
        this.contextMenu.removeEventFilter(KeyEvent.ANY, this.contextMenuHandler);
        this.table.setContextMenu(null);
        this.table.getSortOrder().clear();
        if (this.actionHBox != null) {
            this.table.removeEventHandler(KeyEvent.KEY_PRESSED, this.menuButtonEventHandler);
            this.actionHBox.gcClear();
            this.actionHBox = null;
        }
        this.table.removeEventHandler(KeyEvent.KEY_PRESSED, this.workaroundKeyHandler);
        this.table.getFocusModel().focus(null);
        this.table.setOnMouseClicked(null);
        this.table.getSelectionModel().getSelectedIndices().removeListener(this.selectionListener);
        this.table.setSelectionModel(null);
        this.table.setItems(FXCollections.observableArrayList());
        this.table.getColumns().clear();
        this.setCenter((Node)new Label("GC"));
        this.allItems.clear();
        this.currentItems.clear();
        this.allItems = null;
        this.currentItems = null;
        this.table = null;
    }

    public static class PropertyAndConverter
    extends IToolkit_TableForm.TableColumn {
        public PropertyAndConverter(int pos, String propName, String header, ITableCellStringConverter conv, int width, boolean visible) {
            super(pos, propName, header, conv, width, visible);
        }

        public boolean contains(Object o, String lowercasedString) {
            Object obj = MoJSON.get((Object)o, (String)this.propertyName);
            if (obj == null) {
                return false;
            }
            String st = this.mowareConverter.convert(obj);
            if (st == null) {
                return false;
            }
            return st.replace(".", "").toLowerCase().contains(lowercasedString);
        }
    }

    public static class MyTableCellFactory
    implements Callback<TableColumn, TableCell> {
        private ITableCellStringConverter converter;

        public MyTableCellFactory(ITableCellStringConverter conv) {
            this.converter = conv;
        }

        public TableCell call(TableColumn column) {
            return new MyTableCell(this.converter);
        }
    }

    public static class MyTableCell
    extends TableCell<Object, Object> {
        private ITableCellStringConverter converter;

        public MyTableCell(ITableCellStringConverter conv) {
            this.converter = conv;
        }

        protected void updateItem(Object myObject, boolean arg1) {
            super.updateItem(myObject, arg1);
            if (myObject != null && !arg1) {
                this.setText(this.converter.convert(myObject));
                if (this.converter.isRightAligned()) {
                    this.setAlignment(Pos.BASELINE_RIGHT);
                } else {
                    this.setAlignment(Pos.BASELINE_LEFT);
                }
            } else {
                this.setText(null);
            }
            String col = this.converter.getBgColor(myObject);
            if (col != null && !"".equals(col.trim())) {
                this.setStyle("-fx-text-fill: " + col);
            } else {
                this.setStyle("");
            }
        }

        public void gcClear() {
            this.converter = null;
        }
    }
}

