/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.windows;

import java.math.BigDecimal;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class XXX___EditingCell<T>
extends TableCell<T, Object> {
    private TextField textField;
    private int requested;

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.createTextField();
            this.setText(null);
            System.err.println("startEdit() setting Graphic() " + this.getIndex());
            this.setGraphic((Node)this.textField);
            this.textField.selectAll();
            this.textField.requestFocus();
        }
    }

    public void cancelEdit() {
        System.err.println("cancelEdit() received");
        super.cancelEdit();
        this.setText("" + this.getItem());
        this.setGraphic(null);
    }

    public boolean commitChanges() {
        try {
            BigDecimal xxx = new BigDecimal(this.textField.getText());
            System.err.println("commitChanges alost done: object after convert was " + xxx + "(type: " + xxx.getClass().getName() + ")");
            this.commitEdit(xxx);
            System.err.println("commitChanged done ... ");
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void updateItem(Object item, boolean empty) {
        super.updateItem(item, empty);
        this.setAlignment(Pos.BASELINE_RIGHT);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            this.getStyleClass().add((Object)"FX8EditingCell");
            if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
            } else {
                this.setText(this.getString());
                this.setGraphic(null);
            }
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue() && XXX___EditingCell.this.isEditing()) {
                    System.err.println("focusPropertyListner() FOCUS lost - canceling editing operation");
                    XXX___EditingCell.this.cancelEdit();
                }
            }
        });
        this.textField.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode().equals((Object)KeyCode.ESCAPE)) {
                    keyEvent.consume();
                    XXX___EditingCell.this.cancelEdit();
                }
                if (keyEvent.getCode().equals((Object)KeyCode.ENTER)) {
                    keyEvent.consume();
                    XXX___EditingCell.this.adjustPosition(true, 1);
                }
                if (keyEvent.getCode().equals((Object)KeyCode.DOWN)) {
                    keyEvent.consume();
                    System.err.println(" KEYEVENT: " + keyEvent);
                    XXX___EditingCell.this.adjustPosition(true, 1);
                }
                if (keyEvent.getCode().equals((Object)KeyCode.UP)) {
                    keyEvent.consume();
                    XXX___EditingCell.this.adjustPosition(true, -1);
                }
            }
        });
    }

    public void adjustPosition(boolean commit, int posdiff) {
        boolean okay = true;
        final TablePosition pos = this.getTableView().getEditingCell();
        if (commit) {
            okay = this.commitChanges();
        } else {
            this.cancelEdit();
            okay = false;
        }
        if (okay) {
            TableView v = this.getTableView();
            if (posdiff == 1) {
                v.fireEvent((Event)new KeyEvent((Object)this, (EventTarget)v, KeyEvent.KEY_PRESSED, "DOWN", "DOWN", KeyCode.DOWN, false, false, false, false));
            } else {
                v.fireEvent((Event)new KeyEvent((Object)this, (EventTarget)v, KeyEvent.KEY_PRESSED, "UP", "UP", KeyCode.UP, false, false, false, false));
            }
            this.requested = pos.getRow() + posdiff;
            int total = v.getItems().size();
            if (this.requested >= total || this.requested < 0) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        XXX___EditingCell.this.getTableView().requestFocus();
                    }
                });
            } else {
                System.err.print("Requested is " + this.requested + "  ");
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TableColumn coloumnPost = (TableColumn)XXX___EditingCell.this.getTableView().getColumns().get(pos.getColumn());
                        XXX___EditingCell.this.getTableView().edit(XXX___EditingCell.this.requested, coloumnPost);
                    }
                });
            }
        }
    }

    private String getString() {
        return this.getItem() == null ? "" : "" + this.getItem();
    }
}

