/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.h2forms.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionBindingEvent;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.dataux.runtime.core.ApplicationMDI;
import org.modellwerkstatt.dataux.runtime.core.BasisCmdStart;
import org.modellwerkstatt.dataux.runtime.core.FlagOnUiEvent;
import org.modellwerkstatt.dataux.runtime.core.IApplication;
import org.modellwerkstatt.dataux.runtime.core.ICommandContainer;
import org.modellwerkstatt.dataux.runtime.core.UxEvent;
import org.modellwerkstatt.dataux.runtime.genspecifications.CmdAction;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenAppUiModule;
import org.modellwerkstatt.dataux.runtime.genspecifications.Menu;
import org.modellwerkstatt.dataux.runtime.genspecifications.TileAction;
import org.modellwerkstatt.dataux.runtime.telemetrics.AppJmxRegistration;
import org.modellwerkstatt.dataux.runtime.telemetrics.Dux;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_CommandContainerUi;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_MainWindow;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.h2forms.core.ContextClient;
import org.modellwerkstatt.h2forms.core.ContextPage;
import org.modellwerkstatt.h2forms.core.H2Dialog;
import org.modellwerkstatt.h2forms.core.H2FormRequestStateException;
import org.modellwerkstatt.h2forms.core.IH2Controller;
import org.modellwerkstatt.h2forms.core.IH2FormsTemplateRenderer;
import org.modellwerkstatt.h2forms.core.IH2UiFactory;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXCmdModule;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.runtime.OFXLogger;
import org.modellwerkstatt.objectflow.runtime.OFXUrlParams;

public class H2Application
implements IH2Controller,
IToolkit_MainWindow {
    public static final String MESSAGE_GENERAL_ID = "message_";
    public static final String MESSAGE_ESC_CRTL_CODE = "message_esc";
    public static final String MESSAGE_OK_CRTL_CODE = "message_ok";
    private OFXUrlParams lastUrl;
    public static final String LOGIN_CODE = "login";
    public static final String LOGOUT_CODE = "logout";
    public static final String LOGGEDOUT_CODE = "loggedout";
    public static final String FROMVERSION_CODE = "fromversion";
    public static final String APPSTART_CODE = "appstart";
    public static final String REROUTE_CODE = "reroute";
    protected IH2UiFactory uiFactory;
    protected ApplicationMDI appController;
    protected ContextClient ctxCli;
    private List<H2Menu> currentTileMenu;
    private List<H2Menu> currentStartMenu;
    protected long currentAppFormSequence;
    protected String origHttpSessionId;
    protected String debugMessage;
    protected IToolkit_CommandContainerUi currentCommandUI;
    protected H2Dialog latestDialog;
    protected boolean initiallyExecutedStartupCmd;
    protected boolean removeFromSessionAndClose;
    protected boolean logoutRequested;
    protected String parDeployForwardUrl;
    protected String applicationStateText;
    protected String rerouteUrl;

    public H2Application(IH2UiFactory factory, IGenAppUiModule genApplication, AppJmxRegistration reghelper, ContextClient cli) {
        this.uiFactory = factory;
        this.ctxCli = cli;
        this.currentCommandUI = null;
        this.latestDialog = null;
        this.origHttpSessionId = null;
        this.rerouteUrl = null;
        this.removeFromSessionAndClose = false;
        this.appController = new ApplicationMDI((IToolkit_UiFactory)this.uiFactory, (IToolkit_MainWindow)this, genApplication, reghelper, this.uiFactory.getContextStatics().getMowarePlatform());
        this.currentAppFormSequence = 0L;
        this.logoutRequested = false;
        this.parDeployForwardUrl = null;
        this.debugMessage = "";
        this.applicationStateText = null;
    }

    public void initializeAndLogin(HttpServletRequest request, IOFXUserEnvironment userEnv, String startupInfo) {
        OFXUrlParams url = new OFXUrlParams();
        url.parse(request.getPathInfo());
        this.initiallyExecutedStartupCmd = this.appController.initializeApplication(url, this.uiFactory.getContextStatics().getGuessedServerName(), userEnv, this.ctxCli.getRemoteAddr(), startupInfo);
        this.ctxCli.setUsername(userEnv.getUserName());
        this.ctxCli.setUserid(userEnv.getUserId());
        this.ctxCli.setLangIndex(userEnv.getLangIndex());
        this.ctxCli.setDynamicStatusInfo(this.appController.getDynamicStatusInfoOrSD());
        this.ctxCli.setNETWORK_PROBLEMS(this.uiFactory.getSystemLabel(this.ctxCli.getLangIndex(), MoWareTranslations.Key.NETWORK_PROBLEMS));
        boolean useDebugPerDefault = this.uiFactory.isDebugUsers(userEnv.getUserName());
        this.appController.setDebug(useDebugPerDefault);
    }

    @Override
    public void handleRequest(HttpServletRequest request, String cookieInfo) {
        boolean appstartPresent;
        String naviCrtl = request.getParameter("NaviCrtl");
        String formSequenceIdSt = request.getParameter("SequenceId");
        long recvformSequenceId = this.currentAppFormSequence;
        if (formSequenceIdSt != null) {
            recvformSequenceId = Long.valueOf(formSequenceIdSt);
        }
        String progressor = request.getParameter("Progressor");
        String devicesId = request.getParameter("DeviceId");
        String lastRequestLog = request.getParameter("LastRequestLog");
        if (lastRequestLog == null) {
            lastRequestLog = "";
        }
        long lastRequestDiffMillis = this.zeroOrReqParam(request, "LastRequestDiffMillis");
        long lastRequestDiffMillis2 = this.zeroOrReqParam(request, "LastRequestDiffMillis2");
        long lastRequestDiffMillis3 = this.zeroOrReqParam(request, "LastRequestDiffMillis3");
        this.appController.setuser_lastRequestDiffMillis(lastRequestDiffMillis, lastRequestDiffMillis2, lastRequestDiffMillis3, lastRequestLog);
        this.appController.setuser_progressor(progressor);
        this.appController.setuser_formseqId("frm " + request.getParameter("SequenceId") + " / cur " + this.currentAppFormSequence);
        this.ctxCli.setDeviceId(devicesId);
        this.appController.adjustDeviceID(this.ctxCli.getDeviceId());
        this.rerouteUrl = request.getParameter(REROUTE_CODE);
        if (this.rerouteUrl != null) {
            this.rerouteUrl = this.rerouteUrl + "?appstart=true";
        }
        this.lastUrl = new OFXUrlParams();
        this.lastUrl.parse(request.getPathInfo());
        this.applicationStateText = null;
        this.logoutRequested = LOGOUT_CODE.equals(this.lastUrl.getFirstOrEmpty()) || request.getParameter(LOGOUT_CODE) != null || LOGOUT_CODE.equals(naviCrtl);
        boolean initialRequest = this.currentAppFormSequence == 0L;
        boolean bl = appstartPresent = request.getParameter(APPSTART_CODE) != null;
        if (initialRequest && request.getParameter(FROMVERSION_CODE) != null) {
            String fromVersion = request.getParameter(FROMVERSION_CODE);
            if (!this.appController.getEscSwAppVersion().equals(fromVersion)) {
                this.applicationStateText = this.uiFactory.getSystemLabel(this.ctxCli.getLangIndex(), MoWareTranslations.Key.APPLICATION_REPLACED);
            }
            naviCrtl = null;
        } else if (initialRequest && LOGIN_CODE.equals(naviCrtl)) {
            naviCrtl = null;
        } else if (initialRequest && !this.noNaviCrtl_Get(naviCrtl)) {
            naviCrtl = null;
            this.applicationStateText = this.uiFactory.getSystemLabel(this.ctxCli.getLangIndex(), MoWareTranslations.Key.APPLICATION_RESTARTED);
        }
        if (this.initiallyExecutedStartupCmd && initialRequest && this.latestDialog != null) {
            this.processNoneModalDialog();
        }
        Dux.hl((String)("STATE - urlParams " + this.lastUrl.asUrl() + ", naviCrtl '" + naviCrtl + "', ui " + this.currentCommandUI));
        Dux.hl((String)("        dialog " + this.latestDialog));
        Dux.hl((String)("        seq " + this.currentAppFormSequence + ", startup " + this.appController.isStartupCmdRunning() + ", cmd " + this.appController.isCommandRunning()));
        boolean noNavCrtl = this.noNaviCrtl_Get(naviCrtl);
        if (this.logoutRequested) {
            this.removeFromSessionAndClose = true;
        } else if (recvformSequenceId < this.currentAppFormSequence) {
            String msg = "App comm out of sync, request not handled, since currentAppFromSequence " + this.currentAppFormSequence + " not in sync with formSequenceId " + recvformSequenceId;
            this.internalHtmlProblemPrevented(request, msg);
            Dux.hl((String)msg);
        } else if (initialRequest && (this.initiallyExecutedStartupCmd || this.appController.isStartupCmdRunning())) {
            Dux.hl((String)("STRTUP - Initial request with startup cmd! Install cmd to start? " + this.lastUrl.hasCmdName()));
            if (this.lastUrl.hasCmdName()) {
                final OFXUrlParams toStartParam = this.lastUrl;
                this.appController.execAfterStartupOrNow(new Runnable(){

                    @Override
                    public void run() {
                        Dux.hl((String)"execAfterStartupOrNow() startup done, need to start url");
                        H2Application.this.hack_cmdInitDoneForwardUrlAdjustDlg(toStartParam);
                    }
                });
            }
        } else if (noNavCrtl && this.appController.isStartupCmdRunning()) {
            Dux.hl((String)"GET - Request, startup command not done yet, take as reload.");
        } else if (noNavCrtl && this.appController.isCommandRunning() && appstartPresent) {
            Dux.hl((String)"GET - Request, appstart true and some cmds running.");
        } else if (noNavCrtl) {
            Dux.hl((String)("GET - killing dialog (and running cmds - " + this.appController.isCommandRunning() + ") start " + this.lastUrl.asUrl()));
            this.latestDialog = null;
            if (this.appController.isCommandRunning()) {
                this.appController.logMowareTracing("", "", "org.modellwerkstatt.RT", "Got a HTTP_GET/noNaviCrtlGiven and killing running cmds.", this.appController.fullApplicationCrtlState());
                this.appController.internal_closeAllRunningCmds();
            }
            if (this.lastUrl.hasCmdName()) {
                this.startByParam(this.lastUrl);
                this.processNoneModalDialog();
            }
        } else {
            Dux.hl((String)"POST - handle cmd or dialog... ");
            this.processDialogOrCommand(request, naviCrtl);
        }
    }

    public void processNoneModalDialog() {
        Dux.hl((String)("latestDialog is " + this.latestDialog));
        if (this.latestDialog != null && !this.latestDialog.isModalWithButtons() && this.latestDialog.getRunnable() != null) {
            Dux.hl((String)"RUNNING runnable");
            try {
                this.latestDialog.getRunnable().run(true);
                this.latestDialog.clearRunnable();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                Dux.hl((String)"RUNNING runnable done... ");
            }
        }
    }

    public void processDialogOrCommand(HttpServletRequest request, String naviCrtl) {
        if (this.latestDialog == null && this.currentCommandUI == null) {
            this.internalHtmlProblemPrevented(request, "This can not happen - no dlg, no cmd. [" + this.latestDialog + " / " + this.currentCommandUI + "] with naviCrtl " + naviCrtl);
            throw new RuntimeException("This can not happen - no dlg, no cmd. [" + this.latestDialog + " / " + this.currentCommandUI + "]");
        }
        if (naviCrtl == null) {
            throw new RuntimeException("This can not happen - naviCrtl is null.");
        }
        if (this.latestDialog != null) {
            if (!naviCrtl.startsWith(MESSAGE_GENERAL_ID)) {
                throw new RuntimeException("This can not happen.");
            }
            Dux.hl((String)("Processing " + naviCrtl + " for Dialog [" + this.latestDialog.getText() + "]"));
            IApplication.DlgRunnable runbl = this.latestDialog.getRunnable();
            boolean wasOk = this.latestDialog.isCloseQuestion() ? MESSAGE_OK_CRTL_CODE.equals(naviCrtl) : true;
            this.latestDialog = null;
            if (runbl != null) {
                runbl.run(wasOk);
            }
        } else {
            try {
                this.uiFactory.getRenderer().handleRequest(request, naviCrtl, this.currentCommandUI);
            }
            catch (H2FormRequestStateException ex) {
                String msg = ex.getMessage() + " in " + this.currentCommandUI + " (currentAppFormSequence " + this.currentAppFormSequence + ")\n" + this.appController.fullApplicationCrtlState();
                this.internalHtmlProblemPrevented(request, msg + "\n\n" + OFXConsoleHelper.stackTrace2String((Throwable)ex));
            }
            this.processNoneModalDialog();
        }
    }

    @Override
    public void createResponse(HttpServletResponse response, boolean xmlHttpReq) throws IOException {
        ++this.currentAppFormSequence;
        Dux.hl((String)("RESPONSE - commandUi " + this.currentCommandUI + ", latestDialog " + this.latestDialog + " parDeployForwardUrl is " + this.parDeployForwardUrl));
        if (this.logoutRequested) {
            String url = this.uiFactory.getContextStatics().getServletPath() + "/?loggedout=true";
            this.uiFactory.execLocationRedirect(response, url);
        } else if (this.parDeployForwardUrl != null) {
            if (this.rerouteUrl == null) {
                this.uiFactory.execLocationRedirect(response, this.parDeployForwardUrl);
            } else {
                this.uiFactory.execLocationRedirect(response, this.rerouteUrl);
            }
        } else {
            this.ctxCli.setDebug(this.appController.isDebug());
            this.ctxCli.setBrandingId(this.appController.getUserEnvironment().getBrandingId());
            this.ctxCli.setDynamicStatusInfo(this.appController.getDynamicStatusInfoOrSD());
            long millis = DeprecatedServerDateProvider.getSqlServerDateTime().getMillis();
            ContextPage ctxPage = new ContextPage(this.currentAppFormSequence, xmlHttpReq, millis);
            ctxPage.setIsPreventHtmlCaching(this.appController.getAppTelemetrics().isPreventHtmlCaching());
            ctxPage.setDebugMessage(this.debugMessage);
            ctxPage.setMainLandingMenu(this.currentTileMenu);
            ctxPage.setStartMenu(this.currentStartMenu);
            ctxPage.setAppStateText(this.applicationStateText);
            String redirectRequestedByUserService = this.appController.getLastRequestedRedirectAndReset();
            if (redirectRequestedByUserService != null) {
                this.uiFactory.execLocationRedirect(response, redirectRequestedByUserService);
            } else if (this.currentCommandUI != null) {
                this.uiFactory.getRenderer().handleResponse(response, this.uiFactory.getContextStatics(), this.ctxCli, ctxPage, this.latestDialog, this.currentCommandUI);
            } else if (this.latestDialog == null && this.rerouteUrl == null && !this.appController.isCommandRunning() && this.lastUrl.hasCmdName()) {
                this.uiFactory.execLocationRedirect(response, this.uiFactory.getContextStatics().getServletPath() + "/");
            } else if (this.rerouteUrl != null) {
                if (this.latestDialog == null || this.latestDialog.isToast()) {
                    this.uiFactory.execLocationRedirect(response, this.rerouteUrl);
                    this.rerouteUrl = null;
                } else {
                    if (!this.latestDialog.isModalWithButtons()) {
                        this.latestDialog.addButton(new H2Dialog.DialogButton(this.uiFactory.getSystemLabel(this.ctxCli.getLangIndex(), MoWareTranslations.Key.OK_BUTTON), MESSAGE_OK_CRTL_CODE));
                    }
                    this.uiFactory.getRenderer().handleSpecialPageResponse(IH2FormsTemplateRenderer.SpecialPage.LANDING_PAGE, response, this.uiFactory.getContextStatics(), this.ctxCli, ctxPage, this.latestDialog);
                }
            } else {
                this.uiFactory.getRenderer().handleSpecialPageResponse(IH2FormsTemplateRenderer.SpecialPage.LANDING_PAGE, response, this.uiFactory.getContextStatics(), this.ctxCli, ctxPage, this.latestDialog);
            }
            if (this.latestDialog != null && !this.latestDialog.isModalWithButtons()) {
                this.latestDialog = null;
            }
        }
    }

    public void hack_cmdInitDoneForwardUrlAdjustDlg(final OFXUrlParams toStart) {
        Dux.hl((String)("toStart " + toStart.asUrl() + " - latestDlg " + this.latestDialog));
        if (!toStart.hasCmdName()) {
            throw new RuntimeException("This can not happen. ToStart is " + toStart.asUrl());
        }
        if (this.latestDialog != null && !this.latestDialog.isModalWithButtons()) {
            if (this.latestDialog.getRunnable() != null) {
                throw new RuntimeException("This can not happen. Rnbl not null in " + this.latestDialog);
            }
            this.latestDialog.runnable = new IApplication.DlgRunnable(){

                public void run(boolean confirmed) {
                    H2Application.this.startByParam(toStart);
                    H2Application.this.processNoneModalDialog();
                }
            };
            this.latestDialog.addButton(new H2Dialog.DialogButton(this.uiFactory.getSystemLabel(this.ctxCli.getLangIndex(), MoWareTranslations.Key.OK_BUTTON), MESSAGE_OK_CRTL_CODE));
        } else if (this.latestDialog == null) {
            this.startByParam(toStart);
            this.processNoneModalDialog();
        }
    }

    public boolean noNaviCrtl_Get(String naviCrtl) {
        return naviCrtl == null || naviCrtl.trim().equals("");
    }

    public void internalHtmlProblemPrevented(HttpServletRequest request, String msg) {
        String key;
        Enumeration keyEnumeration = request.getParameterNames();
        String requestDump = "\n Current url path is " + request.getMethod() + " '" + request.getPathInfo() + "'\n";
        requestDump = requestDump + "\nParameters:\n";
        while (keyEnumeration.hasMoreElements()) {
            key = (String)keyEnumeration.nextElement();
            requestDump = requestDump + key + ": " + request.getParameter(key) + "\n";
        }
        keyEnumeration = request.getHeaderNames();
        requestDump = requestDump + "\nHeaders:\n";
        while (keyEnumeration.hasMoreElements()) {
            key = (String)keyEnumeration.nextElement();
            requestDump = requestDump + key + ": " + request.getHeader(key) + "\n";
        }
        keyEnumeration = request.getAttributeNames();
        requestDump = requestDump + "\nAttributes:\n";
        while (keyEnumeration.hasMoreElements()) {
            key = (String)keyEnumeration.nextElement();
            requestDump = requestDump + key + ": " + request.getAttribute(key) + "\n";
        }
        if (this.appController != null) {
            this.appController.logFrmwrkProblem("", "", "org.modellwerkstatt.RT", msg, requestDump);
        } else {
            OFXLogger.log(H2Application.class, (IOFXCoreReporter.LogPriority)IOFXCoreReporter.LogPriority.ERROR, (String)("[no app crtl available, not using logProblem()] " + msg + requestDump), null);
        }
    }

    public void closeApplicationAndExit() {
        this.removeFromSessionAndClose = true;
        this.currentCommandUI = null;
    }

    public void showDialog(IToolkit_MainWindow.DlgType type, String text, IApplication.DlgRunnable callback) {
        if (this.latestDialog != null) {
            throw new RuntimeException("This can not happen. Dialog is " + this.latestDialog + " but overwritten by '" + text + "'");
        }
        if (type.equals((Object)IToolkit_MainWindow.DlgType.QUESTIONCLOSE_SMALL)) {
            this.latestDialog = new H2Dialog(type, this.uiFactory.getSystemLabel(this.ctxCli.getLangIndex(), MoWareTranslations.Key.QUESTION), text, callback);
            this.latestDialog.addButton(new H2Dialog.DialogButton(this.uiFactory.getSystemLabel(this.ctxCli.getLangIndex(), MoWareTranslations.Key.NO_BUTTON), MESSAGE_ESC_CRTL_CODE));
            this.latestDialog.addButton(new H2Dialog.DialogButton(this.uiFactory.getSystemLabel(this.ctxCli.getLangIndex(), MoWareTranslations.Key.DISCARD_BUTTON), MESSAGE_OK_CRTL_CODE));
        } else if (type.equals((Object)IToolkit_MainWindow.DlgType.ERROR_LARGE) || type.equals((Object)IToolkit_MainWindow.DlgType.ERROR_SMALL)) {
            this.latestDialog = new H2Dialog(type, this.uiFactory.getSystemLabel(this.ctxCli.getLangIndex(), MoWareTranslations.Key.ERROR), text, callback);
            this.latestDialog.addButton(new H2Dialog.DialogButton(this.uiFactory.getSystemLabel(this.ctxCli.getLangIndex(), MoWareTranslations.Key.OK_BUTTON), MESSAGE_OK_CRTL_CODE));
        } else {
            this.latestDialog = new H2Dialog(type, this.uiFactory.getSystemLabel(this.ctxCli.getLangIndex(), MoWareTranslations.Key.INFORMATION), text, callback);
        }
    }

    public void showProblemsDialog(List<IOFXProblem> problems, IApplication.DlgRunnable callback) {
        if (this.latestDialog != null) {
            throw new RuntimeException("This can not happen. Dialog is " + this.latestDialog + " but overwritten by " + FlagOnUiEvent.asSimpleString(problems));
        }
        this.latestDialog = new H2Dialog(problems, callback);
    }

    public void showGraphDebugger(List<Object> graph, String controllerInfo) {
    }

    public void addStatusInformation(String info) {
    }

    public void setToastMessage(String info) {
        this.latestDialog = new H2Dialog(true, IToolkit_MainWindow.DlgType.INFO_SMALL, this.uiFactory.getSystemLabel(this.ctxCli.getLangIndex(), MoWareTranslations.Key.INFORMATION), info, null);
    }

    public void setAppInfo(String appName, String version, String dynTitle, int brandingId) {
    }

    public void setMenuAndInit(int langIndex, Menu startMenu, Menu extrasMenu, Menu helpMenu) {
        this.currentStartMenu = ListSequence.fromList(new ArrayList());
        int i = 0;
        for (CmdAction item : startMenu.getAllCmdActionsOfMenu()) {
            boolean enabled = item.reevalEnabled();
            H2Menu m = new H2Menu("_startmenu" + i, item, item.hideWhenDisabled ? enabled : true, enabled, null, null);
            ListSequence.fromList(this.currentStartMenu).addElement((Object)m);
            ++i;
        }
        if (ListSequence.fromList(this.currentStartMenu).count() == 0) {
            this.currentStartMenu = null;
        }
    }

    public void showTiles(List<TileAction> tiles) {
        this.currentTileMenu = ListSequence.fromList(new ArrayList());
        int i = 0;
        for (TileAction item : tiles) {
            boolean enabled = item.getAction().reevalEnabled();
            H2Menu m = new H2Menu("_tilemenu" + i, item.getAction(), item.getAction().hideWhenDisabled ? enabled : true, enabled, item.getColor(), null);
            ListSequence.fromList(this.currentTileMenu).addElement((Object)m);
            ++i;
        }
        if (ListSequence.fromList(this.currentTileMenu).count() == 0) {
            this.currentTileMenu = null;
        }
    }

    public void addTab(IToolkit_CommandContainerUi ui) {
        this.currentCommandUI = ui;
    }

    public void focusTab(IToolkit_CommandContainerUi ui) {
        this.currentCommandUI = ui;
    }

    public void ensureTabClosed(IToolkit_CommandContainerUi ui) {
        this.currentCommandUI = null;
    }

    public void ensureHotkeyAvailable(List<String> hotkeys) {
    }

    public void execEventInBackground(ICommandContainer sender, Runnable r) {
        throw new RuntimeException("Background processing not supported in this implementation.");
    }

    public void execEventInForeground(ICommandContainer sender, UxEvent event) {
        throw new RuntimeException("Not supported in h2forms, you should already be in an foreground thread?");
    }

    public boolean inUiThread() {
        return true;
    }

    public void valueBound(HttpSessionBindingEvent event) {
        if (this.origHttpSessionId == null) {
            this.origHttpSessionId = event.getSession().getId();
        }
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        this.externalCloseApplicationWithSessionId(event.getSession().getId());
    }

    @Override
    public void externalCloseApplicationWithSessionId(String sessionId) {
        if (this.appController != null && !this.appController.inShutdownMode()) {
            this.appController.internal_immediatelyShutdown();
        }
    }

    @Override
    public IH2Controller swapToNextController() {
        return null;
    }

    @Override
    public boolean isRemoveFromSessionAndClose() {
        return this.removeFromSessionAndClose;
    }

    @Override
    public boolean hasCommitableSessionRunning() {
        return !this.appController.noGraphsToCommit();
    }

    public void setCurrentTabModal(boolean lock) {
    }

    public void parDeploymentForwardNow() {
        Dux.hl((String)("parallel deployment, forward to next version. lastUrl: " + this.lastUrl));
        this.parDeployForwardUrl = this.uiFactory.getContextStatics().getServletPath();
        if (this.lastUrl != null) {
            this.parDeployForwardUrl = this.parDeployForwardUrl + this.lastUrl.asUrl();
        }
        if (!this.parDeployForwardUrl.endsWith("/")) {
            this.parDeployForwardUrl = this.parDeployForwardUrl + "/";
        }
        this.parDeployForwardUrl = this.parDeployForwardUrl + "?fromversion=" + this.appController.getEscSwAppVersion();
        this.removeFromSessionAndClose = true;
    }

    public String toString() {
        return this.currentCommandUI == null ? "currentUi null" : this.currentCommandUI.toString();
    }

    @Override
    public String getShortUserInfo() {
        return this.appController == null ? "appController null" : this.appController.getUserName();
    }

    public long zeroOrReqParam(HttpServletRequest req, String paramName) {
        String paramValue = req.getParameter(paramName);
        long ret = 0L;
        if (paramValue != null && !"".equals(paramValue.trim())) {
            ret = Long.parseLong(paramValue.trim());
        }
        return ret;
    }

    public void startByParam(OFXUrlParams param) {
        boolean found = false;
        IOFXCmdModule.CmdUrlDefaults def = this.appController.getUrlDefaultFor(this.uiFactory.getAllCmdUrlDefaults(), param);
        if (def != null) {
            found = true;
            BasisCmdStart start = this.appController.cmdStartForUrlDefault(def, param, this.appController.getMainWindowEvalSession());
            if (start == null) {
                this.showDialog(IToolkit_MainWindow.DlgType.ERROR_SMALL, String.format(this.uiFactory.getSystemLabel(this.appController.getUserEnvironment().getLangIndex(), MoWareTranslations.Key.CMD_NOT_ENABLED), def.url), null);
            } else {
                this.appController.receiveAndProcess((UxEvent)start);
            }
        } else if (param.numParams() == 0) {
            H2Menu item = (H2Menu)ListSequence.fromList(this.currentTileMenu).findFirst(it -> it.isUri(param.getCmdName()));
            if (item == null) {
                item = (H2Menu)ListSequence.fromList(this.currentStartMenu).findFirst(it -> it.isUri(param.getCmdName()));
            }
            if (item != null) {
                found = true;
                boolean enabled = item.getAction().reevalEnabled();
                if (!enabled) {
                    this.showDialog(IToolkit_MainWindow.DlgType.ERROR_SMALL, String.format(this.uiFactory.getSystemLabel(this.appController.getUserEnvironment().getLangIndex(), MoWareTranslations.Key.CMD_NOT_ENABLED), item.label), null);
                } else {
                    item.getAction().startCommand();
                }
            }
        }
        if (!found) {
            String someCmds = String.join((CharSequence)", ", (Iterable<? extends CharSequence>)ListSequence.fromList(this.currentTileMenu).select(it -> it.uri));
            this.showDialog(IToolkit_MainWindow.DlgType.ERROR_SMALL, String.format(this.uiFactory.getSystemLabel(this.appController.getUserEnvironment().getLangIndex(), MoWareTranslations.Key.CMD_NOT_AVAILABLE), someCmds), null);
        }
    }

    public static class H2Menu {
        public String label;
        public String uri;
        public CmdAction actionToCall;
        public String cntNumStr;
        public String[] splittedLabel;
        public boolean enabled;
        public boolean visible;
        public String color;
        public String materialImgName;

        public CmdAction getAction() {
            return this.actionToCall;
        }

        public String getUri() {
            return this.uri;
        }

        public boolean isUri(String uri) {
            return this.uri.equals(uri);
        }

        @Deprecated
        public String uriFromAction(CmdAction act) {
            return "_" + act.labelText.toLowerCase().replaceAll("\\W", "");
        }

        public H2Menu(String aUri, CmdAction act, boolean visible, boolean enabled, String color, String matImg) {
            this.actionToCall = act;
            this.label = act.labelText;
            this.uri = aUri;
            this.cntNumStr = null;
            this.splittedLabel = act.labelText.split("\\r?\\n");
            for (int i = 0; i < this.splittedLabel.length; ++i) {
                String lab = this.splittedLabel[i];
                if (!lab.contains("(") || !lab.contains(")")) continue;
                int openIndex = lab.indexOf("(");
                int closeIndex = lab.indexOf(")");
                String num = lab.substring(openIndex + 1, closeIndex);
                String cutted = lab.substring(0, openIndex - 1) + lab.substring(closeIndex + 1, lab.length());
                if (!num.matches("-?\\d+")) continue;
                this.splittedLabel[i] = cutted;
                this.cntNumStr = num;
            }
            this.visible = visible;
            this.enabled = enabled;
            this.color = color;
            this.materialImgName = matImg;
        }
    }
}

