/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.h2forms.mdeauth;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionBindingEvent;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.modellwerkstatt.dataux.runtime.auth.CredentialReporter;
import org.modellwerkstatt.dataux.runtime.auth.IExtAuthProvider;
import org.modellwerkstatt.dataux.runtime.core.LoginController;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenAppUiModule;
import org.modellwerkstatt.dataux.runtime.telemetrics.AppJmxRegistration;
import org.modellwerkstatt.dataux.runtime.telemetrics.Dux;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_MainWindow;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.h2forms.core.ContextClient;
import org.modellwerkstatt.h2forms.core.ContextPage;
import org.modellwerkstatt.h2forms.core.H2Application;
import org.modellwerkstatt.h2forms.core.H2Dialog;
import org.modellwerkstatt.h2forms.core.IH2Controller;
import org.modellwerkstatt.h2forms.core.IH2FormsTemplateRenderer;
import org.modellwerkstatt.h2forms.core.IH2UiFactory;
import org.modellwerkstatt.h2forms.mdeauth.H2MpreisNoLoginAuth;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.OFXUrlParams;
import org.modellwerkstatt.objectflow.runtime.UserEnvironmentInformation;

public class H2MpreisLoginOAuth
implements IH2Controller {
    protected IH2UiFactory uiFactory;
    protected IGenAppUiModule appMod;
    protected AppJmxRegistration jmxHelper;
    protected H2Application application;
    protected ContextClient client;
    protected LoginController loginController;
    protected IExtAuthProvider provider;
    protected String errorMessage;
    protected String urlToRedirect;
    protected LoginState state;
    protected String thisOAuthState;
    protected OFXUrlParams params;

    public H2MpreisLoginOAuth(IH2UiFactory factory, IGenAppUiModule app, AppJmxRegistration jmx, ContextClient cli) {
        this.uiFactory = factory;
        this.appMod = app;
        this.jmxHelper = jmx;
        this.client = cli;
        this.application = null;
        this.state = LoginState.FIRST_ATTEMPT;
        this.thisOAuthState = "" + this.hashCode();
        this.params = new OFXUrlParams();
    }

    @Override
    public void handleRequest(HttpServletRequest request, String cookieInfo) {
        if (this.state == LoginState.FIRST_ATTEMPT) {
            this.params.parse(request.getPathInfo());
            Dux.hl((String)"");
            Dux.hl((String)("state is " + this.state + " and we are trying direct login (params " + this.params.asUrl() + ")"));
            H2MpreisNoLoginAuth.detectAndSetClient(request, this.client);
            this.loginController = new LoginController((IToolkit_UiFactory)this.uiFactory, this.uiFactory.getContextStatics().getMowarePlatform(), this.uiFactory.getContextStatics().getGuessedServerName(), this.client.getRemoteAddr());
            this.loginController.logOnCoreReporter("", "", "org.modellwerkstatt.h2forms.mdeauth.H2Login", IOFXCoreReporter.LogPriority.INFO, "While login: [" + this.client + "] from '" + request.getHeader("user-agent") + "'", null);
            UserEnvironmentInformation env = new UserEnvironmentInformation();
            env.setDevice(this.client.getDevice(), "" + this.client.getDeviceSw(), this.client.getDeviceId());
            String loginUserParamName = request.getParameter("username");
            if (loginUserParamName == null) {
                loginUserParamName = this.client.getRemoteAddr();
            }
            this.errorMessage = this.loginController.checkLoginPrepareUserEnv(loginUserParamName, "", (IOFXUserEnvironment)env, this.appMod);
            Dux.hl((String)"");
            Dux.hl((String)("- - - - - - - - - checkLoginPrepareUserEnv for " + loginUserParamName + " -> " + this.errorMessage));
            if (this.errorMessage == null) {
                H2MpreisNoLoginAuth.setSessionUserName(this.uiFactory, request, (IOFXUserEnvironment)env);
                this.application = new H2Application(this.uiFactory, this.appMod, this.jmxHelper, this.client);
                this.application.initializeAndLogin(request, (IOFXUserEnvironment)env, cookieInfo);
            } else if (this.loginController.notAuthenticatedButNoProblems()) {
                this.errorMessage = null;
                this.state = LoginState.INITIAL_REQUEST;
            }
        }
        if (this.state == LoginState.INITIAL_REQUEST) {
            this.provider = H2MpreisLoginOAuth.prepareProvider(this.uiFactory, this.loginController);
            this.urlToRedirect = this.provider.initialRedirect(this.thisOAuthState);
            Dux.hl((String)("state now is " + this.state + " set redirecting to " + this.urlToRedirect));
        } else if (this.state == LoginState.CHECK_TOKEN_RETRIEV_UID) {
            String recState = request.getParameter("state");
            String code = request.getParameter("code");
            Dux.hl((String)("received " + recState + " with code " + code));
            if (!this.thisOAuthState.equals(recState)) {
                this.errorMessage = "Login not possible - oauth states do not match.";
                this.loginController.logOnCoreReporter("", "", H2MpreisLoginOAuth.class.getName(), IOFXCoreReporter.LogPriority.ERROR, "Login not possible, internal oauth state '" + this.thisOAuthState + "' does not match received state '" + recState + "'", null);
            } else {
                try {
                    String user = this.provider.retrieveUserWithAccessToken(code);
                    UserEnvironmentInformation env = new UserEnvironmentInformation();
                    env.setDevice(this.client.getDevice(), "" + this.client.getDeviceSw(), this.client.getDeviceId());
                    this.errorMessage = this.loginController.checkLoginPrepareUserEnv(user, "", (IOFXUserEnvironment)env, this.appMod);
                    if (this.errorMessage == null) {
                        H2MpreisNoLoginAuth.setSessionUserName(this.uiFactory, request, (IOFXUserEnvironment)env);
                        this.application = new H2Application(this.uiFactory, this.appMod, this.jmxHelper, this.client);
                        this.application.initializeAndLogin(request, (IOFXUserEnvironment)env, cookieInfo);
                    }
                }
                catch (IOException e) {
                    this.errorMessage = "Login with oauth not possible or login denied.";
                    this.loginController.logExOnCoreReporter("", "", H2MpreisLoginOAuth.class.getName(), IOFXCoreReporter.LogPriority.ERROR, "Exception while using provider " + this.provider.getAuthProviderName(), (Throwable)e);
                }
            }
        } else if (this.state == LoginState.REDIRECT) {
            // empty if block
        }
    }

    @Override
    public String getShortUserInfo() {
        return this.client.getRemoteAddr();
    }

    @Override
    public IH2Controller swapToNextController() {
        if (this.state == LoginState.FIRST_ATTEMPT && this.application != null) {
            return this.application;
        }
        if (this.state == LoginState.REDIRECT) {
            return this.application;
        }
        return null;
    }

    @Override
    public void createResponse(HttpServletResponse response, boolean xmlHttpReq) throws IOException {
        Dux.hl((String)("state is " + this.state));
        if (this.state == LoginState.FIRST_ATTEMPT && this.errorMessage == null) {
            throw new RuntimeException("This can not happen.");
        }
        if (this.state == LoginState.INITIAL_REQUEST && this.errorMessage == null) {
            if (this.urlToRedirect == null) {
                throw new RuntimeException("This can not happen.");
            }
            this.state = LoginState.CHECK_TOKEN_RETRIEV_UID;
            this.uiFactory.execLocationRedirect(response, this.urlToRedirect);
            Dux.hl((String)("state now is " + this.state + " actually redirect now to " + this.urlToRedirect));
            this.urlToRedirect = null;
        } else if (this.state == LoginState.CHECK_TOKEN_RETRIEV_UID && this.errorMessage == null) {
            this.state = LoginState.REDIRECT;
            this.uiFactory.execLocationRedirect(response, this.uiFactory.getContextStatics().getServletPath() + this.params.asUrl());
        }
        if (this.errorMessage != null) {
            Dux.hl((String)("Message to show is " + this.errorMessage));
            H2Dialog h2msg = new H2Dialog(IToolkit_MainWindow.DlgType.ERROR_SMALL, this.uiFactory.getSystemLabel(-1, MoWareTranslations.Key.ERROR), this.errorMessage, null);
            long millis = DeprecatedServerDateProvider.getSqlServerDateTime().getMillis();
            this.uiFactory.getRenderer().handleSpecialPageResponse(IH2FormsTemplateRenderer.SpecialPage.LANDING_PAGE, response, this.uiFactory.getContextStatics(), this.client, new ContextPage(0L, xmlHttpReq, millis), h2msg);
        }
    }

    public static IExtAuthProvider prepareProvider(IH2UiFactory factory, LoginController crtl) {
        DateTime now;
        List<IExtAuthProvider> allProviders = factory.getAllExtAuthProviders();
        IExtAuthProvider provider = null;
        if (allProviders.size() != 1) {
            throw new RuntimeException("H2MpreisLoginOAuth() supports just one provider, but we have " + allProviders.size() + " here.");
        }
        provider = allProviders.get(0);
        LocalDate expDate = provider.getNullOrCredentialExpirationDate();
        if (expDate != null && CredentialReporter.checkExpirationDateOnceInWindow((DateTime)(now = DeprecatedServerDateProvider.getSqlServerDateTime()), (LocalDate)expDate)) {
            crtl.logOnCoreReporter("", "", H2MpreisLoginOAuth.class.getName(), IOFXCoreReporter.LogPriority.ERROR, "Credentials for " + provider + " will expire at " + expDate + "!", null);
        }
        return provider;
    }

    @Override
    public boolean isRemoveFromSessionAndClose() {
        return this.errorMessage != null;
    }

    @Override
    public boolean hasCommitableSessionRunning() {
        return false;
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        this.externalCloseApplicationWithSessionId("null");
    }

    @Override
    public void externalCloseApplicationWithSessionId(String sessionId) {
        this.uiFactory = null;
        this.appMod = null;
        this.jmxHelper = null;
        this.loginController = null;
        this.provider = null;
    }

    public static enum LoginState {
        FIRST_ATTEMPT,
        INITIAL_REQUEST,
        CHECK_TOKEN_RETRIEV_UID,
        REDIRECT;

    }
}

