/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.h2forms.mdeauth;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import org.modellwerkstatt.dataux.runtime.core.LoginController;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenAppUiModule;
import org.modellwerkstatt.dataux.runtime.telemetrics.AppJmxRegistration;
import org.modellwerkstatt.dataux.runtime.telemetrics.Dux;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_MainWindow;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.h2forms.core.ContextClient;
import org.modellwerkstatt.h2forms.core.ContextPage;
import org.modellwerkstatt.h2forms.core.H2Application;
import org.modellwerkstatt.h2forms.core.H2Dialog;
import org.modellwerkstatt.h2forms.core.IH2Controller;
import org.modellwerkstatt.h2forms.core.IH2FormsTemplateRenderer;
import org.modellwerkstatt.h2forms.core.IH2UiFactory;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.UserEnvironmentInformation;

public class H2MpreisNoLoginAuth
implements IH2Controller {
    protected IH2UiFactory uiFactory;
    protected IGenAppUiModule appMod;
    protected AppJmxRegistration jmxHelper;
    protected H2Application application;
    protected ContextClient client;
    protected String errorMessage;

    public H2MpreisNoLoginAuth(IH2UiFactory factory, IGenAppUiModule app, AppJmxRegistration jmx, ContextClient cli) {
        this.uiFactory = factory;
        this.appMod = app;
        this.jmxHelper = jmx;
        this.client = cli;
    }

    public static void setSessionUserName(IH2UiFactory factory, HttpServletRequest req, IOFXUserEnvironment userEnv) {
        HttpSession session = req.getSession();
        session.setAttribute("userName", (Object)(userEnv.getUserName() + " - " + userEnv.getDeviceName() + "/" + userEnv.getDeviceSwName() + " " + factory.getRemoteAddr(req)));
    }

    public static void detectAndSetClient(HttpServletRequest request, ContextClient client) {
        int firstIndex;
        String userAgent = "";
        if (request.getHeader("user-agent") != null) {
            userAgent = request.getHeader("user-agent");
        }
        String requestedWith = request.getHeader("x-requested-with");
        Dux.hl((String)("UserAgen is '" + userAgent + "' and requested-with '" + requestedWith + "'"));
        ContextClient.DevicesSw deviceSwDetected = ContextClient.DevicesSw.STRICH;
        if (userAgent.contains("EB5")) {
            deviceSwDetected = ContextClient.DevicesSw.ZEBRAEB_50;
        } else if (userAgent.contains("EB35") || userAgent.contains("EB37")) {
            deviceSwDetected = ContextClient.DevicesSw.ZEBRAEB_35;
        } else if (userAgent.contains("EB32") || userAgent.contains("EB3")) {
            deviceSwDetected = ContextClient.DevicesSw.ZEBRAEB_32;
        } else if (userAgent.contains("EB2")) {
            deviceSwDetected = ContextClient.DevicesSw.ZEBRAEB_20;
        } else {
            if (userAgent.contains("EB18")) {
                deviceSwDetected = ContextClient.DevicesSw.ZEBRAEB_18;
                throw new RuntimeException("Zebra EB 18 is no longer supported. (Sep 23)");
            }
            if (userAgent.contains("TC25")) {
                deviceSwDetected = ContextClient.DevicesSw.ZEBRAEB_20;
            } else if (userAgent.contains("TC26")) {
                deviceSwDetected = ContextClient.DevicesSw.ZEBRAEB_32;
            } else if (userAgent.contains("TC56")) {
                deviceSwDetected = ContextClient.DevicesSw.ZEBRAEB_20;
            } else if (userAgent.contains("TC57")) {
                deviceSwDetected = ContextClient.DevicesSw.ZEBRAEB_35;
            } else if (userAgent.contains("TC27")) {
                deviceSwDetected = ContextClient.DevicesSw.ZEBRAEB_50;
            } else if ("com.symbol.enterprisebrowser".equals(requestedWith) || "com.zebra.mdna.enterprisebrowser".equals(requestedWith)) {
                deviceSwDetected = ContextClient.DevicesSw.ZEBRAEB_20;
            }
        }
        client.setDevice("");
        if (userAgent.contains("TC") && (firstIndex = userAgent.indexOf("TC")) >= 0 && userAgent.length() > firstIndex + 5) {
            client.setDevice(userAgent.substring(firstIndex, firstIndex + 4));
        }
        client.setDeviceId(request.getParameter("DeviceId"));
        if (client.getDeviceId() == null || "".equals(client.getDeviceId().trim())) {
            client.setDeviceId(H2MpreisNoLoginAuth.getESN(userAgent));
        }
        client.setDeviceSw(deviceSwDetected);
    }

    @Override
    public void handleRequest(HttpServletRequest request, String cookieInfo) {
        this.application = null;
        H2MpreisNoLoginAuth.detectAndSetClient(request, this.client);
        LoginController loginCrtl = new LoginController((IToolkit_UiFactory)this.uiFactory, this.uiFactory.getContextStatics().getMowarePlatform(), this.uiFactory.getContextStatics().getGuessedServerName(), this.client.getRemoteAddr());
        loginCrtl.logOnCoreReporter("", "", "org.modellwerkstatt.h2forms.mdeauth.H2Login", IOFXCoreReporter.LogPriority.INFO, "While login: [" + this.client + "] from '" + request.getHeader("user-agent") + "'", null);
        UserEnvironmentInformation env = new UserEnvironmentInformation();
        env.setDevice(this.client.getDevice(), "" + this.client.getDeviceSw(), this.client.getDeviceId());
        String loginUserParamName = request.getParameter("username");
        if (loginUserParamName == null) {
            loginUserParamName = this.client.getRemoteAddr();
        }
        this.errorMessage = loginCrtl.checkLoginPrepareUserEnv(loginUserParamName, "", (IOFXUserEnvironment)env, this.appMod);
        Dux.hl((String)"");
        Dux.hl((String)("- - - - - - - - - checkLoginPrepareUserEnv for " + loginUserParamName + " -> " + this.errorMessage));
        if (this.errorMessage == null) {
            H2MpreisNoLoginAuth.setSessionUserName(this.uiFactory, request, (IOFXUserEnvironment)env);
            this.application = new H2Application(this.uiFactory, this.appMod, this.jmxHelper, this.client);
            this.application.initializeAndLogin(request, (IOFXUserEnvironment)env, cookieInfo);
        }
    }

    @Override
    public String getShortUserInfo() {
        return this.client.getRemoteAddr();
    }

    @Override
    public IH2Controller swapToNextController() {
        return this.application;
    }

    @Override
    public void createResponse(HttpServletResponse response, boolean xmlHttpReq) throws IOException {
        H2Dialog h2msg = new H2Dialog(IToolkit_MainWindow.DlgType.ERROR_SMALL, this.uiFactory.getSystemLabel(-1, MoWareTranslations.Key.ERROR), this.errorMessage, null);
        long millis = DeprecatedServerDateProvider.getSqlServerDateTime().getMillis();
        this.uiFactory.getRenderer().handleSpecialPageResponse(IH2FormsTemplateRenderer.SpecialPage.LANDING_PAGE, response, this.uiFactory.getContextStatics(), this.client, new ContextPage(0L, xmlHttpReq, millis), h2msg);
    }

    @Override
    public boolean isRemoveFromSessionAndClose() {
        return true;
    }

    @Override
    public boolean hasCommitableSessionRunning() {
        return false;
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        this.externalCloseApplicationWithSessionId("null");
    }

    @Override
    public void externalCloseApplicationWithSessionId(String sessionId) {
        this.uiFactory = null;
        this.appMod = null;
        this.jmxHelper = null;
    }

    private static String getESN(String userAgent) {
        String ESN_IDENTIFIER = "esn=";
        Object esn = "";
        if (userAgent != null && userAgent.toLowerCase().contains(ESN_IDENTIFIER)) {
            String agent = userAgent.toLowerCase();
            for (int start = agent.indexOf(ESN_IDENTIFIER) + ESN_IDENTIFIER.length(); start < agent.length() && Character.isDigit(agent.charAt(start)); ++start) {
                esn = (String)esn + agent.charAt(start);
            }
        }
        return esn;
    }

    public static void main(String[] args) {
        String st = "Mozilla/5.0 (Linux; Android 7.1.2; ESNX=1234TC56 Build/02-07-08.00-NN-U00-STD; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/73.0.3683.90 Mobile Safari/537.36 MAC=40:83:DE:E1:32:01 ESN=17080522506316";
        System.err.println("> " + H2MpreisNoLoginAuth.getESN(st));
    }
}

