/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.h2forms.mdeauth;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionBindingEvent;
import org.modellwerkstatt.dataux.runtime.core.LoginController;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenAppUiModule;
import org.modellwerkstatt.dataux.runtime.telemetrics.AppJmxRegistration;
import org.modellwerkstatt.dataux.runtime.telemetrics.Dux;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_MainWindow;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.h2forms.core.ContextClient;
import org.modellwerkstatt.h2forms.core.ContextPage;
import org.modellwerkstatt.h2forms.core.H2Application;
import org.modellwerkstatt.h2forms.core.H2Dialog;
import org.modellwerkstatt.h2forms.core.IH2Controller;
import org.modellwerkstatt.h2forms.core.IH2FormsTemplateRenderer;
import org.modellwerkstatt.h2forms.core.IH2UiFactory;
import org.modellwerkstatt.h2forms.mdeauth.H2MpreisNoLoginAuth;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.UserEnvironmentInformation;

public class H2MpreisTrialFirstAuth
implements IH2Controller {
    protected static final String USERNAME = "loginUserName";
    protected static final String PASSWORD = "password";
    protected static final String ERRORMESSAGE = "message";
    protected IH2UiFactory uiFactory;
    protected IGenAppUiModule appMod;
    protected AppJmxRegistration jmxHelper;
    protected H2Application application;
    protected ContextClient client;
    protected String errorMessage;
    protected boolean tryAutoIpLogin;
    protected boolean execCleanRedirectToHome;
    protected String lastUrlLocation;

    public H2MpreisTrialFirstAuth(IH2UiFactory factory, IGenAppUiModule app, AppJmxRegistration jmx, ContextClient cli) {
        this.uiFactory = factory;
        this.appMod = app;
        this.jmxHelper = jmx;
        this.client = cli;
        this.tryAutoIpLogin = true;
        this.lastUrlLocation = factory.getContextStatics().getServletPath();
        if (!this.lastUrlLocation.endsWith("/")) {
            this.lastUrlLocation = this.lastUrlLocation + "/";
        }
    }

    @Override
    public void handleRequest(HttpServletRequest request, String cookieInfo) {
        this.application = null;
        this.lastUrlLocation = request.getRequestURL().toString();
        H2MpreisNoLoginAuth.detectAndSetClient(request, this.client);
        LoginController loginCrtl = new LoginController((IToolkit_UiFactory)this.uiFactory, this.uiFactory.getContextStatics().getMowarePlatform(), this.uiFactory.getContextStatics().getGuessedServerName(), this.client.getRemoteAddr());
        loginCrtl.logOnCoreReporter("", "", "org.modellwerkstatt.h2forms.mdeauth.H2Login", IOFXCoreReporter.LogPriority.INFO, "While login: [" + this.client + "] from '" + request.getHeader("user-agent") + "'", null);
        UserEnvironmentInformation env = new UserEnvironmentInformation();
        env.setDevice(this.client.getDevice(), "" + this.client.getDeviceSw(), this.client.getDeviceId());
        String loginUserParamName = request.getParameter(USERNAME);
        String password = request.getParameter(PASSWORD);
        boolean bl = this.execCleanRedirectToHome = request.getParameter("loggedout") != null;
        if (this.execCleanRedirectToHome) {
            this.tryAutoIpLogin = false;
        }
        if (this.tryAutoIpLogin) {
            String userName = this.client.getRemoteAddr();
            if (loginUserParamName != null) {
                userName = loginUserParamName;
            }
            this.errorMessage = loginCrtl.checkLoginPrepareUserEnv(userName, "", (IOFXUserEnvironment)env, this.appMod);
            this.tryAutoIpLogin = false;
            if (this.errorMessage == null) {
                H2MpreisNoLoginAuth.setSessionUserName(this.uiFactory, request, (IOFXUserEnvironment)env);
                this.application = new H2Application(this.uiFactory, this.appMod, this.jmxHelper, this.client);
                this.application.initializeAndLogin(request, (IOFXUserEnvironment)env, cookieInfo);
            }
            this.errorMessage = null;
        } else if (!this.execCleanRedirectToHome && loginUserParamName != null) {
            this.errorMessage = loginCrtl.checkLoginPrepareUserEnv(loginUserParamName, password, (IOFXUserEnvironment)env, this.appMod);
            if (this.errorMessage == null) {
                Dux.hl((String)("- - - - - - - logging in user " + env.getUserName() + ", creating H2Application"));
                H2MpreisNoLoginAuth.setSessionUserName(this.uiFactory, request, (IOFXUserEnvironment)env);
                this.application = new H2Application(this.uiFactory, this.appMod, this.jmxHelper, this.client);
                this.application.initializeAndLogin(request, (IOFXUserEnvironment)env, cookieInfo);
            }
        }
    }

    @Override
    public String getShortUserInfo() {
        return this.client.getRemoteAddr();
    }

    @Override
    public IH2Controller swapToNextController() {
        return this.application;
    }

    @Override
    public void createResponse(HttpServletResponse response, boolean xmlHttpReq) throws IOException {
        if (this.execCleanRedirectToHome) {
            this.execCleanRedirectToHome = false;
            this.uiFactory.execLocationRedirect(response, this.lastUrlLocation);
            return;
        }
        H2Dialog h2msg = null;
        if (this.errorMessage != null) {
            h2msg = new H2Dialog(IToolkit_MainWindow.DlgType.ERROR_SMALL, this.uiFactory.getSystemLabel(-1, MoWareTranslations.Key.ERROR), this.errorMessage, null);
        }
        long millis = DeprecatedServerDateProvider.getSqlServerDateTime().getMillis();
        this.uiFactory.getRenderer().handleSpecialPageResponse(IH2FormsTemplateRenderer.SpecialPage.LOGIN_PAGE, response, this.uiFactory.getContextStatics(), this.client, new ContextPage(0L, xmlHttpReq, millis), h2msg);
    }

    @Override
    public boolean isRemoveFromSessionAndClose() {
        return this.application != null;
    }

    @Override
    public boolean hasCommitableSessionRunning() {
        return false;
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        this.externalCloseApplicationWithSessionId("null");
    }

    @Override
    public void externalCloseApplicationWithSessionId(String sessionId) {
        this.uiFactory = null;
        this.appMod = null;
        this.jmxHelper = null;
    }
}

