/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.h2forms.pebble;

import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jetbrains.mps.internal.collections.runtime.IMapSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import org.modellwerkstatt.h2forms.core.ContextClient;
import org.modellwerkstatt.h2forms.core.ContextPage;
import org.modellwerkstatt.h2forms.core.ContextStatics;
import org.modellwerkstatt.h2forms.pebble.AbstractEditor;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;

public abstract class AbstractForm {
    public static final String TITLE_TEXT = "titleText";
    public static final String LIST_OF_PROBLEMS = "listOfProblems";
    public static final String CHILDREN = "children";
    public static final String DELEGATES = "delegates";
    public static final String ACTIONS = "actions";
    public static final String TOPBAR_ACTIONS = "topBarActions";
    public static final String DROPDOWN_ACTIONS = "dropDownActions";
    public static final String HAS_VISIBLE_ACTIONS = "hasVisibleActions";
    public static final String ACCORDION_ID = "accordionId";
    public static final String FOOTER = "footer";
    public static final String TABLE_ROWS = "tableRows";
    public static final String TABLE_COLUMNS = "tableColumns";
    public static final String CURRENT_SELECTION = "currentSelection";
    public static final String STATICS_CTX = "statics";
    public static final String CLIENT_CTX = "client";
    public static final String PAGE_CTX = "page";
    public static final String FORM = "form";
    public static final String WINDOW_TITLE = "windowTitle";
    public static final String NOTIFICATION_TEXT = "notificationText";
    public static final String SPLITTED_PAGE_TITLE = "splittedPageTitleText";
    public static final String DIALOG = "dialog";
    public static final String KEYBOARD = "keyboard";
    public static final String CONCLUSIONS = "conclusions";
    public static final String ESC_CONCLUSION = "escConclusion";
    public static final String SCAN_CONCLUSION = "scanConclusion";
    public static final String GO_CONCLUSION = "goConclusion";
    public static final String DEFAULT_CONCLUSION = "defaultConclusion";
    public static final String FORM_ID = "formId";
    public static final String SCROLL_ENABLED = "scroll";
    public static final String OPTIM_KEYBAORD = "optimKeyboard";
    private boolean initBeforeRenderDone;
    private List<IOFXProblem> listOfProblems;
    private String titleText;
    private String[] splittedtitleText;
    private int formId;
    private boolean scrollEnabled;
    protected Writer writerToUse;
    protected ContextStatics statics;
    protected ContextClient client;
    protected ContextPage page;
    protected PebbleTemplate compiledTextEditorTemplate;

    public AbstractForm(PebbleTemplate template) {
        this.compiledTextEditorTemplate = template;
        this.initBeforeRenderDone = false;
        this.titleText = null;
        this.splittedtitleText = null;
        this.listOfProblems = ListSequence.fromList(new ArrayList());
    }

    public void initBeforeRender(int id, Writer writer, ContextStatics stat, ContextClient clnt, ContextPage pg) {
        this.writerToUse = writer;
        this.statics = stat;
        this.client = clnt;
        this.page = pg;
        this.initBeforeRenderDone = true;
        this.formId = id;
        this.scrollEnabled = stat.isScroll();
    }

    public Map<String, Object> initAndGetRenderMap() {
        if (!this.initBeforeRenderDone) {
            throw new IllegalStateException("Programming error - initBeforeRender() not called.");
        }
        IMapSequence renderMap = MapSequence.fromMap(new HashMap());
        this.initBeforeRenderDone = false;
        MapSequence.fromMap((Map)renderMap).put((Object)TITLE_TEXT, (Object)this.titleText);
        MapSequence.fromMap((Map)renderMap).put((Object)LIST_OF_PROBLEMS, this.listOfProblems);
        MapSequence.fromMap((Map)renderMap).put((Object)SPLITTED_PAGE_TITLE, (Object)this.splittedtitleText);
        MapSequence.fromMap((Map)renderMap).put((Object)STATICS_CTX, (Object)this.statics);
        MapSequence.fromMap((Map)renderMap).put((Object)CLIENT_CTX, (Object)this.client);
        MapSequence.fromMap((Map)renderMap).put((Object)PAGE_CTX, (Object)this.page);
        MapSequence.fromMap((Map)renderMap).put((Object)FORM_ID, (Object)this.formId);
        MapSequence.fromMap((Map)renderMap).put((Object)SCROLL_ENABLED, (Object)this.scrollEnabled);
        return renderMap;
    }

    public void setTitleText(String text) {
        if (text != null && !text.trim().equals("")) {
            this.titleText = text;
            this.splittedtitleText = this.titleText.split("\\r?\\n");
        } else {
            this.titleText = null;
            this.splittedtitleText = null;
        }
    }

    public void setProblems(List<IOFXProblem> lop) {
        this.listOfProblems = lop;
    }

    public List<IOFXProblem> getProblems() {
        return this.listOfProblems;
    }

    public IOFXSession.IUxEventActionable getResolveActionToTrigger(String trigger) {
        int id = Integer.valueOf(trigger.split("_")[1]);
        for (IOFXProblem prblm : this.listOfProblems) {
            IOFXSession.IUxEventActionable action = prblm.getResolveActionOrNull();
            if (action == null || action.getTriggerCode() != id) continue;
            return action;
        }
        return null;
    }

    public String[] getSplittedPageTitleText() {
        return this.splittedtitleText;
    }

    public abstract void toHtml() throws IOException;

    public abstract boolean actionInForm(int var1, int var2, int var3);

    public abstract void delegateDataInForm(HttpServletRequest var1);

    public abstract Object myRequestFocus();

    public abstract boolean delegatesNeedKeyboard();

    public abstract AbstractEditor firstEditorFocused();

    public abstract String debugInfo();

    public void afterFullUiInitialized() {
    }

    public static class PebAction {
        public String label;
        public String[] splittedLabel;
        public boolean enabled;
        public boolean hideOnDisabled;
        public boolean visible;
        public String origImgName;
        public String materialImgName;
        public String hotKey;
        public int popupMenuId;
        public int triggerCode;

        public PebAction(String label, boolean hideOnDisabled, String img1, String imgConv, int popMenuId, int triggerCode, String hk) {
            this.label = label;
            this.splittedLabel = label.split("\\r?\\n");
            this.hideOnDisabled = hideOnDisabled;
            this.enabled = false;
            this.visible = false;
            this.origImgName = img1;
            this.materialImgName = imgConv;
            this.hotKey = hk;
            this.popupMenuId = popMenuId;
            this.triggerCode = triggerCode;
        }

        public boolean hasText() {
            return this.label != null && !"".equals(this.label);
        }

        public boolean hasImage() {
            return this.origImgName != null && !"".equals(this.origImgName);
        }

        public void adjustEnabled(boolean enbld) {
            this.enabled = enbld;
            this.visible = true;
            if (this.hideOnDisabled && !enbld) {
                this.visible = false;
            }
        }
    }
}

