/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.h2forms.pebble;

import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jetbrains.mps.internal.collections.runtime.IMapSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import org.modellwerkstatt.dataux.runtime.core.ConclusionEvent;
import org.modellwerkstatt.dataux.runtime.core.ICommandContainer;
import org.modellwerkstatt.dataux.runtime.core.UxEvent;
import org.modellwerkstatt.dataux.runtime.telemetrics.Dux;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_CommandContainerUi;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;
import org.modellwerkstatt.h2forms.core.ContextClient;
import org.modellwerkstatt.h2forms.core.ContextPage;
import org.modellwerkstatt.h2forms.core.ContextStatics;
import org.modellwerkstatt.h2forms.core.H2ColorUtil;
import org.modellwerkstatt.h2forms.core.H2Dialog;
import org.modellwerkstatt.h2forms.core.H2FormRequestStateException;
import org.modellwerkstatt.h2forms.pebble.AbstractEditor;
import org.modellwerkstatt.h2forms.pebble.AbstractForm;
import org.modellwerkstatt.h2forms.pebble.MaterialIconsConverter;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.OFXConclusionInformation;

public class CommandContainerUi
implements IToolkit_CommandContainerUi {
    private ICommandContainer cmdContainer;
    private AbstractForm form;
    private PebbleTemplate template;
    private String windowTitle;
    private String uiColor;
    private String notificationText;
    private int lastScrollTopPosition;
    private boolean scrollAdjustEnabled;
    private boolean optimKeyboard;
    private List<AbstractForm.PebAction> conclusions;

    public CommandContainerUi(PebbleTemplate commandUiTemplate, boolean scrollAdjustEnbld, boolean keyboardOptim) {
        this.template = commandUiTemplate;
        this.notificationText = null;
        this.lastScrollTopPosition = 0;
        this.scrollAdjustEnabled = scrollAdjustEnbld;
        this.optimKeyboard = keyboardOptim;
    }

    public void setCommandContainer(ICommandContainer container) {
        this.cmdContainer = container;
    }

    public void show(String wd, IToolkit_Form content) {
        this.windowTitle = wd;
        this.form = (AbstractForm)content;
    }

    public void setContent(IToolkit_Form content) {
        if (this.form != content) {
            this.form = (AbstractForm)content;
            this.lastScrollTopPosition = 0;
        }
    }

    public void adjustWindowTitle(String title) {
        this.windowTitle = title;
    }

    public void setNotification(String notificat) {
        this.notificationText = notificat;
    }

    public void setConclusions(List<OFXConclusionInformation> concInfos, List<String> additionalHotkeys) {
        this.conclusions = ListSequence.fromList(new ArrayList());
        for (OFXConclusionInformation con : concInfos) {
            AbstractForm.PebAction ac = new AbstractForm.PebAction(con.buttonTitle, con.hideWhenDisabled, con.iconName, MaterialIconsConverter.codeFor(con.iconName), con.conclusionHashCode, con.conclusionHashCode, con.hotkey);
            ac.adjustEnabled(con.enabled);
            ListSequence.fromList(this.conclusions).addElement((Object)ac);
        }
    }

    public void reevalConclusions(List<OFXConclusionInformation> conclusionsToCheck) {
        for (int i = 0; i < ListSequence.fromList(this.conclusions).count(); ++i) {
            OFXConclusionInformation aToCheck = conclusionsToCheck.get(i);
            AbstractForm.PebAction aExisting = (AbstractForm.PebAction)ListSequence.fromList(this.conclusions).getElement(i);
            if (aExisting.triggerCode != aToCheck.conclusionHashCode) {
                throw new IllegalStateException("Conclusions out of sync between set() and reeval() ?? " + this.conclusions + " vs " + conclusionsToCheck);
            }
            aExisting.adjustEnabled(aToCheck.enabled);
        }
    }

    public void delayedRequestFocus() {
        this.form.myRequestFocus();
    }

    public void delayedAfterFullUiInitialized() {
    }

    public void close() {
    }

    public void handleRequest(HttpServletRequest request, String naviCrtl) {
        int scrollPos;
        String selectionId = request.getParameter("SelectionId");
        Dux.hl((String)("CommandContainerUI " + this.cmdContainer + " taking over, lastScrollTopPosition is " + this.lastScrollTopPosition + " vs. from request " + request.getParameter("ScrollPosition")));
        String scrollPosString = request.getParameter("ScrollPosition");
        if (scrollPosString != null && this.scrollAdjustEnabled && (scrollPos = Integer.parseInt(scrollPosString)) >= 0) {
            this.lastScrollTopPosition = scrollPos;
        }
        if (naviCrtl != null && selectionId != null) {
            int actionId;
            int selectionNum;
            String[] selString;
            int formId;
            if (naviCrtl.startsWith("resolve_")) {
                IOFXSession.IUxEventActionable action = this.form.getResolveActionToTrigger(naviCrtl);
                if (action == null) {
                    throw new RuntimeException("This can not happen: While looking for " + naviCrtl + " in " + this.form + " action not found.");
                }
                action.performAction();
            } else if (naviCrtl.startsWith("conclusion_")) {
                int buttonHashCode = Integer.valueOf(naviCrtl.split("_")[1]);
                if (buttonHashCode != 0) {
                    this.form.delegateDataInForm(request);
                }
                this.cmdContainer.receiveAndProcess((UxEvent)new ConclusionEvent(buttonHashCode, this.findTitleOfFirstHashConclusion(buttonHashCode)));
            } else if (naviCrtl.startsWith("trigger_") && !this.form.actionInForm(formId = Integer.valueOf((selString = selectionId.split("_"))[1]).intValue(), selectionNum = Integer.valueOf(selString[2]).intValue(), actionId = Integer.valueOf(naviCrtl.split("_")[1]).intValue())) {
                throw new H2FormRequestStateException("The action " + formId + " / " + selectionNum + " / " + actionId + " was not evaluated by the form.");
            }
        }
    }

    public void setColor(String color) {
        this.uiColor = color;
    }

    public static Map<String, Object> createDefaultMapForCommandUI(ContextStatics statics, ContextClient client, ContextPage page, H2Dialog dlg) {
        IMapSequence renderMap = MapSequence.fromMap(new HashMap());
        MapSequence.fromMap((Map)renderMap).put((Object)"statics", (Object)statics);
        MapSequence.fromMap((Map)renderMap).put((Object)"client", (Object)client);
        MapSequence.fromMap((Map)renderMap).put((Object)"page", (Object)page);
        MapSequence.fromMap((Map)renderMap).put((Object)"form", null);
        MapSequence.fromMap((Map)renderMap).put((Object)"dialog", (Object)dlg);
        MapSequence.fromMap((Map)renderMap).put((Object)"windowTitle", (Object)statics.getApplicationName());
        MapSequence.fromMap((Map)renderMap).put((Object)"keyboard", (Object)false);
        MapSequence.fromMap((Map)renderMap).put((Object)"optimKeyboard", (Object)false);
        MapSequence.fromMap((Map)renderMap).put((Object)"conclusions", null);
        MapSequence.fromMap((Map)renderMap).put((Object)"escConclusion", null);
        MapSequence.fromMap((Map)renderMap).put((Object)"scanConclusion", null);
        MapSequence.fromMap((Map)renderMap).put((Object)"goConclusion", null);
        MapSequence.fromMap((Map)renderMap).put((Object)"defaultConclusion", null);
        return renderMap;
    }

    public void handleResponse(HttpServletResponse response, ContextStatics statics, ContextClient client, ContextPage page, H2Dialog msg) throws IOException {
        page.setColor(this.uiColor);
        page.setColorD3(H2ColorUtil.calcD3Color(this.uiColor));
        page.setHasSessionToCommit(this.cmdContainer.hasRwSessionToCommit());
        page.setIsReadOnly(this.cmdContainer.isReadOnly());
        page.setIsDocumentSearch(this.cmdContainer.isDocumentSearch());
        if (msg != null && msg.isCloseQuestion()) {
            page.setScrollPosition(-1);
        } else {
            page.setScrollPosition(this.lastScrollTopPosition);
        }
        Map<String, Object> renderMap = CommandContainerUi.createDefaultMapForCommandUI(statics, client, page, msg);
        int id = 1;
        this.form.initBeforeRender(id, response.getWriter(), statics, client, page);
        MapSequence.fromMap(renderMap).put((Object)"form", (Object)this.form);
        MapSequence.fromMap(renderMap).put((Object)"windowTitle", (Object)this.windowTitle);
        MapSequence.fromMap(renderMap).put((Object)"splittedPageTitleText", (Object)this.form.getSplittedPageTitleText());
        MapSequence.fromMap(renderMap).put((Object)"listOfProblems", this.form.getProblems());
        MapSequence.fromMap(renderMap).put((Object)"notificationText", (Object)this.notificationText);
        MapSequence.fromMap(renderMap).put((Object)"escConclusion", ListSequence.fromList(this.conclusions).findFirst(it -> it.triggerCode == 0));
        MapSequence.fromMap(renderMap).put((Object)"scanConclusion", ListSequence.fromList(this.conclusions).findFirst(it -> "UPD".equals(it.hotKey)));
        MapSequence.fromMap(renderMap).put((Object)"goConclusion", ListSequence.fromList(this.conclusions).findFirst(it -> "GO".equals(it.hotKey)));
        MapSequence.fromMap(renderMap).put((Object)"defaultConclusion", ListSequence.fromList(this.conclusions).findLast(it -> it.enabled));
        AbstractEditor edtr = this.form.firstEditorFocused();
        boolean supportsCustomKeyboard = client.getDeviceSw() != ContextClient.DevicesSw.STANDARD && client.getDeviceSw() != ContextClient.DevicesSw.STRICH && client.getDeviceSw() != ContextClient.DevicesSw.SCANDIT;
        MapSequence.fromMap(renderMap).put((Object)"optimKeyboard", (Object)(this.optimKeyboard && MapSequence.fromMap(renderMap).get((Object)"scanConclusion") != null && edtr != null && edtr.scanable && supportsCustomKeyboard ? 1 : 0));
        if (this.form.delegatesNeedKeyboard()) {
            MapSequence.fromMap(renderMap).put((Object)"keyboard", (Object)supportsCustomKeyboard);
        }
        MapSequence.fromMap(renderMap).put((Object)"conclusions", this.conclusions);
        this.template.evaluate((Writer)response.getWriter(), renderMap);
    }

    public String findTitleOfFirstHashConclusion(int hashCode) {
        for (AbstractForm.PebAction action : this.conclusions) {
            if (action.triggerCode != hashCode) continue;
            return "HK_" + action.hotKey + " " + action.label;
        }
        return null;
    }

    public boolean isTabWindow() {
        return true;
    }

    public boolean isModalTabWindow() {
        return false;
    }

    public String toString() {
        return "" + this.cmdContainer;
    }

    public String debugInfo() {
        String s = "CommandContainerUI.debugInfo()" + this.windowTitle + "\n" + this.form.debugInfo();
        return s;
    }
}

