/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.h2forms.pebble;

import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_DateOrTimeEditor;
import org.modellwerkstatt.h2forms.core.IH2UiFactory;
import org.modellwerkstatt.h2forms.pebble.TextEditor;

public class DateOrTimeEditor
extends TextEditor
implements IToolkit_DateOrTimeEditor {
    private IH2UiFactory uiFactory;
    private DateTimeFormatter formatter;

    public DateOrTimeEditor(IH2UiFactory factory, PebbleTemplate tmpl, boolean withPicker) {
        super("datEditor", tmpl);
        if (withPicker) {
            this.isDateDelegateWithPicker = true;
            this.uiFactory = factory;
        }
    }

    public void setFormatter(String format, String locale, int langIdx) {
        if (this.isDateDelegateWithPicker) {
            this.formatter = this.uiFactory.getTransProvider().getLocalDateFormatter(langIdx, format);
        }
    }

    @Override
    public void toHtml() throws IOException {
        if (this.isDateDelegateWithPicker && !"".equals(this.text)) {
            String origText = this.text;
            LocalDate date = this.formatter.parseLocalDate(this.text);
            this.text = String.format("%d-%02d-%02d", date.getYear(), date.getMonthOfYear(), date.getDayOfMonth());
            super.toHtml();
            this.text = origText;
        } else {
            super.toHtml();
        }
    }

    @Override
    public void handleRequest(HttpServletRequest req) {
        super.handleRequest(req);
        if (this.enabled && this.isDateDelegateWithPicker && !"".equals(this.text)) {
            String[] splt = this.text.split("-");
            int year = Integer.valueOf(splt[0]);
            int month = Integer.valueOf(splt[1]);
            int day = Integer.valueOf(splt[2]);
            this.text = this.formatter.print((ReadablePartial)new LocalDate(year, month, day));
        }
    }

    @Override
    public void gcClear() {
        super.gcClear();
        this.uiFactory = null;
        this.formatter = null;
    }

    public static void main(String[] args) {
        String st = "2022-01-15";
        String[] splt = st.split("-");
        System.err.println(splt[0].substring(2));
        System.err.println(splt[1]);
        System.err.println(splt[2]);
    }
}

