/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.h2forms.pebble;

import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import org.modellwerkstatt.dataux.runtime.genspecifications.CmdAction;
import org.modellwerkstatt.dataux.runtime.genspecifications.Menu;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_FormContainer;
import org.modellwerkstatt.h2forms.core.H2FormRequestStateException;
import org.modellwerkstatt.h2forms.pebble.AbstractForm;
import org.modellwerkstatt.h2forms.pebble.HasChildForms;
import org.modellwerkstatt.h2forms.pebble.MaterialIconsConverter;

public class FormContainer<T>
extends HasChildForms<T>
implements IToolkit_FormContainer<T> {
    private List<CmdAction> dataUXmenuActions;
    private List<AbstractForm.PebAction> actions;
    private List<AbstractForm.PebAction> topBarActions;
    private List<AbstractForm.PebAction> dropDownActions;
    private boolean hasActions = false;

    public FormContainer(PebbleTemplate template) {
        super(template);
    }

    public void setLayoutConstraints(List<String> colConstraints, List<String> rowConstraints) {
    }

    public void skipFocus(int cmptToStartWith) {
        this.focusController.skipFocus(cmptToStartWith);
    }

    public void addMenuAndSetButtons(Menu menu) {
        AbstractForm.PebAction action;
        String convertedImgName;
        this.dataUXmenuActions = ListSequence.fromList(new ArrayList());
        this.actions = ListSequence.fromList(new ArrayList());
        this.topBarActions = ListSequence.fromList(new ArrayList());
        this.dropDownActions = ListSequence.fromList(new ArrayList());
        for (CmdAction item : menu.getTopBarActions()) {
            convertedImgName = MaterialIconsConverter.codeFor(item.image);
            action = new AbstractForm.PebAction(item.labelText, item.hideWhenDisabled, item.image, convertedImgName, this.hashCode(), item.hashCode(), item.hotKey);
            ListSequence.fromList(this.dataUXmenuActions).addElement((Object)item);
            ListSequence.fromList(this.actions).addElement((Object)action);
            ListSequence.fromList(this.topBarActions).addElement((Object)action);
        }
        for (CmdAction item : menu.getDropDownActions()) {
            convertedImgName = MaterialIconsConverter.codeFor(item.image);
            action = new AbstractForm.PebAction(item.labelText, item.hideWhenDisabled, item.image, convertedImgName, this.hashCode(), item.hashCode(), item.hotKey);
            ListSequence.fromList(this.dataUXmenuActions).addElement((Object)item);
            ListSequence.fromList(this.actions).addElement((Object)action);
            ListSequence.fromList(this.dropDownActions).addElement((Object)action);
        }
        this.dataUXmenuActions = ListSequence.fromList(this.dataUXmenuActions).reversedList();
        this.actions = ListSequence.fromList(this.actions).reversedList();
        this.topBarActions = ListSequence.fromList(this.topBarActions).reversedList();
        this.hasActions = true;
    }

    public void dispatchTopLevelHotKey(String modifier, String hk) {
    }

    @Override
    public void toHtml() throws IOException {
        Map<String, Object> renderMap = this.initAndGetRenderMap();
        MapSequence.fromMap(renderMap).put((Object)"actions", null);
        MapSequence.fromMap(renderMap).put((Object)"topBarActions", null);
        MapSequence.fromMap(renderMap).put((Object)"dropDownActions", null);
        MapSequence.fromMap(renderMap).put((Object)"children", (Object)this.children);
        MapSequence.fromMap(renderMap).put((Object)"hasVisibleActions", (Object)false);
        if (this.hasActions) {
            if (MapSequence.fromMap(renderMap).get((Object)"titleText") == null) {
                MapSequence.fromMap(renderMap).put((Object)"titleText", (Object)"");
            }
            for (int i = 0; i < ListSequence.fromList(this.dataUXmenuActions).count(); ++i) {
                CmdAction mae = (CmdAction)ListSequence.fromList(this.dataUXmenuActions).getElement(i);
                ((AbstractForm.PebAction)ListSequence.fromList(this.actions).getElement(i)).adjustEnabled(mae.reevalEnabled());
            }
            MapSequence.fromMap(renderMap).put((Object)"actions", this.actions);
            if (ListSequence.fromList(this.topBarActions).count() > 0) {
                MapSequence.fromMap(renderMap).put((Object)"topBarActions", this.topBarActions);
            }
            if (ListSequence.fromList(this.dropDownActions).count() > 0) {
                MapSequence.fromMap(renderMap).put((Object)"dropDownActions", this.dropDownActions);
            }
            MapSequence.fromMap(renderMap).put((Object)"hasVisibleActions", (Object)ListSequence.fromList(this.actions).any(it -> it.visible));
        }
        this.compiledTextEditorTemplate.evaluate(this.writerToUse, renderMap);
    }

    @Override
    public boolean actionInForm(int formId, int selectionNum, int actionId) {
        if (this.hasActions && formId == this.hashCode()) {
            for (CmdAction t : this.dataUXmenuActions) {
                if (t.hashCode() != actionId) continue;
                if (t.reevalEnabled()) {
                    t.startCommand();
                    continue;
                }
                throw new H2FormRequestStateException("This can not be true: " + t.labelText + " is disabled for this selection.");
            }
            return true;
        }
        return super.actionInForm(formId, selectionNum, actionId);
    }

    @Override
    public String debugInfo() {
        Wrappers._T s = new Wrappers._T((Object)"FormContainer.debugInfo()\n");
        ListSequence.fromList(this.dataUXmenuActions).visitAll(it -> {
            s.value = s.value + it.commandFqName + " : " + it.hashCode() + "\n";
        });
        s.value = s.value + super.debugInfo();
        return (String)s.value;
    }

    @Override
    public void gcClear() {
        super.gcClear();
    }
}

