/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.h2forms.pebble;

import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_ReferenceEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.h2forms.pebble.AbstractEditor;
import org.modellwerkstatt.h2forms.pebble.StatusEditor;

public class ReferenceEditor
extends AbstractEditor
implements IToolkit_ReferenceEditor {
    protected String value;
    protected String promptText;
    protected String propertyName;
    protected String optionalLabelText;
    protected List<AbstractEditor.PebItem> items = ListSequence.fromList(new ArrayList());
    protected int selectedIndex = -1;
    protected boolean optional;
    protected boolean alternativEditor;

    public ReferenceEditor(PebbleTemplate tmpl, boolean alter) {
        super("refEditor", tmpl);
        this.value = null;
        this.optional = false;
        this.alternativEditor = alter;
    }

    public ReferenceEditor(String id, PebbleTemplate tmpl, boolean alter) {
        super(id, tmpl);
        this.alternativEditor = alter;
    }

    @Override
    public void setOption(IToolkit_TextEditor.Option ... option) {
        super.setOption(option);
    }

    public void setItems(List<String> stringItems) {
        ListSequence.fromList(this.items).clear();
        this.selectedIndex = -1;
        for (int i = 0; i < ListSequence.fromList(stringItems).count(); ++i) {
            String itemLabel = (String)ListSequence.fromList(stringItems).getElement(i);
            if (itemLabel == null) {
                throw new IllegalStateException("Do not uses null labels in reference/status delegates! item " + i + "is null: " + stringItems);
            }
            AbstractEditor.PebItem itm = new AbstractEditor.PebItem(itemLabel, true, i, false);
            ListSequence.fromList(this.items).addElement((Object)itm);
        }
    }

    public void setPromptText(String text) {
        this.promptText = text;
    }

    public void setDelegate(IDataUxDelegate dlgt) {
        this.propertyName = dlgt.getPropertyName();
    }

    public void setText(String txt) {
        this.value = txt;
        this.selectedIndex = -1;
    }

    public String getText() {
        return this.value;
    }

    public void setOptionalAfterLoad(boolean opt) {
        this.optional = opt;
        if (this instanceof StatusEditor) {
            throw new RuntimeException("This can not happen");
        }
        if (opt && (ListSequence.fromList(this.items).count() <= 0 || !"---".equals(((AbstractEditor.PebItem)ListSequence.fromList(this.items).first()).label))) {
            int optionalIndex = ListSequence.fromList(this.items).count();
            ListSequence.fromList(this.items).insertElement(0, (Object)new AbstractEditor.PebItem("---", true, optionalIndex, false));
        }
    }

    @Override
    public void setIssuesUpdateConclusion() {
        this.scanable = true;
    }

    @Override
    public void toHtml() throws IOException {
        Map<String, Object> renderMap = this.initAndGetRenderMap();
        MapSequence.fromMap(renderMap).put((Object)"items", this.items);
        MapSequence.fromMap(renderMap).put((Object)"value", (Object)this.value);
        MapSequence.fromMap(renderMap).put((Object)"alter", (Object)this.alternativEditor);
        boolean selected = false;
        this.selectedIndex = -1;
        for (int i = 0; i < ListSequence.fromList(this.items).count(); ++i) {
            selected = ((AbstractEditor.PebItem)ListSequence.fromList(this.items).getElement((int)i)).label.equals(this.value);
            if (this.optional && this.value == null) {
                selected = ((AbstractEditor.PebItem)ListSequence.fromList(this.items).getElement((int)i)).label.equals("---");
            }
            if (selected && this.selectedIndex != -1) {
                String msg = "This should not happen, we already selected item " + this.selectedIndex + " / " + ListSequence.fromList(this.items).getElement(this.selectedIndex) + " vs. " + i + " / " + ListSequence.fromList(this.items).getElement(i) + "\n";
                msg = msg + "(all items are " + this.items + ")";
                throw new IllegalStateException(msg);
            }
            if (selected) {
                this.selectedIndex = i;
            }
            ((AbstractEditor.PebItem)ListSequence.fromList(this.items).getElement((int)i)).selected = selected;
        }
        MapSequence.fromMap(renderMap).put((Object)"selectedIndex", (Object)this.selectedIndex);
        if (ListSequence.fromList(this.items).count() <= 0 && ListSequence.fromList(this.items).count() == 0 && !this.enabled) {
            MapSequence.fromMap(renderMap).put((Object)"items", (Object)ListSequence.fromListAndArray(new ArrayList(), (Object[])new AbstractEditor.PebItem[]{new AbstractEditor.PebItem(this.value, true, 0, true)}));
        }
        this.compiledTextEditorTemplate.evaluate(this.writerToUse, renderMap);
        this.requestFocus = false;
    }

    @Override
    public void handleRequest(HttpServletRequest req) {
        if (!this.enabled) {
            return;
        }
        String val = req.getParameter(this.editorId);
        if (val == null || "".equals(val)) {
            this.value = null;
        } else {
            this.selectedIndex = Integer.valueOf(val);
            AbstractEditor.PebItem selectedItem = (AbstractEditor.PebItem)ListSequence.fromList(this.items).findFirst(it -> it.itemId == this.selectedIndex);
            this.value = selectedItem == null ? null : selectedItem.label;
            if (this.optional && "---".equals(this.value)) {
                this.value = null;
            }
        }
    }
}

