/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.h2forms.pebble;

import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import org.modellwerkstatt.dataux.runtime.extensions.ITableCellStringConverter;
import org.modellwerkstatt.dataux.runtime.genspecifications.CmdAction;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenSelControlled;
import org.modellwerkstatt.dataux.runtime.genspecifications.Menu;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TableForm;
import org.modellwerkstatt.dataux.runtime.utils.MoJSON;
import org.modellwerkstatt.h2forms.core.H2FormRequestStateException;
import org.modellwerkstatt.h2forms.pebble.AbstractColumnDivider;
import org.modellwerkstatt.h2forms.pebble.AbstractEditor;
import org.modellwerkstatt.h2forms.pebble.AbstractForm;
import org.modellwerkstatt.h2forms.pebble.MaterialIconsConverter;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import org.modellwerkstatt.objectflow.runtime.Selection;

public class TableForm<T>
extends AbstractForm
implements IToolkit_TableForm<T> {
    private List<T> currentlyBoundObjects;
    private List<Column> columns;
    private IOFXSelection currentSelection;
    private List<CmdAction> dataUxMenuItems;
    private List<AbstractForm.PebAction> actions;
    private boolean hasActions = false;
    private IGenSelControlled formController;
    private String footer = null;
    private AbstractColumnDivider colDivider;

    public TableForm(PebbleTemplate template, AbstractColumnDivider div) {
        super(template);
        this.colDivider = div;
        this.columns = new ArrayList<Column>();
    }

    public void endOfInitializationForElementClass(Class cls) {
        this.colDivider.init(this.columns);
    }

    public void setFormController(IGenSelControlled crtl) {
        this.formController = crtl;
    }

    public void addColumn(String property, String label, ITableCellStringConverter converter, int width, boolean editable, boolean folded, boolean important) {
        this.columns.add(new Column(property, label, converter, width, important));
    }

    public void setSelectionSummaryLineText(String text) {
    }

    public void setTableSummaryLineText(String text) {
        this.footer = text != null && !text.trim().equals("") ? text : null;
    }

    public void addMenuAndSetButtons(Menu folder) {
        this.dataUxMenuItems = new ArrayList<CmdAction>();
        this.actions = new ArrayList<AbstractForm.PebAction>();
        for (CmdAction item : folder.getAllCmdActionsOfMenu()) {
            String convertedImgName = MaterialIconsConverter.codeFor(item.image);
            AbstractForm.PebAction action = new AbstractForm.PebAction(item.labelText, item.hideWhenDisabled, item.image, convertedImgName, this.hashCode(), item.hashCode(), item.hotKey);
            this.dataUxMenuItems.add(item);
            this.actions.add(action);
        }
        this.hasActions = true;
    }

    public boolean selectionChanged(IOFXSelection<T> selection) {
        this.currentSelection = selection;
        return true;
    }

    public void loadList(List<T> objects, IOFXSelection<T> selection) {
        this.currentlyBoundObjects = objects;
        this.currentSelection = selection;
    }

    @Override
    public Object myRequestFocus() {
        return null;
    }

    public void forceNotEditable() {
    }

    public void setEditPreview() {
    }

    @Override
    public boolean actionInForm(int formId, int selectionNum, int actionId) {
        if (this.hasActions && formId == this.hashCode()) {
            this.formController.pushSelection((IOFXSelection)new Selection(this.currentlyBoundObjects.get(selectionNum)));
            for (CmdAction t : this.dataUxMenuItems) {
                if (t.hashCode() != actionId) continue;
                if (t.reevalEnabled()) {
                    t.startCommand();
                    continue;
                }
                throw new H2FormRequestStateException("This can not be true: " + t.labelText + " is disabled for selection " + selectionNum);
            }
            return true;
        }
        return false;
    }

    public void addTableItemColor(String property, ITableCellStringConverter converter) {
    }

    @Override
    public void toHtml() throws IOException {
        Map<String, Object> renderMap = this.initAndGetRenderMap();
        MapSequence.fromMap(renderMap).put((Object)"actions", null);
        MapSequence.fromMap(renderMap).put((Object)"footer", (Object)this.footer);
        MapSequence.fromMap(renderMap).put((Object)"tableColumns", this.columns);
        MapSequence.fromMap(renderMap).put((Object)"currentSelection", (Object)this.currentSelection);
        IListSequence tableRows = ListSequence.fromList(new ArrayList());
        IOFXSelection originalSelection = this.currentSelection;
        for (int line = 0; line < this.currentlyBoundObjects.size(); ++line) {
            T curObj = this.currentlyBoundObjects.get(line);
            Row row = new Row(line, originalSelection.getObjectOrNull() == curObj, this.actions);
            if (this.hasActions) {
                this.dataUxMenuItems.get(0).getLocalSelController().pushSelectionAbsolute((IOFXSelection)new Selection(curObj));
                for (int j = 0; j < this.dataUxMenuItems.size(); ++j) {
                    CmdAction mae = this.dataUxMenuItems.get(j);
                    row.setActionEnabled(this.actions.get(j), mae.reevalEnabled());
                }
            }
            for (int cell = 0; cell < this.columns.size(); ++cell) {
                Column currentColumn = this.columns.get(cell);
                Object currentPropData = MoJSON.get(curObj, (String)currentColumn.property);
                String itemColor = currentColumn.converter.getBgColor(currentPropData);
                String dataAsString = currentColumn.converter.convert(currentPropData);
                row.addCell(dataAsString, itemColor, this.colDivider.needsOpenRow(cell), this.colDivider.getSizeS(cell), this.colDivider.getSizeM(cell), this.colDivider.needsCloseRow(cell), currentColumn.important);
            }
            int emptyCellsToAdd = this.colDivider.numOfEmptyCellToAdd();
            for (int e = 0; e < emptyCellsToAdd; ++e) {
                row.addCell("", null, this.colDivider.needsOpenRow(e), this.colDivider.getSizeS(e), this.colDivider.getSizeM(e), this.colDivider.needsCloseRow(e), false);
            }
            ListSequence.fromList((List)tableRows).addElement((Object)row);
        }
        if (this.hasActions) {
            this.dataUxMenuItems.get(0).getLocalSelController().pushSelectionAbsolute(originalSelection);
        }
        MapSequence.fromMap(renderMap).put((Object)"tableRows", (Object)tableRows);
        this.compiledTextEditorTemplate.evaluate(this.writerToUse, renderMap);
    }

    @Override
    public void delegateDataInForm(HttpServletRequest request) {
    }

    @Override
    public boolean delegatesNeedKeyboard() {
        return false;
    }

    @Override
    public AbstractEditor firstEditorFocused() {
        return null;
    }

    @Override
    public String debugInfo() {
        Object s = "TableForm.debugInfo()\n";
        for (CmdAction gl : this.dataUxMenuItems) {
            s = (String)s + gl.commandFqName + " : " + gl.hashCode() + "\n";
        }
        return s;
    }

    public void gcClear() {
    }

    public static class Column {
        public ITableCellStringConverter converter;
        public String property;
        public String label;
        public int width;
        public boolean important;

        public Column(String prop, String lab, ITableCellStringConverter conv, int wid, boolean imp) {
            this.property = prop;
            this.label = lab;
            this.converter = conv;
            this.width = wid;
            this.important = imp;
        }
    }

    public static class Row {
        public List<Cell> cells = ListSequence.fromList(new ArrayList());
        public int index;
        public int numActions;
        public boolean selected;
        private List<AbstractForm.PebAction> actions;
        private List<Boolean> enabledActions = ListSequence.fromList(new ArrayList());

        public Row(int indx, boolean sel, List<AbstractForm.PebAction> act) {
            this.actions = act;
            this.index = indx;
            this.numActions = ListSequence.fromList(act).count();
            this.selected = sel;
        }

        public void addCell(String cellContent, String color, boolean openRow, int sizeS, int sizeM, boolean closeRow, boolean imp) {
            ListSequence.fromList(this.cells).addElement((Object)new Cell(cellContent, color, openRow, sizeS, sizeM, closeRow, imp));
        }

        public void setActionEnabled(AbstractForm.PebAction act, boolean enabled) {
            ListSequence.fromList(this.enabledActions).addElement((Object)enabled);
        }

        public List<AbstractForm.PebAction> getActions() {
            for (int i = 0; i < ListSequence.fromList(this.actions).count(); ++i) {
                ((AbstractForm.PebAction)ListSequence.fromList(this.actions).getElement(i)).adjustEnabled((Boolean)ListSequence.fromList(this.enabledActions).getElement(i));
            }
            return this.actions;
        }

        public AbstractForm.PebAction getMainAction() {
            if (ListSequence.fromList(this.actions).count() == 0) {
                return null;
            }
            AbstractForm.PebAction firstOne = (AbstractForm.PebAction)ListSequence.fromList(this.actions).getElement(0);
            firstOne.adjustEnabled((Boolean)ListSequence.fromList(this.enabledActions).getElement(0));
            return firstOne;
        }
    }

    public static class Cell {
        public String content;
        public String color;
        public int sizeM;
        public int sizeS;
        public boolean openRow;
        public boolean closeRow;
        public boolean important;

        public Cell(String content, String color, boolean open, int ss, int sm, boolean close, boolean imp) {
            this.content = content;
            this.color = color;
            this.important = imp;
            this.sizeM = sm;
            this.sizeS = ss;
            this.openRow = open;
            this.closeRow = close;
        }
    }
}

