/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.h2forms.pebble;

import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import org.modellwerkstatt.dataux.runtime.delegates.DateTimeDateDelegate;
import org.modellwerkstatt.dataux.runtime.delegates.DecimalDelegate;
import org.modellwerkstatt.dataux.runtime.delegates.IntegerDelegate;
import org.modellwerkstatt.dataux.runtime.delegates.LocalDateDelegate;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.h2forms.core.H2FormRequestStateException;
import org.modellwerkstatt.h2forms.pebble.AbstractEditor;

public class TextEditor
extends AbstractEditor
implements IToolkit_TextEditor {
    protected String text;
    protected boolean useNumericKeyboard = false;
    protected boolean isDateDelegate = false;
    protected boolean isDateDelegateWithPicker = false;
    protected int multilineCount = 1;

    public TextEditor(PebbleTemplate template, int numOfLines) {
        super("txEditor", template);
        this.multilineCount = numOfLines;
    }

    public TextEditor(String name, PebbleTemplate template) {
        super(name, template);
    }

    public void setDelegate(IDataUxDelegate dlgt) {
        if (dlgt instanceof IntegerDelegate || dlgt instanceof DecimalDelegate) {
            this.useNumericKeyboard = true;
        } else if (dlgt instanceof DateTimeDateDelegate || dlgt instanceof LocalDateDelegate) {
            this.useNumericKeyboard = true;
            this.isDateDelegate = true;
        } else if (this.useNumericKeyboard) {
            // empty if block
        }
        if (this.isMultiLine()) {
            dlgt.setDisableFORCE();
        }
    }

    public void setText(String tx) {
        this.text = tx;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void setIssuesUpdateConclusion() {
        this.scanable = true;
    }

    @Override
    public void setOption(IToolkit_TextEditor.Option ... option) {
        if (IToolkit_TextEditor.has((IToolkit_TextEditor.Option)IToolkit_TextEditor.Option.FORCE_NUMERICAL_EDITOR, (IToolkit_TextEditor.Option[])option)) {
            this.useNumericKeyboard = true;
        }
        super.setOption(option);
    }

    public boolean isMultiLine() {
        return this.multilineCount > 1;
    }

    public String[] calcLabels(String theText) {
        String[] lines = theText.split("\\r?\\n");
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = lines[i].trim();
        }
        return lines;
    }

    @Override
    public void toHtml() throws IOException {
        Map<String, Object> renderMap = this.initAndGetRenderMap();
        MapSequence.fromMap(renderMap).put((Object)"useNumericKeyboard", (Object)this.useNumericKeyboard);
        MapSequence.fromMap(renderMap).put((Object)"isDateDelegate", (Object)this.isDateDelegate);
        MapSequence.fromMap(renderMap).put((Object)"isDateDelegateWithPicker", (Object)this.isDateDelegateWithPicker);
        MapSequence.fromMap(renderMap).put((Object)"text", (Object)this.text);
        MapSequence.fromMap(renderMap).put((Object)"multiline", (Object)this.isMultiLine());
        MapSequence.fromMap(renderMap).put((Object)"numOfLines", (Object)this.multilineCount);
        if (this.isMultiLine()) {
            MapSequence.fromMap(renderMap).put((Object)"multilineLabels", (Object)this.calcLabels(this.labelText));
            MapSequence.fromMap(renderMap).put((Object)"multilineValues", (Object)this.calcLabels(this.text));
        } else {
            MapSequence.fromMap(renderMap).put((Object)"multilineLabels", null);
            MapSequence.fromMap(renderMap).put((Object)"multilineValues", null);
        }
        this.compiledTextEditorTemplate.evaluate(this.writerToUse, renderMap);
    }

    @Override
    public void handleRequest(HttpServletRequest req) {
        if (!this.enabled) {
            return;
        }
        String val = req.getParameter(this.editorId);
        if (val == null) {
            throw new H2FormRequestStateException("Client did not provide editor information in form for ATextEditor: EditorId " + this.editorId);
        }
        this.text = val;
    }
}

