/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.h2forms.tools;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.LogFactory;

public class OJDBC6_LoaderServlet
extends HttpServlet {
    private static boolean initSuccessFullyCalled = false;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        out.println("<html>OJDBC6_LoaderServlet - init() done is " + initSuccessFullyCalled + "</html>");
    }

    public void init() throws ServletException {
        super.init();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
            try {
                Class.forName("oracle.jdbc.driver.OracleTimeoutThreadPerVM");
            }
            catch (ClassNotFoundException e) {
                LogFactory.getLog(OJDBC6_LoaderServlet.class).error((Object)("ClassNotFoundException while trying to load ojdbc driver. " + OJDBC6_LoaderServlet.stackTrace2String(e)));
            }
            initSuccessFullyCalled = true;
        }
        catch (Exception ex) {
            LogFactory.getLog(OJDBC6_LoaderServlet.class).error((Object)("Exception while trying to load ojdbc driver. " + OJDBC6_LoaderServlet.stackTrace2String(ex)));
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    public static String stackTrace2String(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return "\n" + sw.toString();
    }
}

