/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.tests.ConvSerdes;

import java.math.BigDecimal;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;
import org.modellwerkstatt.objectflow.serdes.CONV;
import org.modellwerkstatt.objectflow.serdes.ConvFormatOptions;
import org.modellwerkstatt.objectflow.serdes.ConvStdFormatters;
import org.modellwerkstatt.objectflow.serdes.IConvFormatOptions;
import org.modellwerkstatt.objectflow.serdes.IConvSerdes;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.BdCoordinates;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.ComplexArr;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.ErrCodes;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.JsonKeySubsitutes;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.MyE;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.MyEChild;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.ROOT;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.ROOT_BoolStatus;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.RootChild;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.RootEntity;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.Servlet;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.Text;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.TextChild;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.Text_MySatus;
import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;

public class JSonDeserialization
extends OFXTestSuit {
    @Autowired
    private IOFXPlatform __runtimeIOFXPlatform;
    @Autowired
    private IOFXTranslationProvider __runtimeIOFXTranslationProvider;
    private String jSonTxt = "{\n\t\"intValue\": 4711,\n\t\"stringValue\": \"Test String\",\n\t\"bdValue\": 12.45,\n\t\"localDateValue\": \"27.01.1980\",\n\t\"dateTimeValue\": \"04:7:28 27.01.80\", \n\t\"statusValue\": \"S2\",\n\t\n\t\"textChild\": {\n\t\"intValue\": 0,\n\t\"stringValue\": \"Test String in Text Child\",\n\t\"bdValue\": 47.11,\n\t\"localDateValue\": \"27.01.1980\",\n\t\"dateTimeValue\": \"04:7:28 27.01.80\", \n\t\"statusValue\": \"S3\" \t\n\t},\n\t\"multipleChilds\": [{\n\t\"intValue\": 10,\n\t\"stringValue\": \"Child in List 1\",\n\t\"bdValue\": 47.12,\n\t\"localDateValue\": \"27.01.1980\",\n\t\"dateTimeValue\": \"04:7:28 27.01.80\", \n\t\"statusValue\": \"S1\" \t\n\t}, { \n\t\"intValue\": 20,\n\t\"stringValue\": \"Child in List 2\",\n\t\"bdValue\": 47.13,\n\t\"localDateValue\": \"27.01.1980\",\n\t\"dateTimeValue\": \"04:7:28 27.01.80\", \n\t\"statusValue\": \"\" \t\n\t} ]\n}    \n";
    private String entityJsonTxt = "{\"id\":4711,\"vo1\":{\"myIntVal\":4712,\"myStringVal\":\"4712\"},\"vo2\":{\"myIntVal\":4713,\"myStringVal\":\"4713\"},\"childs\":[{\"id\":7,\"name\":\"Entity Child\",\"parentKEY\":4711}]}";
    @Autowired
    private IOFXUserEnvironment userEnv;

    public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
    }

    @OFXTestMethod(id=0, name="Deserialize and check various types here..", debug=false, enabled=true, runAt="")
    public void __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        BigDecimal rightSide;
        int rightSide2;
        BigDecimal rightSide3;
        int rightSide4;
        BigDecimal rightSide5;
        int rightSide6;
        BigDecimal rightSide7;
        int rightSide8;
        ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", new IConvFormatOptions.Mode[]{IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY});
        IConvSerdes myDeser = CONV.jsonSerDes(Text.class, (IConvFormatOptions)new ConvStdFormatters(opts));
        Text newObj = (Text)((Object)myDeser.deser(this.jSonTxt));
        int leftSide = newObj.getIntValue();
        if (leftSide != (rightSide8 = 4711)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .intValue == 4711          ==>>" + leftSide + " ==" + rightSide8 + "\n");
        }
        Object operand = newObj.getStringValue();
        String param0 = "Test String";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!((String)operand).equals(param0)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .stringValue.equals(\"Test String\")          ==>> '" + (String)operand + "'.equals(" + textRepresentation + ") \n");
        }
        BigDecimal leftSide2 = newObj.getBdValue();
        if (leftSide2.compareTo(rightSide7 = new BigDecimal("12.45")) != 0) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .bdValue == 12.45bd          ==>>" + leftSide2 + " ==" + rightSide7 + "\n");
        }
        operand = newObj.getLocalDateValue();
        param0 = new LocalDate(1980, 1, 27);
        textRepresentation = new StringBuilder();
        textRepresentation.append((LocalDate)param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals((Object)param0)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .localDateValue.equals( new_LocalDateFromServer )          ==>> '" + (LocalDate)operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = newObj.getDateTimeValue();
        param0 = new DateTime(1980, 1, 27, 4, 7, 28, 0);
        textRepresentation = new StringBuilder();
        textRepresentation.append((DateTime)param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals((Object)param0)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .dateTimeValue.equals( new_DateTimeFromServer )          ==>> '" + (DateTime)operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = newObj.getStatusValue();
        if (!SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)operand, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{Text_MySatus.S2})) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .statusValue of S2           ==>>" + (IOFXMetaStatus.IOFXStatusElement)operand + "\n");
        }
        leftSide = newObj.getTextChild().getIntValue();
        if (leftSide != (rightSide6 = 0)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .textChild.intValue == 0          ==>>" + leftSide + " ==" + rightSide6 + "\n");
        }
        BigDecimal leftSide3 = newObj.getTextChild().getBdValue();
        if (leftSide3.compareTo(rightSide5 = new BigDecimal("47.11")) != 0) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .textChild.bdValue == 47.11bd          ==>>" + leftSide3 + " ==" + rightSide5 + "\n");
        }
        Text_MySatus operand2 = newObj.getTextChild().getStatusValue();
        if (!SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)operand2, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{Text_MySatus.S3})) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .textChild.statusValue of S3           ==>>" + operand2 + "\n");
        }
        leftSide = ListSequence.fromList(newObj.getMultipleChilds()).count();
        if (leftSide != (rightSide4 = 2)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .multipleChilds.size == 2          ==>>" + leftSide + " ==" + rightSide4 + "\n");
        }
        leftSide = ((TextChild)((Object)ListSequence.fromList(newObj.getMultipleChilds()).getElement(0))).getIntValue();
        if (leftSide != (rightSide4 = 10)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .multipleChilds.get.intValue == 10          ==>>" + leftSide + " ==" + rightSide4 + "\n");
        }
        BigDecimal leftSide4 = ((TextChild)((Object)ListSequence.fromList(newObj.getMultipleChilds()).getElement(0))).getBdValue();
        if (leftSide4.compareTo(rightSide3 = new BigDecimal("47.12")) != 0) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .multipleChilds.get.bdValue == 47.12bd          ==>>" + leftSide4 + " ==" + rightSide3 + "\n");
        }
        Text_MySatus operand3 = ((TextChild)((Object)ListSequence.fromList(newObj.getMultipleChilds()).getElement(0))).getStatusValue();
        if (!SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)operand3, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{Text_MySatus.S1})) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .multipleChilds.get.statusValue of S1           ==>>" + operand3 + "\n");
        }
        leftSide = ((TextChild)((Object)ListSequence.fromList(newObj.getMultipleChilds()).getElement(1))).getIntValue();
        if (leftSide != (rightSide2 = 20)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .multipleChilds.get.intValue == 20          ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        BigDecimal leftSide5 = ((TextChild)((Object)ListSequence.fromList(newObj.getMultipleChilds()).getElement(1))).getBdValue();
        if (leftSide5.compareTo(rightSide = new BigDecimal("47.13")) != 0) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .multipleChilds.get.bdValue == 47.13bd          ==>>" + leftSide5 + " ==" + rightSide + "\n");
        }
        Text_MySatus operand4 = ((TextChild)((Object)ListSequence.fromList(newObj.getMultipleChilds()).getElement(1))).getStatusValue();
        if (!SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)operand4, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{Text_MySatus.S3})) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here..':  newObj .multipleChilds.get.statusValue of S3           ==>>" + operand4 + "\n");
        }
    }

    @OFXTestMethod(id=1, name="Deserialize and check various types here that might be null, when null in json", debug=false, enabled=true, runAt="")
    public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Object rightSide;
        int rightSide2;
        String nullText;
        ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", new IConvFormatOptions.Mode[]{IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY});
        IConvSerdes myDeser = CONV.jsonSerDes(Text.class, (IConvFormatOptions)new ConvStdFormatters(opts));
        Text newObj = (Text)((Object)myDeser.deser(nullText = "{\n\t\"intValue\": null,\n\t\"stringValue\": null,\n\t\"bdValue\": null,\n\t\"localDateValue\": null,\n\t\"dateTimeValue\": null, \n\t\"statusValue\": null,\n\t\n\t\"textChild\": null,\n\t\"multipleChilds\": null\n}"));
        int leftSide = newObj.getIntValue();
        if (leftSide != (rightSide2 = -1)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here that might be null, when null in json':  newObj .intValue == -1          ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        Object leftSide2 = newObj.getStringValue();
        if (leftSide2 != (rightSide = null)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here that might be null, when null in json':  newObj .stringValue ==  null           ==>>" + (String)leftSide2 + " ==" + rightSide + "\n");
        }
        leftSide2 = newObj.getBdValue();
        if (leftSide2 != (rightSide = null)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here that might be null, when null in json':  newObj .bdValue ==  null           ==>>" + (BigDecimal)leftSide2 + " ==" + rightSide + "\n");
        }
        leftSide2 = newObj.getLocalDateValue();
        if (leftSide2 != (rightSide = null)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here that might be null, when null in json':  newObj .localDateValue ==  null           ==>>" + (LocalDate)leftSide2 + " ==" + rightSide + "\n");
        }
        leftSide2 = newObj.getDateTimeValue();
        if (leftSide2 != (rightSide = null)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here that might be null, when null in json':  newObj .dateTimeValue ==  null           ==>>" + (DateTime)leftSide2 + " ==" + rightSide + "\n");
        }
        Text_MySatus operand = newObj.getStatusValue();
        if (!SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)operand, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{Text_MySatus.S3})) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here that might be null, when null in json':  newObj .statusValue of S3           ==>>" + operand + "\n");
        }
        leftSide2 = newObj.getTextChild();
        if (leftSide2 != (rightSide = null)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here that might be null, when null in json':  newObj .textChild ==  null           ==>>" + (TextChild)((Object)leftSide2) + " ==" + rightSide + "\n");
        }
        leftSide2 = newObj.getMultipleChilds();
        if (leftSide2 != (rightSide = null)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize and check various types here that might be null, when null in json':  newObj .multipleChilds ==  null           ==>>" + leftSide2 + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=2, name="Deserialize and provok an error.", debug=false, enabled=true, runAt="")
    public void __testmethod_2(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        block12: {
            ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", new IConvFormatOptions.Mode[]{IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY});
            IConvSerdes myDeser = CONV.jsonSerDes(Text.class, (IConvFormatOptions)new ConvStdFormatters(opts));
            boolean __FailIn_catched = false;
            boolean __FailIn_text = true;
            RuntimeException __FailIn_origThrowable = null;
            Object messagesInProblems = "";
            try {
                Text text = (Text)((Object)myDeser.deser(this.jSonTxt.replace("stringValue", "stringValue2")));
            }
            catch (RuntimeException ex) {
                __FailIn_origThrowable = ex;
                __FailIn_catched = true;
                messagesInProblems = ex.getMessage();
                __FailIn_text = false;
                if (messagesInProblems == null) {
                    messagesInProblems = "";
                }
                if (((String)messagesInProblems).contains("Text.stringValue")) {
                    __FailIn_text = true;
                }
                messagesInProblems = (String)messagesInProblems + "\n";
                List allProblems = __manMapSession.getAndclearProblemState();
                for (IOFXProblem problem : allProblems) {
                    messagesInProblems = (String)messagesInProblems + problem.getSimpleUserText() + "\n";
                    if (!problem.getSimpleUserText().contains("Text.stringValue")) continue;
                    __FailIn_text = true;
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                if (!__FailIn_catched && __FailIn_origThrowable == null) {
                    throw new OFXTestSuitException("'JSonDeserialization.Deserialize and provok an error.': Fail In Exception RuntimeException was NOT catched!");
                }
                if (__FailIn_catched && !__FailIn_text) {
                    throw new OFXTestSuitException("'JSonDeserialization.Deserialize and provok an error.': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + (String)messagesInProblems + " \n");
                }
                if (__FailIn_catched) break block12;
                throw new OFXTestSuitException("'JSonDeserialization.Deserialize and provok an error.': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
            }
        }
    }

    @OFXTestMethod(id=3, name="Using Key Substitutioner for json to obj graph", debug=false, enabled=true, runAt="")
    public void __testmethod_3(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", new IConvFormatOptions.Mode[]{IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY});
        String json_Adopted = this.jSonTxt.replace("intValue", "int-Value").replace("textChild", "text-Child");
        IConvSerdes myDeser = CONV.jsonSerDes(Text.class, (IConvFormatOptions)new ConvStdFormatters(opts, JsonKeySubsitutes.KEY_SUB));
        Text newObj = (Text)((Object)myDeser.deser(json_Adopted));
        int leftSide = newObj.getIntValue();
        if (leftSide != (rightSide = 4711)) {
            throw new OFXTestSuitException("'JSonDeserialization.Using Key Substitutioner for json to obj graph':  newObj .intValue == 4711          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = newObj.getTextChild().getIntValue();
        if (leftSide != (rightSide = 0)) {
            throw new OFXTestSuitException("'JSonDeserialization.Using Key Substitutioner for json to obj graph':  newObj .textChild.intValue == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = ListSequence.fromList(newObj.getMultipleChilds()).count();
        if (leftSide != (rightSide = 2)) {
            throw new OFXTestSuitException("'JSonDeserialization.Using Key Substitutioner for json to obj graph':  newObj .multipleChilds.size == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = ((TextChild)((Object)ListSequence.fromList(newObj.getMultipleChilds()).getElement(0))).getIntValue();
        if (leftSide != (rightSide = 10)) {
            throw new OFXTestSuitException("'JSonDeserialization.Using Key Substitutioner for json to obj graph':  newObj .multipleChilds.get.intValue == 10          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = ((TextChild)((Object)ListSequence.fromList(newObj.getMultipleChilds()).getElement(1))).getIntValue();
        if (leftSide != (rightSide = 20)) {
            throw new OFXTestSuitException("'JSonDeserialization.Using Key Substitutioner for json to obj graph':  newObj .multipleChilds.get.intValue == 20          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=4, name="Field Missing in json should lead to error when using complete_excact.", debug=false, enabled=true, runAt="")
    public void __testmethod_4(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        block12: {
            ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", new IConvFormatOptions.Mode[]{IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY});
            String json_Adopted = this.jSonTxt.replace("\"intValue\": 4711,", "");
            IConvSerdes myDeser = CONV.jsonSerDes(Text.class, (IConvFormatOptions)new ConvStdFormatters(opts));
            boolean __FailIn_catched = false;
            boolean __FailIn_text = true;
            RuntimeException __FailIn_origThrowable = null;
            Object messagesInProblems = "";
            try {
                Text text = (Text)((Object)myDeser.deser(json_Adopted));
            }
            catch (RuntimeException ex) {
                __FailIn_origThrowable = ex;
                __FailIn_catched = true;
                messagesInProblems = ex.getMessage();
                __FailIn_text = false;
                if (messagesInProblems == null) {
                    messagesInProblems = "";
                }
                if (((String)messagesInProblems).contains("do not match")) {
                    __FailIn_text = true;
                }
                messagesInProblems = (String)messagesInProblems + "\n";
                List allProblems = __manMapSession.getAndclearProblemState();
                for (IOFXProblem problem : allProblems) {
                    messagesInProblems = (String)messagesInProblems + problem.getSimpleUserText() + "\n";
                    if (!problem.getSimpleUserText().contains("do not match")) continue;
                    __FailIn_text = true;
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                if (!__FailIn_catched && __FailIn_origThrowable == null) {
                    throw new OFXTestSuitException("'JSonDeserialization.Field Missing in json should lead to error when using complete_excact.': Fail In Exception RuntimeException was NOT catched!");
                }
                if (__FailIn_catched && !__FailIn_text) {
                    throw new OFXTestSuitException("'JSonDeserialization.Field Missing in json should lead to error when using complete_excact.': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + (String)messagesInProblems + " \n");
                }
                if (__FailIn_catched) break block12;
                throw new OFXTestSuitException("'JSonDeserialization.Field Missing in json should lead to error when using complete_excact.': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
            }
        }
    }

    @OFXTestMethod(id=5, name="Field to much leads to error when using complete_exact", debug=false, enabled=true, runAt="")
    public void __testmethod_5(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        block12: {
            ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", new IConvFormatOptions.Mode[]{IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY});
            String json_Adopted = this.jSonTxt.replace("\"intValue\": 4711,", "\"intValue\": 4711, \"intValue2\": 4722,");
            IConvSerdes myDeser = CONV.jsonSerDes(Text.class, (IConvFormatOptions)new ConvStdFormatters(opts));
            boolean __FailIn_catched = false;
            boolean __FailIn_text = true;
            RuntimeException __FailIn_origThrowable = null;
            Object messagesInProblems = "";
            try {
                Text text = (Text)((Object)myDeser.deser(json_Adopted));
            }
            catch (RuntimeException ex) {
                __FailIn_origThrowable = ex;
                __FailIn_catched = true;
                messagesInProblems = ex.getMessage();
                __FailIn_text = false;
                if (messagesInProblems == null) {
                    messagesInProblems = "";
                }
                if (((String)messagesInProblems).contains("do not match")) {
                    __FailIn_text = true;
                }
                messagesInProblems = (String)messagesInProblems + "\n";
                List allProblems = __manMapSession.getAndclearProblemState();
                for (IOFXProblem problem : allProblems) {
                    messagesInProblems = (String)messagesInProblems + problem.getSimpleUserText() + "\n";
                    if (!problem.getSimpleUserText().contains("do not match")) continue;
                    __FailIn_text = true;
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                if (!__FailIn_catched && __FailIn_origThrowable == null) {
                    throw new OFXTestSuitException("'JSonDeserialization.Field to much leads to error when using complete_exact': Fail In Exception RuntimeException was NOT catched!");
                }
                if (__FailIn_catched && !__FailIn_text) {
                    throw new OFXTestSuitException("'JSonDeserialization.Field to much leads to error when using complete_exact': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + (String)messagesInProblems + " \n");
                }
                if (__FailIn_catched) break block12;
                throw new OFXTestSuitException("'JSonDeserialization.Field to much leads to error when using complete_exact': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
            }
        }
    }

    @OFXTestMethod(id=6, name="Field to much leads to NO ERROR when not using complete_exact", debug=false, enabled=true, runAt="")
    public void __testmethod_6(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", new IConvFormatOptions.Mode[0]);
        String json_Adopted = this.jSonTxt.replace("\"intValue\": 4711,", "\"intValue\": 4711, \"intValue2\": 4722,");
        IConvSerdes myDeser = CONV.jsonSerDes(Text.class, (IConvFormatOptions)new ConvStdFormatters(opts));
        Text newObj = (Text)((Object)myDeser.deser(json_Adopted));
    }

    @OFXTestMethod(id=7, name="Field Missing in json should set Field to null / 0 when field not present", debug=false, enabled=true, runAt="")
    public void __testmethod_7(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        Object rightSide2;
        int rightSide3;
        ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", new IConvFormatOptions.Mode[]{IConvFormatOptions.Mode.SET_MISSING_PROPERTIES_NULL});
        String json_Adopted = "{ }";
        IConvSerdes myDeser = CONV.jsonSerDes(Text.class, (IConvFormatOptions)new ConvStdFormatters(opts));
        Text newObj = (Text)((Object)myDeser.deser(json_Adopted));
        int leftSide = newObj.getIntValue();
        if (leftSide != (rightSide3 = 0)) {
            throw new OFXTestSuitException("'JSonDeserialization.Field Missing in json should set Field to null / 0 when field not present':  newObj .intValue == 0          ==>>" + leftSide + " ==" + rightSide3 + "\n");
        }
        Object leftSide2 = newObj.getStringValue();
        if (leftSide2 != (rightSide2 = null)) {
            throw new OFXTestSuitException("'JSonDeserialization.Field Missing in json should set Field to null / 0 when field not present':  newObj .stringValue ==  null           ==>>" + (String)leftSide2 + " ==" + rightSide2 + "\n");
        }
        leftSide2 = newObj.getBdValue();
        if (leftSide2 != (rightSide2 = null)) {
            throw new OFXTestSuitException("'JSonDeserialization.Field Missing in json should set Field to null / 0 when field not present':  newObj .bdValue ==  null           ==>>" + (BigDecimal)leftSide2 + " ==" + rightSide2 + "\n");
        }
        leftSide2 = newObj.getLocalDateValue();
        if (leftSide2 != (rightSide2 = null)) {
            throw new OFXTestSuitException("'JSonDeserialization.Field Missing in json should set Field to null / 0 when field not present':  newObj .localDateValue ==  null           ==>>" + (LocalDate)leftSide2 + " ==" + rightSide2 + "\n");
        }
        leftSide2 = newObj.getDateTimeValue();
        if (leftSide2 != (rightSide2 = null)) {
            throw new OFXTestSuitException("'JSonDeserialization.Field Missing in json should set Field to null / 0 when field not present':  newObj .dateTimeValue ==  null           ==>>" + (DateTime)leftSide2 + " ==" + rightSide2 + "\n");
        }
        Text_MySatus operand = newObj.getStatusValue();
        if (!SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)operand, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{Text_MySatus.S3})) {
            throw new OFXTestSuitException("'JSonDeserialization.Field Missing in json should set Field to null / 0 when field not present':  newObj .statusValue of S3           ==>>" + operand + "\n");
        }
        leftSide2 = newObj.getTextChild();
        if (leftSide2 != (rightSide2 = null)) {
            throw new OFXTestSuitException("'JSonDeserialization.Field Missing in json should set Field to null / 0 when field not present':  newObj .textChild ==  null           ==>>" + (TextChild)((Object)leftSide2) + " ==" + rightSide2 + "\n");
        }
        leftSide = ListSequence.fromList(newObj.getMultipleChilds()).count();
        if (leftSide != (rightSide = 0)) {
            throw new OFXTestSuitException("'JSonDeserialization.Field Missing in json should set Field to null / 0 when field not present':  newObj .multipleChilds.size == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=8, name="Null array should set list property to null", debug=false, enabled=true, runAt="")
    public void __testmethod_8(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Object rightSide;
        ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", new IConvFormatOptions.Mode[]{IConvFormatOptions.Mode.SET_MISSING_PROPERTIES_NULL});
        String json_Adopted = "{\"multipleChilds\": null}";
        IConvSerdes myDeser = CONV.jsonSerDes(Text.class, (IConvFormatOptions)new ConvStdFormatters(opts));
        Text newObj = (Text)((Object)myDeser.deser(json_Adopted));
        List<TextChild> leftSide = newObj.getMultipleChilds();
        if (leftSide != (rightSide = null)) {
            throw new OFXTestSuitException("'JSonDeserialization.Null array should set list property to null':  newObj .multipleChilds ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=9, name="Null array should set list property to empty in case of NULL_ARRAY_TO_EMPTY", debug=false, enabled=true, runAt="")
    public void __testmethod_9(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", new IConvFormatOptions.Mode[]{IConvFormatOptions.Mode.SET_MISSING_PROPERTIES_NULL, IConvFormatOptions.Mode.NULL_ARRAY_TO_EMPTY});
        String json_Adopted = "{\"multipleChilds\": null}";
        IConvSerdes myDeser = CONV.jsonSerDes(Text.class, (IConvFormatOptions)new ConvStdFormatters(opts));
        Text newObj = (Text)((Object)myDeser.deser(json_Adopted));
        int leftSide = ListSequence.fromList(newObj.getMultipleChilds()).count();
        if (leftSide != (rightSide = 0)) {
            throw new OFXTestSuitException("'JSonDeserialization.Null array should set list property to empty in case of NULL_ARRAY_TO_EMPTY':  newObj .multipleChilds.size == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=10, name="Deserialize a list of object straight on - using array and class.", debug=false, enabled=true, runAt="")
    public void __testmethod_10(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", new IConvFormatOptions.Mode[]{IConvFormatOptions.Mode.SET_MISSING_PROPERTIES_NULL});
        String json_adopted = "[" + this.jSonTxt + ", " + this.jSonTxt + "]";
        IConvSerdes myDeser = CONV.jsonSerDes(Text[].class, (IConvFormatOptions)new ConvStdFormatters(opts));
        Text[] newObjList = (Text[])myDeser.deser(json_adopted);
        int leftSide = newObjList.length;
        if (leftSide != (rightSide = 2)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of object straight on - using array and class.':  newObjList .length == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        for (Text newObj : newObjList) {
            BigDecimal rightSide2;
            int rightSide3;
            BigDecimal rightSide4;
            int rightSide5;
            int leftSide2 = newObj.getIntValue();
            if (leftSide2 != (rightSide5 = 4711)) {
                throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of object straight on - using array and class.':  newObj .intValue == 4711          ==>>" + leftSide2 + " ==" + rightSide5 + "\n");
            }
            Object operand = newObj.getStringValue();
            String param0 = "Test String";
            StringBuilder textRepresentation = new StringBuilder();
            textRepresentation.append(param0 + ", ");
            textRepresentation.setLength(textRepresentation.length() - 2);
            if (!((String)operand).equals(param0)) {
                throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of object straight on - using array and class.':  newObj .stringValue.equals(\"Test String\")          ==>> '" + (String)operand + "'.equals(" + textRepresentation + ") \n");
            }
            BigDecimal leftSide22 = newObj.getBdValue();
            if (leftSide22.compareTo(rightSide4 = new BigDecimal("12.45")) != 0) {
                throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of object straight on - using array and class.':  newObj .bdValue == 12.45bd          ==>>" + leftSide22 + " ==" + rightSide4 + "\n");
            }
            operand = newObj.getLocalDateValue();
            param0 = new LocalDate(1980, 1, 27);
            textRepresentation = new StringBuilder();
            textRepresentation.append((LocalDate)param0 + ", ");
            textRepresentation.setLength(textRepresentation.length() - 2);
            if (!operand.equals((Object)param0)) {
                throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of object straight on - using array and class.':  newObj .localDateValue.equals( new_LocalDateFromServer )          ==>> '" + (LocalDate)operand + "'.equals(" + textRepresentation + ") \n");
            }
            operand = newObj.getDateTimeValue();
            param0 = new DateTime(1980, 1, 27, 4, 7, 28, 0);
            textRepresentation = new StringBuilder();
            textRepresentation.append((DateTime)param0 + ", ");
            textRepresentation.setLength(textRepresentation.length() - 2);
            if (!operand.equals((Object)param0)) {
                throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of object straight on - using array and class.':  newObj .dateTimeValue.equals( new_DateTimeFromServer )          ==>> '" + (DateTime)operand + "'.equals(" + textRepresentation + ") \n");
            }
            operand = newObj.getStatusValue();
            if (!SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)operand, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{Text_MySatus.S2})) {
                throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of object straight on - using array and class.':  newObj .statusValue of S2           ==>>" + (IOFXMetaStatus.IOFXStatusElement)operand + "\n");
            }
            leftSide = newObj.getTextChild().getIntValue();
            if (leftSide != (rightSide3 = 0)) {
                throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of object straight on - using array and class.':  newObj .textChild.intValue == 0          ==>>" + leftSide + " ==" + rightSide3 + "\n");
            }
            BigDecimal leftSide3 = newObj.getTextChild().getBdValue();
            if (leftSide3.compareTo(rightSide2 = new BigDecimal("47.11")) != 0) {
                throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of object straight on - using array and class.':  newObj .textChild.bdValue == 47.11bd          ==>>" + leftSide3 + " ==" + rightSide2 + "\n");
            }
            Text_MySatus operand2 = newObj.getTextChild().getStatusValue();
            if (!SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)operand2, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{Text_MySatus.S3})) {
                throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of object straight on - using array and class.':  newObj .textChild.statusValue of S3           ==>>" + operand2 + "\n");
            }
            leftSide2 = ListSequence.fromList(newObj.getMultipleChilds()).count();
            if (leftSide2 == (rightSide5 = 2)) continue;
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of object straight on - using array and class.':  newObj .multipleChilds.size == 2          ==>>" + leftSide2 + " ==" + rightSide5 + "\n");
        }
    }

    @OFXTestMethod(id=11, name="Deserialize with null object field . . . ", debug=false, enabled=true, runAt="")
    public void __testmethod_11(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        BigDecimal rightSide2;
        int rightSide3;
        String json = "{\n\t\"intValue\": 4711,\n\t\"stringValue\": \"Test String\",\n\t\"bdValue\": 12.45,\n\t\"localDateValue\": \"27.01.1980\",\n\t\"dateTimeValue\": \"04:7:28 27.01.80\", \n\t\"statusValue\": \"S2\",\n\t\n\t\"textChild\": null,\n\t\"multipleChilds\": []\n}    \n";
        ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", new IConvFormatOptions.Mode[]{IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY});
        IConvSerdes myDeser = CONV.jsonSerDes(Text.class, (IConvFormatOptions)new ConvStdFormatters(opts));
        Text newObj = (Text)((Object)myDeser.deser(json));
        int leftSide = newObj.getIntValue();
        if (leftSide != (rightSide3 = 4711)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize with null object field . . . ':  newObj .intValue == 4711          ==>>" + leftSide + " ==" + rightSide3 + "\n");
        }
        Object operand = newObj.getStringValue();
        String param0 = "Test String";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!((String)operand).equals(param0)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize with null object field . . . ':  newObj .stringValue.equals(\"Test String\")          ==>> '" + (String)operand + "'.equals(" + textRepresentation + ") \n");
        }
        Object leftSide2 = newObj.getBdValue();
        if (leftSide2.compareTo(rightSide2 = new BigDecimal("12.45")) != 0) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize with null object field . . . ':  newObj .bdValue == 12.45bd          ==>>" + leftSide2 + " ==" + rightSide2 + "\n");
        }
        operand = newObj.getLocalDateValue();
        param0 = new LocalDate(1980, 1, 27);
        textRepresentation = new StringBuilder();
        textRepresentation.append((LocalDate)param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals((Object)param0)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize with null object field . . . ':  newObj .localDateValue.equals( new_LocalDateFromServer )          ==>> '" + (LocalDate)operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = newObj.getDateTimeValue();
        param0 = new DateTime(1980, 1, 27, 4, 7, 28, 0);
        textRepresentation = new StringBuilder();
        textRepresentation.append((DateTime)param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals((Object)param0)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize with null object field . . . ':  newObj .dateTimeValue.equals( new_DateTimeFromServer )          ==>> '" + (DateTime)operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = newObj.getStatusValue();
        if (!SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)operand, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{Text_MySatus.S2})) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize with null object field . . . ':  newObj .statusValue of S2           ==>>" + (IOFXMetaStatus.IOFXStatusElement)operand + "\n");
        }
        leftSide2 = newObj.getTextChild();
        if (leftSide2 != (rightSide2 = null)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize with null object field . . . ':  newObj .textChild ==  null           ==>>" + (TextChild)((Object)leftSide2) + " ==" + rightSide2 + "\n");
        }
        leftSide = ListSequence.fromList(newObj.getMultipleChilds()).count();
        if (leftSide != (rightSide = 0)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize with null object field . . . ':  newObj .multipleChilds.size == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=12, name="Deserialize Entity Graph with Opposite Keyword.", debug=false, enabled=true, runAt="")
    public void __testmethod_12(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        IConvSerdes myDeser = CONV.jsonSerDes(MyE.class, (IConvFormatOptions)CONV.CONV_DEFAULT_EN);
        MyE origObj = (MyE)((Object)myDeser.deser(this.entityJsonTxt));
        int leftSide = ListSequence.fromList(origObj.getChilds()).count();
        if (leftSide != (rightSide = 1)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize Entity Graph with Opposite Keyword.':  origObj .childs.size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = ((MyEChild)((Object)ListSequence.fromList(origObj.getChilds()).first())).getParentKEY();
        if (leftSide != (rightSide = 4711)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize Entity Graph with Opposite Keyword.':  origObj .childs.first.parent#KEY == 4711          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=13, name="Deserialize a cycling graph here.", debug=false, enabled=true, runAt="")
    public void __testmethod_13(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        String JSON_INPUT = "{\"id\":1,\"rootName\":\"Root\",\"listOfChilds\":[{\"id\":2,\"childName\":\"Child 2\",\"listOfChilds\":[]},{\"id\":3,\"childName\":\"Child 3\",\"listOfChilds\":[]},{\"id\":4,\"childName\":\"Child 4\",\"listOfChilds\":[{\"id\":5,\"childName\":\"Child 5\",\"listOfChilds\":[]}]}]}";
        IConvSerdes myDeser = CONV.jsonSerDes(RootEntity.class, (IConvFormatOptions)CONV.CONV_DEFAULT_EN);
        RootEntity root = (RootEntity)((Object)myDeser.deser(JSON_INPUT));
        int leftSide = ListSequence.fromList(root.getListOfChilds()).count();
        if (leftSide != (rightSide = 3)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize a cycling graph here.':  root .listOfChilds.size == 3          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = ListSequence.fromList(((RootChild)((Object)ListSequence.fromList(root.getListOfChilds()).getElement(0))).getListOfChilds()).count();
        if (leftSide != (rightSide = 0)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize a cycling graph here.':  root .listOfChilds.get.listOfChilds.size == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = ((RootChild)((Object)ListSequence.fromList(root.getListOfChilds()).getElement(0))).getId();
        if (leftSide != (rightSide = 2)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize a cycling graph here.':  root .listOfChilds.get.id == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = ListSequence.fromList(((RootChild)((Object)ListSequence.fromList(root.getListOfChilds()).getElement(1))).getListOfChilds()).count();
        if (leftSide != (rightSide = 0)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize a cycling graph here.':  root .listOfChilds.get.listOfChilds.size == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = ((RootChild)((Object)ListSequence.fromList(root.getListOfChilds()).getElement(1))).getId();
        if (leftSide != (rightSide = 3)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize a cycling graph here.':  root .listOfChilds.get.id == 3          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = ListSequence.fromList(((RootChild)((Object)ListSequence.fromList(root.getListOfChilds()).getElement(2))).getListOfChilds()).count();
        if (leftSide != (rightSide = 1)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize a cycling graph here.':  root .listOfChilds.get.listOfChilds.size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = ((RootChild)((Object)ListSequence.fromList(root.getListOfChilds()).getElement(2))).getId();
        if (leftSide != (rightSide = 4)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize a cycling graph here.':  root .listOfChilds.get.id == 4          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = ((RootChild)((Object)ListSequence.fromList(((RootChild)((Object)ListSequence.fromList(root.getListOfChilds()).getElement(2))).getListOfChilds()).getElement(0))).getId();
        if (leftSide != (rightSide = 5)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize a cycling graph here.':  root .listOfChilds.get.listOfChilds.get.id == 5          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=14, name="Deserialize a simple array of value", debug=false, enabled=true, runAt="")
    public void __testmethod_14(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        String json_codes = "[500, 501, 502]";
        ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", new IConvFormatOptions.Mode[]{IConvFormatOptions.Mode.SIMPLE_ARRAYS_TO_DTO});
        IConvSerdes myDeser = CONV.jsonSerDes(ErrCodes[].class, (IConvFormatOptions)new ConvStdFormatters(opts));
        ErrCodes[] newObj = (ErrCodes[])myDeser.deser(json_codes);
        int leftSide = newObj.length;
        if (leftSide != (rightSide = 3)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize a simple array of value':  newObj .length == 3          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = newObj[0].getValue();
        if (leftSide != (rightSide = 500)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize a simple array of value':  [ .value == 500          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = newObj[1].getValue();
        if (leftSide != (rightSide = 501)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize a simple array of value':  [ .value == 501          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = newObj[2].getValue();
        if (leftSide != (rightSide = 502)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize a simple array of value':  [ .value == 502          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=15, name="Deserialize an object with an array", debug=false, enabled=true, runAt="")
    public void __testmethod_15(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        BigDecimal rightSide;
        int rightSide2;
        String json_codes = "{\"name\": \"test object\", \"errorCodes\": [500, 501, 502], \"coordinates\": [12.12, 13.13]}";
        ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", new IConvFormatOptions.Mode[]{IConvFormatOptions.Mode.SIMPLE_ARRAYS_TO_DTO});
        IConvSerdes myDeser = CONV.jsonSerDes(ComplexArr.class, (IConvFormatOptions)new ConvStdFormatters(opts));
        ComplexArr newObj = (ComplexArr)((Object)myDeser.deser(json_codes));
        String operand = newObj.getName();
        String param0 = "test object";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize an object with an array':  newObj .name.equals(\"test object\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
        int leftSide = ListSequence.fromList(newObj.getErrorCodes()).count();
        if (leftSide != (rightSide2 = 3)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize an object with an array':  newObj .errorCodes.size == 3          ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        leftSide = ((ErrCodes)((Object)ListSequence.fromList(newObj.getErrorCodes()).getElement(0))).getValue();
        if (leftSide != (rightSide2 = 500)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize an object with an array':  newObj .errorCodes.get.value == 500          ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        leftSide = ((ErrCodes)((Object)ListSequence.fromList(newObj.getErrorCodes()).getElement(1))).getValue();
        if (leftSide != (rightSide2 = 501)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize an object with an array':  newObj .errorCodes.get.value == 501          ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        leftSide = ((ErrCodes)((Object)ListSequence.fromList(newObj.getErrorCodes()).getElement(2))).getValue();
        if (leftSide != (rightSide2 = 502)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize an object with an array':  newObj .errorCodes.get.value == 502          ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        BigDecimal leftSide2 = ((BdCoordinates)((Object)ListSequence.fromList(newObj.getCoordinates()).getElement(0))).getValue();
        if (leftSide2.compareTo(rightSide = new BigDecimal("12.12")) != 0) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize an object with an array':  newObj .coordinates.get.value == 12.12bd          ==>>" + leftSide2 + " ==" + rightSide + "\n");
        }
        leftSide2 = ((BdCoordinates)((Object)ListSequence.fromList(newObj.getCoordinates()).getElement(1))).getValue();
        if (leftSide2.compareTo(rightSide = new BigDecimal("13.13")) != 0) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize an object with an array':  newObj .coordinates.get.value == 13.13bd          ==>>" + leftSide2 + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=16, name="Deserialize complex ROOT - also checking for boolean.", debug=false, enabled=true, runAt="")
    public void __testmethod_16(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        String json_codes = "{  \"web-app\": {    \"servlet\": [      {        \"servlet-name\": \"cofaxCDS\",        \"servlet-class\": \"org.cofax.cds.CDSServlet\",        \"init-param\": {          \"configGlossary:installationAt\": \"Philadelphia, PA\",          \"useJSP\": false,          \"jspListTemplate\": \"listTemplate.jsp\",          \"jspFileTemplate\": \"articleTemplate.jsp\",          \"cachePackageTagsTrack\": 200,          \"cachePackageTagsStore\": 200,          \"useDataStore\": true,          \"betaServer\": true        }      }    ]  }}";
        ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", new IConvFormatOptions.Mode[]{IConvFormatOptions.Mode.SET_MISSING_PROPERTIES_NULL});
        IConvSerdes myDeser = CONV.jsonSerDes(ROOT.class, (IConvFormatOptions)new ConvStdFormatters(opts, JsonKeySubsitutes.KEY_SUB_COMPLEX));
        ROOT newObj = (ROOT)((Object)myDeser.deser(json_codes));
        ROOT_BoolStatus operand = ((Servlet)((Object)ListSequence.fromList(newObj.getWeb_app().getServlet()).first())).getInit_param().getUseJSP();
        if (!SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)operand, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{ROOT_BoolStatus.FALSE})) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize complex ROOT - also checking for boolean.':  newObj .web_app.servlet.first.init_param.useJSP of false           ==>>" + operand + "\n");
        }
        operand = ((Servlet)((Object)ListSequence.fromList(newObj.getWeb_app().getServlet()).first())).getInit_param().getBetaServer();
        if (!SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)operand, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{ROOT_BoolStatus.TRUE})) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize complex ROOT - also checking for boolean.':  newObj .web_app.servlet.first.init_param.betaServer of true           ==>>" + operand + "\n");
        }
    }

    @OFXTestMethod(id=17, name="Deserialize a list of 1000 object for performance checks.", debug=false, enabled=true, runAt="")
    public void __testmethod_17(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        int rightSide2;
        ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", new IConvFormatOptions.Mode[]{IConvFormatOptions.Mode.SET_MISSING_PROPERTIES_NULL});
        long startTime2 = System.currentTimeMillis();
        Object json_adopted = "[";
        for (int i = 0; i < 1000; ++i) {
            json_adopted = (String)json_adopted + this.jSonTxt + ", ";
        }
        json_adopted = (String)json_adopted + this.jSonTxt + "]";
        long diffMsCreation = System.currentTimeMillis() - startTime2;
        long startTime3 = System.currentTimeMillis();
        IConvSerdes myDeser = CONV.jsonSerDes(Text[].class, (IConvFormatOptions)new ConvStdFormatters(opts));
        long diffMsSerializer = System.currentTimeMillis() - startTime3;
        long startTime = System.currentTimeMillis();
        Text[] newObjList = (Text[])myDeser.deser((String)json_adopted);
        int leftSide = newObjList.length;
        if (leftSide != (rightSide2 = 1001)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of 1000 object for performance checks.':  newObjList .length == 1001          ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        long diffMs = System.currentTimeMillis() - startTime;
        long leftSide2 = diffMs;
        if (leftSide2 >= (long)(rightSide = 400)) {
            throw new OFXTestSuitException("'JSonDeserialization.Deserialize a list of 1000 object for performance checks.':  diffMs  < 400          ==>>" + leftSide2 + " <" + rightSide + "\n");
        }
    }

    public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
    }

    public static void main(String[] args) {
        String[] allIncludedTest = new String[]{};
        String[] includedTestToRun = new String[]{};
        OFXTestSuit.runAsMain((String)"org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", JSonDeserialization.class, (String[])allIncludedTest, (String[])includedTestToRun);
    }
}

