/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.tests.ConvSerdes;

import java.math.BigDecimal;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.references.BLOperations;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;
import org.modellwerkstatt.objectflow.serdes.CONV;
import org.modellwerkstatt.objectflow.serdes.ConvFormatOptions;
import org.modellwerkstatt.objectflow.serdes.ConvStdFormatters;
import org.modellwerkstatt.objectflow.serdes.IConvFormatOptions;
import org.modellwerkstatt.objectflow.serdes.IConvSerdes;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.Artikel;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.Gebinde;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.JsonRootFactory;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.MyArtikelSerdes;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.MyE;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.MyEChild;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.Preis;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.SingleMyE;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.SingleMyVO;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.Text;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.TextChild;
import org.modellwerkstatt.objectflow.tests.ConvSerdes.Text_MySatus;
import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;

public class XmlSerDeserialization
extends OFXTestSuit {
    @Autowired
    private JsonRootFactory __ConvSerdesJsonRootFactory;
    @Autowired
    private IOFXPlatform __runtimeIOFXPlatform;
    @Autowired
    private IOFXTranslationProvider __runtimeIOFXTranslationProvider;

    public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
    }

    @OFXTestMethod(id=0, name="Serialize and check various types here..", debug=false, enabled=true, runAt="")
    public void __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", new IConvFormatOptions.Mode[]{IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY});
        IConvSerdes myDeser = CONV.xmlSerDes(Text.class, (IConvFormatOptions)new ConvStdFormatters(opts));
        Text origObj = this.__ConvSerdesJsonRootFactory.create(__manMapSession);
        BLOperations.plusAssign(origObj.refToStringValue(), (Object)" & <Dan>");
        String st = myDeser.ser((Object)origObj);
        Text reconstructed = (Text)((Object)myDeser.deser(st));
        int leftSide = reconstructed.getIntValue();
        int rightSide = origObj.getIntValue();
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize and check various types here..':  reconstructed .intValue ==  origObj .intValue          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        Object leftSide2 = reconstructed.getBdValue();
        if (((BigDecimal)leftSide2).compareTo((BigDecimal)(rightSide = origObj.getBdValue())) != 0) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize and check various types here..':  reconstructed .bdValue ==  origObj .bdValue          ==>>" + (BigDecimal)leftSide2 + " ==" + (BigDecimal)rightSide + "\n");
        }
        leftSide2 = reconstructed.getStringValue();
        if (!SaveObjectComperator.equals((Object)leftSide2, (Object)(rightSide = origObj.getStringValue()))) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize and check various types here..':  reconstructed .stringValue ==  origObj .stringValue          ==>>" + (String)leftSide2 + " ==" + (String)rightSide + "\n");
        }
        leftSide = reconstructed.getLocalDateValue().compareTo((ReadablePartial)origObj.getLocalDateValue());
        if (leftSide != (rightSide = 0)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize and check various types here..':  reconstructed .localDateValue.compareTo( origObj .localDateValue) == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = reconstructed.getDateTimeValue().compareTo((ReadableInstant)origObj.getDateTimeValue());
        if (leftSide != (rightSide = 0)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize and check various types here..':  reconstructed .dateTimeValue.compareTo( origObj .dateTimeValue) == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        Text_MySatus leftSide3 = reconstructed.getStatusValue();
        if (leftSide3 != (rightSide = origObj.getStatusValue())) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize and check various types here..':  reconstructed .statusValue ==  origObj .statusValue          ==>>" + leftSide3 + " ==" + rightSide + "\n");
        }
        leftSide = reconstructed.getTextChild().getIntValue();
        if (leftSide != (rightSide = 0)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize and check various types here..':  reconstructed .textChild.intValue == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        BigDecimal leftSide4 = reconstructed.getTextChild().getBdValue();
        if (leftSide4.compareTo(rightSide = new BigDecimal("47.11")) != 0) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize and check various types here..':  reconstructed .textChild.bdValue == 47.11bd          ==>>" + leftSide4 + " ==" + rightSide + "\n");
        }
        Text_MySatus operand = reconstructed.getTextChild().getStatusValue();
        if (!SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)operand, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{Text_MySatus.S1})) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize and check various types here..':  reconstructed .textChild.statusValue of S1           ==>>" + operand + "\n");
        }
        leftSide = ListSequence.fromList(reconstructed.getMultipleChilds()).count();
        if (leftSide != (rightSide = ListSequence.fromList(reconstructed.getMultipleChilds()).count())) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize and check various types here..':  reconstructed .multipleChilds.size ==  reconstructed .multipleChilds.size          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=1, name="Serialize null fields to xml correctly ......", debug=false, enabled=true, runAt="")
    public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        Object rightSide2;
        int rightSide3;
        ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", new IConvFormatOptions.Mode[]{IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY});
        IConvSerdes myDeser = CONV.xmlSerDes(Text.class, (IConvFormatOptions)new ConvStdFormatters(opts));
        Text obj = new Text();
        obj.setIntValue(0);
        obj.setStringValue(null);
        obj.setBdValue(null);
        obj.setLocalDateValue(null);
        obj.setDateTimeValue(null);
        obj.setStatusValue(null);
        obj.setTextChild(null);
        obj.setMultipleChilds(null);
        String xml = myDeser.ser((Object)obj);
        String st = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><Text><intValue>0</intValue><stringValue/><bdValue/><localDateValue/><dateTimeValue/><statusValue/><textChild/><multipleChilds/></Text>";
        String operand = xml.replace("\n", "");
        String param0 = st.replace("\n", "");
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize null fields to xml correctly ......':  xml .replace(\"\n\", \"\").equals( st .replace(\"\n\", \"\"))          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
        Text reconstructed = (Text)((Object)myDeser.deser(st));
        int leftSide = reconstructed.getIntValue();
        if (leftSide != (rightSide3 = 0)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize null fields to xml correctly ......':  reconstructed .intValue == 0          ==>>" + leftSide + " ==" + rightSide3 + "\n");
        }
        Object operand2 = reconstructed.getStringValue();
        String param02 = "";
        StringBuilder textRepresentation2 = new StringBuilder();
        textRepresentation2.append(param02 + ", ");
        textRepresentation2.setLength(textRepresentation2.length() - 2);
        if (!((String)operand2).equals(param02)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize null fields to xml correctly ......':  reconstructed .stringValue.equals(\"\")          ==>> '" + (String)operand2 + "'.equals(" + textRepresentation2 + ") \n");
        }
        Object leftSide2 = reconstructed.getBdValue();
        if (leftSide2 != (rightSide2 = null)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize null fields to xml correctly ......':  reconstructed .bdValue ==  null           ==>>" + leftSide2 + " ==" + rightSide2 + "\n");
        }
        leftSide2 = reconstructed.getLocalDateValue();
        if (leftSide2 != (rightSide2 = null)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize null fields to xml correctly ......':  reconstructed .localDateValue ==  null           ==>>" + (LocalDate)leftSide2 + " ==" + rightSide2 + "\n");
        }
        leftSide2 = reconstructed.getDateTimeValue();
        if (leftSide2 != (rightSide2 = null)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize null fields to xml correctly ......':  reconstructed .dateTimeValue ==  null           ==>>" + (DateTime)leftSide2 + " ==" + rightSide2 + "\n");
        }
        operand2 = reconstructed.getStatusValue();
        if (!SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)operand2, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{Text_MySatus.S3})) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize null fields to xml correctly ......':  reconstructed .statusValue of S3           ==>>" + (IOFXMetaStatus.IOFXStatusElement)operand2 + "\n");
        }
        leftSide2 = reconstructed.getTextChild();
        if (leftSide2 != (rightSide2 = null)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize null fields to xml correctly ......':  reconstructed .textChild ==  null           ==>>" + (TextChild)((Object)leftSide2) + " ==" + rightSide2 + "\n");
        }
        leftSide = ListSequence.fromList(reconstructed.getMultipleChilds()).count();
        if (leftSide != (rightSide = 0)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize null fields to xml correctly ......':  reconstructed .multipleChilds.size == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=2, name="Just trying to serialize an entity with valueObject", debug=false, enabled=true, runAt="")
    public void __testmethod_2(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        int rightSide2;
        ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", new IConvFormatOptions.Mode[]{IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY});
        IConvSerdes myDeser = CONV.xmlSerDes(MyE.class, (IConvFormatOptions)new ConvStdFormatters(opts));
        MyE origObj = this.__ConvSerdesJsonRootFactory.createEntity(__manMapSession);
        String st = myDeser.ser((Object)origObj);
        String result = "<vo2><MyVO><myIntVal>4713</myIntVal><myStringVal>4713</myStringVal></MyVO></vo2><childs><MyEChild><id>7</id><name>Entity Child</name><parentKEY>4711</parentKEY></MyEChild></childs>";
        String operand = st.replace("\n", "");
        String param0 = result;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.contains(param0)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Just trying to serialize an entity with valueObject':  st .replace(\"\n\", \"\").contains( result )          ==>> '" + operand + "'.contains(" + textRepresentation + ") \n");
        }
        MyE reconstructed = (MyE)((Object)myDeser.deser(st));
        int leftSide = reconstructed.getVo1().getMyIntVal();
        if (leftSide != (rightSide2 = 4712)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Just trying to serialize an entity with valueObject':  reconstructed .vo1.myIntVal == 4712          ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        leftSide = reconstructed.getVo2().getMyIntVal();
        if (leftSide != (rightSide2 = 4713)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Just trying to serialize an entity with valueObject':  reconstructed .vo2.myIntVal == 4713          ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        String operand2 = reconstructed.getVo1().getMyStringVal();
        String param02 = "4712";
        StringBuilder textRepresentation2 = new StringBuilder();
        textRepresentation2.append(param02 + ", ");
        textRepresentation2.setLength(textRepresentation2.length() - 2);
        if (!operand2.equals(param02)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Just trying to serialize an entity with valueObject':  reconstructed .vo1.myStringVal.equals(\"4712\")          ==>> '" + operand2 + "'.equals(" + textRepresentation2 + ") \n");
        }
        operand2 = reconstructed.getVo2().getMyStringVal();
        param02 = "4713";
        textRepresentation2 = new StringBuilder();
        textRepresentation2.append(param02 + ", ");
        textRepresentation2.setLength(textRepresentation2.length() - 2);
        if (!operand2.equals(param02)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Just trying to serialize an entity with valueObject':  reconstructed .vo2.myStringVal.equals(\"4713\")          ==>> '" + operand2 + "'.equals(" + textRepresentation2 + ") \n");
        }
        leftSide = ListSequence.fromList(reconstructed.getChilds()).count();
        if (leftSide != (rightSide = 1)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Just trying to serialize an entity with valueObject':  reconstructed .childs.size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        operand = ((MyEChild)((Object)ListSequence.fromList(reconstructed.getChilds()).getElement(0))).getName();
        param0 = "Entity Child";
        textRepresentation2 = new StringBuilder();
        textRepresentation2.append(param0 + ", ");
        textRepresentation2.setLength(textRepresentation2.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Just trying to serialize an entity with valueObject':  reconstructed .childs.get.name.equals(\"Entity Child\")          ==>> '" + operand + "'.equals(" + textRepresentation2 + ") \n");
        }
    }

    @OFXTestMethod(id=3, name="Serialize a list of DTOs into a string.", debug=false, enabled=true, runAt="")
    public void __testmethod_3(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        int rightSide2;
        ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "en", new IConvFormatOptions.Mode[]{IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY});
        IConvSerdes myDeser = CONV.xmlSerDes(Text[].class, (IConvFormatOptions)new ConvStdFormatters(opts));
        Text textObj = this.__ConvSerdesJsonRootFactory.create(__manMapSession);
        Text textObj2 = this.__ConvSerdesJsonRootFactory.create(__manMapSession);
        Text[] textArray = new Text[]{textObj, textObj2};
        String st = myDeser.ser((Object)textArray);
        String operand = st.replace("\n", "");
        String param0 = "</Text></TextList>";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.endsWith(param0)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize a list of DTOs into a string.':  st .replace(\"\n\", \"null\").endsWith(\"</Text></TextList>\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") \n");
        }
        Text[] reconstructed = (Text[])myDeser.deser(st);
        int leftSide = reconstructed.length;
        if (leftSide != (rightSide2 = 2)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize a list of DTOs into a string.':  reconstructed .length == 2          ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        String operand2 = reconstructed[0].getStringValue();
        String param02 = "Test String";
        StringBuilder textRepresentation2 = new StringBuilder();
        textRepresentation2.append(param02 + ", ");
        textRepresentation2.setLength(textRepresentation2.length() - 2);
        if (!operand2.equals(param02)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize a list of DTOs into a string.':  [ .stringValue.equals(\"Test String\")          ==>> '" + operand2 + "'.equals(" + textRepresentation2 + ") \n");
        }
        operand2 = reconstructed[1].getStringValue();
        param02 = "Test String";
        textRepresentation2 = new StringBuilder();
        textRepresentation2.append(param02 + ", ");
        textRepresentation2.setLength(textRepresentation2.length() - 2);
        if (!operand2.equals(param02)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize a list of DTOs into a string.':  [ .stringValue.equals(\"Test String\")          ==>> '" + operand2 + "'.equals(" + textRepresentation2 + ") \n");
        }
        operand2 = reconstructed[0].getTextChild().getStringValue();
        param02 = "Test String in Text Child";
        textRepresentation2 = new StringBuilder();
        textRepresentation2.append(param02 + ", ");
        textRepresentation2.setLength(textRepresentation2.length() - 2);
        if (!operand2.equals(param02)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize a list of DTOs into a string.':  [ .textChild.stringValue.equals(\"Test String in Text Child\")          ==>> '" + operand2 + "'.equals(" + textRepresentation2 + ") \n");
        }
        operand2 = reconstructed[1].getTextChild().getStringValue();
        param02 = "Test String in Text Child";
        textRepresentation2 = new StringBuilder();
        textRepresentation2.append(param02 + ", ");
        textRepresentation2.setLength(textRepresentation2.length() - 2);
        if (!operand2.equals(param02)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize a list of DTOs into a string.':  [ .textChild.stringValue.equals(\"Test String in Text Child\")          ==>> '" + operand2 + "'.equals(" + textRepresentation2 + ") \n");
        }
        leftSide = ListSequence.fromList(reconstructed[0].getMultipleChilds()).count();
        if (leftSide != (rightSide = 2)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize a list of DTOs into a string.':  [ .multipleChilds.size == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = ListSequence.fromList(reconstructed[1].getMultipleChilds()).count();
        if (leftSide != (rightSide = 2)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize a list of DTOs into a string.':  [ .multipleChilds.size == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=4, name="Deserialize some oracle xml export ... ", debug=false, enabled=true, runAt="")
    public void __testmethod_4(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        BigDecimal rightSide2;
        String st = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><artikel NUM_ARTIKEL=\"\">   <num_artikel>109076</num_artikel>   <bezeichnung>Red Bull Silver Edition 250 ml</bezeichnung>   <inhalt>1</inhalt>   <preise>      <preis>         <prz_steuer>20</prz_steuer>         <cod_whrg>EUR</cod_whrg>         <vk>            <brutto>1,59</brutto>            <netto>1,325</netto>            <typ>V1NO</typ>            <referenz>3361762</referenz>         </vk>         <ek>            <netto>,9554</netto>            <typ>E1NO</typ>            <referenz>4616371</referenz>         </ek>      </preis>   </preise>   <gebinde_liste>      <gebinde NUM_GEBINDE=\"0\">         <num_geb_inh>0</num_geb_inh>         <typ_einheit>9</typ_einheit>         <mge_inh>0</mge_inh>         <num_art_lg>0</num_art_lg>         <ean_bestellung>9002490218225</ean_bestellung>      </gebinde>      <gebinde NUM_GEBINDE=\"1\">         <num_geb_inh>0</num_geb_inh>         <typ_einheit>5</typ_einheit>         <mge_inh>24</mge_inh>         <num_art_lg>0</num_art_lg>         <ean_bestellung>9002490218379</ean_bestellung>      </gebinde>   </gebinde_liste></artikel>";
        ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "de", new IConvFormatOptions.Mode[]{IConvFormatOptions.Mode.SET_MISSING_PROPERTIES_NULL});
        IConvSerdes myDeser = CONV.xmlSerDes(Artikel.class, (IConvFormatOptions)new ConvStdFormatters(opts));
        Artikel wolfiXmlExp = (Artikel)((Object)myDeser.deser(st));
        BigDecimal leftSide = ((Preis)((Object)ListSequence.fromList(wolfiXmlExp.getPreise()).getElement(0))).getVk().getBrutto();
        if (leftSide.compareTo(rightSide2 = new BigDecimal("1.59")) != 0) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Deserialize some oracle xml export ... ':  wolfiXmlExp .preise.get.vk.brutto == 1.59bd          ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        leftSide = ((Preis)((Object)ListSequence.fromList(wolfiXmlExp.getPreise()).getElement(0))).getEk().getBrutto();
        if (leftSide != (rightSide2 = null)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Deserialize some oracle xml export ... ':  wolfiXmlExp .preise.get.ek.brutto ==  null           ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        int leftSide2 = ListSequence.fromList(wolfiXmlExp.getGebinde_liste()).count();
        if (leftSide2 != (rightSide = 2)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Deserialize some oracle xml export ... ':  wolfiXmlExp .gebinde_liste.size == 2          ==>>" + leftSide2 + " ==" + rightSide + "\n");
        }
        String operand = ((Gebinde)((Object)ListSequence.fromList(wolfiXmlExp.getGebinde_liste()).getElement(1))).getEan_bestellung();
        String param0 = "9002490218379";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Deserialize some oracle xml export ... ':  wolfiXmlExp .gebinde_liste.get.ean_bestellung.equals(\"9002490218379\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=5, name="Custom serialization, using an attribute for ids", debug=false, enabled=true, runAt="")
    public void __testmethod_5(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        BigDecimal rightSide2;
        int rightSide3;
        String st = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><artikel NUM_ARTIKEL=\"109076\">   <bezeichnung>Red Bull Silver Edition 250 ml</bezeichnung>   <inhalt>1</inhalt>   <preise>      <preis>         <prz_steuer>20</prz_steuer>         <cod_whrg>EUR</cod_whrg>         <vk>            <brutto>1,59</brutto>            <netto>1,325</netto>            <typ>V1NO</typ>            <referenz>3361762</referenz>         </vk>         <ek>            <netto>,9554</netto>            <typ>E1NO</typ>            <referenz>4616371</referenz>         </ek>      </preis>   </preise>   <gebinde_liste>      <gebinde NUM_GEBINDE=\"0\">         <num_geb_inh>0</num_geb_inh>         <typ_einheit>9</typ_einheit>         <mge_inh>0</mge_inh>         <num_art_lg>0</num_art_lg>         <ean_bestellung>9002490218225</ean_bestellung>      </gebinde>      <gebinde NUM_GEBINDE=\"1\">         <num_geb_inh>0</num_geb_inh>         <typ_einheit>5</typ_einheit>         <mge_inh>24</mge_inh>         <num_art_lg>0</num_art_lg>         <ean_bestellung>9002490218379</ean_bestellung>      </gebinde>   </gebinde_liste></artikel>";
        ConvFormatOptions opts = new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#,##0.00", "de", new IConvFormatOptions.Mode[]{IConvFormatOptions.Mode.SET_MISSING_PROPERTIES_NULL});
        MyArtikelSerdes myDeser = new MyArtikelSerdes((IConvFormatOptions)new ConvStdFormatters(opts));
        Artikel wolfiXmlExp = (Artikel)((Object)myDeser.deser(st));
        int leftSide = wolfiXmlExp.getNum_artikel();
        if (leftSide != (rightSide3 = 109076)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Custom serialization, using an attribute for ids':  wolfiXmlExp .num_artikel == 109076          ==>>" + leftSide + " ==" + rightSide3 + "\n");
        }
        BigDecimal leftSide2 = ((Preis)((Object)ListSequence.fromList(wolfiXmlExp.getPreise()).getElement(0))).getVk().getBrutto();
        if (leftSide2.compareTo(rightSide2 = new BigDecimal("1.59")) != 0) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Custom serialization, using an attribute for ids':  wolfiXmlExp .preise.get.vk.brutto == 1.59bd          ==>>" + leftSide2 + " ==" + rightSide2 + "\n");
        }
        leftSide2 = ((Preis)((Object)ListSequence.fromList(wolfiXmlExp.getPreise()).getElement(0))).getEk().getBrutto();
        if (leftSide2 != (rightSide2 = null)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Custom serialization, using an attribute for ids':  wolfiXmlExp .preise.get.ek.brutto ==  null           ==>>" + leftSide2 + " ==" + rightSide2 + "\n");
        }
        leftSide = ListSequence.fromList(wolfiXmlExp.getGebinde_liste()).count();
        if (leftSide != (rightSide = 2)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Custom serialization, using an attribute for ids':  wolfiXmlExp .gebinde_liste.size == 2          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        String operand = ((Gebinde)((Object)ListSequence.fromList(wolfiXmlExp.getGebinde_liste()).getElement(1))).getEan_bestellung();
        String param0 = "9002490218379";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Custom serialization, using an attribute for ids':  wolfiXmlExp .gebinde_liste.get.ean_bestellung.equals(\"9002490218379\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=6, name="Serialize / Deserialive single field value object", debug=false, enabled=true, runAt="")
    public void __testmethod_6(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        SingleMyE entity = new SingleMyE();
        entity.setText("textcontent");
        entity.setVo1(new SingleMyVO().withMyVal("4711"));
        entity.setVo2(null);
        IConvSerdes serdes = CONV.xmlSerDes(SingleMyE.class, (IConvFormatOptions)CONV.CONV_DEFAULT_EN);
        String st = serdes.ser((Object)entity);
        SingleMyE reloaded = (SingleMyE)((Object)serdes.deser(st));
        String operand = reloaded.getVo1().getMyVal();
        String param0 = "4711";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'XmlSerDeserialization.Serialize / Deserialive single field value object':  reloaded .vo1.myVal.equals(\"4711\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
    }

    public static void main(String[] args) {
        String[] allIncludedTest = new String[]{};
        String[] includedTestToRun = new String[]{};
        OFXTestSuit.runAsMain((String)"org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", XmlSerDeserialization.class, (String[])allIncludedTest, (String[])includedTestToRun);
    }
}

