/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.tests.ObjectFlowInfra;

import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.references.BLOperations;
import org.modellwerkstatt.objectflow.runtime.IOFXEntity;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.MoRevertibleMerger;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.runtime.OFXEntity;
import org.modellwerkstatt.objectflow.runtime.OFXIllegalAccessException;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.CreatorsFactory;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Invoice;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.InvoicePosition;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.NewInvoice;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoInvoice;
import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;

public class SessionAndMerge
extends OFXTestSuit {
    @Autowired
    private CreatorsFactory __DomainCreatorsFactory;
    @Autowired
    private RepoInvoice __DomainRepoInvoice;
    @Autowired
    private IOFXPlatform __runtimeIOFXPlatform;
    @Autowired
    private IOFXTranslationProvider __runtimeIOFXTranslationProvider;

    public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
    }

    @OFXTestMethod(id=0, name="SessionEntities Test Checkout / RO marked", debug=false, enabled=true, runAt="")
    public void __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Object rightSide;
        int rightSide2;
        int i;
        for (i = 1; i < 100000; ++i) {
            Invoice inv = new Invoice();
            inv.setId(i);
            inv.setText("Invoice " + i);
            inv.setReadOnly(true);
            __manMapSession.ensureInSession((Object)inv);
        }
        for (i = 1; i < 100000; ++i) {
            NewInvoice ni = new NewInvoice();
            ni.setId(i);
            ni.setText("NewInvoice " + i);
            __manMapSession.ensureInSession((Object)ni);
        }
        int leftSide = ListSequence.fromList((List)__manMapSession.getEntitiesCheckedOut(Invoice.entitySessionUID)).count();
        if (leftSide != (rightSide2 = 0)) {
            throw new OFXTestSuitException("'SessionAndMerge.SessionEntities Test Checkout / RO marked':  session entities .size == 0          ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        leftSide = ListSequence.fromList((List)__manMapSession.getEntitiesCheckedOutKey(Invoice.entitySessionUID)).count();
        if (leftSide != (rightSide2 = 0)) {
            throw new OFXTestSuitException("'SessionAndMerge.SessionEntities Test Checkout / RO marked':  session entities .size == 0          ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        leftSide = ListSequence.fromList((List)__manMapSession.getEntitiesAll(Invoice.entitySessionUID)).count();
        if (leftSide != (rightSide2 = 99999)) {
            throw new OFXTestSuitException("'SessionAndMerge.SessionEntities Test Checkout / RO marked':  session entities .size == 99999          ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        leftSide = ListSequence.fromList((List)__manMapSession.getEntitiesAllKey(Invoice.entitySessionUID)).count();
        if (leftSide != (rightSide2 = 99999)) {
            throw new OFXTestSuitException("'SessionAndMerge.SessionEntities Test Checkout / RO marked':  session entities .size == 99999          ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        leftSide = ListSequence.fromList((List)__manMapSession.getEntitiesCheckedOut(NewInvoice.entitySessionUID)).count();
        if (leftSide != (rightSide2 = 99999)) {
            throw new OFXTestSuitException("'SessionAndMerge.SessionEntities Test Checkout / RO marked':  session entities .size == 99999          ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        leftSide = ListSequence.fromList((List)__manMapSession.getEntitiesCheckedOutKey(NewInvoice.entitySessionUID)).count();
        if (leftSide != (rightSide2 = 99999)) {
            throw new OFXTestSuitException("'SessionAndMerge.SessionEntities Test Checkout / RO marked':  session entities .size == 99999          ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        long t = System.currentTimeMillis();
        Invoice lookingFor = (Invoice)((Object)ListSequence.fromList((List)__manMapSession.getEntitiesAll(Invoice.entitySessionUID)).findFirst(it -> it.getId() == 99997));
        Invoice leftSide2 = lookingFor;
        if (leftSide2 == (rightSide = null)) {
            throw new OFXTestSuitException("'SessionAndMerge.SessionEntities Test Checkout / RO marked':  lookingFor  !=  null           ==>>" + leftSide2 + " !=" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=1, name="Use of concept sessionEntities", debug=false, enabled=true, runAt="")
    public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        int rightSide2;
        IOFXSession sess = this.__DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
        Invoice invoice1 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("sesEnt-1", sess);
        Invoice invoice2 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB("sesEnt-2", sess);
        Invoice reloaded_inv1 = this.__DomainRepoInvoice.checkoutInvoiceByIdWithRefs(invoice1.getId(), __manMapSession);
        Invoice reloaded_inv2 = this.__DomainRepoInvoice.checkoutInvoiceByIdWithRefs(invoice2.getId(), __manMapSession);
        List invoicesCheckedOut = __manMapSession.getEntitiesCheckedOut(Invoice.entitySessionUID);
        int leftSide = ListSequence.fromList((List)invoicesCheckedOut).count();
        if (leftSide != (rightSide2 = 2)) {
            throw new OFXTestSuitException("'SessionAndMerge.Use of concept sessionEntities':  invoicesCheckedOut .size == 2          ==>>" + leftSide + " ==" + rightSide2 + "\n");
        }
        if (!ListSequence.fromList((List)invoicesCheckedOut).any(it -> it.getId() == reloaded_inv1.getId())) {
            throw new OFXTestSuitException("'SessionAndMerge.Use of concept sessionEntities':  invoicesCheckedOut .any          ==>> FALSE !\n");
        }
        if (!ListSequence.fromList((List)invoicesCheckedOut).any(it -> it.getId() == reloaded_inv2.getId())) {
            throw new OFXTestSuitException("'SessionAndMerge.Use of concept sessionEntities':  invoicesCheckedOut .any          ==>> FALSE !\n");
        }
        List keysOfInv = __manMapSession.getEntitiesCheckedOutKey(Invoice.entitySessionUID);
        int leftSide2 = ListSequence.fromList((List)keysOfInv).count();
        if (leftSide2 != (rightSide = 2)) {
            throw new OFXTestSuitException("'SessionAndMerge.Use of concept sessionEntities':  keysOfInv .size == 2          ==>>" + leftSide2 + " ==" + rightSide + "\n");
        }
        if (!ListSequence.fromList((List)keysOfInv).any(it -> it.intValue() == reloaded_inv1.getId())) {
            throw new OFXTestSuitException("'SessionAndMerge.Use of concept sessionEntities':  keysOfInv .any          ==>> FALSE !\n");
        }
        if (!ListSequence.fromList((List)keysOfInv).any(it -> it.intValue() == reloaded_inv2.getId())) {
            throw new OFXTestSuitException("'SessionAndMerge.Use of concept sessionEntities':  keysOfInv .any          ==>> FALSE !\n");
        }
    }

    @OFXTestMethod(id=2, name="Using Merge - entity into entity merged into session", debug=false, enabled=true, runAt="")
    public void __testmethod_2(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        IOFXSession sess = this.__DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
        Invoice orig = this.__DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("ee-merge-1", sess);
        Invoice mergedInvoice = (Invoice)MoRevertibleMerger.mergeEntityIntoEntity(Invoice.class, (IOFXEntity)orig, (IOFXEntity)new Invoice(), (IOFXSession)__manMapSession, (boolean)false);
        boolean leftSide = mergedInvoice.getName().equals("ee-merge-1");
        boolean bl = mergedInvoice != orig;
        leftSide = ListSequence.fromList((List)__manMapSession.getEntitiesAll(Invoice.entitySessionUID)).count() == 1;
        bl = ListSequence.fromList((List)__manMapSession.getEntitiesAll(Invoice.entitySessionUID)).first() == mergedInvoice;
    }

    @OFXTestMethod(id=3, name="Using Merge - entity into entity merged into session - [Read Only Error]", debug=false, enabled=true, runAt="")
    public void __testmethod_3(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        block12: {
            IOFXSession sess = this.__DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
            Invoice orig = this.__DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("ee-merge-1", sess);
            boolean __FailIn_catched = false;
            boolean __FailIn_text = true;
            IllegalStateException __FailIn_origThrowable = null;
            Object messagesInProblems = "";
            try {
                Invoice invoice = (Invoice)MoRevertibleMerger.mergeEntityIntoEntity(Invoice.class, (IOFXEntity)orig, (IOFXEntity)new Invoice(), (IOFXSession)__manMapSession, (boolean)true);
            }
            catch (IllegalStateException ex) {
                __FailIn_origThrowable = ex;
                __FailIn_catched = true;
                messagesInProblems = ex.getMessage();
                __FailIn_text = false;
                if (messagesInProblems == null) {
                    messagesInProblems = "";
                }
                if (((String)messagesInProblems).contains("checkedout")) {
                    __FailIn_text = true;
                }
                messagesInProblems = (String)messagesInProblems + "\n";
                List allProblems = __manMapSession.getAndclearProblemState();
                for (IOFXProblem problem : allProblems) {
                    messagesInProblems = (String)messagesInProblems + problem.getSimpleUserText() + "\n";
                    if (!problem.getSimpleUserText().contains("checkedout")) continue;
                    __FailIn_text = true;
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                if (!__FailIn_catched && __FailIn_origThrowable == null) {
                    throw new OFXTestSuitException("'SessionAndMerge.Using Merge - entity into entity merged into session - [Read Only Error]': Fail In Exception IllegalStateException was NOT catched!");
                }
                if (__FailIn_catched && !__FailIn_text) {
                    throw new OFXTestSuitException("'SessionAndMerge.Using Merge - entity into entity merged into session - [Read Only Error]': Fail In Exception IllegalStateException catched but text not correct! Got instead: \n" + (String)messagesInProblems + " \n");
                }
                if (__FailIn_catched) break block12;
                throw new OFXTestSuitException("'SessionAndMerge.Using Merge - entity into entity merged into session - [Read Only Error]': Fail In Exception 'IllegalStateException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
            }
        }
    }

    @OFXTestMethod(id=4, name="Using Merge - situation in a search command.. ", debug=false, enabled=true, runAt="")
    public void __testmethod_4(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Invoice mergedInvoice;
        IListSequence resultList;
        Invoice invoice1;
        block14: {
            IOFXSession sess = this.__DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
            invoice1 = this.__DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("srchmerge-1", sess);
            Invoice invoice2 = this.__DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("srchmerge-2", sess);
            Invoice reloaded_inv1 = this.__DomainRepoInvoice.getInvoiceByIdWithRefs(invoice1.getId(), __manMapSession);
            Invoice reloaded_inv2 = this.__DomainRepoInvoice.getInvoiceByIdWithRefs(invoice2.getId(), __manMapSession);
            resultList = ListSequence.fromListAndArray(new ArrayList(), (Object[])new Invoice[]{reloaded_inv1, reloaded_inv2});
            boolean leftSide = reloaded_inv1.getMainPosRef() != null;
            boolean bl = reloaded_inv1.getMainPosRef().getId() == invoice1.getMainPosRef().getId();
            invoice1.setText("head_changed");
            invoice1.getMainPosRef().setPosText("pos_changed");
            mergedInvoice = (Invoice)MoRevertibleMerger.mergeEntityIntoList(Invoice.class, (IOFXEntity)invoice1, (List)resultList, (IOFXSession)__manMapSession, (boolean)true);
            MoRevertibleMerger.mergeRefOnRef(InvoicePosition.class, (IOFXEntity)invoice1.getMainPosRef(), (IOFXSession)__manMapSession, (boolean)true, (MoRevertibleMerger.RefChange)new MoRevertibleMerger.RefChange<Invoice, InvoicePosition>(){

                public void doChange(Invoice destEntity, InvoicePosition destRef) {
                    boolean isDestReadOnly = destEntity.getReadOnly();
                    destEntity.setReadOnly(false);
                    destEntity.setMainPosRef(destRef);
                    destEntity.setReadOnly(isDestReadOnly);
                }
            }, (IOFXEntity)mergedInvoice);
            InvoicePosition leftSide2 = mergedInvoice.getMainPosRef();
            Object rightSide = null;
            if (leftSide2 == rightSide) {
                throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command.. ':  mergedInvoice .mainPosRef !=  null           ==>>" + leftSide2 + " !=" + rightSide + "\n");
            }
            boolean __FailIn_catched = false;
            boolean __FailIn_text = true;
            OFXIllegalAccessException __FailIn_origThrowable = null;
            String messagesInProblems = "";
            try {
                mergedInvoice.getMainPosRef().setInvoice(mergedInvoice);
            }
            catch (OFXIllegalAccessException ex) {
                __FailIn_origThrowable = ex;
                __FailIn_catched = true;
                messagesInProblems = ex.getMessage();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                if (!__FailIn_catched && __FailIn_origThrowable == null) {
                    throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command.. ': Fail In Exception OFXIllegalAccessException was NOT catched!");
                }
                if (__FailIn_catched && !__FailIn_text) {
                    throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command.. ': Fail In Exception OFXIllegalAccessException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");
                }
                if (__FailIn_catched) break block14;
                throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command.. ': Fail In Exception 'OFXIllegalAccessException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
            }
        }
        OFXEntity operand = mergedInvoice;
        StringBuilder textRepresentation = new StringBuilder();
        if (!operand.getReadOnly()) {
            throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command.. ': ((IOFXEntity) mergedInvoice ).getReadOnly()          ==>> '" + (IOFXEntity)operand + "'.getReadOnly(" + textRepresentation + ") \n");
        }
        operand = mergedInvoice.getMainPosRef();
        textRepresentation = new StringBuilder();
        if (!operand.getReadOnly()) {
            throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command.. ': ((IOFXEntity) mergedInvoice .mainPosRef).getReadOnly()          ==>> '" + (IOFXEntity)operand + "'.getReadOnly(" + textRepresentation + ") \n");
        }
        boolean leftSide = mergedInvoice.getText().equals("head_changed");
        boolean textRepresentation2 = mergedInvoice != invoice1;
        leftSide = mergedInvoice.getMainPosRef().getPosText().equals("pos_changed");
        textRepresentation2 = mergedInvoice.getMainPosRef() != invoice1.getMainPosRef();
        OFXEntity leftSide2 = mergedInvoice;
        OFXEntity rightSide = (Invoice)((Object)ListSequence.fromList((List)resultList).getElement(0));
        if (leftSide2 != rightSide) {
            throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command.. ':  mergedInvoice  ==  resultList .get          ==>>" + (Invoice)leftSide2 + " ==" + (Invoice)rightSide + "\n");
        }
        leftSide2 = mergedInvoice.getMainPosRef();
        if (leftSide2 != (rightSide = ((Invoice)((Object)ListSequence.fromList((List)resultList).getElement(0))).getMainPosRef())) {
            throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command.. ':  mergedInvoice .mainPosRef ==  resultList .get.mainPosRef          ==>>" + (InvoicePosition)leftSide2 + " ==" + (InvoicePosition)rightSide + "\n");
        }
    }

    @OFXTestMethod(id=5, name="Using Merge - integrate ref into session", debug=false, enabled=true, runAt="")
    public void __testmethod_5(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        IOFXSession sess = this.__DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
        Invoice invoice1 = this.__DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("refferr-1", sess);
        Invoice mergedInvoice = (Invoice)MoRevertibleMerger.mergeEntityIntoEntity(Invoice.class, (IOFXEntity)invoice1, (IOFXEntity)new Invoice(), (IOFXSession)__manMapSession, (boolean)false);
        MoRevertibleMerger.mergeRefOnRef(InvoicePosition.class, (IOFXEntity)invoice1.getMainPosRef(), (IOFXSession)__manMapSession, (boolean)false, (MoRevertibleMerger.RefChange)new MoRevertibleMerger.RefChange<Invoice, InvoicePosition>(){

            public void doChange(Invoice destEntity, InvoicePosition destRef) {
                boolean isDestReadOnly = destEntity.getReadOnly();
                destEntity.setReadOnly(false);
                destEntity.setMainPosRef(destRef);
                destEntity.setReadOnly(isDestReadOnly);
            }
        }, (IOFXEntity)mergedInvoice);
        Invoice leftSide = mergedInvoice.getMainPosRef().getInvoice();
        Object rightSide = null;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'SessionAndMerge.Using Merge - integrate ref into session':  mergedInvoice .mainPosRef.invoice ==  null           ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        if (mergedInvoice.getMainPosRef().getReadOnly()) {
            throw new OFXTestSuitException("'SessionAndMerge.Using Merge - integrate ref into session': !(((IOFXEntity) mergedInvoice .mainPosRef).getReadOnly())          ==>> FALSE !\n");
        }
        int leftSide2 = ListSequence.fromList((List)__manMapSession.getEntitiesCheckedOut(InvoicePosition.entitySessionUID)).count();
        if (leftSide2 != (rightSide = 1)) {
            throw new OFXTestSuitException("'SessionAndMerge.Using Merge - integrate ref into session':  session entities .size == 1          ==>>" + leftSide2 + " ==" + rightSide + "\n");
        }
        InvoicePosition leftSide3 = (InvoicePosition)((Object)ListSequence.fromList((List)__manMapSession.getEntitiesCheckedOut(InvoicePosition.entitySessionUID)).first());
        if (leftSide3 != (rightSide = mergedInvoice.getMainPosRef())) {
            throw new OFXTestSuitException("'SessionAndMerge.Using Merge - integrate ref into session':  session entities .first ==  mergedInvoice .mainPosRef          ==>>" + leftSide3 + " ==" + rightSide + "\n");
        }
        leftSide3 = mergedInvoice.getMainPosRef();
        if (leftSide3 == (rightSide = invoice1.getMainPosRef())) {
            throw new OFXTestSuitException("'SessionAndMerge.Using Merge - integrate ref into session':  mergedInvoice .mainPosRef !=  invoice1 .mainPosRef          ==>>" + leftSide3 + " !=" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=6, name="Using Merge - integrate ref into session [Read Only Error]", debug=false, enabled=true, runAt="")
    public void __testmethod_6(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        block13: {
            IOFXSession sess = this.__DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
            Invoice invoice1 = this.__DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("refferr-1", sess);
            Invoice mergedInvoice = (Invoice)MoRevertibleMerger.mergeEntityIntoEntity(Invoice.class, (IOFXEntity)invoice1, (IOFXEntity)new Invoice(), (IOFXSession)__manMapSession, (boolean)false);
            InvoicePosition pos = (InvoicePosition)MoRevertibleMerger.mergeEntityIntoEntity(InvoicePosition.class, (IOFXEntity)invoice1.getMainPosRef(), (IOFXEntity)new InvoicePosition(), (IOFXSession)__manMapSession, (boolean)false);
            MoRevertibleMerger.mergeRefOnRef(InvoicePosition.class, (IOFXEntity)invoice1.getMainPosRef(), (IOFXSession)__manMapSession, (boolean)false, (MoRevertibleMerger.RefChange)new MoRevertibleMerger.RefChange<Invoice, InvoicePosition>(){

                public void doChange(Invoice destEntity, InvoicePosition destRef) {
                    boolean isDestReadOnly = destEntity.getReadOnly();
                    destEntity.setReadOnly(false);
                    destEntity.setMainPosRef(destRef);
                    destEntity.setReadOnly(isDestReadOnly);
                }
            }, (IOFXEntity)mergedInvoice);
            InvoicePosition leftSide = mergedInvoice.getMainPosRef();
            InvoicePosition rightSide = pos;
            if (leftSide != rightSide) {
                throw new OFXTestSuitException("'SessionAndMerge.Using Merge - integrate ref into session [Read Only Error]':  mergedInvoice .mainPosRef ==  pos           ==>>" + leftSide + " ==" + rightSide + "\n");
            }
            boolean __FailIn_catched = false;
            boolean __FailIn_text = true;
            IllegalStateException __FailIn_origThrowable = null;
            Object messagesInProblems = "";
            try {
                MoRevertibleMerger.mergeRefOnRef(InvoicePosition.class, (IOFXEntity)invoice1.getMainPosRef(), (IOFXSession)__manMapSession, (boolean)true, (MoRevertibleMerger.RefChange)new MoRevertibleMerger.RefChange<Invoice, InvoicePosition>(){

                    public void doChange(Invoice destEntity, InvoicePosition destRef) {
                        boolean isDestReadOnly = destEntity.getReadOnly();
                        destEntity.setReadOnly(false);
                        destEntity.setMainPosRef(destRef);
                        destEntity.setReadOnly(isDestReadOnly);
                    }
                }, (IOFXEntity)mergedInvoice);
            }
            catch (IllegalStateException ex) {
                __FailIn_origThrowable = ex;
                __FailIn_catched = true;
                messagesInProblems = ex.getMessage();
                __FailIn_text = false;
                if (messagesInProblems == null) {
                    messagesInProblems = "";
                }
                if (((String)messagesInProblems).contains("checkedout")) {
                    __FailIn_text = true;
                }
                messagesInProblems = (String)messagesInProblems + "\n";
                List allProblems = __manMapSession.getAndclearProblemState();
                for (IOFXProblem problem : allProblems) {
                    messagesInProblems = (String)messagesInProblems + problem.getSimpleUserText() + "\n";
                    if (!problem.getSimpleUserText().contains("checkedout")) continue;
                    __FailIn_text = true;
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                if (!__FailIn_catched && __FailIn_origThrowable == null) {
                    throw new OFXTestSuitException("'SessionAndMerge.Using Merge - integrate ref into session [Read Only Error]': Fail In Exception IllegalStateException was NOT catched!");
                }
                if (__FailIn_catched && !__FailIn_text) {
                    throw new OFXTestSuitException("'SessionAndMerge.Using Merge - integrate ref into session [Read Only Error]': Fail In Exception IllegalStateException catched but text not correct! Got instead: \n" + (String)messagesInProblems + " \n");
                }
                if (__FailIn_catched) break block13;
                throw new OFXTestSuitException("'SessionAndMerge.Using Merge - integrate ref into session [Read Only Error]': Fail In Exception 'IllegalStateException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
            }
        }
    }

    @OFXTestMethod(id=7, name="Using Merge - situation in a search command (article ref changes)", debug=false, enabled=true, runAt="")
    public void __testmethod_7(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        InvoicePosition rightSide;
        IOFXSession sess = this.__DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
        Invoice invoice1 = this.__DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("srchmerge-1", sess);
        Invoice invoice2 = this.__DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("srchmerge-2", sess);
        Invoice reloaded_inv1 = this.__DomainRepoInvoice.getInvoiceByIdWithRefs(invoice1.getId(), __manMapSession);
        Invoice reloaded_inv2 = this.__DomainRepoInvoice.getInvoiceByIdWithRefs(invoice2.getId(), __manMapSession);
        IListSequence resultList = ListSequence.fromListAndArray(new ArrayList(), (Object[])new Invoice[]{reloaded_inv1, reloaded_inv2});
        int leftSide = reloaded_inv1.getMainPosRef() != null ? 1 : 0;
        boolean bl = reloaded_inv1.getMainPosRef().getId() == invoice1.getMainPosRef().getId();
        invoice1.setText("head_changed");
        invoice1.setMainPosRef((InvoicePosition)((Object)ListSequence.fromList(invoice1.getPositions()).last()));
        leftSide = invoice1.getMainPosRef().getId();
        int rightSide2 = reloaded_inv1.getMainPosRef().getId();
        if (leftSide == rightSide2) {
            throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command (article ref changes)':  invoice1 .mainPosRef.id !=  reloaded_inv1 .mainPosRef.id          ==>>" + leftSide + " !=" + rightSide2 + "\n");
        }
        Invoice mergedInvoice = (Invoice)MoRevertibleMerger.mergeEntityIntoList(Invoice.class, (IOFXEntity)invoice1, (List)resultList, (IOFXSession)__manMapSession, (boolean)true);
        MoRevertibleMerger.mergeRefOnRef(InvoicePosition.class, (IOFXEntity)invoice1.getMainPosRef(), (IOFXSession)__manMapSession, (boolean)true, (MoRevertibleMerger.RefChange)new MoRevertibleMerger.RefChange<Invoice, InvoicePosition>(){

            public void doChange(Invoice destEntity, InvoicePosition destRef) {
                boolean isDestReadOnly = destEntity.getReadOnly();
                destEntity.setReadOnly(false);
                destEntity.setMainPosRef(destRef);
                destEntity.setReadOnly(isDestReadOnly);
            }
        }, (IOFXEntity)mergedInvoice);
        OFXEntity operand = mergedInvoice;
        StringBuilder textRepresentation = new StringBuilder();
        if (!operand.getReadOnly()) {
            throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command (article ref changes)': ((IOFXEntity) mergedInvoice ).getReadOnly()          ==>> '" + (IOFXEntity)operand + "'.getReadOnly(" + textRepresentation + ") \n");
        }
        operand = mergedInvoice.getMainPosRef();
        textRepresentation = new StringBuilder();
        if (!operand.getReadOnly()) {
            throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command (article ref changes)': ((IOFXEntity) mergedInvoice .mainPosRef).getReadOnly()          ==>> '" + (IOFXEntity)operand + "'.getReadOnly(" + textRepresentation + ") \n");
        }
        boolean leftSide2 = mergedInvoice.getText().equals("head_changed");
        boolean textRepresentation2 = mergedInvoice != invoice1;
        leftSide2 = mergedInvoice.getMainPosRef().getPosText().equals("pos_changed");
        textRepresentation2 = mergedInvoice.getMainPosRef() != invoice1.getMainPosRef();
        InvoicePosition leftSide22 = mergedInvoice.getMainPosRef();
        if (leftSide22 != (rightSide = ((Invoice)((Object)ListSequence.fromList((List)resultList).getElement(0))).getMainPosRef())) {
            throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command (article ref changes)':  mergedInvoice .mainPosRef ==  resultList .get.mainPosRef          ==>>" + leftSide22 + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=8, name="Using Merge - situation in a search command (merge positions also)", debug=false, enabled=true, runAt="")
    public void __testmethod_8(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        InvoicePosition rightSide;
        IOFXSession sess = this.__DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
        Invoice invoice1 = this.__DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("srchmerge-1", sess);
        Invoice invoice2 = this.__DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("srchmerge-2", sess);
        Invoice reloaded_inv1 = this.__DomainRepoInvoice.getInvoiceByIdWithRefs(invoice1.getId(), __manMapSession);
        Invoice reloaded_inv2 = this.__DomainRepoInvoice.getInvoiceByIdWithRefs(invoice2.getId(), __manMapSession);
        IListSequence resultList = ListSequence.fromListAndArray(new ArrayList(), (Object[])new Invoice[]{reloaded_inv1, reloaded_inv2});
        boolean leftSide = reloaded_inv1.getMainPosRef() != null;
        boolean bl = reloaded_inv1.getMainPosRef().getId() == invoice1.getMainPosRef().getId();
        invoice1.setText("head_changed");
        ((InvoicePosition)((Object)ListSequence.fromList(invoice1.getPositions()).getElement(0))).setPosText("poschange0");
        ((InvoicePosition)((Object)ListSequence.fromList(invoice1.getPositions()).getElement(1))).setPosText("poschange1");
        ((InvoicePosition)((Object)ListSequence.fromList(invoice1.getPositions()).getElement(2))).setPosText("poschange2");
        ((InvoicePosition)((Object)ListSequence.fromList(invoice1.getPositions()).getElement(3))).setPosText("poschange3");
        Invoice mergedInvoice = (Invoice)MoRevertibleMerger.mergeEntityIntoList(Invoice.class, (IOFXEntity)invoice1, (List)resultList, (IOFXSession)__manMapSession, (boolean)true);
        MoRevertibleMerger.mergeListIntoList(InvoicePosition.class, invoice1.getPositions(), mergedInvoice.getPositions(), (IOFXSession)__manMapSession, (boolean)true);
        Invoice operand = mergedInvoice;
        StringBuilder textRepresentation22 = new StringBuilder();
        if (!operand.getReadOnly()) {
            throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command (merge positions also)': ((IOFXEntity) mergedInvoice ).getReadOnly()          ==>> '" + (IOFXEntity)operand + "'.getReadOnly(" + textRepresentation22 + ") \n");
        }
        boolean leftSide2 = ((Object)((Object)((InvoicePosition)((Object)ListSequence.fromList(mergedInvoice.getPositions()).getElement(1))))).equals("poschange1");
        boolean textRepresentation22 = ListSequence.fromList(mergedInvoice.getPositions()).getElement(1) != ListSequence.fromList(invoice1.getPositions()).getElement(1);
        InvoicePosition leftSide22 = mergedInvoice.getMainPosRef();
        if (leftSide22 != (rightSide = ((Invoice)((Object)ListSequence.fromList((List)resultList).getElement(0))).getMainPosRef())) {
            throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command (merge positions also)':  mergedInvoice .mainPosRef ==  resultList .get.mainPosRef          ==>>" + leftSide22 + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=9, name="Using Merge - situation in a search command (merge positions also - adding a new one!)", debug=false, enabled=true, runAt="")
    public void __testmethod_9(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        IOFXSession sess = this.__DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
        Invoice invoice1 = this.__DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("srchmerge-1", sess);
        Invoice invoice2 = this.__DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("srchmerge-2", sess);
        Invoice reloaded_inv1 = this.__DomainRepoInvoice.getInvoiceByIdWithRefs(invoice1.getId(), __manMapSession);
        Invoice reloaded_inv2 = this.__DomainRepoInvoice.getInvoiceByIdWithRefs(invoice2.getId(), __manMapSession);
        IListSequence resultList = ListSequence.fromListAndArray(new ArrayList(), (Object[])new Invoice[]{reloaded_inv1, reloaded_inv2});
        boolean leftSide = reloaded_inv1.getMainPosRef() != null;
        boolean bl = reloaded_inv1.getMainPosRef().getId() == invoice1.getMainPosRef().getId();
        ListSequence.fromList(reloaded_inv1.getPositions()).removeLastElement();
        invoice1.setText("head_changed");
        ((InvoicePosition)((Object)ListSequence.fromList(invoice1.getPositions()).getElement(0))).setPosText("poschange0");
        ((InvoicePosition)((Object)ListSequence.fromList(invoice1.getPositions()).getElement(1))).setPosText("poschange1");
        ((InvoicePosition)((Object)ListSequence.fromList(invoice1.getPositions()).getElement(2))).setPosText("poschange2");
        ((InvoicePosition)((Object)ListSequence.fromList(invoice1.getPositions()).getElement(3))).setPosText("poschange3");
        Invoice mergedInvoice = (Invoice)MoRevertibleMerger.mergeEntityIntoList(Invoice.class, (IOFXEntity)invoice1, (List)resultList, (IOFXSession)__manMapSession, (boolean)true);
        MoRevertibleMerger.mergeListIntoList(InvoicePosition.class, invoice1.getPositions(), mergedInvoice.getPositions(), (IOFXSession)__manMapSession, (boolean)true);
        Invoice operand = mergedInvoice;
        StringBuilder textRepresentation = new StringBuilder();
        if (!operand.getReadOnly()) {
            throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command (merge positions also - adding a new one!)': ((IOFXEntity) mergedInvoice ).getReadOnly()          ==>> '" + (IOFXEntity)operand + "'.getReadOnly(" + textRepresentation + ") \n");
        }
        int leftSide2 = ListSequence.fromList(mergedInvoice.getPositions()).count();
        if (leftSide2 != (rightSide = 4)) {
            throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command (merge positions also - adding a new one!)':  mergedInvoice .positions.size == 4          ==>>" + leftSide2 + " ==" + rightSide + "\n");
        }
        leftSide2 = ((Object)((Object)((InvoicePosition)((Object)ListSequence.fromList(mergedInvoice.getPositions()).getElement(3))))).equals("poschange3") ? 1 : 0;
        rightSide = ListSequence.fromList(mergedInvoice.getPositions()).getElement(3) != ListSequence.fromList(invoice1.getPositions()).getElement(3) ? 1 : 0;
        InvoicePosition leftSide22 = mergedInvoice.getMainPosRef();
        if (leftSide22 != (rightSide = ((Invoice)((Object)ListSequence.fromList((List)resultList).getElement(0))).getMainPosRef())) {
            throw new OFXTestSuitException("'SessionAndMerge.Using Merge - situation in a search command (merge positions also - adding a new one!)':  mergedInvoice .mainPosRef ==  resultList .get.mainPosRef          ==>>" + leftSide22 + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=10, name="Merging Invoices multiple times ... ", debug=false, enabled=true, runAt="")
    public void __testmethod_10(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Invoice rightSide;
        Invoice inv5;
        Invoice leftSide;
        Invoice inv;
        Invoice invoice1;
        block15: {
            Invoice rightSide2;
            IOFXSession sess = this.__DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
            invoice1 = this.__DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("dtomrg-1", sess);
            inv = (Invoice)MoRevertibleMerger.mergeEntityIntoEntity(Invoice.class, (IOFXEntity)invoice1, null, (IOFXSession)__manMapSession, (boolean)false);
            Invoice leftSide2 = inv;
            if (leftSide2 == (rightSide2 = invoice1)) {
                throw new OFXTestSuitException("'SessionAndMerge.Merging Invoices multiple times ... ':  inv  !=  invoice1           ==>>" + leftSide2 + " !=" + rightSide2 + "\n");
            }
            Invoice leftSide3 = inv;
            Invoice inv2 = (Invoice)MoRevertibleMerger.mergeEntityIntoEntity(Invoice.class, (IOFXEntity)invoice1, null, (IOFXSession)__manMapSession, (boolean)false);
            Invoice rightSide3 = inv2;
            if (leftSide3 != rightSide3) {
                throw new OFXTestSuitException("'SessionAndMerge.Merging Invoices multiple times ... ':  inv  ==  inv2           ==>>" + leftSide3 + " ==" + rightSide3 + "\n");
            }
            boolean __FailIn_catched = false;
            boolean __FailIn_text = true;
            IllegalStateException __FailIn_origThrowable = null;
            Object messagesInProblems = "";
            try {
                Invoice invoice = (Invoice)MoRevertibleMerger.mergeEntityIntoEntity(Invoice.class, (IOFXEntity)invoice1, (IOFXEntity)new Invoice(), (IOFXSession)__manMapSession, (boolean)false);
            }
            catch (IllegalStateException ex) {
                __FailIn_origThrowable = ex;
                __FailIn_catched = true;
                messagesInProblems = ex.getMessage();
                __FailIn_text = false;
                if (messagesInProblems == null) {
                    messagesInProblems = "";
                }
                if (((String)messagesInProblems).contains("not the one in the session")) {
                    __FailIn_text = true;
                }
                messagesInProblems = (String)messagesInProblems + "\n";
                List allProblems = __manMapSession.getAndclearProblemState();
                for (IOFXProblem problem : allProblems) {
                    messagesInProblems = (String)messagesInProblems + problem.getSimpleUserText() + "\n";
                    if (!problem.getSimpleUserText().contains("not the one in the session")) continue;
                    __FailIn_text = true;
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                if (!__FailIn_catched && __FailIn_origThrowable == null) {
                    throw new OFXTestSuitException("'SessionAndMerge.Merging Invoices multiple times ... ': Fail In Exception IllegalStateException was NOT catched!");
                }
                if (__FailIn_catched && !__FailIn_text) {
                    throw new OFXTestSuitException("'SessionAndMerge.Merging Invoices multiple times ... ': Fail In Exception IllegalStateException catched but text not correct! Got instead: \n" + (String)messagesInProblems + " \n");
                }
                if (__FailIn_catched) break block15;
                throw new OFXTestSuitException("'SessionAndMerge.Merging Invoices multiple times ... ': Fail In Exception 'IllegalStateException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
            }
        }
        if ((leftSide = (inv5 = (Invoice)MoRevertibleMerger.mergeEntityIntoEntity(Invoice.class, (IOFXEntity)invoice1, (IOFXEntity)new Invoice(), null, (boolean)false))) == (rightSide = inv)) {
            throw new OFXTestSuitException("'SessionAndMerge.Merging Invoices multiple times ... ':  inv5  !=  inv           ==>>" + leftSide + " !=" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=11, name="DTO Style merging; not considerung current session.", debug=false, enabled=true, runAt="")
    public void __testmethod_11(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        IOFXSession sess = this.__DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
        Invoice invoice1 = this.__DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("dtomrg-1", sess);
        Invoice inv = (Invoice)MoRevertibleMerger.mergeEntityIntoEntity(Invoice.class, (IOFXEntity)invoice1, null, null, (boolean)false);
        InvoicePosition mainPos = (InvoicePosition)MoRevertibleMerger.mergeRefOnRef(InvoicePosition.class, (IOFXEntity)invoice1.getMainPosRef(), null, (boolean)false, (MoRevertibleMerger.RefChange)new MoRevertibleMerger.RefChange<Invoice, InvoicePosition>(){

            public void doChange(Invoice destEntity, InvoicePosition destRef) {
                boolean isDestReadOnly = destEntity.getReadOnly();
                destEntity.setReadOnly(false);
                destEntity.setMainPosRef(destRef);
                destEntity.setReadOnly(isDestReadOnly);
            }
        }, (IOFXEntity)inv);
        int leftSide = ListSequence.fromList((List)__manMapSession.getEntitiesAll(InvoicePosition.entitySessionUID)).count();
        if (leftSide != (rightSide = 0)) {
            throw new OFXTestSuitException("'SessionAndMerge.DTO Style merging; not considerung current session.':  session entities .size == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        InvoicePosition leftSide2 = mainPos;
        InvoicePosition rightSide2 = invoice1.getMainPosRef();
        if (leftSide2 == rightSide2) {
            throw new OFXTestSuitException("'SessionAndMerge.DTO Style merging; not considerung current session.':  mainPos  !=  invoice1 .mainPosRef          ==>>" + leftSide2 + " !=" + rightSide2 + "\n");
        }
        String operand = mainPos.getPosText();
        String param0 = invoice1.getMainPosRef().getPosText();
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'SessionAndMerge.DTO Style merging; not considerung current session.':  mainPos .posText.equals( invoice1 .mainPosRef.posText)          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=12, name="Merging positions in existing aggregate", debug=false, enabled=true, runAt="")
    public void __testmethod_12(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        IOFXSession sess = this.__DomainCreatorsFactory.CREATE_SESSION(__manMapSession);
        Invoice invoice1 = this.__DomainCreatorsFactory.createInvoiceGraphWith4PositionsAndFirstAsMainRef_onDB("postst-1", sess);
        Invoice reloaded = this.__DomainRepoInvoice.getInvoiceByIdWithRefs(invoice1.getId(), __manMapSession);
        InvoicePosition pos = new InvoicePosition();
        pos.setInvoice(reloaded);
        pos.setPosText("created pos");
        ListSequence.fromList(reloaded.getPositions()).addElement((Object)pos);
        int leftSide = ListSequence.fromList(reloaded.getPositions()).count();
        int rightSide = 5;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'SessionAndMerge.Merging positions in existing aggregate':  reloaded .positions.size == 5          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        ListSequence.fromList(invoice1.getPositions()).visitAll(it -> BLOperations.plusAssign(it.refToPosText(), (Object)" *"));
        Invoice integrated = (Invoice)MoRevertibleMerger.mergeEntityIntoEntity(Invoice.class, (IOFXEntity)invoice1, (IOFXEntity)reloaded, (IOFXSession)__manMapSession, (boolean)true);
        List integrated_pos = MoRevertibleMerger.mergeListIntoList(InvoicePosition.class, invoice1.getPositions(), integrated.getPositions(), (IOFXSession)__manMapSession, (boolean)true);
        int leftSide2 = ListSequence.fromList((List)__manMapSession.getEntitiesAll(InvoicePosition.entitySessionUID)).count();
        int rightSide2 = 4;
        if (leftSide2 != rightSide2) {
            throw new OFXTestSuitException("'SessionAndMerge.Merging positions in existing aggregate':  session entities .size == 4          ==>>" + leftSide2 + " ==" + rightSide2 + "\n");
        }
        leftSide2 = ListSequence.fromList((List)integrated_pos).count();
        if (leftSide2 != (rightSide2 = 4)) {
            throw new OFXTestSuitException("'SessionAndMerge.Merging positions in existing aggregate':  integrated_pos .size == 4          ==>>" + leftSide2 + " ==" + rightSide2 + "\n");
        }
        leftSide2 = ListSequence.fromList(reloaded.getPositions()).count();
        if (leftSide2 != (rightSide2 = 4)) {
            throw new OFXTestSuitException("'SessionAndMerge.Merging positions in existing aggregate':  reloaded .positions.size == 4          ==>>" + leftSide2 + " ==" + rightSide2 + "\n");
        }
        if (!ListSequence.fromList(reloaded.getPositions()).all(it -> it.getPosText().endsWith("*"))) {
            throw new OFXTestSuitException("'SessionAndMerge.Merging positions in existing aggregate':  reloaded .positions.all          ==>> FALSE !\n");
        }
    }

    public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
    }

    public static void main(String[] args) {
        String[] allIncludedTest = new String[]{};
        String[] includedTestToRun = new String[]{};
        OFXTestSuit.runAsMain((String)"org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", SessionAndMerge.class, (String[])allIncludedTest, (String[])includedTestToRun);
    }
}

