/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.tests.OrderDocument;

import java.math.BigDecimal;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.references.Reference;
import org.joda.time.LocalDate;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaBasis;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaLength;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaRange;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXRevertableObject;
import org.modellwerkstatt.objectflow.runtime.OFXEntity;
import org.modellwerkstatt.objectflow.runtime.OFXIllegalAccessException;
import org.modellwerkstatt.objectflow.runtime.OFXInteger;
import org.modellwerkstatt.objectflow.runtime.OFXList;
import org.modellwerkstatt.objectflow.runtime.OFXLocalDate;
import org.modellwerkstatt.objectflow.runtime.OFXProblem;
import org.modellwerkstatt.objectflow.runtime.OFXShutDownSessionException;
import org.modellwerkstatt.objectflow.runtime.OFXStatus;
import org.modellwerkstatt.objectflow.runtime.OFXString;
import org.modellwerkstatt.objectflow.runtime.OFXStringFormatter2;
import org.modellwerkstatt.objectflow.runtime.OFXValueObject;
import org.modellwerkstatt.objectflow.tests.OrderDocument.MonetaryValue;
import org.modellwerkstatt.objectflow.tests.OrderDocument.OrderDocumentPos;
import org.modellwerkstatt.objectflow.tests.OrderDocument.OrderDocument_OrderDocStatus;

public class OrderDocument
extends OFXEntity<Integer> {
    public static final int entitySessionUID = OrderDocument.class.hashCode();
    protected OFXInteger id = new OFXInteger();
    protected OFXString remark = new OFXString(0, 100);
    protected OFXString crtlpath = new OFXString(0, 200);
    protected OFXString personName = new OFXString(0, 100);
    protected OFXLocalDate expectedDate = new OFXLocalDate();
    protected OFXValueObject<MonetaryValue> totalValue = new OFXValueObject();
    protected OFXList<OrderDocumentPos> positions = new OFXList();
    protected OFXStatus<OrderDocument_OrderDocStatus> status = new OFXStatus((IOFXMetaStatus.IOFXStatusElement)OrderDocument_OrderDocStatus.ON_CREATE);
    protected OFXString goPrblm = new OFXString();
    protected OFXString gePrblm = new OFXString();
    protected OFXString preProblem = new OFXString();

    public int getSessionObjectKeyStoreID() {
        return entitySessionUID;
    }

    public Integer getIM3Key() {
        return this.id.getValue();
    }

    public Object getKeyProperty() {
        return this.id;
    }

    public int getId() {
        return this.id.getValue();
    }

    private void _setId(int value) {
        if ((this._dirty |= this.id.setValue(value)) && this._readOnly) {
            throw new OFXIllegalAccessException("Changing values in read only OrderDocument (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
        }
    }

    public int setId(int value) {
        this._setId(value);
        return value;
    }

    public Reference<Integer> refToId() {
        return new Reference<Integer>(){

            public Integer get() {
                return OrderDocument.this.getId();
            }

            public void set(Integer value) {
                OrderDocument.this._setId(value);
            }
        };
    }

    public String getRemark() {
        return this.remark.getValue();
    }

    private void _setRemark(String value) {
        if ((this._dirty |= this.remark.setValue(value)) && this._readOnly) {
            throw new OFXIllegalAccessException("Changing values in read only OrderDocument (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
        }
    }

    public String setRemark(String value) {
        this._setRemark(value);
        return value;
    }

    public Reference<String> refToRemark() {
        return new Reference<String>(){

            public String get() {
                return OrderDocument.this.getRemark();
            }

            public void set(String value) {
                OrderDocument.this._setRemark(value);
            }
        };
    }

    public String getCrtlpath() {
        return this.crtlpath.getValue();
    }

    private void _setCrtlpath(String value) {
        if ((this._dirty |= this.crtlpath.setValue(value)) && this._readOnly) {
            throw new OFXIllegalAccessException("Changing values in read only OrderDocument (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
        }
    }

    public String setCrtlpath(String value) {
        this._setCrtlpath(value);
        return value;
    }

    public Reference<String> refToCrtlpath() {
        return new Reference<String>(){

            public String get() {
                return OrderDocument.this.getCrtlpath();
            }

            public void set(String value) {
                OrderDocument.this._setCrtlpath(value);
            }
        };
    }

    public String getPersonName() {
        return this.personName.getValue();
    }

    private void _setPersonName(String value) {
        if ((this._dirty |= this.personName.setValue(value)) && this._readOnly) {
            throw new OFXIllegalAccessException("Changing values in read only OrderDocument (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
        }
    }

    public String setPersonName(String value) {
        this._setPersonName(value);
        return value;
    }

    public Reference<String> refToPersonName() {
        return new Reference<String>(){

            public String get() {
                return OrderDocument.this.getPersonName();
            }

            public void set(String value) {
                OrderDocument.this._setPersonName(value);
            }
        };
    }

    public LocalDate getExpectedDate() {
        return this.expectedDate.getValue();
    }

    private void _setExpectedDate(LocalDate value) {
        if ((this._dirty |= this.expectedDate.setValue(value)) && this._readOnly) {
            throw new OFXIllegalAccessException("Changing values in read only OrderDocument (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
        }
    }

    public LocalDate setExpectedDate(LocalDate value) {
        this._setExpectedDate(value);
        return value;
    }

    public Reference<LocalDate> refToExpectedDate() {
        return new Reference<LocalDate>(){

            public LocalDate get() {
                return OrderDocument.this.getExpectedDate();
            }

            public void set(LocalDate value) {
                OrderDocument.this._setExpectedDate(value);
            }
        };
    }

    public MonetaryValue getTotalValue() {
        return (MonetaryValue)this.totalValue.getValue();
    }

    private void _setTotalValue(MonetaryValue value) {
        if ((this._dirty |= this.totalValue.setValue((Object)value)) && this._readOnly) {
            throw new OFXIllegalAccessException("Changing values in read only OrderDocument (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
        }
    }

    public MonetaryValue setTotalValue(MonetaryValue value) {
        this._setTotalValue(value);
        return value;
    }

    public Reference<MonetaryValue> refToTotalValue() {
        return new Reference<MonetaryValue>(){

            public MonetaryValue get() {
                return OrderDocument.this.getTotalValue();
            }

            public void set(MonetaryValue value) {
                OrderDocument.this._setTotalValue(value);
            }
        };
    }

    public List<OrderDocumentPos> getPositions() {
        return this.positions.getValue();
    }

    private void _setPositions(List<OrderDocumentPos> value) {
        if ((this._dirty |= this.positions.setValue(value)) && this._readOnly) {
            throw new OFXIllegalAccessException("Changing values in read only OrderDocument (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
        }
    }

    public List<OrderDocumentPos> setPositions(List<OrderDocumentPos> value) {
        this._setPositions(value);
        return value;
    }

    public Reference<List<OrderDocumentPos>> refToPositions() {
        return new Reference<List<OrderDocumentPos>>(){

            public List<OrderDocumentPos> get() {
                return OrderDocument.this.getPositions();
            }

            public void set(List<OrderDocumentPos> value) {
                OrderDocument.this._setPositions(value);
            }
        };
    }

    public OrderDocument_OrderDocStatus getStatus() {
        return (OrderDocument_OrderDocStatus)this.status.getValue();
    }

    private void _setStatus(OrderDocument_OrderDocStatus value) {
        if ((this._dirty |= this.status.setValue((IOFXMetaStatus.IOFXStatusElement)value)) && this._readOnly) {
            throw new OFXIllegalAccessException("Changing values in read only OrderDocument (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
        }
    }

    public OrderDocument_OrderDocStatus setStatus(OrderDocument_OrderDocStatus value) {
        this._setStatus(value);
        return value;
    }

    public Reference<OrderDocument_OrderDocStatus> refToStatus() {
        return new Reference<OrderDocument_OrderDocStatus>(){

            public OrderDocument_OrderDocStatus get() {
                return OrderDocument.this.getStatus();
            }

            public void set(OrderDocument_OrderDocStatus value) {
                OrderDocument.this._setStatus(value);
            }
        };
    }

    public String getGoPrblm() {
        return this.goPrblm.getValue();
    }

    private void _setGoPrblm(String value) {
        if ((this._dirty |= this.goPrblm.setValue(value)) && this._readOnly) {
            throw new OFXIllegalAccessException("Changing values in read only OrderDocument (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
        }
    }

    public String setGoPrblm(String value) {
        this._setGoPrblm(value);
        return value;
    }

    public Reference<String> refToGoPrblm() {
        return new Reference<String>(){

            public String get() {
                return OrderDocument.this.getGoPrblm();
            }

            public void set(String value) {
                OrderDocument.this._setGoPrblm(value);
            }
        };
    }

    public String getGePrblm() {
        return this.gePrblm.getValue();
    }

    private void _setGePrblm(String value) {
        if ((this._dirty |= this.gePrblm.setValue(value)) && this._readOnly) {
            throw new OFXIllegalAccessException("Changing values in read only OrderDocument (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
        }
    }

    public String setGePrblm(String value) {
        this._setGePrblm(value);
        return value;
    }

    public Reference<String> refToGePrblm() {
        return new Reference<String>(){

            public String get() {
                return OrderDocument.this.getGePrblm();
            }

            public void set(String value) {
                OrderDocument.this._setGePrblm(value);
            }
        };
    }

    public String getPreProblem() {
        return this.preProblem.getValue();
    }

    private void _setPreProblem(String value) {
        if ((this._dirty |= this.preProblem.setValue(value)) && this._readOnly) {
            throw new OFXIllegalAccessException("Changing values in read only OrderDocument (key " + this.getIM3Key() + ") is not allowed. You set new val=" + value);
        }
    }

    public String setPreProblem(String value) {
        this._setPreProblem(value);
        return value;
    }

    public Reference<String> refToPreProblem() {
        return new Reference<String>(){

            public String get() {
                return OrderDocument.this.getPreProblem();
            }

            public void set(String value) {
                OrderDocument.this._setPreProblem(value);
            }
        };
    }

    public void calcAggregate() {
        if (ListSequence.fromList(this.getPositions()).select(it -> it.getVal().getCurrency()).distinct().count() != 1) {
            throw new OFXShutDownSessionException((IOFXProblem)new OFXProblem(true, OFXStringFormatter2.GLOBAL_INSTANCE_DEFAULT_LANG.translate(-1, "Different currencies are not suppored yet. We have %s", new Object[]{"" + ListSequence.fromList(this.getPositions()).select(it -> it.getVal().getCurrency()).distinct()}), null, null));
        }
        BigDecimal val = (BigDecimal)ListSequence.fromList(this.getPositions()).foldLeft((Object)new BigDecimal("0.0"), (s, it) -> s.add(it.getVal().getAmount()));
        this.setTotalValue(new MonetaryValue(val));
    }

    public void triggerGuardWithInstanceAndSolution() {
        throw new OFXShutDownSessionException((IOFXProblem)new OFXProblem(true, OFXStringFormatter2.GLOBAL_INSTANCE_DEFAULT_LANG.translate(-1, "TestGuard with instance and solution", new Object[0]), "" + this, null));
    }

    public void triggerGuardWithEX() {
        try {
            throw new Exception("Somne IO Excpetion?");
        }
        catch (Exception ex) {
            throw new OFXShutDownSessionException((IOFXProblem)new OFXProblem(true, null, null, (Throwable)ex), (Throwable)ex);
        }
    }

    public void passed(String point) {
        this.setCrtlpath(this.getCrtlpath() + " [" + point + "]");
    }

    public boolean did(String point) {
        String pointName = "[" + point + "]";
        return this.getCrtlpath().contains(pointName);
    }

    public int count(String point) {
        String pointName = "[" + point + "]";
        String st = this.getCrtlpath().replace(pointName, "\u00a7");
        return st.length() - st.replace("\u00a7", "").length();
    }

    public boolean isCase(String caseString) {
        return this.getRemark().toLowerCase().contains(caseString.toLowerCase());
    }

    public IOFXMetaRange<Integer> getId_META() {
        return this.id;
    }

    public IOFXMetaLength<String> getRemark_META() {
        return this.remark;
    }

    public IOFXMetaLength<String> getCrtlpath_META() {
        return this.crtlpath;
    }

    public IOFXMetaLength<String> getPersonName_META() {
        return this.personName;
    }

    public IOFXMetaRange<LocalDate> getExpectedDate_META() {
        return this.expectedDate;
    }

    public IOFXMetaBasis getTotalValue_META() {
        return this.totalValue;
    }

    public IOFXMetaBasis getPositions_META() {
        return this.positions;
    }

    public IOFXMetaStatus<OrderDocument_OrderDocStatus> getStatus_META() {
        return this.status;
    }

    public IOFXMetaLength<String> getGoPrblm_META() {
        return this.goPrblm;
    }

    public IOFXMetaLength<String> getGePrblm_META() {
        return this.gePrblm;
    }

    public IOFXMetaLength<String> getPreProblem_META() {
        return this.preProblem;
    }

    public void beforeSave() {
        super.beforeSave();
    }

    public void rollback() {
        super.rollback();
        this.id.setValue(((Integer)this._BEFORESAVE_KEY).intValue());
    }

    public boolean anyOfListDirty() {
        boolean dirty = super.anyOfListDirty();
        return dirty |= this.positions.wasListChanged();
    }

    public void clearDirtyOnLists() {
        super.clearDirtyOnLists();
        this.positions.setHashForDirtyChecking();
    }

    public String toString() {
        return "OrderDocument " + this.getKeyProperty();
    }

    public void load(IOFXRevertableObject param, boolean fullRevertNotMerge) {
        OrderDocument entity = (OrderDocument)param;
        this.id.load(entity.id, fullRevertNotMerge);
        this.remark.load(entity.remark, fullRevertNotMerge);
        this.crtlpath.load(entity.crtlpath, fullRevertNotMerge);
        this.personName.load(entity.personName, fullRevertNotMerge);
        this.expectedDate.load(entity.expectedDate, fullRevertNotMerge);
        this.totalValue.load(entity.totalValue, fullRevertNotMerge);
        this.positions.load(entity.positions, fullRevertNotMerge);
        this.status.load(entity.status, fullRevertNotMerge);
        this.goPrblm.load(entity.goPrblm, fullRevertNotMerge);
        this.gePrblm.load(entity.gePrblm, fullRevertNotMerge);
        this.preProblem.load(entity.preProblem, fullRevertNotMerge);
        super.load(param, fullRevertNotMerge);
    }

    public IOFXRevertableObject copy() {
        OrderDocument entity = new OrderDocument();
        entity.id = this.id.copy();
        entity.remark = this.remark.copy();
        entity.crtlpath = this.crtlpath.copy();
        entity.personName = this.personName.copy();
        entity.expectedDate = this.expectedDate.copy();
        entity.totalValue = this.totalValue.copy();
        entity.positions = this.positions.copy();
        entity.status = this.status.copy();
        entity.goPrblm = this.goPrblm.copy();
        entity.gePrblm = this.gePrblm.copy();
        entity.preProblem = this.preProblem.copy();
        super.entityInfraInto((OFXEntity)entity);
        return entity;
    }
}

