/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.tests.manmap.Tests;

import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXSessionOperation;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.OFXIncludedSuit;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.AuditEntity;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.CreatorsFactory;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoAuditEntity;
import org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit;
import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;

public class Audit
extends OFXTestSuit {
    @Autowired
    private CreatorsFactory __DomainCreatorsFactory;
    @Autowired
    private RepoAuditEntity __DomainRepoAuditEntity;
    @Autowired
    private IOFXPlatform __runtimeIOFXPlatform;
    @Autowired
    private IOFXTranslationProvider __runtimeIOFXTranslationProvider;
    private IOFXUserEnvironment userEnv;
    private int origUserId;
    private DateTime defaultDateTime = new DateTime(1980, 1, 27, 4, 30, 0, 0);
    private DateTime secondModification = new DateTime(1985, 1, 7, 12, 0, 0, 0);
    @OFXIncludedSuit(name="org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit")
    private DBinit ___inst_DBinit;

    public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
        this.userEnv = this.__localApplicationFactory.createNewSession(this.__userEnvironment, this.__userServices).getUserEnvironment();
        this.origUserId = this.userEnv.getUserId();
    }

    @OFXTestMethod(id=0, name="Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        int rightSide2;
        Object rightSide3;
        final AuditEntity entity = this.__DomainCreatorsFactory.createAuditEntity_NOTonDB("audit", __manMapSession);
        DateTime leftSide = entity.getZzCreatedAt();
        if (leftSide != (rightSide3 = null)) {
            throw new OFXTestSuitException("'Audit.Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.':  entity .zzCreatedAt ==  null           ==>>" + leftSide + " ==" + rightSide3 + "\n");
        }
        leftSide = entity.getZzModifiedAt();
        if (leftSide != (rightSide3 = null)) {
            throw new OFXTestSuitException("'Audit.Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.':  entity .zzModifiedAt ==  null           ==>>" + leftSide + " ==" + rightSide3 + "\n");
        }
        leftSide = entity.getZzCreatedAtLDate();
        if (leftSide != (rightSide3 = null)) {
            throw new OFXTestSuitException("'Audit.Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.':  entity .zzCreatedAtLDate ==  null           ==>>" + (LocalDate)leftSide + " ==" + rightSide3 + "\n");
        }
        leftSide = entity.getZzModifiedAtLDate();
        if (leftSide != (rightSide3 = null)) {
            throw new OFXTestSuitException("'Audit.Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.':  entity .zzModifiedAtLDate ==  null           ==>>" + (LocalDate)leftSide + " ==" + rightSide3 + "\n");
        }
        int leftSide2 = entity.getZzCreatedAtUid();
        if (leftSide2 != (rightSide2 = 0)) {
            throw new OFXTestSuitException("'Audit.Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.':  entity .zzCreatedAtUid == 0          ==>>" + leftSide2 + " ==" + rightSide2 + "\n");
        }
        leftSide2 = entity.getZzModifiedAtUid();
        if (leftSide2 != (rightSide2 = 0)) {
            throw new OFXTestSuitException("'Audit.Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.':  entity .zzModifiedAtUid == 0          ==>>" + leftSide2 + " ==" + rightSide2 + "\n");
        }
        final IOFXSession session = this.__localApplicationFactory.createNewSession(this.__userEnvironment, this.__userServices);
        session.addOperation(new IOFXSessionOperation(){

            public void execute() {
                Audit.this.__DomainRepoAuditEntity.checkinAuditEntity(entity, session);
            }

            public String getInformation() {
                return "checking AuditEntity";
            }
        });
        try {
            session.startTransactionAndFlush();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        AuditEntity reload = this.__DomainRepoAuditEntity.checkoutAuditEntity(entity.getId(), null);
        DateTime operand = reload.getZzCreatedAt();
        DateTime param0 = this.defaultDateTime;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals((Object)param0)) {
            throw new OFXTestSuitException("'Audit.Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.':  reload .zzCreatedAt.equals( defaultDateTime )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = reload.getZzModifiedAt();
        param0 = this.defaultDateTime;
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals((Object)param0)) {
            throw new OFXTestSuitException("'Audit.Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.':  reload .zzModifiedAt.equals( defaultDateTime )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = reload.getZzCreatedAtLDate();
        param0 = this.defaultDateTime.toLocalDate();
        textRepresentation = new StringBuilder();
        textRepresentation.append((LocalDate)param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals((Object)param0)) {
            throw new OFXTestSuitException("'Audit.Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.':  reload .zzCreatedAtLDate.equals( defaultDateTime .toLocalDate())          ==>> '" + (LocalDate)operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = reload.getZzModifiedAtLDate();
        param0 = this.defaultDateTime.toLocalDate();
        textRepresentation = new StringBuilder();
        textRepresentation.append((LocalDate)param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals((Object)param0)) {
            throw new OFXTestSuitException("'Audit.Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.':  reload .zzModifiedAtLDate.equals( defaultDateTime .toLocalDate())          ==>> '" + (LocalDate)operand + "'.equals(" + textRepresentation + ") \n");
        }
        int leftSide3 = reload.getZzCreatedAtUid();
        if (leftSide3 != (rightSide = this.userEnv.getUserId())) {
            throw new OFXTestSuitException("'Audit.Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.':  reload .zzCreatedAtUid ==  userEnv .getUserId()          ==>>" + leftSide3 + " ==" + rightSide + "\n");
        }
        leftSide3 = reload.getZzModifiedAtUid();
        if (leftSide3 != (rightSide = this.userEnv.getUserId())) {
            throw new OFXTestSuitException("'Audit.Insert an AuditEntity with complete auditing (created / modified) - LocalDate and DateTime.':  reload .zzModifiedAtUid ==  userEnv .getUserId()          ==>>" + leftSide3 + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=1, name="Update the AuditEntity should change modified Stamps. - LocalDate and DateTime.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        AuditEntity created = this.__DomainCreatorsFactory.createAuditEntity_onDB("update", __manMapSession);
        DeprecatedServerDateProvider.fixServerDatetimeToConstant((DateTime)this.secondModification);
        this.userEnv.setUserId(4711);
        final IOFXSession session = this.__localApplicationFactory.createNewSession(this.__userEnvironment, this.__userServices);
        final AuditEntity reloaded = this.__DomainRepoAuditEntity.checkoutAuditEntity(created.getId(), session);
        reloaded.setText("*changed*");
        session.addOperation(new IOFXSessionOperation(){

            public void execute() {
                Audit.this.__DomainRepoAuditEntity.checkinAuditEntity(reloaded, session);
            }

            public String getInformation() {
                return "checking AuditEntity";
            }
        });
        try {
            session.startTransactionAndFlush();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.userEnv.setUserId(this.origUserId);
        }
        AuditEntity reload2 = this.__DomainRepoAuditEntity.checkoutAuditEntity(reloaded.getId(), null);
        DateTime operand = reload2.getZzCreatedAt();
        DateTime param0 = this.defaultDateTime;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals((Object)param0)) {
            throw new OFXTestSuitException("'Audit.Update the AuditEntity should change modified Stamps. - LocalDate and DateTime.':  reload2 .zzCreatedAt.equals( defaultDateTime )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = reload2.getZzCreatedAtLDate();
        param0 = this.defaultDateTime.toLocalDate();
        textRepresentation = new StringBuilder();
        textRepresentation.append((LocalDate)param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals((Object)param0)) {
            throw new OFXTestSuitException("'Audit.Update the AuditEntity should change modified Stamps. - LocalDate and DateTime.':  reload2 .zzCreatedAtLDate.equals( defaultDateTime .toLocalDate())          ==>> '" + (LocalDate)operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = reload2.getZzModifiedAt();
        param0 = this.secondModification;
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals((Object)param0)) {
            throw new OFXTestSuitException("'Audit.Update the AuditEntity should change modified Stamps. - LocalDate and DateTime.':  reload2 .zzModifiedAt.equals( secondModification )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = reload2.getZzModifiedAtLDate();
        param0 = this.secondModification.toLocalDate();
        textRepresentation = new StringBuilder();
        textRepresentation.append((LocalDate)param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals((Object)param0)) {
            throw new OFXTestSuitException("'Audit.Update the AuditEntity should change modified Stamps. - LocalDate and DateTime.':  reload2 .zzModifiedAtLDate.equals( secondModification .toLocalDate())          ==>> '" + (LocalDate)operand + "'.equals(" + textRepresentation + ") \n");
        }
        int leftSide = reload2.getZzCreatedAtUid();
        if (leftSide != (rightSide = this.origUserId)) {
            throw new OFXTestSuitException("'Audit.Update the AuditEntity should change modified Stamps. - LocalDate and DateTime.':  reload2 .zzCreatedAtUid ==  origUserId           ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = reload2.getZzModifiedAtUid();
        if (leftSide != (rightSide = 4711)) {
            throw new OFXTestSuitException("'Audit.Update the AuditEntity should change modified Stamps. - LocalDate and DateTime.':  reload2 .zzModifiedAtUid == 4711          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=2, name="Update the AuditEntity should NOT change modified Stamps when not dirty. - LocalDate and DateTime.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_2(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        AuditEntity created = this.__DomainCreatorsFactory.createAuditEntity_onDB("update", __manMapSession);
        DateTime modifiedAt = new DateTime(1985, 1, 7, 12, 0, 0, 0);
        DeprecatedServerDateProvider.fixServerDatetimeToConstant((DateTime)modifiedAt);
        this.userEnv.setUserId(4711);
        final IOFXSession session = this.__localApplicationFactory.createNewSession(this.__userEnvironment, this.__userServices);
        final AuditEntity reloaded = this.__DomainRepoAuditEntity.checkoutAuditEntity(created.getId(), session);
        session.addOperation(new IOFXSessionOperation(){

            public void execute() {
                Audit.this.__DomainRepoAuditEntity.checkinAuditEntity(reloaded, session);
            }

            public String getInformation() {
                return "checking AuditEntity";
            }
        });
        try {
            session.startTransactionAndFlush();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.userEnv.setUserId(this.origUserId);
        }
        AuditEntity reload2 = this.__DomainRepoAuditEntity.checkoutAuditEntity(reloaded.getId(), null);
        DateTime operand = reload2.getZzCreatedAt();
        DateTime param0 = this.defaultDateTime;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals((Object)param0)) {
            throw new OFXTestSuitException("'Audit.Update the AuditEntity should NOT change modified Stamps when not dirty. - LocalDate and DateTime.':  reload2 .zzCreatedAt.equals( defaultDateTime )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = reload2.getZzModifiedAt();
        param0 = this.defaultDateTime;
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals((Object)param0)) {
            throw new OFXTestSuitException("'Audit.Update the AuditEntity should NOT change modified Stamps when not dirty. - LocalDate and DateTime.':  reload2 .zzModifiedAt.equals( defaultDateTime )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = reload2.getZzCreatedAtLDate();
        param0 = this.defaultDateTime.toLocalDate();
        textRepresentation = new StringBuilder();
        textRepresentation.append((LocalDate)param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals((Object)param0)) {
            throw new OFXTestSuitException("'Audit.Update the AuditEntity should NOT change modified Stamps when not dirty. - LocalDate and DateTime.':  reload2 .zzCreatedAtLDate.equals( defaultDateTime .toLocalDate())          ==>> '" + (LocalDate)operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = reload2.getZzModifiedAtLDate();
        param0 = this.defaultDateTime.toLocalDate();
        textRepresentation = new StringBuilder();
        textRepresentation.append((LocalDate)param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals((Object)param0)) {
            throw new OFXTestSuitException("'Audit.Update the AuditEntity should NOT change modified Stamps when not dirty. - LocalDate and DateTime.':  reload2 .zzModifiedAtLDate.equals( defaultDateTime .toLocalDate())          ==>> '" + (LocalDate)operand + "'.equals(" + textRepresentation + ") \n");
        }
        int leftSide = reload2.getZzCreatedAtUid();
        if (leftSide != (rightSide = this.origUserId)) {
            throw new OFXTestSuitException("'Audit.Update the AuditEntity should NOT change modified Stamps when not dirty. - LocalDate and DateTime.':  reload2 .zzCreatedAtUid ==  origUserId           ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = reload2.getZzModifiedAtUid();
        if (leftSide != (rightSide = this.origUserId)) {
            throw new OFXTestSuitException("'Audit.Update the AuditEntity should NOT change modified Stamps when not dirty. - LocalDate and DateTime.':  reload2 .zzModifiedAtUid ==  origUserId           ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=3, name="Update the AuditEntity should change modified Stamps when not dirty (forced) - LocalDate and DateTime.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_3(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        AuditEntity created = this.__DomainCreatorsFactory.createAuditEntity_onDB("update", __manMapSession);
        DateTime modifiedAt = new DateTime(1985, 1, 7, 12, 0, 0, 0);
        DeprecatedServerDateProvider.fixServerDatetimeToConstant((DateTime)modifiedAt);
        this.userEnv.setUserId(4711);
        final IOFXSession session = this.__localApplicationFactory.createNewSession(this.__userEnvironment, this.__userServices);
        final AuditEntity reloaded = this.__DomainRepoAuditEntity.checkoutAuditEntity(created.getId(), session);
        session.addOperation(new IOFXSessionOperation(){

            public void execute() {
                Audit.this.__DomainRepoAuditEntity.checkinAuditEntityForceAudit(reloaded, session);
            }

            public String getInformation() {
                return "checking AuditEntity";
            }
        });
        try {
            session.startTransactionAndFlush();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.userEnv.setUserId(this.origUserId);
        }
        AuditEntity reload2 = this.__DomainRepoAuditEntity.checkoutAuditEntity(reloaded.getId(), null);
        DateTime operand = reload2.getZzCreatedAt();
        DateTime param0 = this.defaultDateTime;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals((Object)param0)) {
            throw new OFXTestSuitException("'Audit.Update the AuditEntity should change modified Stamps when not dirty (forced) - LocalDate and DateTime.':  reload2 .zzCreatedAt.equals( defaultDateTime )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = reload2.getZzModifiedAt();
        param0 = modifiedAt;
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals((Object)param0)) {
            throw new OFXTestSuitException("'Audit.Update the AuditEntity should change modified Stamps when not dirty (forced) - LocalDate and DateTime.':  reload2 .zzModifiedAt.equals( modifiedAt )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = reload2.getZzCreatedAtLDate();
        param0 = this.defaultDateTime.toLocalDate();
        textRepresentation = new StringBuilder();
        textRepresentation.append((LocalDate)param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals((Object)param0)) {
            throw new OFXTestSuitException("'Audit.Update the AuditEntity should change modified Stamps when not dirty (forced) - LocalDate and DateTime.':  reload2 .zzCreatedAtLDate.equals( defaultDateTime .toLocalDate())          ==>> '" + (LocalDate)operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = reload2.getZzModifiedAtLDate();
        param0 = modifiedAt.toLocalDate();
        textRepresentation = new StringBuilder();
        textRepresentation.append((LocalDate)param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals((Object)param0)) {
            throw new OFXTestSuitException("'Audit.Update the AuditEntity should change modified Stamps when not dirty (forced) - LocalDate and DateTime.':  reload2 .zzModifiedAtLDate.equals( modifiedAt .toLocalDate())          ==>> '" + (LocalDate)operand + "'.equals(" + textRepresentation + ") \n");
        }
        int leftSide = reload2.getZzCreatedAtUid();
        if (leftSide != (rightSide = this.origUserId)) {
            throw new OFXTestSuitException("'Audit.Update the AuditEntity should change modified Stamps when not dirty (forced) - LocalDate and DateTime.':  reload2 .zzCreatedAtUid ==  origUserId           ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = reload2.getZzModifiedAtUid();
        if (leftSide != (rightSide = 4711)) {
            throw new OFXTestSuitException("'Audit.Update the AuditEntity should change modified Stamps when not dirty (forced) - LocalDate and DateTime.':  reload2 .zzModifiedAtUid == 4711          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=4, name="Update the AuditEntity should NOT change modified Stamps (skiped) - LocalDate and DateTime.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_4(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        AuditEntity created = this.__DomainCreatorsFactory.createAuditEntity_onDB("update", __manMapSession);
        DateTime modifiedAt = new DateTime(1985, 1, 7, 12, 0, 0, 0);
        DeprecatedServerDateProvider.fixServerDatetimeToConstant((DateTime)modifiedAt);
        this.userEnv.setUserId(4711);
        final IOFXSession session = this.__localApplicationFactory.createNewSession(this.__userEnvironment, this.__userServices);
        final AuditEntity reloaded = this.__DomainRepoAuditEntity.checkoutAuditEntity(created.getId(), session);
        reloaded.setText("*changed*");
        session.addOperation(new IOFXSessionOperation(){

            public void execute() {
                Audit.this.__DomainRepoAuditEntity.checkinAuditEntitySkipAudit(reloaded, session);
            }

            public String getInformation() {
                return "checking AuditEntity";
            }
        });
        try {
            session.startTransactionAndFlush();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.userEnv.setUserId(this.origUserId);
        }
        AuditEntity reload2 = this.__DomainRepoAuditEntity.checkoutAuditEntity(reloaded.getId(), null);
        DateTime operand = reload2.getZzCreatedAt();
        DateTime param0 = this.defaultDateTime;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals((Object)param0)) {
            throw new OFXTestSuitException("'Audit.Update the AuditEntity should NOT change modified Stamps (skiped) - LocalDate and DateTime.':  reload2 .zzCreatedAt.equals( defaultDateTime )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = reload2.getZzModifiedAt();
        param0 = this.defaultDateTime;
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals((Object)param0)) {
            throw new OFXTestSuitException("'Audit.Update the AuditEntity should NOT change modified Stamps (skiped) - LocalDate and DateTime.':  reload2 .zzModifiedAt.equals( defaultDateTime )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = reload2.getZzCreatedAtLDate();
        param0 = this.defaultDateTime.toLocalDate();
        textRepresentation = new StringBuilder();
        textRepresentation.append((LocalDate)param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals((Object)param0)) {
            throw new OFXTestSuitException("'Audit.Update the AuditEntity should NOT change modified Stamps (skiped) - LocalDate and DateTime.':  reload2 .zzCreatedAtLDate.equals( defaultDateTime .toLocalDate())          ==>> '" + (LocalDate)operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = reload2.getZzModifiedAtLDate();
        param0 = this.defaultDateTime.toLocalDate();
        textRepresentation = new StringBuilder();
        textRepresentation.append((LocalDate)param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals((Object)param0)) {
            throw new OFXTestSuitException("'Audit.Update the AuditEntity should NOT change modified Stamps (skiped) - LocalDate and DateTime.':  reload2 .zzModifiedAtLDate.equals( defaultDateTime .toLocalDate())          ==>> '" + (LocalDate)operand + "'.equals(" + textRepresentation + ") \n");
        }
        int leftSide = reload2.getZzCreatedAtUid();
        if (leftSide != (rightSide = this.origUserId)) {
            throw new OFXTestSuitException("'Audit.Update the AuditEntity should NOT change modified Stamps (skiped) - LocalDate and DateTime.':  reload2 .zzCreatedAtUid ==  origUserId           ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        leftSide = reload2.getZzModifiedAtUid();
        if (leftSide != (rightSide = this.origUserId)) {
            throw new OFXTestSuitException("'Audit.Update the AuditEntity should NOT change modified Stamps (skiped) - LocalDate and DateTime.':  reload2 .zzModifiedAtUid ==  origUserId           ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=5, name="newDateTimeFromServer(): Get a DB Hit - assuming it is not in Sync with local time. ", debug=false, enabled=true, runAt="")
    public void __testmethod_5(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        DateTime dt = DeprecatedServerDateProvider.getSqlServerDateTime();
        long localMillis = System.currentTimeMillis();
        long leftSide = Math.abs(dt.getMillis() - localMillis);
        if (leftSide <= (long)(rightSide = 30)) {
            throw new OFXTestSuitException("'Audit.newDateTimeFromServer(): Get a DB Hit - assuming it is not in Sync with local time. ': Math.abs( dt .getMillis() -  localMillis ) > 30          ==>>" + leftSide + " >" + rightSide + "\n");
        }
        leftSide = Math.abs(dt.getMillis() - localMillis);
        if (leftSide >= (long)(rightSide = 300000)) {
            throw new OFXTestSuitException("'Audit.newDateTimeFromServer(): Get a DB Hit - assuming it is not in Sync with local time. ': Math.abs( dt .getMillis() -  localMillis ) < 60000 * 5          ==>>" + leftSide + " <" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=6, name="newDateTimeFromServer(): Hitting it 1000 times is quite fast. ", debug=false, enabled=true, runAt="")
    public void __testmethod_6(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        DateTime dt = DeprecatedServerDateProvider.getSqlServerDateTime();
        long currentMillis = System.currentTimeMillis();
        for (int i = 1; i < 100000; ++i) {
            DateTime tmpDateTime = DeprecatedServerDateProvider.getSqlServerDateTime();
            if (tmpDateTime.getMinuteOfHour() <= 100) continue;
            throw new RuntimeException("This can not happen. Prevent optimization.");
        }
        long leftSide = currentMillis - System.currentTimeMillis();
        if (leftSide >= (long)(rightSide = 5)) {
            throw new OFXTestSuitException("'Audit.newDateTimeFromServer(): Hitting it 1000 times is quite fast. ':  currentMillis  - System.currentTimeMillis() < 5          ==>>" + leftSide + " <" + rightSide + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OFXTestMethod(id=7, name="newDateTimeFromServer(): Hitting continiously the db. ", debug=false, enabled=true, runAt="")
    public void __testmethod_7(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        long was = DeprecatedServerDateProvider.REORGANIZE_TIMESTAMP_FROM_DB_INTERVALL;
        try {
            int rightSide;
            DeprecatedServerDateProvider.REORGANIZE_TIMESTAMP_FROM_DB_INTERVALL = 0L;
            long startTime = System.currentTimeMillis();
            for (int i = 1; i < 1000; ++i) {
                DateTime tmpDateTime = DeprecatedServerDateProvider.getSqlServerDateTime();
                if (tmpDateTime.getMinuteOfHour() <= 100) continue;
                throw new RuntimeException("This can not happen. Prevent optimization.");
            }
            long leftSide = System.currentTimeMillis() - startTime;
            if (leftSide <= (long)(rightSide = 100)) {
                throw new OFXTestSuitException("'Audit.newDateTimeFromServer(): Hitting continiously the db. ': System.currentTimeMillis() -  startTime  > 100          ==>>" + leftSide + " >" + rightSide + "\n");
            }
        }
        finally {
            DeprecatedServerDateProvider.REORGANIZE_TIMESTAMP_FROM_DB_INTERVALL = was;
        }
    }

    public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
    }

    public static void main(String[] args) {
        String[] allIncludedTest = new String[]{"org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit"};
        String[] includedTestToRun = new String[]{};
        OFXTestSuit.runAsMain((String)"org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", Audit.class, (String[])allIncludedTest, (String[])includedTestToRun);
    }
}

