/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.tests.manmap.Tests;

import java.math.BigDecimal;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.modellwerkstatt.manmap.runtime.IM3DatabaseDescription;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.runtime.OFXIncludedSuit;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.AuditEntity;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.CreatorsFactory;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Invoice;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Invoice_HeadState;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoCustomSql;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoCustomSqlNP;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.RepoInvoice;
import org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit;
import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomSQL
extends OFXTestSuit {
    @Autowired
    private CreatorsFactory __DomainCreatorsFactory;
    @Autowired
    private RepoCustomSql __DomainRepoCustomSql;
    @Autowired
    private RepoCustomSqlNP __DomainRepoCustomSqlNP;
    @Autowired
    private RepoInvoice __DomainRepoInvoice;
    @Autowired
    private IOFXPlatform __runtimeIOFXPlatform;
    @Autowired
    private IOFXTranslationProvider __runtimeIOFXTranslationProvider;
    @Autowired
    private IM3DatabaseDescription dbDesc;
    @OFXIncludedSuit(name="org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit")
    private DBinit ___inst_DBinit;

    public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
    }

    @OFXTestMethod(id=0, name="Simply query for int with plain sql.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        AuditEntity obj = this.__DomainCreatorsFactory.createAuditEntity_onDB("simple", __manMapSession);
        int numOfRecords = this.__DomainRepoCustomSql.getCountOfAuditEntities(null);
        int leftSide = numOfRecords;
        if (leftSide <= (rightSide = 0)) {
            throw new OFXTestSuitException("'CustomSQL.Simply query for int with plain sql.':  numOfRecords  > 0          ==>>" + leftSide + " >" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=1, name="Using Custom SQL to load an AuditEntity.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity obj = this.__DomainCreatorsFactory.createAuditEntity_onDB("numeric", __manMapSession);
        AuditEntity reload = this.__DomainRepoCustomSql.findAuditEntityById_numericInterface(obj.getId(), null);
        String operand = reload.getText();
        String param0 = "numeric";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'CustomSQL.Using Custom SQL to load an AuditEntity.':  reload .text.equals(\"numeric\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=2, name="Use new mapper interface to load entity.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_2(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity obj = this.__DomainCreatorsFactory.createAuditEntity_onDB("newstyle", __manMapSession);
        AuditEntity reloaded = this.__DomainRepoCustomSql.findAuditEntitybyId_combinedSQL(obj.getId(), null);
        String operand = reloaded.getText();
        String param0 = "newstyle";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'CustomSQL.Use new mapper interface to load entity.':  reloaded .text.equals(\"newstyle\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=3, name="Use new mapper interface to load entity - combined sql.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_3(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity obj = this.__DomainCreatorsFactory.createAuditEntity_onDB("newstyle", __manMapSession);
        AuditEntity reloaded = this.__DomainRepoCustomSql.findIntkeyObjectById_combinedsqlAlternative(obj.getId(), null);
        String operand = reloaded.getText();
        String param0 = "newstyle";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'CustomSQL.Use new mapper interface to load entity - combined sql.':  reloaded .text.equals(\"newstyle\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=4, name="Use numeric interface to load a list of AuditEntities", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_4(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        AuditEntity obj = this.__DomainCreatorsFactory.createAuditEntity_onDB("oldstyle1", __manMapSession);
        AuditEntity obj1 = this.__DomainCreatorsFactory.createAuditEntity_onDB("oldstyle2", __manMapSession);
        AuditEntity obj2 = this.__DomainCreatorsFactory.createAuditEntity_onDB("oldstyle3", __manMapSession);
        List<AuditEntity> objects = this.__DomainRepoCustomSql.findAllAuditEntities_numericInterface(null);
        int leftSide = ListSequence.fromList(objects).where(it -> it.getId() == obj.getId() || it.getId() == obj1.getId() || it.getId() == obj2.getId()).count();
        if (leftSide != (rightSide = 3)) {
            throw new OFXTestSuitException("'CustomSQL.Use numeric interface to load a list of AuditEntities':  objects .where.size == 3          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=5, name="Issue an update call in plain sql.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_5(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        AuditEntity obj = this.__DomainCreatorsFactory.createAuditEntity_onDB("inserted", __manMapSession);
        boolean leftSide = obj.getId() > 0;
        boolean bl = obj.getText().equals("inserted");
        obj.setText("plainsql");
        this.__DomainRepoCustomSql.updateTextInAuditEntityPlainSQL(obj, null);
        AuditEntity reloded = this.__DomainRepoCustomSql.findAuditEntitybyId_combinedSQL(obj.getId(), null);
        String operand = reloded.getText();
        String param0 = "plainsql";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'CustomSQL.Issue an update call in plain sql.':  reloded .text.equals(\"plainsql\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=6, name="Find AuditEntity plain sql with some params.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_6(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        AuditEntity obj = this.__DomainCreatorsFactory.createAuditEntity_onDB("params", __manMapSession);
        List<AuditEntity> reloaded = this.__DomainRepoCustomSql.findAuditEntitiesWithSomeParams(obj.getId(), obj.getZzCreatedAt(), obj.getOnOff(), null);
        int leftSide = ListSequence.fromList(reloaded).count();
        if (leftSide != (rightSide = 1)) {
            throw new OFXTestSuitException("'CustomSQL.Find AuditEntity plain sql with some params.':  reloaded .size == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        String operand = ((AuditEntity)((Object)ListSequence.fromList(reloaded).getElement(0))).getText();
        String param0 = "params";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'CustomSQL.Find AuditEntity plain sql with some params.':  reloaded .get.text.equals(\"params\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @OFXTestMethod(id=7, name="MapSELECT should report nice messages on errors.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_7(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        if (this.dbDesc.needsIdSelectPost()) {
            boolean __FailIn_catched = false;
            boolean __FailIn_text = true;
            RuntimeException __FailIn_origThrowable = null;
            Object messagesInProblems = "";
            try {
                this.__DomainRepoCustomSql.mapSelectError("DAN", null);
                return;
            }
            catch (RuntimeException ex) {
                __FailIn_origThrowable = ex;
                __FailIn_catched = true;
                messagesInProblems = ex.getMessage();
                __FailIn_text = false;
                if (messagesInProblems == null) {
                    messagesInProblems = "";
                }
                if (((String)messagesInProblems).contains("bad SQL grammar")) {
                    __FailIn_text = true;
                }
                messagesInProblems = (String)messagesInProblems + "\n";
                List allProblems = __manMapSession.getAndclearProblemState();
                for (IOFXProblem problem : allProblems) {
                    messagesInProblems = (String)messagesInProblems + problem.getSimpleUserText() + "\n";
                    if (!problem.getSimpleUserText().contains("bad SQL grammar")) continue;
                    __FailIn_text = true;
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                if (!__FailIn_catched && __FailIn_origThrowable == null) {
                    throw new OFXTestSuitException("'CustomSQL.MapSELECT should report nice messages on errors.': Fail In Exception RuntimeException was NOT catched!");
                }
                if (__FailIn_catched && !__FailIn_text) {
                    throw new OFXTestSuitException("'CustomSQL.MapSELECT should report nice messages on errors.': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + (String)messagesInProblems + " \n");
                }
                if (__FailIn_catched) return;
                throw new OFXTestSuitException("'CustomSQL.MapSELECT should report nice messages on errors.': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
            }
        }
        boolean __FailIn_catched = false;
        boolean __FailIn_text = true;
        RuntimeException __FailIn_origThrowable = null;
        Object messagesInProblems = "";
        try {
            this.__DomainRepoCustomSql.mapSelectError("DAN", null);
            return;
        }
        catch (RuntimeException ex) {
            __FailIn_origThrowable = ex;
            __FailIn_catched = true;
            messagesInProblems = ex.getMessage();
            __FailIn_text = false;
            if (messagesInProblems == null) {
                messagesInProblems = "";
            }
            if (((String)messagesInProblems).contains("ORA-00936")) {
                __FailIn_text = true;
            }
            messagesInProblems = (String)messagesInProblems + "\n";
            List allProblems = __manMapSession.getAndclearProblemState();
            for (IOFXProblem problem : allProblems) {
                messagesInProblems = (String)messagesInProblems + problem.getSimpleUserText() + "\n";
                if (!problem.getSimpleUserText().contains("ORA-00936")) continue;
                __FailIn_text = true;
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            if (!__FailIn_catched && __FailIn_origThrowable == null) {
                throw new OFXTestSuitException("'CustomSQL.MapSELECT should report nice messages on errors.': Fail In Exception RuntimeException was NOT catched!");
            }
            if (__FailIn_catched && !__FailIn_text) {
                throw new OFXTestSuitException("'CustomSQL.MapSELECT should report nice messages on errors.': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + (String)messagesInProblems + " \n");
            }
            if (__FailIn_catched) return;
            throw new OFXTestSuitException("'CustomSQL.MapSELECT should report nice messages on errors.': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @OFXTestMethod(id=8, name="MapUPDATE should report nice messages on errors.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_8(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        if (this.dbDesc.needsIdSelectPost()) {
            boolean __FailIn_catched = false;
            boolean __FailIn_text = true;
            RuntimeException __FailIn_origThrowable = null;
            Object messagesInProblems = "";
            try {
                this.__DomainRepoCustomSql.mapUpdateError("DAN", null);
                return;
            }
            catch (RuntimeException ex) {
                __FailIn_origThrowable = ex;
                __FailIn_catched = true;
                messagesInProblems = ex.getMessage();
                __FailIn_text = false;
                if (messagesInProblems == null) {
                    messagesInProblems = "";
                }
                if (((String)messagesInProblems).contains("bad SQL grammar")) {
                    __FailIn_text = true;
                }
                messagesInProblems = (String)messagesInProblems + "\n";
                List allProblems = __manMapSession.getAndclearProblemState();
                for (IOFXProblem problem : allProblems) {
                    messagesInProblems = (String)messagesInProblems + problem.getSimpleUserText() + "\n";
                    if (!problem.getSimpleUserText().contains("bad SQL grammar")) continue;
                    __FailIn_text = true;
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                if (!__FailIn_catched && __FailIn_origThrowable == null) {
                    throw new OFXTestSuitException("'CustomSQL.MapUPDATE should report nice messages on errors.': Fail In Exception RuntimeException was NOT catched!");
                }
                if (__FailIn_catched && !__FailIn_text) {
                    throw new OFXTestSuitException("'CustomSQL.MapUPDATE should report nice messages on errors.': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + (String)messagesInProblems + " \n");
                }
                if (__FailIn_catched) return;
                throw new OFXTestSuitException("'CustomSQL.MapUPDATE should report nice messages on errors.': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
            }
        }
        boolean __FailIn_catched = false;
        boolean __FailIn_text = true;
        RuntimeException __FailIn_origThrowable = null;
        Object messagesInProblems = "";
        try {
            this.__DomainRepoCustomSql.mapUpdateError("DAN", null);
            return;
        }
        catch (RuntimeException ex) {
            __FailIn_origThrowable = ex;
            __FailIn_catched = true;
            messagesInProblems = ex.getMessage();
            __FailIn_text = false;
            if (messagesInProblems == null) {
                messagesInProblems = "";
            }
            if (((String)messagesInProblems).contains("ORA-00971")) {
                __FailIn_text = true;
            }
            messagesInProblems = (String)messagesInProblems + "\n";
            List allProblems = __manMapSession.getAndclearProblemState();
            for (IOFXProblem problem : allProblems) {
                messagesInProblems = (String)messagesInProblems + problem.getSimpleUserText() + "\n";
                if (!problem.getSimpleUserText().contains("ORA-00971")) continue;
                __FailIn_text = true;
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            if (!__FailIn_catched && __FailIn_origThrowable == null) {
                throw new OFXTestSuitException("'CustomSQL.MapUPDATE should report nice messages on errors.': Fail In Exception RuntimeException was NOT catched!");
            }
            if (__FailIn_catched && !__FailIn_text) {
                throw new OFXTestSuitException("'CustomSQL.MapUPDATE should report nice messages on errors.': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + (String)messagesInProblems + " \n");
            }
            if (__FailIn_catched) return;
            throw new OFXTestSuitException("'CustomSQL.MapUPDATE should report nice messages on errors.': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
        }
    }

    @OFXTestMethod(id=9, name="MapUPDATE can be used also without return value.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_9(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        this.__DomainRepoCustomSql.mapUpdateWithoutReturnValue(null);
    }

    @OFXTestMethod(id=10, name="Query by all types for the 47000000 invoice", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_10(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        int leftSide = this.__DomainRepoCustomSqlNP.queryByAllTypes(47000000, "Invoice", new BigDecimal("60.0"), new LocalDate(2016, 9, 21), new DateTime(2016, 9, 21, 0, 0, 0, 0), Invoice_HeadState.STAT1, __manMapSession);
        if (leftSide != (rightSide = 1)) {
            throw new OFXTestSuitException("'CustomSQL.Query by all types for the 47000000 invoice': #RepoCustomSqlNP.queryByAllTypes(47000000, \"Invoice\", 60.0bd,  new_LocalDateFromServer ,  new_DateTimeFromServer , \"HeadState.stat1\") == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=11, name="Named Parameter Test - multiple named params used in query", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_11(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        int leftSide = this.__DomainRepoCustomSqlNP.namedParamTest(47000001, 8, __manMapSession);
        if (leftSide != (rightSide = 1)) {
            throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - multiple named params used in query': #RepoCustomSqlNP.namedParamTest(47000001, 8) == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=12, name="Named Parameter Test - Query by all types for the 47000000 invoice", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_12(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        int leftSide = this.__DomainRepoCustomSqlNP.queryByAllTypes(47000000, "Invoice", new BigDecimal("60.0"), new LocalDate(2016, 9, 21), new DateTime(2016, 9, 21, 0, 0, 0, 0), Invoice_HeadState.STAT1, __manMapSession);
        if (leftSide != (rightSide = 1)) {
            throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - Query by all types for the 47000000 invoice': #RepoCustomSqlNP.queryByAllTypes(47000000, \"Invoice\", 60.0bd,  new_LocalDateFromServer ,  new_DateTimeFromServer , \"HeadState.stat1\") == 1          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=13, name="Named Parameter Test - INSERT invoice with MapUPDATE", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_13(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        int key = this.__DomainRepoCustomSqlNP.insertInvoice(__manMapSession);
        int leftSide = key;
        if (leftSide <= (rightSide = 0)) {
            throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - INSERT invoice with MapUPDATE':  key  > 0          ==>>" + leftSide + " >" + rightSide + "\n");
        }
        Invoice inv = this.__DomainRepoInvoice.checkoutInvoiceByIdWithoutRefs(key, __manMapSession);
        Invoice_HeadState operand = inv.getHeadState();
        if (!SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)operand, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{Invoice_HeadState.STAT2})) {
            throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - INSERT invoice with MapUPDATE':  inv .headState of stat2           ==>>" + operand + "\n");
        }
    }

    @OFXTestMethod(id=14, name="Named Parameter Test - UPDATE invoice with MapUPDATE", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_14(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        BigDecimal rightSide;
        int key2 = this.__DomainRepoCustomSqlNP.insertInvoice(__manMapSession);
        this.__DomainRepoCustomSqlNP.updateInvoice(key2, __manMapSession);
        Invoice inv = this.__DomainRepoInvoice.checkoutInvoiceByIdWithoutRefs(key2, __manMapSession);
        Object operand = inv.getHeadState();
        if (!SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)operand, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{Invoice_HeadState.STAT2})) {
            throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - UPDATE invoice with MapUPDATE':  inv .headState of stat2           ==>>" + (IOFXMetaStatus.IOFXStatusElement)operand + "\n");
        }
        operand = inv.getText();
        String param0 = "some text";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!((String)operand).equals(param0)) {
            throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - UPDATE invoice with MapUPDATE':  inv .text.equals(\"some text\")          ==>> '" + (String)operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = inv.getName();
        param0 = "some text 2";
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!((String)operand).equals(param0)) {
            throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - UPDATE invoice with MapUPDATE':  inv .name.equals(\"some text 2\")          ==>> '" + (String)operand + "'.equals(" + textRepresentation + ") \n");
        }
        BigDecimal leftSide = inv.getTotalAmount();
        if (leftSide.compareTo(rightSide = new BigDecimal("11.11")) != 0) {
            throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - UPDATE invoice with MapUPDATE':  inv .totalAmount == 11.11bd          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=15, name="Named Parameter Test - Check for escape of : when used in ''", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_15(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        int rightSide;
        DateTime t = this.__DomainRepoCustomSqlNP.checkForEscapeFeature(__manMapSession);
        int leftSide = t.compareTo((ReadableInstant)new DateTime(2015, 5, 15, 8, 30, 25, 0));
        if (leftSide != (rightSide = 0)) {
            throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - Check for escape of : when used in ''':  t .compareTo( new_DateTimeFromServer ) == 0          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=16, name="NPE from 22. Apr. 24''", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_16(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        this.__DomainRepoCustomSqlNP.checkForNPParameterNull(null, __manMapSession);
    }

    @OFXTestMethod(id=17, name="Named Parameter Test - with dynamic named parameters.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_17(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        BigDecimal rightSide;
        int key2 = this.__DomainRepoCustomSqlNP.insertInvoice(__manMapSession);
        this.__DomainRepoCustomSqlNP.updateInvoiceWithDynParams(key2, __manMapSession);
        Invoice inv = this.__DomainRepoInvoice.checkoutInvoiceByIdWithoutRefs(key2, __manMapSession);
        Object operand = inv.getHeadState();
        if (!SaveObjectComperator.equalsStatus((IOFXMetaStatus.IOFXStatusElement)operand, (IOFXMetaStatus.IOFXStatusElement[])new IOFXMetaStatus.IOFXStatusElement[]{Invoice_HeadState.STAT2})) {
            throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - with dynamic named parameters.':  inv .headState of stat2           ==>>" + (IOFXMetaStatus.IOFXStatusElement)operand + "\n");
        }
        operand = inv.getText();
        String param0 = "dyn params";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!((String)operand).equals(param0)) {
            throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - with dynamic named parameters.':  inv .text.equals(\"dyn params\")          ==>> '" + (String)operand + "'.equals(" + textRepresentation + ") \n");
        }
        operand = inv.getName();
        param0 = "dyn params 2";
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!((String)operand).equals(param0)) {
            throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - with dynamic named parameters.':  inv .name.equals(\"dyn params 2\")          ==>> '" + (String)operand + "'.equals(" + textRepresentation + ") \n");
        }
        BigDecimal leftSide = inv.getTotalAmount();
        if (leftSide.compareTo(rightSide = new BigDecimal("27.80")) != 0) {
            throw new OFXTestSuitException("'CustomSQL.Named Parameter Test - with dynamic named parameters.':  inv .totalAmount == 27.80bd          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
    }

    public static void main(String[] args) {
        String[] allIncludedTest = new String[]{"org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit"};
        String[] includedTestToRun = new String[]{};
        OFXTestSuit.runAsMain((String)"org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", CustomSQL.class, (String[])allIncludedTest, (String[])includedTestToRun);
    }
}

