/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.delegates;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.stage.Popup;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.dataux.runtime.delegates.ReferenceDelegate;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import org.modellwerkstatt.fx8forms.windows.FX8Application;
import org.modellwerkstatt.fx8forms.windows.FX8TraversalHelper;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;

public class AutoCompletePopupField
extends TextField {
    private Popup popup = new Popup();
    private ListView<String> listView = new ListView();
    private List<String> items;
    private boolean textChangeListenerEnabled = true;
    private IDataUxDelegate delegate;
    private boolean issueBoundEvent = false;
    private boolean optionalAlso = false;
    protected boolean issueUpdateConclusion = false;
    protected String lastItemIssuedUpdate = null;
    protected boolean provideHintEnabled = false;
    protected String provideHintLast = "";

    public AutoCompletePopupField() {
        this.listView.setPrefWidth(450.0);
        this.listView.setPrefHeight(170.0);
        this.listView.setOrientation(Orientation.VERTICAL);
        this.popup.getContent().add(this.listView);
        this.popup.addEventFilter(KeyEvent.ANY, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                boolean checkIssueUpdateOrTraverse = false;
                if (keyEvent.getCode().equals((Object)KeyCode.ESCAPE)) {
                    keyEvent.consume();
                    if (keyEvent.getEventType().equals(KeyEvent.KEY_RELEASED)) {
                        AutoCompletePopupField.this.popup.hide();
                    }
                } else if ((keyEvent.getCode().equals((Object)KeyCode.ENTER) || keyEvent.getCode().equals((Object)KeyCode.TAB)) && keyEvent.getEventType().equals(KeyEvent.KEY_RELEASED)) {
                    AutoCompletePopupField.this.ll("popup.EventListener", "ENTER");
                    boolean found = AutoCompletePopupField.this.showCompletionAndBindIfPossible(false, true, (String)AutoCompletePopupField.this.listView.getSelectionModel().getSelectedItem());
                    if (AutoCompletePopupField.this.provideHintEnabled && !found) {
                        AutoCompletePopupField.this.provideHint();
                    } else if (!AutoCompletePopupField.this.popup.isShowing()) {
                        keyEvent.consume();
                        AutoCompletePopupField.this.traverseOrIssueUpdateConc();
                    }
                }
            }
        });
        this.addEventFilter(KeyEvent.ANY, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.TAB && keyEvent.getEventType().equals(KeyEvent.KEY_PRESSED) && !keyEvent.isShiftDown()) {
                    AutoCompletePopupField.this.showCompletionAndBindIfPossible(false, true, null);
                    if (!AutoCompletePopupField.this.popup.isShowing()) {
                        keyEvent.consume();
                        AutoCompletePopupField.this.traverseOrIssueUpdateConc();
                    }
                } else if (keyEvent.getCode() == KeyCode.ENTER && keyEvent.getEventType().equals(KeyEvent.KEY_PRESSED)) {
                    AutoCompletePopupField.this.ll("Text Key ", "ENTER " + AutoCompletePopupField.this.getItem());
                    AutoCompletePopupField.this.showCompletionAndBindIfPossible(false, true, null);
                    if (!AutoCompletePopupField.this.popup.isShowing()) {
                        keyEvent.consume();
                        AutoCompletePopupField.this.traverseOrIssueUpdateConc();
                    }
                } else if (keyEvent.getCode() == KeyCode.SPACE && keyEvent.getEventType().equals(KeyEvent.KEY_PRESSED) && keyEvent.isControlDown()) {
                    AutoCompletePopupField.this.ll("keyEventFilter.ANY", "crtl space pressed.");
                    keyEvent.consume();
                    boolean found = AutoCompletePopupField.this.showCompletionAndBindIfPossible(true, false, null);
                    if (AutoCompletePopupField.this.provideHintEnabled) {
                        if (AutoCompletePopupField.this.specificItemSelected()) {
                            AutoCompletePopupField.this.setText(AutoCompletePopupField.this.provideHintLast);
                        }
                        AutoCompletePopupField.this.provideHint();
                    }
                } else if (keyEvent.getCode() == KeyCode.A && keyEvent.getEventType().equals(KeyEvent.KEY_PRESSED) && (keyEvent.isControlDown() || keyEvent.isMetaDown())) {
                    AutoCompletePopupField.this.selectAll();
                } else if (FX8Application.FX8_IS_HOTKEY_TO_FORWARD(keyEvent.getCode().getName(), false) && AutoCompletePopupField.this.getScene() != null) {
                    AutoCompletePopupField.this.getScene().getOnKeyPressed().handle((Event)keyEvent);
                }
            }
        });
        this.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (AutoCompletePopupField.this.textChangeListenerEnabled) {
                    if (newValue.length() == 0) {
                        AutoCompletePopupField.this.popup.hide();
                    } else {
                        AutoCompletePopupField.this.showCompletionAndBindIfPossible(false, false, null);
                    }
                }
            }
        });
        this.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                AutoCompletePopupField.this.ll("this.focusProperty", "focus changed to " + newValue);
                if (!newValue.booleanValue()) {
                    AutoCompletePopupField.this.showCompletionAndBindIfPossible(false, true, null);
                    if (AutoCompletePopupField.this.popup.isShowing()) {
                        AutoCompletePopupField.this.popup.hide();
                    }
                    AutoCompletePopupField.this.checkDelegateIsInputValid();
                }
            }
        });
        this.listView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> value, Object oldValue, Object newValue) {
                AutoCompletePopupField.this.ll("listView.getSelectedModel()", "from '" + oldValue + "' to '" + newValue + "'");
                if (newValue == null || oldValue == null) {
                    AutoCompletePopupField.this.ll("listView.getSelectedModel()", "SKIPPED setting item to " + newValue);
                } else {
                    AutoCompletePopupField.this.setItem((String)newValue);
                }
            }
        });
        this.listView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent p0) {
                AutoCompletePopupField.this.ll("listView.setOnMouseClick()", "calling setItem() next.. ");
                AutoCompletePopupField.this.setItem((String)AutoCompletePopupField.this.listView.getSelectionModel().getSelectedItem());
                AutoCompletePopupField.this.popup.hide();
                AutoCompletePopupField.this.traverseOrIssueUpdateConc();
            }
        });
        this.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent p0) {
                AutoCompletePopupField.this.ll("this.setOnMouseClick", "" + p0);
                AutoCompletePopupField.this.showCompletionAndBindIfPossible(true, false, null);
            }
        });
        this.items = ListSequence.fromList(new ArrayList());
    }

    protected void provideHint() {
        String textHint;
        this.provideHintLast = textHint = this.getText();
        this.ll("provideHint", " issuing a hint updated for <" + textHint + ">");
        ((ReferenceDelegate)this.delegate).setHintForScope(textHint);
        this.lastItemIssuedUpdate = null;
        this.delegate.issueUpdateConclusionAfterContentChange();
        this.setText(textHint);
        this.ll("provideHint", "HINT UPDATE DONE");
    }

    private void traverseOrIssueUpdateConc() {
        String item = this.getItem();
        boolean sameItem = SaveObjectComperator.equals((Object)item, (Object)this.lastItemIssuedUpdate);
        this.ll("traverseOrIssueUpdateConc", " with item " + item + " is same " + sameItem);
        if (this.isIssueUpdate() && !sameItem) {
            if (this.delegate.isInputValid() == null && !this.isDisabled()) {
                this.lastItemIssuedUpdate = item;
                this.delegate.issueUpdateConclusionAfterContentChange();
            }
        } else {
            FX8TraversalHelper.traverseNext((Node)this);
        }
    }

    public void newObjectBound() {
        this.lastItemIssuedUpdate = null;
    }

    public void setDelegate(IDataUxDelegate dlgt) {
        this.delegate = dlgt;
    }

    public void checkDelegateIsInputValid() {
        if (this.delegate != null) {
            this.delegate.isInputValid();
        }
    }

    private void populateMenu(List<String> items) {
        this.ll("populateMenu", "");
        this.listView.getItems().clear();
        for (String result : items) {
            this.listView.getItems().add((Object)result);
        }
        if (this.listView.getItems().size() > 0) {
            this.listView.getSelectionModel().select(0);
        }
        if (!this.popup.isShowing() && this.getScene() != null) {
            Bounds pos = this.localToScreen(this.getBoundsInLocal());
            this.popup.show(this.getScene().getWindow(), pos.getMinX(), pos.getMaxY());
        }
        this.popup.requestFocus();
    }

    public void setItems(List<String> items) {
        this.items = items;
    }

    private boolean specificItemSelected() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.getText().toLowerCase().equals(this.items.get(i).toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public String getItem() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.getText().toLowerCase().equals(this.items.get(i).toLowerCase())) continue;
            return this.items.get(i);
        }
        this.ll("getItem", "clearing text");
        this.setText("");
        return null;
    }

    public void setItem(String item) {
        this.ll("setItem", "setting item to " + item);
        this.textChangeListenerEnabled = false;
        boolean found = false;
        if (item == null) {
            this.setText("");
        } else {
            for (int i = 0; i < this.items.size(); ++i) {
                if (!item.toLowerCase().equals(this.items.get(i).toLowerCase())) continue;
                this.setText(this.items.get(i));
                this.selectAll();
                this.checkDelegateIsInputValid();
                found = true;
                break;
            }
            if (!found && this.items.size() > 0) {
                String error = "'" + item + "' not in reference scope (len " + this.items.size() + "). programming error.";
                this.setText(error);
                throw new RuntimeException(error);
            }
            if (!found) {
                this.setText(item);
                this.selectAll();
                this.checkDelegateIsInputValid();
            }
        }
        if (this.issueBoundEvent && (found || item == null && this.optionalAlso)) {
            this.delegate.keyReleasedEvent();
        }
        this.textChangeListenerEnabled = true;
    }

    public List<String> filterItems(String searchText) {
        searchText = searchText.toLowerCase();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i).toLowerCase().equals(searchText)) {
                result.clear();
                result.add(this.items.get(i));
                break;
            }
            if (!this.items.get(i).toLowerCase().contains(searchText)) continue;
            result.add(this.items.get(i));
        }
        return result;
    }

    public boolean showCompletionAndBindIfPossible(boolean all, boolean focusChanged, String hint) {
        String text = this.getText().trim();
        if (text.trim().equals("")) {
            all = true;
        }
        List<String> results = all ? this.items : this.filterItems(text);
        if (hint != null && results.contains(hint)) {
            results = new ArrayList<String>();
            results.add(hint);
        }
        this.ll("showCompletionAndBindIfPossible", "results now " + results.size() + ", all " + all + ", focusChanged " + focusChanged);
        boolean itemFound = false;
        if (focusChanged && results.size() == 1) {
            itemFound = true;
            this.setItem(results.get(0));
            if (this.popup.isShowing()) {
                this.popup.hide();
            }
        } else if (!focusChanged) {
            this.populateMenu(results);
        }
        return itemFound;
    }

    public void issueBoundEvent() {
        this.issueBoundEvent = true;
    }

    public void setOptional(boolean opt) {
        this.optionalAlso = opt;
    }

    public void setIssueUpdate() {
        this.issueUpdateConclusion = true;
    }

    public boolean isIssueUpdate() {
        return this.issueUpdateConclusion;
    }

    public void setLastItemIssuedUpdate(String x) {
        this.lastItemIssuedUpdate = x;
    }

    public String getLastItemIssuedUpdate() {
        return this.lastItemIssuedUpdate;
    }

    public void setProvideHint() {
        this.provideHintEnabled = true;
    }

    public void ll(String m, String desc) {
    }
}

