/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.delegates;

import java.util.Map;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_DateOrTimeEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.fx8forms.delegates.DatePatternField;
import org.modellwerkstatt.fx8forms.delegates.FX8TextEditor;
import org.modellwerkstatt.fx8forms.windows.FX8Application;
import org.modellwerkstatt.fx8forms.windows.FX8TraversalHelper;

public class FX8DateAndTimeEditor
extends HBox
implements IToolkit_DateOrTimeEditor,
EventHandler<KeyEvent> {
    private IDataUxDelegate delegate;
    protected Label label;
    private DatePatternField dateField = new DatePatternField();
    private DatePatternField timeField = new DatePatternField("__:__", ':', new char[]{',', '.'});
    private Node complexRightPart;
    private Button updateConclusionButton;
    protected boolean issueUpdateConclusion = false;
    protected String lastTextIssuedUpdate = null;

    public FX8DateAndTimeEditor() {
        this.label = new Label();
        this.label.getStyleClass().add((Object)"delegateLabel");
        this.label.setLabelFor((Node)this);
        this.label.setAlignment(Pos.TOP_RIGHT);
        this.getChildren().addAll((Object[])new Node[]{this.dateField, this.timeField});
        this.complexRightPart = this;
        this.label.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() == 2 && event.getButton().equals((Object)MouseButton.PRIMARY)) {
                    ClipboardContent allContent = new ClipboardContent();
                    allContent.putString(FX8DateAndTimeEditor.this.getText());
                    Clipboard.getSystemClipboard().setContent((Map)allContent);
                }
            }
        });
        this.dateField.addEventFilter(KeyEvent.KEY_PRESSED, this);
        this.timeField.addEventFilter(KeyEvent.KEY_PRESSED, this);
    }

    public void enableKeyReleaseEvents() {
        throw new RuntimeException("KeyReleaseEvents are not supported for FX8DateTimeEditor.");
    }

    public void setValidationErrorText(String text) {
        if (text == null || text.trim().equals("")) {
            this.setStyle("-fx-border-color: -error-red; -fx-border-width: 0;");
            this.dateField.setTooltip(null);
            this.timeField.setTooltip(null);
        } else {
            this.setStyle("-fx-border-color: -error-red; -fx-border-width: 1;");
            this.dateField.setTooltip(new Tooltip(text));
            this.timeField.setTooltip(new Tooltip(text));
        }
    }

    public void newObjectBound() {
        this.lastTextIssuedUpdate = null;
    }

    public void setText(String text) {
        if ("".equals(text)) {
            this.dateField.setText("");
            this.timeField.setText("");
        } else {
            int splitPoint = text.lastIndexOf(" ");
            String date = text.substring(0, splitPoint);
            String time = text.substring(splitPoint + 1);
            this.dateField.setText(date);
            this.timeField.setText(time);
        }
    }

    public String getText() {
        return (this.dateField.getTextOrEmpty() + " " + this.timeField.getTextOrEmpty()).trim();
    }

    public void handle(KeyEvent event) {
        Control sender = (Control)event.getSource();
        if (FX8Application.FX8_IS_HOTKEY_TO_FORWARD(event.getCode().getName(), false) && this.dateField.getScene() != null) {
            this.dateField.getScene().getOnKeyPressed().handle((Event)event);
        } else if (event.getCode() == KeyCode.TAB && !event.isShiftDown() || event.getCode() == KeyCode.ENTER) {
            event.consume();
            if (sender.equals((Object)this.dateField)) {
                FX8TraversalHelper.traverseNext((Node)sender);
            } else if (this.issueUpdateConclusion && !this.getText().equals(this.lastTextIssuedUpdate) && !this.dateField.isDisabled()) {
                if (this.delegate.isInputValid() == null) {
                    this.lastTextIssuedUpdate = this.getText();
                    this.delegate.issueUpdateConclusionAfterContentChange();
                }
            } else {
                FX8TraversalHelper.traverseNext((Node)sender);
            }
        } else if (event.getCode() == KeyCode.TAB && event.isShiftDown()) {
            event.consume();
            FX8TraversalHelper.traversePrevious((Node)sender);
        }
    }

    public void setIssuesUpdateConclusion() {
        this.updateConclusionButton = FX8TextEditor.createUpdateButton();
        this.updateConclusionButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent p0) {
                if (FX8DateAndTimeEditor.this.delegate.isInputValid() == null) {
                    FX8DateAndTimeEditor.this.lastTextIssuedUpdate = FX8DateAndTimeEditor.this.getText();
                    FX8DateAndTimeEditor.this.delegate.issueUpdateConclusionAfterContentChange();
                }
            }
        });
        this.getChildren().add((Object)this.updateConclusionButton);
        this.issueUpdateConclusion = true;
    }

    public void setLabelTooltip(String text) {
        this.label.setTooltip(new Tooltip(text));
    }

    public void setEditorPrompt(String promptText) {
        if (promptText.contains(" ")) {
            String[] splitted = promptText.trim().split("\\s+");
            this.dateField.setPromptText(splitted[0]);
            this.timeField.setPromptText(splitted[1]);
        }
    }

    public void setLabel(String labelString) {
        this.label.setText(FX8TextEditor.getLabelTextAdjustColon(labelString));
        this.label.setMinWidth(FX8TextEditor.getLabelWidthWRKRND(labelString));
    }

    public void setEnabled(boolean enabled) {
        this.dateField.setDisable(!enabled);
        this.timeField.setDisable(!enabled);
        if (this.updateConclusionButton != null) {
            this.updateConclusionButton.setDisable(!enabled);
        }
    }

    public boolean isOnlyDateChars(String st) {
        for (int i = 0; i < st.length(); ++i) {
            if (st.charAt(i) == '.' || Character.isDigit(st.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void setDelegate(IDataUxDelegate dlgt) {
        this.delegate = dlgt;
    }

    public Object getEditor() {
        return this;
    }

    public Object getLabel() {
        return this.label;
    }

    public Object getRightPartComponent() {
        return this.complexRightPart;
    }

    public void requestFocus() {
        this.dateField.requestFocus();
    }

    public void setOption(IToolkit_TextEditor.Option ... option) {
    }

    public void setFormatter(String format, String locale, int langIdx) {
    }

    public void gcClear() {
        this.dateField.removeEventFilter(KeyEvent.KEY_PRESSED, this);
        this.timeField.removeEventFilter(KeyEvent.KEY_PRESSED, this);
        this.dateField = null;
        this.timeField = null;
    }
}

