/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.delegates;

import java.io.FileInputStream;
import java.io.InputStream;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_ImageEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.fx8forms.delegates.FX8TextEditor;
import org.modellwerkstatt.fx8forms.windows.FX8CmdUiBasis;

public class FX8ImageEditor
implements IToolkit_ImageEditor {
    private ImageView imageView = new ImageView();
    protected Label label = new Label();
    protected IDataUxDelegate delegate;
    protected int pxlToSubstractY = 200;
    protected int pxlToSubstractX = 200;
    protected double imageHeight;
    protected double imageWidth;

    public FX8ImageEditor() {
        this.label.getStyleClass().add((Object)"delegateLabel");
        this.label.setLabelFor((Node)this.imageView);
        this.label.setAlignment(Pos.TOP_RIGHT);
    }

    public void setDelegate(IDataUxDelegate dlgt) {
        this.delegate = dlgt;
    }

    public void enableKeyReleaseEvents() {
    }

    public void setLabelTooltip(String text) {
        this.label.setTooltip(new Tooltip(text));
    }

    public void setValidationErrorText(String text) {
    }

    public void setLabel(String text) {
        this.label.setText(FX8TextEditor.getLabelTextAdjustColon(text));
        this.label.setMinWidth(FX8TextEditor.getLabelWidthWRKRND(text));
    }

    public void setEnabled(boolean enabled) {
    }

    public void newObjectBound() {
    }

    public void setText(String text) {
        if (text == null || text.trim().equals("")) {
            return;
        }
        try {
            FileInputStream in = new FileInputStream(text);
            Image image = new Image((InputStream)in);
            this.imageView.setImage(image);
            this.imageView.setPreserveRatio(true);
            in.close();
            this.imageHeight = image.getHeight();
            this.imageWidth = image.getWidth();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public double getPreservedImageWidthToHeight(double toHeight) {
        return toHeight / this.imageHeight * this.imageWidth;
    }

    public void adjustImageSize() {
        if (this.imageView.getScene() == null) {
            FX8CmdUiBasis.runRealyLater(new Runnable(){

                @Override
                public void run() {
                    FX8ImageEditor.this.adjustImageSize();
                }
            });
        } else {
            double spaceWidth = this.imageView.getScene().getWidth() - (double)this.pxlToSubstractX;
            double spaceHeight = this.imageView.getScene().getHeight() - (double)this.pxlToSubstractY;
            double neededWidth = this.getPreservedImageWidthToHeight(spaceHeight);
            if (neededWidth > spaceWidth) {
                this.imageView.setFitWidth(spaceWidth);
            } else {
                this.imageView.setFitHeight(spaceHeight);
            }
        }
    }

    public String getText() {
        return "";
    }

    public Object getEditor() {
        return this.imageView;
    }

    public Object getLabel() {
        return this.label;
    }

    public Object getRightPartComponent() {
        return this.getEditor();
    }

    public void setIssuesUpdateConclusion() {
    }

    public void setEditorPrompt(String promptText) {
        String[] xySplit = promptText.split(",");
        String xVal = xySplit[0].trim();
        String yVal = xySplit[1].trim();
        this.pxlToSubstractX = Integer.valueOf(xVal);
        this.pxlToSubstractY = Integer.valueOf(yVal);
    }

    public void setSubtractWidth(int pxl) {
        this.pxlToSubstractX = pxl;
    }

    public void setSubtractHeight(int pxl) {
        this.pxlToSubstractY = pxl;
    }

    public void setOption(IToolkit_TextEditor.Option ... option) {
    }

    public void gcClear() {
    }
}

