/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.delegates;

import java.util.Map;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.text.Text;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.fx8forms.delegates.DatePatternField;
import org.modellwerkstatt.fx8forms.delegates.FX8EditorWithOptions;
import org.modellwerkstatt.fx8forms.windows.FX8Application;
import org.modellwerkstatt.fx8forms.windows.FX8TraversalHelper;
import org.modellwerkstatt.fx8forms.windows.FX8UiFactory;

public class FX8TextEditor
extends FX8EditorWithOptions
implements IToolkit_TextEditor,
EventHandler<KeyEvent> {
    public static final int DELEGATE_EDITOR_MINHEIGH = 26;
    protected TextField textField;
    protected Button updateButton;
    protected Node complexRightPart;
    protected Label label = new Label();
    protected IDataUxDelegate delegate;
    protected boolean notifyDelegateOnKeyPress = false;
    protected boolean issueUpdateConclusion = false;
    protected String lastTextIssuedUpdate = null;
    protected EventHandler<KeyEvent> keyReleaseHandler;

    public FX8TextEditor(boolean dateEditor) {
        this.label.getStyleClass().add((Object)"delegateLabel");
        this.label.setLabelFor((Node)this.textField);
        this.label.setAlignment(Pos.TOP_RIGHT);
        if (!dateEditor) {
            this.textField = new TextField();
            this.textField.getStyleClass().add((Object)"delegateControl");
            this.textField.setMinHeight(26.0);
        } else {
            this.textField = new DatePatternField();
            this.textField.getStyleClass().add((Object)"delegateControl");
            this.textField.setMinHeight(26.0);
        }
        this.complexRightPart = this.textField;
        this.textField.setMinWidth(100.0);
        this.label.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() == 2 && event.getButton().equals((Object)MouseButton.PRIMARY)) {
                    ClipboardContent allContent = new ClipboardContent();
                    allContent.putString(FX8TextEditor.this.textField.getText());
                    Clipboard.getSystemClipboard().setContent((Map)allContent);
                }
            }
        });
        this.keyReleaseHandler = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent p0) {
                if (!FX8TextEditor.this.textField.isDisabled() && FX8TextEditor.this.textField.getText().contains("\u20ac")) {
                    int pos = FX8TextEditor.this.textField.getCaretPosition();
                    FX8TextEditor.this.textField.setText(FX8TextEditor.this.textField.getText().replace("\u20ac", "EUR"));
                    FX8TextEditor.this.textField.positionCaret(pos + 2);
                }
                if (FX8TextEditor.this.notifyDelegateOnKeyPress && FX8TextEditor.this.delegate.isInputValid() == null) {
                    FX8TextEditor.this.delegate.keyReleasedEvent();
                }
            }
        };
        this.textField.setOnKeyReleased(this.keyReleaseHandler);
        this.textField.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)this);
    }

    public void handle(KeyEvent event) {
        if (FX8Application.FX8_IS_HOTKEY_TO_FORWARD(event.getCode().getName(), false) && this.textField.getScene() != null) {
            this.textField.getScene().getOnKeyPressed().handle((Event)event);
        } else if (event.getCode() == KeyCode.TAB && !event.isShiftDown() || event.getCode() == KeyCode.ENTER) {
            event.consume();
            if (this.issueUpdateConclusion && !this.textField.getText().equals(this.lastTextIssuedUpdate)) {
                if (this.delegate.isInputValid() == null && !this.textField.isDisabled()) {
                    this.lastTextIssuedUpdate = this.textField.getText();
                    this.delegate.issueUpdateConclusionAfterContentChange();
                }
            } else {
                FX8TraversalHelper.traverseNext((Node)this.textField);
            }
        } else if (event.getCode() == KeyCode.TAB && event.isShiftDown()) {
            event.consume();
            FX8TraversalHelper.traversePrevious((Node)this.textField);
        }
    }

    public void setDelegate(IDataUxDelegate dlgt) {
        this.delegate = dlgt;
        if (this.textField instanceof DatePatternField) {
            ((DatePatternField)this.textField).setDelegate(this.delegate);
        }
    }

    public void enableKeyReleaseEvents() {
        this.notifyDelegateOnKeyPress = true;
    }

    public void setLabelTooltip(String t) {
        this.label.setTooltip(new Tooltip(t));
    }

    public void setValidationErrorText(String text) {
        if (text == null || text.trim().equals("")) {
            this.textField.setStyle("-fx-border-color: -error-red; -fx-border-width: 0;");
            this.textField.setTooltip(null);
        } else {
            this.textField.setStyle("-fx-border-color: -error-red; -fx-border-width: 1;");
            this.textField.setTooltip(new Tooltip(text));
        }
    }

    public void setLabel(String labelString) {
        this.label.setText(FX8TextEditor.getLabelTextAdjustColon(labelString));
        this.label.setMinWidth(FX8TextEditor.getLabelWidthWRKRND(labelString));
    }

    public void setEnabled(boolean enabled) {
        if (this.updateButton != null) {
            this.updateButton.setDisable(!enabled);
        }
        this.textField.setDisable(!enabled);
    }

    public void newObjectBound() {
        this.lastTextIssuedUpdate = null;
    }

    public void setText(String text) {
        this.textField.setText(text);
    }

    public String getText() {
        if (this.textField instanceof DatePatternField) {
            return ((DatePatternField)this.textField).getTextOrEmpty();
        }
        return this.textField.getText();
    }

    public static Button createUpdateButton() {
        Image img = new Image(FX8UiFactory.getImage("autorenew"));
        Button btn = new Button();
        btn.setFocusTraversable(false);
        btn.setGraphic((Node)new ImageView(img));
        btn.setPadding(new Insets(4.0, 5.0, 4.0, 5.0));
        return btn;
    }

    public void setIssuesUpdateConclusion() {
        HBox box = new HBox();
        this.updateButton = FX8TextEditor.createUpdateButton();
        this.updateButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent p0) {
                if (FX8TextEditor.this.delegate.isInputValid() == null) {
                    FX8TextEditor.this.lastTextIssuedUpdate = FX8TextEditor.this.textField.getText();
                    FX8TextEditor.this.delegate.issueUpdateConclusionAfterContentChange();
                }
            }
        });
        box.getChildren().addAll((Object[])new Node[]{this.textField, this.updateButton});
        HBox.setHgrow((Node)this.textField, (Priority)Priority.ALWAYS);
        this.complexRightPart = box;
        this.issueUpdateConclusion = true;
    }

    public Object getEditor() {
        return this.textField;
    }

    public Object getLabel() {
        return this.label;
    }

    public Object getRightPartComponent() {
        return this.complexRightPart;
    }

    public void setEditorPrompt(String promptText) {
        this.textField.setPromptText(promptText);
    }

    public void gcClear() {
        this.textField.setOnKeyReleased(null);
        this.textField.removeEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)this);
    }

    public static String getLabelTextAdjustColon(String label) {
        if (label.trim().equals("")) {
            return "";
        }
        return label + ": ";
    }

    public static double getLabelWidthWRKRND(String labelString) {
        double width;
        try {
            Text text = new Text(labelString + "XX");
            text.snapshot(null, null);
            width = text.getLayoutBounds().getWidth();
        }
        catch (Throwable t) {
            width = 100.0;
        }
        if (width > 100.0) {
            return width;
        }
        return 100.0;
    }
}

