/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.windows;

import java.util.List;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.dataux.runtime.genspecifications.AbstractAction;
import org.modellwerkstatt.dataux.runtime.genspecifications.CmdAction;
import org.modellwerkstatt.dataux.runtime.genspecifications.Menu;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_EnableItem;
import org.modellwerkstatt.fx8forms.windows.FX8Application;
import org.modellwerkstatt.fx8forms.windows.FX8Button;
import org.modellwerkstatt.fx8forms.windows.FX8UiFactory;

public class FX8ActionHBox
extends HBox {
    private List<CmdAction> cmdTrgs;

    public FX8ActionHBox(Menu folder, ContextMenu cm) {
        this.setAlignment(Pos.BASELINE_RIGHT);
        this.getStyleClass().add((Object)"conclusionButtonBox");
        this.getStyleClass().add((Object)"FX8ConclusionButtonsBox");
        List confs = folder.getAllItems();
        for (AbstractAction currentItem : confs) {
            FX8Button b;
            if (currentItem instanceof CmdAction) {
                final CmdAction trigger = (CmdAction)currentItem;
                b = new FX8Button(trigger.labelText, trigger.getToolTip());
                b.getStyleClass().add((Object)"FX8StatusButton");
                b.setGraphic((Node)new ImageView(new Image(FX8UiFactory.getImage("label_white"))));
                b.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent p0) {
                        b.setDisable(true);
                        trigger.startCommand();
                    }
                });
                trigger.attachButton1((IToolkit_EnableItem)b);
                this.getChildren().add((Object)b);
                continue;
            }
            if (currentItem.labelText == null) continue;
            Image img = new Image(FX8UiFactory.getImage("menu"));
            b = new MenuButton(currentItem.labelText, (Node)new ImageView(img));
            b.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
            FX8Application.createMenuStructure((ObservableList<MenuItem>)b.getItems(), (Menu)currentItem, false);
            this.getChildren().add((Object)b);
            if (cm == null) continue;
            FX8Application.createMenuStructure((ObservableList<MenuItem>)cm.getItems(), (Menu)currentItem, true);
        }
        this.cmdTrgs = folder.getAllCmdActionsOfMenu();
    }

    public void hotKeyReceived(KeyEvent event) {
        String key = event.getCode().getName().toUpperCase();
        for (CmdAction action : this.cmdTrgs) {
            if (!key.equals(action.hotKey)) continue;
            event.consume();
            if (action.reevalEnabled()) {
                action.startCommand();
            }
            return;
        }
    }

    public void doubleClickReceived() {
        for (CmdAction action : this.cmdTrgs) {
            if (!"ENTER".equals(action.hotKey) || !action.reevalEnabled()) continue;
            action.startCommand();
        }
    }

    public void gcClear() {
        ListSequence.fromList(this.cmdTrgs).visitAll(it -> it.gcClear());
    }
}

