/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.windows;

import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.dataux.runtime.core.ConclusionEvent;
import org.modellwerkstatt.dataux.runtime.core.ICommandContainer;
import org.modellwerkstatt.dataux.runtime.core.UxEvent;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;
import org.modellwerkstatt.fx8forms.windows.FX8Button;
import org.modellwerkstatt.fx8forms.windows.FX8CmdUiPrompt;
import org.modellwerkstatt.fx8forms.windows.FX8NotificationPane;
import org.modellwerkstatt.fx8forms.windows.FX8UiFactory;
import org.modellwerkstatt.objectflow.runtime.OFXConclusionInformation;

public class FX8CmdUiBasis
extends BorderPane {
    private static String CONCLUCION_BUTTON_BOX = "FX8ConclusionButtonsBox";
    protected HBox rightbuttonBoxPane;
    protected HBox leftbuttonBoxPane;
    protected ICommandContainer commandContainer;
    protected List<FX8Button> conclusionButtons = ListSequence.fromList(new ArrayList());
    protected BorderPane buttonBorder;
    protected BorderPane colorPane;
    protected FX8NotificationPane notificationPane = new FX8NotificationPane();

    public FX8CmdUiBasis() {
        this.rightbuttonBoxPane = new HBox();
        this.leftbuttonBoxPane = new HBox();
        this.rightbuttonBoxPane.getStyleClass().add((Object)CONCLUCION_BUTTON_BOX);
        this.leftbuttonBoxPane.getStyleClass().add((Object)CONCLUCION_BUTTON_BOX);
        this.rightbuttonBoxPane.setAlignment(Pos.CENTER_RIGHT);
        this.leftbuttonBoxPane.setAlignment(Pos.CENTER_LEFT);
        this.rightbuttonBoxPane.spacingProperty().set(10.0);
        this.leftbuttonBoxPane.spacingProperty().set(10.0);
        this.buttonBorder = new BorderPane();
        this.buttonBorder.setRight((Node)this.rightbuttonBoxPane);
        this.buttonBorder.setLeft((Node)this.leftbuttonBoxPane);
        this.notificationPane.onClose(new Runnable(){

            @Override
            public void run() {
                FX8CmdUiBasis.this.colorPane.setTop(null);
            }
        });
        this.setBottom((Node)this.buttonBorder);
        this.colorPane = new BorderPane();
        this.setTop((Node)this.colorPane);
    }

    public void gcClear() {
        this.commandContainer = null;
        ListSequence.fromList(this.conclusionButtons).visitAll(it -> {
            it.setOnAction(null);
            it.setOnKeyPressed(null);
        });
        ListSequence.fromList(this.conclusionButtons).clear();
        this.conclusionButtons = null;
    }

    public void setCommandContainer(ICommandContainer cmdContainer) {
        this.commandContainer = cmdContainer;
    }

    public void setConclusions(List<OFXConclusionInformation> conclusionInformations, List<String> additionalHotkeys) {
        this.rightbuttonBoxPane.getChildren().clear();
        this.leftbuttonBoxPane.getChildren().clear();
        ListSequence.fromList(this.conclusionButtons).visitAll(it -> it.setOnAction(null));
        ListSequence.fromList(this.conclusionButtons).visitAll(it -> it.setOnKeyPressed(null));
        ListSequence.fromList(this.conclusionButtons).clear();
        for (int i = 0; i < conclusionInformations.size(); ++i) {
            final OFXConclusionInformation it2 = conclusionInformations.get(i);
            if (!"".equals(it2.hotkey)) {
                it2.buttonTitle = it2.buttonTitle + " (" + it2.hotkey + ")";
            }
            FX8Button newButton = new FX8Button(it2.buttonTitle, it2.buttonTitle);
            if (!"".equals(it2.iconName)) {
                Image img = new Image(FX8UiFactory.getImage(it2.iconName));
                ImageView imgView = new ImageView(FX8CmdUiBasis.blackImgWorkaround(img, it2.iconName));
                newButton.setGraphic((Node)imgView);
            }
            newButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent p0) {
                    if (!FX8CmdUiBasis.this.isAlreadyClosedAndGcClean()) {
                        FX8CmdUiBasis.this.commandContainer.receiveAndProcess((UxEvent)new ConclusionEvent(it2.conclusionHashCode, it2.buttonTitle));
                    }
                }
            });
            if ("UPD".equals(it2.hotkey)) {
                newButton.setVisible(false);
            }
            if (this instanceof FX8CmdUiPrompt) {
                newButton.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent p0) {
                        if (!FX8CmdUiBasis.this.isAlreadyClosedAndGcClean() && p0.getCode().equals((Object)KeyCode.ENTER)) {
                            FX8CmdUiBasis.this.commandContainer.receiveAndProcess((UxEvent)new ConclusionEvent(it2.conclusionHashCode, it2.buttonTitle));
                        }
                    }
                });
            }
            ListSequence.fromList(this.conclusionButtons).addElement((Object)newButton);
            if (i == 0) {
                this.leftbuttonBoxPane.getChildren().add((Object)newButton);
                continue;
            }
            this.rightbuttonBoxPane.getChildren().add((Object)newButton);
        }
    }

    public void reevalConclusions(List<OFXConclusionInformation> conclusionInformations) {
        for (int i = 0; i < ListSequence.fromList(this.conclusionButtons).count(); ++i) {
            ((FX8Button)((Object)ListSequence.fromList(this.conclusionButtons).getElement(i))).setItemEnabled(conclusionInformations.get((int)i).enabled);
        }
    }

    public void setColor(String color) {
        this.colorPane.setStyle("-fx-border-width: 3 0 0 0; -fx-border-color: " + color + "; -fx-border-insets: 1 0 0 0;");
    }

    public void setNotification(String notificat) {
        this.notificationPane.setText(notificat);
        this.colorPane.setTop((Node)this.notificationPane);
    }

    public boolean isAlreadyClosedAndGcClean() {
        return this.commandContainer == null;
    }

    public void delayedRequestFocus() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ((IToolkit_Form)FX8CmdUiBasis.this.getCenter()).myRequestFocus();
            }
        });
    }

    public void delayedAfterFullUiInitialized() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ((IToolkit_Form)FX8CmdUiBasis.this.getCenter()).afterFullUiInitialized();
            }
        });
    }

    public static void runRealyLater(final Runnable r) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1500L);
                    Platform.runLater((Runnable)r);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        });
        t.start();
    }

    public static Image blackImgWorkaround(Image img, String imgName) {
        String[] NO_CONVERT = new String[]{"ok_white", "nopic", "label_white", "autorenew", "arrow_back"};
        boolean found = false;
        for (String candidate : NO_CONVERT) {
            if (!candidate.toLowerCase().equals(imgName.toLowerCase())) continue;
            found = true;
            break;
        }
        if (found) {
            return img;
        }
        PixelReader reader = img.getPixelReader();
        int w = (int)img.getWidth();
        int h = (int)img.getHeight();
        WritableImage wImage = new WritableImage(w, h);
        PixelWriter writer = wImage.getPixelWriter();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                Color color = reader.getColor(x, y);
                writer.setColor(x, y, color.invert());
            }
        }
        return wImage;
    }
}

