/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.windows;

import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.util.Callback;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.fx8forms.windows.FX8TreeItem;
import org.modellwerkstatt.fx8forms.windows.MoFX8TreeIntroPrinter;
import org.modellwerkstatt.objectflow.services.MoStringIntroPrinter;

public class FX8GraphDebuggerFactory {
    private FX8TreeItem rootNode;

    public TreeTableView<String> createGraphAndCrtlInfo(List<Object> graph, String crtlInfo) {
        this.rootNode = new FX8TreeItem("list<?>");
        this.rootNode.setExpanded(true);
        for (int i = 0; i < ListSequence.fromList(graph).count(); ++i) {
            MoFX8TreeIntroPrinter tip = new MoFX8TreeIntroPrinter(ListSequence.fromList(graph).getElement(i));
            this.rootNode.addNode(tip.getNodeForObject());
        }
        TreeTableColumn col1 = new TreeTableColumn("Graph");
        col1.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<String, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TreeTableColumn.CellDataFeatures<String, String> p) {
                return p.getValue().valueProperty();
            }
        });
        TreeTableColumn col2 = new TreeTableColumn("Warnings");
        col2.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<String, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TreeTableColumn.CellDataFeatures<String, String> p) {
                return ((FX8TreeItem)p.getValue()).getWarning();
            }
        });
        TreeTableView ttv = new TreeTableView((TreeItem)this.rootNode);
        ttv.getColumns().add((Object)col1);
        ttv.getColumns().add((Object)col2);
        col1.prefWidthProperty().bind((ObservableValue)ttv.widthProperty().multiply(0.68));
        col2.prefWidthProperty().bind((ObservableValue)ttv.widthProperty().multiply(0.28));
        ttv.setShowRoot(true);
        System.err.println("\n\n\n* * * * * * * * *                      FX8 Selection Crtl Info                      * * * * * * * * *\n" + crtlInfo + "\n\n\n");
        return ttv;
    }

    public String createGraphAndCrtlInfoAsString(List<Object> graph, String crtlInfo) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ListSequence.fromList(graph).count(); ++i) {
            MoStringIntroPrinter sip = new MoStringIntroPrinter(ListSequence.fromList(graph).getElement(i));
            sb.append(sip.printGraph());
        }
        sb.append("\n\n\n");
        sb.append(crtlInfo);
        return sb.toString();
    }
}

