/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.windows;

import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_EnableItem;

public class FX8TileButton
extends Button
implements IToolkit_EnableItem {
    private String hotkeyLabel;

    public FX8TileButton(Image image, String text, String tooltip, String hl, String col) {
        super(text, (Node)new ImageView(image));
        this.setup(tooltip, hl, col);
    }

    public FX8TileButton(String text, String tooltip, String hl, String col) {
        super(text);
        this.setup(tooltip, hl, col);
    }

    private void setup(String tooltip, String hl, String col) {
        this.hotkeyLabel = hl;
        if (tooltip != null && !"".equals(tooltip)) {
            super.setTooltip(new Tooltip(tooltip));
        }
        this.getStyleClass().add((Object)"FX8TilePaneButton");
        if (col != null) {
            this.setStyle("-fx-border-color:" + col + "; -fx-text-fill: " + col + ";");
        }
        this.setPrefWidth(400.0);
        if (this.hotkeyLabel != null) {
            this.setText(this.getText() + "    (" + this.hotkeyLabel + ")");
        }
    }

    public void updateTitle(String t) {
        if (this.hotkeyLabel != null) {
            this.setText(t + "    (" + this.hotkeyLabel + ")");
        } else {
            this.setText(t);
        }
    }

    public void setItemEnabled(boolean enabled) {
        this.setDisabled(!enabled);
    }
}

