/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.windows;

import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.SequentialTransition;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Duration;

public class FX8ToastPrompt {
    protected Stage toastStage = new Stage(StageStyle.TRANSPARENT);
    protected Scene toastScene;
    protected Label toastLabel;
    protected double width;
    protected double height;

    public FX8ToastPrompt(Stage parentStage) {
        this.toastStage.initOwner((Window)parentStage);
        double parentWidth = parentStage.getWidth();
        double parentHeight = parentStage.getHeight();
        this.width = 600.0;
        if (parentWidth < 600.0) {
            this.width = parentWidth;
        }
        this.height = 50.0;
        this.toastStage.setWidth(this.width);
        this.toastStage.setHeight(this.height);
        this.toastStage.setX(parentStage.getX() + (parentStage.getWidth() - this.width) / 2.0);
        this.toastStage.setY(parentStage.getScene().getY() + parentStage.getY() + parentStage.getScene().getRoot().getLayoutY());
        this.toastLabel = new Label();
        this.toastLabel.getStyleClass().add((Object)"FX8ToastLabel");
        this.toastLabel.setPrefWidth(this.width);
        this.toastLabel.setWrapText(true);
        this.toastLabel.setTextAlignment(TextAlignment.JUSTIFY);
        this.toastScene = new Scene((Parent)this.toastLabel);
        this.toastStage.setScene(this.toastScene);
    }

    public void showMessage(String msg) {
        this.toastLabel.setText(msg.replaceAll("\n", ""));
        this.toastStage.show();
        this.toastStage.getScene().getRoot().opacityProperty().set(0.0);
        Timeline fadeIn = new Timeline();
        KeyFrame key0 = new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{new KeyValue((WritableValue)this.toastStage.getScene().getRoot().opacityProperty(), (Object)1.0)});
        fadeIn.getKeyFrames().add((Object)key0);
        Timeline constant = new Timeline();
        KeyFrame key = new KeyFrame(Duration.millis((double)1500.0), new KeyValue[]{new KeyValue((WritableValue)this.toastStage.getScene().getRoot().opacityProperty(), (Object)1.0)});
        constant.getKeyFrames().add((Object)key);
        Timeline fadeOut = new Timeline();
        KeyFrame key2 = new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{new KeyValue((WritableValue)this.toastStage.getScene().getRoot().opacityProperty(), (Object)0.0)});
        fadeOut.getKeyFrames().add((Object)key2);
        constant.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent p0) {
                FX8ToastPrompt.this.toastStage.close();
            }
        });
        SequentialTransition st = new SequentialTransition(new Animation[]{fadeIn, constant, fadeOut});
        st.play();
    }

    public Stage getStage() {
        return this.toastStage;
    }
}

