/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.fx8forms.windows;

import org.modellwerkstatt.fx8forms.windows.FX8TreeItem;
import org.modellwerkstatt.objectflow.runtime.OFXBigDecimal;
import org.modellwerkstatt.objectflow.runtime.OFXDateTime;
import org.modellwerkstatt.objectflow.runtime.OFXInteger;
import org.modellwerkstatt.objectflow.runtime.OFXKeyReference;
import org.modellwerkstatt.objectflow.runtime.OFXList;
import org.modellwerkstatt.objectflow.runtime.OFXLocalDate;
import org.modellwerkstatt.objectflow.runtime.OFXStatus;
import org.modellwerkstatt.objectflow.runtime.OFXString;
import org.modellwerkstatt.objectflow.runtime.OFXVPBase;
import org.modellwerkstatt.objectflow.runtime.OFXValueObject;
import org.modellwerkstatt.objectflow.sdservices.ILgcyGraphPrinter;
import org.modellwerkstatt.objectflow.sdservices.LgcyGraphIntrospector;
import org.modellwerkstatt.objectflow.services.IMoTNode;

public class MoFX8TreeIntroPrinter
implements ILgcyGraphPrinter {
    private LgcyGraphIntrospector introspector = new LgcyGraphIntrospector();
    private IMoTNode objNode;
    private Object rootObject;

    public MoFX8TreeIntroPrinter(Object rootObj) {
        this.rootObject = rootObj;
    }

    public void handleIntro(String indent, String objectName, String simpleFields) {
        this.objNode = new FX8TreeItem(objectName + "  (" + simpleFields + ")");
    }

    public void handleInteger(String indent, String fieldname, OFXInteger value, boolean isKey) {
        this.objNode.addNode(fieldname + ": " + value.getValue());
    }

    public void handleBigDecimal(String indent, String fieldname, OFXBigDecimal value, boolean isKey) {
        this.objNode.addNode(fieldname + ": " + value.getValue());
    }

    public void handleString(String indent, String fieldname, OFXString value, boolean isKey) {
        this.objNode.addNode(fieldname + ": " + value.getValue());
    }

    public void handleLocalDate(String indent, String fieldname, OFXLocalDate value) {
        this.objNode.addNode(fieldname + ": " + value.getValue());
    }

    public void handleDateTime(String indent, String fieldname, OFXDateTime value) {
        this.objNode.addNode(fieldname + ": " + value.getValue());
    }

    public void handleStatus(String indent, String fieldname, OFXStatus ofStatus, boolean isKey) {
        try {
            String longText = "null";
            if (ofStatus.getValue() != null) {
                longText = ofStatus.getValue().getLongDesc();
            }
            this.objNode.addNode(fieldname + ": " + longText);
        }
        catch (RuntimeException ex) {
            IMoTNode node = this.objNode.addNode(fieldname + ": " + ofStatus.getValue());
            node.setWarning("Can not get long Text for value '" + ofStatus.getValue() + "'. Status not known!");
        }
    }

    public void handleKefReference(String indent, String fieldname, OFXKeyReference value) {
        IMoTNode currentRoot = this.objNode;
        IMoTNode subSection = this.objNode.addNode(fieldname + " (Reference): Key:" + value.getKey() + "\n");
        if (!value.getOpposite() && value.isInitialized()) {
            this.introspector.introspectionPrint("", (Object)value.getValue(), (ILgcyGraphPrinter)this);
            subSection.addNode(this.objNode);
        }
        this.objNode = currentRoot;
    }

    public void handleValueObject(String indent, String fieldname, OFXValueObject value, boolean isKey) {
        IMoTNode currentRoot = this.objNode;
        IMoTNode subSection = this.objNode.addNode(fieldname + " (ValueObject): \n");
        this.introspector.introspectionPrint("", value.getValue(), (ILgcyGraphPrinter)this);
        subSection.addNode(this.objNode);
        this.objNode = currentRoot;
    }

    public void handleList(String indent, String fieldname, OFXList value) {
        IMoTNode currentRoot = this.objNode;
        if (value.getValue() == null) {
            this.objNode.addNode(fieldname + " (List): NULL !!\n");
        } else {
            IMoTNode subSection = this.objNode.addNode(fieldname + " (List):\n");
            for (Object obj : value.getValue()) {
                this.introspector.introspectionPrint("", obj, (ILgcyGraphPrinter)this);
                subSection.addNode(this.objNode);
            }
        }
        this.objNode = currentRoot;
    }

    public void handleVirtualProperty(String indent, String fieldname, OFXVPBase meta, Object value, boolean isKey) {
        this.objNode.addNode(fieldname + " (Virt.Prop.) " + value + "\n");
    }

    public void handleOutro() {
    }

    public FX8TreeItem getNodeForObject() {
        try {
            this.introspector.introspectionPrint("", this.rootObject, (ILgcyGraphPrinter)this);
        }
        catch (StackOverflowError err) {
            try {
                this.introspector.noteKeyAndListFieldNames();
                this.introspector.introspectionPrint("", this.rootObject, (ILgcyGraphPrinter)this);
            }
            catch (StackOverflowError stackOverflowError) {
                // empty catch block
            }
            String allListFieldNames = this.introspector.getKeyAndListCycleInfo();
            throw new RuntimeException("StackOverflowError - running in cycle on lists/references?\n\n\n" + allListFieldNames + "\n\n\n\n", err);
        }
        return (FX8TreeItem)this.objNode;
    }
}

