/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.manmap.runtime;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.modellwerkstatt.manmap.runtime.IM3TypeHandler;

public class MMJodaLocalDateTypeHandler
implements IM3TypeHandler<LocalDate> {
    @Override
    public LocalDate getResult(ResultSet resultSet, int colIndex) throws SQLException {
        Timestamp t = resultSet.getTimestamp(colIndex);
        if (t == null) {
            return null;
        }
        return new LocalDate(t.getTime());
    }

    @Override
    public LocalDate getResult(ResultSet resultSet, String colName) throws SQLException {
        Timestamp t = resultSet.getTimestamp(colName);
        if (t == null) {
            return null;
        }
        return new LocalDate(t.getTime());
    }

    @Override
    public void setParameter(PreparedStatement preparedStatement, int parameterInder, LocalDate object, StringBuilder debugSb) throws SQLException {
        if (debugSb != null) {
            debugSb.append(parameterInder + ": " + object + "\n");
        }
        if (object != null) {
            DateTime datetime = new DateTime(object.getYear(), object.getMonthOfYear(), object.getDayOfMonth(), 0, 0, 0, 0);
            Timestamp t = new Timestamp(datetime.getMillis());
            preparedStatement.setTimestamp(parameterInder, t);
        } else {
            preparedStatement.setTimestamp(parameterInder, null);
        }
    }

    @Override
    public boolean isNullRef(LocalDate t) {
        throw new RuntimeException("Not implemented.");
    }
}

