/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.manmap.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.modellwerkstatt.manmap.runtime.IM3NamedParameter;

public class MMNamedParameterSupport {
    private static final String PARAMETER_SEPARATORS = "\"':&,;()|=+-*%/\\<>^]";
    private static final boolean[] separatorIndex = new boolean[128];
    private static final String[] START_SKIP;
    private static final String[] STOP_SKIP;

    public static int posOf(String name, String ... listOfNames) {
        int i = 0;
        for (String a : listOfNames) {
            if (name.equals(a)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isParameterSeperator(char c) {
        return c < '\u0080' && separatorIndex[c] || Character.isWhitespace(c);
    }

    public static List<String> retrievFieldsFromSqlStatement(String sql) {
        ArrayList<String> fields = new ArrayList<String>();
        char[] statement = sql.toCharArray();
        for (int i = 0; i < statement.length; ++i) {
            int paramEnd;
            int skipToPosition = i;
            while (i < statement.length && i != (skipToPosition = MMNamedParameterSupport.skipCommentsAndQuotes(statement, i))) {
                i = skipToPosition;
            }
            if (i >= statement.length) break;
            char c = statement[i];
            if (c != ':') continue;
            String parameter = null;
            for (paramEnd = i + 1; paramEnd < statement.length && !MMNamedParameterSupport.isParameterSeperator(statement[paramEnd]); ++paramEnd) {
            }
            if (paramEnd - i <= 1) {
                throw new RuntimeException("Can not handle misspecified Parameter after ':' at position " + i);
            }
            parameter = sql.substring(i + 1, paramEnd);
            fields.add(parameter);
            i = paramEnd - 1;
        }
        return fields;
    }

    public static int[] parseSqlStatementWithNpOrSimpleIntArray(String sql, IM3NamedParameter ... allParams) {
        if (allParams.length == 0) {
            return new int[0];
        }
        boolean isNamed = allParams[0].isNamedParam();
        if (isNamed) {
            String[] paramNames = new String[allParams.length];
            for (int i = 0; i < allParams.length; ++i) {
                paramNames[i] = allParams[i].getName();
                if (allParams[i].isNamedParam()) continue;
                throw new RuntimeException("You can not mix named and regular params, first param was a named one, but this param num. " + i + " is not named.");
            }
            return MMNamedParameterSupport.parseSqlStatement(sql, paramNames);
        }
        int[] ascendingArray = new int[allParams.length];
        for (int i = 0; i < allParams.length; ++i) {
            ascendingArray[i] = i;
            if (!allParams[i].isNamedParam()) continue;
            throw new RuntimeException("You can not mix named and regular params, first param was a regular one, but this param num. " + i + " is named '" + allParams[i].getName());
        }
        return ascendingArray;
    }

    public static int[] parseSqlStatement(String sql, String ... allParameterNames) {
        ArrayList<Integer> paramPositions = new ArrayList<Integer>();
        List<String> namedParamsInSql = MMNamedParameterSupport.retrievFieldsFromSqlStatement(sql);
        for (String param : namedParamsInSql) {
            int paramIndex = MMNamedParameterSupport.posOf(param, allParameterNames);
            if (paramIndex < 0) {
                throw new RuntimeException("Parameter with name '" + param + "' not found in given named parameters " + Arrays.toString(allParameterNames));
            }
            paramPositions.add(paramIndex);
        }
        int[] retArry = new int[paramPositions.size()];
        for (int j = 0; j < paramPositions.size(); ++j) {
            retArry[j] = (Integer)paramPositions.get(j);
        }
        return retArry;
    }

    private static int skipCommentsAndQuotes(char[] statement, int position) {
        for (int i = 0; i < START_SKIP.length; ++i) {
            if (statement[position] != START_SKIP[i].charAt(0)) continue;
            boolean match = true;
            for (int j = 1; j < START_SKIP[i].length(); ++j) {
                if (statement[position + j] == START_SKIP[i].charAt(j)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            int offset = START_SKIP[i].length();
            for (int m = position + offset; m < statement.length; ++m) {
                if (statement[m] != STOP_SKIP[i].charAt(0)) continue;
                boolean endMatch = true;
                int endPos = m;
                for (int n = 1; n < STOP_SKIP[i].length(); ++n) {
                    if (m + n >= statement.length) {
                        return statement.length;
                    }
                    if (statement[m + n] != STOP_SKIP[i].charAt(n)) {
                        endMatch = false;
                        break;
                    }
                    endPos = m + n;
                }
                if (!endMatch) continue;
                return endPos + 1;
            }
            return statement.length;
        }
        return position;
    }

    static {
        for (char c : PARAMETER_SEPARATORS.toCharArray()) {
            MMNamedParameterSupport.separatorIndex[c] = true;
        }
        START_SKIP = new String[]{"'", "\"", "--", "/*"};
        STOP_SKIP = new String[]{"'", "\"", "\n", "*/"};
    }
}

