/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.tests.ObjectFlowInfra;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.OFXAbortedException;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.runtime.OFXIncludedSuit;
import org.modellwerkstatt.objectflow.runtime.OFXProblem;
import org.modellwerkstatt.objectflow.runtime.OFXStringFormatter2;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import org.modellwerkstatt.objectflow.runtime.OFXTestSuitException;
import org.modellwerkstatt.objectflow.tests.ObjectFlowInfra.PlatformService;
import org.modellwerkstatt.objectflow.tests.ObjectFlowInfra.SimpleService;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.AccountKey_Active;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.AuditEntity_OnOff;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.CreatorsFactory;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.Invoice;
import org.modellwerkstatt.objectflow.tests.manmap.Domain.InvoicePosition;
import org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit;
import org.modellwerkstatt.objectflow.testsuit.OFXTestSuit;
import org.springframework.beans.factory.annotation.Autowired;

public class Services
extends OFXTestSuit {
    @Autowired
    private SimpleService __ObjectFlowInfraSimpleService;
    @Autowired
    private CreatorsFactory __DomainCreatorsFactory;
    @Autowired
    private PlatformService __ObjectFlowInfraPlatformService;
    @Autowired
    private IOFXPlatform __runtimeIOFXPlatform;
    @Autowired
    private IOFXTranslationProvider __runtimeIOFXTranslationProvider;
    private DecimalFormat deziFormat = new DecimalFormat("#,##0.00");
    private String bigDeci10 = this.deziFormat.format(new BigDecimal("10.0"));
    private int DE = -1;
    private String NULL_STRING = "#NULL?";
    @Autowired
    private IOFXPlatform platform;
    @OFXIncludedSuit(name="org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit")
    private DBinit ___inst_DBinit;

    public void onStartup(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
    }

    @OFXTestMethod(id=0, name="OFXS_INSTANCE", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public IOFXTranslationProvider __testmethod_0(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        OFXStringFormatter2 frmt = new OFXStringFormatter2();
        frmt.setBigDecimalFormat("#,##0.00");
        frmt.setDateTimeFormat("dd.MM.yyyy hh:mm:ss");
        frmt.setTimeDateTimeFormat("hh:mm");
        frmt.setLocalDateFormat("dd.MM.yy");
        frmt.setShortLocalDateFormat("dd.MMM");
        frmt.afterPropertiesSet();
        return frmt;
    }

    @OFXTestMethod(id=1, name="Formatting not format chars at al", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_1(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        String toFormat;
        IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);
        String operand = toFormat = p.translate(this.DE, "Hello World", new Object[0]);
        String param0 = "Hello World";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'Services.Formatting not format chars at al':  toFormat .equals(\"Hello World\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=2, name="Format simple integer, string, decimal, float.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_2(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);
        String toFormat = p.translate(this.DE, "%d,%s,%f,%f", new Object[]{4711, "DAN", new BigDecimal("1.4711"), 1.0});
        String expected = String.format("%d,%s,%f,%f", 4711, "DAN", new BigDecimal("1.4711"), 1.0);
        String operand = toFormat;
        String param0 = expected;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'Services.Format simple integer, string, decimal, float.':  toFormat .equals( expected )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=3, name="Format simple integer, string, decimal, float with format specified", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_3(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);
        String toFormat = p.translate(this.DE, "%05d,%5s,%05.2f,%07.2f", new Object[]{4711, "DAN", new BigDecimal("1.4711"), 1.0});
        String expected = String.format("%05d,%5s,%05.2f,%07.2f", 4711, "DAN", new BigDecimal("1.4711"), 1.0);
        String operand = toFormat;
        String param0 = expected;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'Services.Format simple integer, string, decimal, float with format specified':  toFormat .equals( expected )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=4, name="Format simple float and bigDecimal with dynamic formatter", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_4(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);
        String toFormat = p.translate(this.DE, "DAN %07.3f == %07.3bd DAN %05.2bd DAN", new Object[]{new BigDecimal("1.4711"), new BigDecimal("1.4711"), new BigDecimal("1.4711")});
        String expected = String.format("DAN %07.3f == %07.3f DAN %05.2f DAN", new BigDecimal("1.4711"), new BigDecimal("1.4711"), new BigDecimal("1.4711"));
        String operand = toFormat;
        String param0 = expected;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'Services.Format simple float and bigDecimal with dynamic formatter':  toFormat .equals( expected )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=5, name="Format simple bigDecimal with default formatter", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_5(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);
        String toFormat = p.translate(this.DE, "DAN %bd DAN %bd", new Object[]{new BigDecimal("123456.4711"), new BigDecimal("12.4711")});
        String expected = "DAN 123.456,47 DAN 12,47";
        String operand = toFormat;
        String param0 = expected;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'Services.Format simple bigDecimal with default formatter':  toFormat .equals( expected )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=6, name="Format status, DB-Values, Short-, Long-Desc and nulls.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_6(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);
        String toFormat = p.translate(this.DE, "%stdb,%sts,%st,%stdb,%sts,%st", new Object[]{AuditEntity_OnOff.ON, AuditEntity_OnOff.ON, AuditEntity_OnOff.ON, null, null, null});
        String expected_BEFORE_REFACT_JULY23 = "ON,On_Short,On_Long,,,";
        String expected = "ON,On_Short,On_Long," + this.NULL_STRING + "," + this.NULL_STRING + "," + this.NULL_STRING;
        String operand = toFormat;
        String param0 = expected;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'Services.Format status, DB-Values, Short-, Long-Desc and nulls.':  toFormat .equals( expected )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=7, name="Applying Escape character to string formatter", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_7(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);
        String toFormat = p.translate(this.DE, "DAN%%DAN", new Object[0]);
        String expected = "DAN%DAN";
        String operand = toFormat;
        String param0 = expected;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'Services.Applying Escape character to string formatter':  toFormat .equals( expected )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=8, name="Applying Escape character to string formatter - more complex version.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_8(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);
        String toFormat = p.translate(this.DE, "%%%%%%%%DAN%%", new Object[0]);
        String expected = "%%%%DAN%";
        String operand = toFormat;
        String param0 = expected;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'Services.Applying Escape character to string formatter - more complex version.':  toFormat .equals( expected )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=9, name="Format LocalDate and DateTime with %dt", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_9(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);
        LocalDate currentDate = new LocalDate(1980, 1, 27);
        DateTime curTime = new DateTime(1980, 1, 27, 5, 30, 20, 0);
        String toFormat = p.translate(this.DE, "DAN%dtDAN%dtDAN", new Object[]{curTime, currentDate});
        String expected = "DAN27.01.1980 05:30:20DAN27.01.1980 \ufffd\ufffd:\ufffd\ufffd:\ufffd\ufffdDAN";
        String operand = toFormat;
        String param0 = expected;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'Services.Format LocalDate and DateTime with %dt':  toFormat .equals( expected )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=10, name="Format LocalDate and DateTime with %tdt", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_10(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);
        LocalDate currentDate = new LocalDate(1980, 1, 27);
        DateTime curTime = new DateTime(1980, 1, 27, 5, 30, 20, 0);
        String toFormat = p.translate(this.DE, "DAN%tdtDAN%tdtDAN", new Object[]{curTime, currentDate});
        String expected = "DAN05:30DAN\ufffd\ufffd:\ufffd\ufffdDAN";
        String operand = toFormat;
        String param0 = expected;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'Services.Format LocalDate and DateTime with %tdt':  toFormat .equals( expected )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=11, name="Format LocalDate and DateTime with %ld", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_11(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);
        LocalDate currentDate = new LocalDate(1980, 1, 27);
        DateTime curTime = new DateTime(1980, 1, 27, 5, 30, 20, 0);
        String toFormat = p.translate(this.DE, "DAN%ldDAN%ldDAN", new Object[]{curTime, currentDate});
        String expected = "DAN27.01.80DAN27.01.80DAN";
        String operand = toFormat;
        String param0 = expected;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'Services.Format LocalDate and DateTime with %ld':  toFormat .equals( expected )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=12, name="Format LocalDate and DateTime with %sld", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_12(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);
        LocalDate currentDate = new LocalDate(1980, 1, 27);
        DateTime curTime = new DateTime(1980, 1, 27, 5, 30, 20, 0);
        String toFormat = p.translate(this.DE, "DAN%sldDAN%sldDAN", new Object[]{curTime, currentDate});
        String expected = "DAN27.JanDAN27.JanDAN";
        String operand = toFormat;
        String param0 = expected;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'Services.Format LocalDate and DateTime with %sld':  toFormat .equals( expected )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=13, name="Force %d and %s instead of moware extensions starting with %s or %d.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_13(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);
        String toFormat = p.translate(this.DE, "DAN%0dtDAN%0stDAN", new Object[]{4711, "string"});
        String expected = "DAN4711tDANstringtDAN";
        String operand = toFormat;
        String param0 = expected;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'Services.Force %d and %s instead of moware extensions starting with %s or %d.':  toFormat .equals( expected )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=14, name="Rainy - sld with width and precission is taken as %s and will be checked.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_14(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        block12: {
            IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);
            LocalDate currentDate = new LocalDate(1980, 1, 27);
            DateTime curTime = new DateTime(1980, 1, 27, 5, 30, 20, 0);
            boolean __FailIn_catched = false;
            boolean __FailIn_text = true;
            RuntimeException __FailIn_origThrowable = null;
            Object messagesInProblems = "";
            try {
                String string = p.translate(this.DE, "DAN%2.0sldDAN%2.0sldDAN", new Object[]{curTime, currentDate});
            }
            catch (RuntimeException ex) {
                __FailIn_origThrowable = ex;
                __FailIn_catched = true;
                messagesInProblems = ex.getMessage();
                __FailIn_text = false;
                if (messagesInProblems == null) {
                    messagesInProblems = "";
                }
                if (((String)messagesInProblems).contains("but argument")) {
                    __FailIn_text = true;
                }
                messagesInProblems = (String)messagesInProblems + "\n";
                List allProblems = __manMapSession.getAndclearProblemState();
                for (IOFXProblem problem : allProblems) {
                    messagesInProblems = (String)messagesInProblems + problem.getSimpleUserText() + "\n";
                    if (!problem.getSimpleUserText().contains("but argument")) continue;
                    __FailIn_text = true;
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                if (!__FailIn_catched && __FailIn_origThrowable == null) {
                    throw new OFXTestSuitException("'Services.Rainy - sld with width and precission is taken as %s and will be checked.': Fail In Exception RuntimeException was NOT catched!");
                }
                if (__FailIn_catched && !__FailIn_text) {
                    throw new OFXTestSuitException("'Services.Rainy - sld with width and precission is taken as %s and will be checked.': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + (String)messagesInProblems + " \n");
                }
                if (__FailIn_catched) break block12;
                throw new OFXTestSuitException("'Services.Rainy - sld with width and precission is taken as %s and will be checked.': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
            }
        }
    }

    @OFXTestMethod(id=15, name="Rainy - tdt with width and precission is wrong.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_15(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        block12: {
            IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);
            LocalDate currentDate = new LocalDate(1980, 1, 27);
            DateTime curTime = new DateTime(1980, 1, 27, 5, 30, 20, 0);
            boolean __FailIn_catched = false;
            boolean __FailIn_text = true;
            RuntimeException __FailIn_origThrowable = null;
            Object messagesInProblems = "";
            try {
                String string = p.translate(this.DE, "DAN%2.0tdtDAN%2.0tdtDAN", new Object[]{curTime, currentDate});
            }
            catch (RuntimeException ex) {
                __FailIn_origThrowable = ex;
                __FailIn_catched = true;
                messagesInProblems = ex.getMessage();
                __FailIn_text = false;
                if (messagesInProblems == null) {
                    messagesInProblems = "";
                }
                if (((String)messagesInProblems).contains("unclear how we should handle")) {
                    __FailIn_text = true;
                }
                messagesInProblems = (String)messagesInProblems + "\n";
                List allProblems = __manMapSession.getAndclearProblemState();
                for (IOFXProblem problem : allProblems) {
                    messagesInProblems = (String)messagesInProblems + problem.getSimpleUserText() + "\n";
                    if (!problem.getSimpleUserText().contains("unclear how we should handle")) continue;
                    __FailIn_text = true;
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                if (!__FailIn_catched && __FailIn_origThrowable == null) {
                    throw new OFXTestSuitException("'Services.Rainy - tdt with width and precission is wrong.': Fail In Exception RuntimeException was NOT catched!");
                }
                if (__FailIn_catched && !__FailIn_text) {
                    throw new OFXTestSuitException("'Services.Rainy - tdt with width and precission is wrong.': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + (String)messagesInProblems + " \n");
                }
                if (__FailIn_catched) break block12;
                throw new OFXTestSuitException("'Services.Rainy - tdt with width and precission is wrong.': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
            }
        }
    }

    @OFXTestMethod(id=16, name="Rainy - argument forgotten", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_16(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        block12: {
            IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);
            boolean __FailIn_catched = false;
            boolean __FailIn_text = true;
            RuntimeException __FailIn_origThrowable = null;
            Object messagesInProblems = "";
            try {
                String string = p.translate(this.DE, "DAN%0dtDAN%0stDAN", new Object[]{4711});
            }
            catch (RuntimeException ex) {
                __FailIn_origThrowable = ex;
                __FailIn_catched = true;
                messagesInProblems = ex.getMessage();
                __FailIn_text = false;
                if (messagesInProblems == null) {
                    messagesInProblems = "";
                }
                if (((String)messagesInProblems).contains("Expecting to format argument 2 but we have only 1 in total")) {
                    __FailIn_text = true;
                }
                messagesInProblems = (String)messagesInProblems + "\n";
                List allProblems = __manMapSession.getAndclearProblemState();
                for (IOFXProblem problem : allProblems) {
                    messagesInProblems = (String)messagesInProblems + problem.getSimpleUserText() + "\n";
                    if (!problem.getSimpleUserText().contains("Expecting to format argument 2 but we have only 1 in total")) continue;
                    __FailIn_text = true;
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                if (!__FailIn_catched && __FailIn_origThrowable == null) {
                    throw new OFXTestSuitException("'Services.Rainy - argument forgotten': Fail In Exception RuntimeException was NOT catched!");
                }
                if (__FailIn_catched && !__FailIn_text) {
                    throw new OFXTestSuitException("'Services.Rainy - argument forgotten': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + (String)messagesInProblems + " \n");
                }
                if (__FailIn_catched) break block12;
                throw new OFXTestSuitException("'Services.Rainy - argument forgotten': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
            }
        }
    }

    @OFXTestMethod(id=17, name="Rainy - wrong argument (eg. for dt)", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_17(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        block12: {
            IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);
            boolean __FailIn_catched = false;
            boolean __FailIn_text = true;
            RuntimeException __FailIn_origThrowable = null;
            Object messagesInProblems = "";
            try {
                String string = p.translate(this.DE, "DAN%dtDAN%dtDAN", new Object[]{4711, 4711});
            }
            catch (RuntimeException ex) {
                __FailIn_origThrowable = ex;
                __FailIn_catched = true;
                messagesInProblems = ex.getMessage();
                __FailIn_text = false;
                if (messagesInProblems == null) {
                    messagesInProblems = "";
                }
                if (((String)messagesInProblems).contains("is required")) {
                    __FailIn_text = true;
                }
                messagesInProblems = (String)messagesInProblems + "\n";
                List allProblems = __manMapSession.getAndclearProblemState();
                for (IOFXProblem problem : allProblems) {
                    messagesInProblems = (String)messagesInProblems + problem.getSimpleUserText() + "\n";
                    if (!problem.getSimpleUserText().contains("is required")) continue;
                    __FailIn_text = true;
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                if (!__FailIn_catched && __FailIn_origThrowable == null) {
                    throw new OFXTestSuitException("'Services.Rainy - wrong argument (eg. for dt)': Fail In Exception RuntimeException was NOT catched!");
                }
                if (__FailIn_catched && !__FailIn_text) {
                    throw new OFXTestSuitException("'Services.Rainy - wrong argument (eg. for dt)': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + (String)messagesInProblems + " \n");
                }
                if (__FailIn_catched) break block12;
                throw new OFXTestSuitException("'Services.Rainy - wrong argument (eg. for dt)': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
            }
        }
    }

    @OFXTestMethod(id=18, name="Rainy - wrong argument (eg. for status)", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_18(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        block12: {
            IOFXTranslationProvider p = this.__testmethod_0(__manMapSession, __testSuitHandler);
            boolean __FailIn_catched = false;
            boolean __FailIn_text = true;
            RuntimeException __FailIn_origThrowable = null;
            Object messagesInProblems = "";
            try {
                String string = p.translate(this.DE, "DAN%stDAN%stDAN", new Object[]{4711, 4711});
            }
            catch (RuntimeException ex) {
                __FailIn_origThrowable = ex;
                __FailIn_catched = true;
                messagesInProblems = ex.getMessage();
                __FailIn_text = false;
                if (messagesInProblems == null) {
                    messagesInProblems = "";
                }
                if (((String)messagesInProblems).contains("is required")) {
                    __FailIn_text = true;
                }
                messagesInProblems = (String)messagesInProblems + "\n";
                List allProblems = __manMapSession.getAndclearProblemState();
                for (IOFXProblem problem : allProblems) {
                    messagesInProblems = (String)messagesInProblems + problem.getSimpleUserText() + "\n";
                    if (!problem.getSimpleUserText().contains("is required")) continue;
                    __FailIn_text = true;
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                if (!__FailIn_catched && __FailIn_origThrowable == null) {
                    throw new OFXTestSuitException("'Services.Rainy - wrong argument (eg. for status)': Fail In Exception RuntimeException was NOT catched!");
                }
                if (__FailIn_catched && !__FailIn_text) {
                    throw new OFXTestSuitException("'Services.Rainy - wrong argument (eg. for status)': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + (String)messagesInProblems + " \n");
                }
                if (__FailIn_catched) break block12;
                throw new OFXTestSuitException("'Services.Rainy - wrong argument (eg. for status)': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
            }
        }
    }

    @OFXTestMethod(id=19, name="Multistring - Print status", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_19(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        String s;
        String operand = s = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sts ok", new Object[]{AccountKey_Active.ON});
        String param0 = "On ok";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'Services.Multistring - Print status':  s .equals(\"On ok\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
        AuditEntity_OnOff status = AuditEntity_OnOff.ON;
        String operand2 = s = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sts ok", new Object[]{status});
        String param02 = "On_Short ok";
        StringBuilder textRepresentation2 = new StringBuilder();
        textRepresentation2.append(param02 + ", ");
        textRepresentation2.setLength(textRepresentation2.length() - 2);
        if (!operand2.equals(param02)) {
            throw new OFXTestSuitException("'Services.Multistring - Print status':  s .equals(\"On_Short ok\")          ==>> '" + operand2 + "'.equals(" + textRepresentation2 + ") \n");
        }
    }

    @OFXTestMethod(id=20, name="MultiString - Print BigDecimal.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_20(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        String s;
        String operand = s = this.__ObjectFlowInfraSimpleService.testInteger_String_BigDeci(10, "dan", new BigDecimal("10.0"), __manMapSession);
        String param0 = "   10   dan   " + this.bigDeci10 + "   ";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'Services.MultiString - Print BigDecimal.':  s .equals(\"   10   dan   \" +  bigDeci10  + \"   \")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=21, name="MultiString - Print BigDecimal with 4 f", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_21(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        String s;
        String operand = s = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%.4bd", new Object[]{new BigDecimal("10.999855")});
        String param0 = "10,9999";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'Services.MultiString - Print BigDecimal with 4 f':  s .equals(\"10,9999\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=22, name="MultiString - Print LocalDate and DateTime.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_22(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        String s = this.__ObjectFlowInfraSimpleService.testInteger_String_BigDeci_LocalDate_DateTime(10, "dan", new BigDecimal("10.0"), DeprecatedServerDateProvider.getSqlServerLocalDate(), DeprecatedServerDateProvider.getSqlServerDateTime(), __manMapSession);
        String shouldBe = "   10   dan   " + this.bigDeci10 + "   27.01.80   27.01.1980 04:30:00   ";
        String operand = s;
        String param0 = shouldBe;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'Services.MultiString - Print LocalDate and DateTime.':  s .equals( shouldBe )          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=23, name="MultiString - Print LocalDate and LocalDate.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_23(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        String s;
        String operand = s = this.__ObjectFlowInfraSimpleService.testInteger_String_BigDeci_LocalDate_Localdate(10, "dan", new BigDecimal("10.0"), DeprecatedServerDateProvider.getSqlServerLocalDate(), DeprecatedServerDateProvider.getSqlServerDateTime(), __manMapSession);
        String param0 = "   10   dan   " + this.bigDeci10 + "   27.01.80   27.01.80   ";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'Services.MultiString - Print LocalDate and LocalDate.':  s .equals(\"   10   dan   \" +  bigDeci10  + \"   27.01.80   27.01.80   \")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=24, name="MultiString - Used in OFXTestSuit itself.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_24(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Invoice inv1 = this.__DomainCreatorsFactory.createInvoiceGraphWith4Positions_onDB(this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "Hello %s %d", new Object[]{"Dan", 10}), __manMapSession);
        String operand = ((InvoicePosition)((Object)ListSequence.fromList(inv1.getPositions()).first())).getPosText();
        String param0 = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "Hello Dan 10_0", new Object[0]);
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'Services.MultiString - Used in OFXTestSuit itself.':  inv1 .positions.first.posText.equals('Hello Dan 10_0')          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
        inv1.setText(this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "Hello Wolfgang it is %dt", new Object[]{DeprecatedServerDateProvider.getSqlServerDateTime()}));
        operand = inv1.getText();
        param0 = "Hello Wolfgang it is 27.01.1980 04:30:00";
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'Services.MultiString - Used in OFXTestSuit itself.':  inv1 .text.equals(\"Hello Wolfgang it is 27.01.1980 04:30:00\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=25, name="MultiString - More complex string with string and decimal precission", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_25(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        String operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%06d = %s", new Object[]{4711, "4711"});
        String param0 = "004711 = 4711";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'Services.MultiString - More complex string with string and decimal precission': '%06d = %s'.equals(\"004711 = 4711\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=26, name="MultiString - More complex int with float precission", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_26(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        String operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%4d and %2.2f", new Object[]{4711, Float.valueOf(88.88f)});
        String param0 = String.format("%4d and %2.2f", 4711, Float.valueOf(88.88f));
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'Services.MultiString - More complex int with float precission': '%4d and %2.2f'.equals(String.format(\"%4d and %2.2f\", 4711,  floating point constant (float) ))          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=27, name="MultiString - More complex string with new line and int", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_27(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        String operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%06d%n", new Object[]{4711});
        String param0 = String.format("%06d%n", 4711);
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'Services.MultiString - More complex string with new line and int': '%06d%n'.equals(String.format(\"%06d%n\", 4711))          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=28, name="Check platform is handled correctly, running on Platform_1.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_28(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        block9: {
            boolean __FailIn_catched = false;
            boolean __FailIn_text = true;
            OFXAbortedException __FailIn_origThrowable = null;
            String messagesInProblems = "";
            try {
                this.__ObjectFlowInfraPlatformService.dependsOnPlatForm(__manMapSession);
            }
            catch (OFXAbortedException ex) {
                __FailIn_origThrowable = ex;
                __FailIn_catched = true;
                messagesInProblems = ex.getMessage();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                if (!__FailIn_catched && __FailIn_origThrowable == null) {
                    throw new OFXTestSuitException("'Services.Check platform is handled correctly, running on Platform_1.': Fail In Exception OFXAbortedException was NOT catched!");
                }
                if (__FailIn_catched && !__FailIn_text) {
                    throw new OFXTestSuitException("'Services.Check platform is handled correctly, running on Platform_1.': Fail In Exception OFXAbortedException catched but text not correct! Got instead: \n" + messagesInProblems + " \n");
                }
                if (__FailIn_catched) break block9;
                throw new OFXTestSuitException("'Services.Check platform is handled correctly, running on Platform_1.': Fail In Exception 'OFXAbortedException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
            }
        }
    }

    @OFXTestMethod(id=29, name="get platform and set platform. set platform forth and back.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_29(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        boolean rightSide;
        String currentPlatform = this.platform.getPlatformName();
        boolean leftSide = this.platform.isPlatform(currentPlatform, null);
        if (leftSide != (rightSide = true)) {
            throw new OFXTestSuitException("'Services.get platform and set platform. set platform forth and back.':  platform .isPlatform( currentPlatform ,  null ) == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        this.platform.setPlatformName("dan");
        leftSide = this.platform.isPlatform("dan", null);
        rightSide = true;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'Services.get platform and set platform. set platform forth and back.':  platform .isPlatform(\"dan\",  null ) == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
        this.platform.setPlatformName(currentPlatform);
        leftSide = this.platform.isPlatform(currentPlatform, null);
        rightSide = true;
        if (leftSide != rightSide) {
            throw new OFXTestSuitException("'Services.get platform and set platform. set platform forth and back.':  platform .isPlatform( currentPlatform ,  null ) == \"true\"          ==>>" + leftSide + " ==" + rightSide + "\n");
        }
    }

    @OFXTestMethod(id=30, name="Check Platform aware string handling.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_30(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        String st3;
        String st2;
        String st1;
        this.platform.setPlatformName("Default");
        String operand = st1 = this.__ObjectFlowInfraSimpleService.calcPlatformString(this.__localApplicationFactory.createNewSession(this.__userEnvironment, this.__userServices));
        String param0 = "Default Platform";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.equals(param0)) {
            throw new OFXTestSuitException("'Services.Check Platform aware string handling.':  st1 .equals(\"Default Platform\")          ==>> '" + operand + "'.equals(" + textRepresentation + ") \n");
        }
        this.platform.setPlatformName("Platform_2");
        String operand2 = st2 = this.__ObjectFlowInfraSimpleService.calcPlatformString(this.__localApplicationFactory.createNewSession(this.__userEnvironment, this.__userServices));
        String param02 = "Default";
        StringBuilder textRepresentation2 = new StringBuilder();
        textRepresentation2.append(param02 + ", ");
        textRepresentation2.setLength(textRepresentation2.length() - 2);
        if (!operand2.equals(param02)) {
            throw new OFXTestSuitException("'Services.Check Platform aware string handling.':  st2 .equals(\"Default\")          ==>> '" + operand2 + "'.equals(" + textRepresentation2 + ") \n");
        }
        this.platform.setPlatformName("Some Other Platform");
        String operand3 = st3 = this.__ObjectFlowInfraSimpleService.calcPlatformString(this.__localApplicationFactory.createNewSession(this.__userEnvironment, this.__userServices));
        String param03 = "Default";
        StringBuilder textRepresentation3 = new StringBuilder();
        textRepresentation3.append(param03 + ", ");
        textRepresentation3.setLength(textRepresentation3.length() - 2);
        if (!operand3.equals(param03)) {
            throw new OFXTestSuitException("'Services.Check Platform aware string handling.':  st3 .equals(\"Default\")          ==>> '" + operand3 + "'.equals(" + textRepresentation3 + ") \n");
        }
    }

    @OFXTestMethod(id=31, name="Some checks on Fail-In: RuntimeException with text.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_31(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        boolean __FailIn_catched = false;
        boolean __FailIn_text = true;
        RuntimeException __FailIn_origThrowable = null;
        Object messagesInProblems = "";
        try {
            throw new RuntimeException("Hello this is some text");
        }
        catch (RuntimeException ex) {
            __FailIn_origThrowable = ex;
            __FailIn_catched = true;
            messagesInProblems = ex.getMessage();
            __FailIn_text = false;
            if (messagesInProblems == null) {
                messagesInProblems = "";
            }
            if (((String)messagesInProblems).contains("some text")) {
                __FailIn_text = true;
            } else {
                messagesInProblems = (String)messagesInProblems + "\n";
                List allProblems = __manMapSession.getAndclearProblemState();
                for (IOFXProblem problem : allProblems) {
                    messagesInProblems = (String)messagesInProblems + problem.getSimpleUserText() + "\n";
                    if (!problem.getSimpleUserText().contains("some text")) continue;
                    __FailIn_text = true;
                    break;
                }
            }
            if (!__FailIn_catched && __FailIn_origThrowable == null) {
                throw new OFXTestSuitException("'Services.Some checks on Fail-In: RuntimeException with text.': Fail In Exception RuntimeException was NOT catched!");
            }
            if (__FailIn_catched && !__FailIn_text) {
                throw new OFXTestSuitException("'Services.Some checks on Fail-In: RuntimeException with text.': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + (String)messagesInProblems + " \n");
            }
            if (!__FailIn_catched) {
                throw new OFXTestSuitException("'Services.Some checks on Fail-In: RuntimeException with text.': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
            }
        }
        catch (Throwable t) {
            try {
                throw new RuntimeException(t);
            }
            catch (Throwable throwable) {
                if (!__FailIn_catched && __FailIn_origThrowable == null) {
                    throw new OFXTestSuitException("'Services.Some checks on Fail-In: RuntimeException with text.': Fail In Exception RuntimeException was NOT catched!");
                }
                if (__FailIn_catched && !__FailIn_text) {
                    throw new OFXTestSuitException("'Services.Some checks on Fail-In: RuntimeException with text.': Fail In Exception RuntimeException catched but text not correct! Got instead: \n" + (String)messagesInProblems + " \n");
                }
                if (!__FailIn_catched) {
                    throw new OFXTestSuitException("'Services.Some checks on Fail-In: RuntimeException with text.': Fail In Exception 'RuntimeException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
                }
                throw throwable;
            }
        }
    }

    @OFXTestMethod(id=32, name="Some checks on Fail-In: condition with text handled correctly.", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_32(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        boolean __FailIn_catched = false;
        boolean __FailIn_text = true;
        OFXAbortedException __FailIn_origThrowable = null;
        Object messagesInProblems = "";
        try {
            HashMap parameterMap = null;
            __manMapSession.addProblem((IOFXProblem)new OFXProblem(this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "Hello condtion some text.", new Object[0]), null, parameterMap, new IOFXProblem.Opt[0]));
            throw new OFXAbortedException();
        }
        catch (OFXAbortedException ex) {
            __FailIn_origThrowable = ex;
            __FailIn_catched = true;
            messagesInProblems = ex.getMessage();
            __FailIn_text = false;
            if (messagesInProblems == null) {
                messagesInProblems = "";
            }
            if (((String)messagesInProblems).contains("some text")) {
                __FailIn_text = true;
            } else {
                messagesInProblems = (String)messagesInProblems + "\n";
                List allProblems = __manMapSession.getAndclearProblemState();
                for (IOFXProblem problem : allProblems) {
                    messagesInProblems = (String)messagesInProblems + problem.getSimpleUserText() + "\n";
                    if (!problem.getSimpleUserText().contains("some text")) continue;
                    __FailIn_text = true;
                    break;
                }
            }
            if (!__FailIn_catched && __FailIn_origThrowable == null) {
                throw new OFXTestSuitException("'Services.Some checks on Fail-In: condition with text handled correctly.': Fail In Exception OFXAbortedException was NOT catched!");
            }
            if (__FailIn_catched && !__FailIn_text) {
                throw new OFXTestSuitException("'Services.Some checks on Fail-In: condition with text handled correctly.': Fail In Exception OFXAbortedException catched but text not correct! Got instead: \n" + (String)messagesInProblems + " \n");
            }
            if (!__FailIn_catched) {
                throw new OFXTestSuitException("'Services.Some checks on Fail-In: condition with text handled correctly.': Fail In Exception 'OFXAbortedException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
            }
        }
        catch (Throwable t) {
            try {
                throw new RuntimeException(t);
            }
            catch (Throwable throwable) {
                if (!__FailIn_catched && __FailIn_origThrowable == null) {
                    throw new OFXTestSuitException("'Services.Some checks on Fail-In: condition with text handled correctly.': Fail In Exception OFXAbortedException was NOT catched!");
                }
                if (__FailIn_catched && !__FailIn_text) {
                    throw new OFXTestSuitException("'Services.Some checks on Fail-In: condition with text handled correctly.': Fail In Exception OFXAbortedException catched but text not correct! Got instead: \n" + (String)messagesInProblems + " \n");
                }
                if (!__FailIn_catched) {
                    throw new OFXTestSuitException("'Services.Some checks on Fail-In: condition with text handled correctly.': Fail In Exception 'OFXAbortedException' was not catched, instead \n" + OFXConsoleHelper.stackTrace2String((Throwable)__FailIn_origThrowable));
                }
                throw throwable;
            }
        }
    }

    @OFXTestMethod(id=33, name="Strange behaviour of JAVA 11 on short local date printing. ", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_33(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Locale l = Locale.getDefault();
        String operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new Object[]{new DateTime().withDate(1980, 1, 27)});
        String param0 = "Jan";
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.endsWith(param0)) {
            throw new OFXTestSuitException("'Services.Strange behaviour of JAVA 11 on short local date printing. ': '%sld'.endsWith(\"Jan\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") \n");
        }
        operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new Object[]{new DateTime().withDate(1980, 2, 27)});
        param0 = "Feb";
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.endsWith(param0)) {
            throw new OFXTestSuitException("'Services.Strange behaviour of JAVA 11 on short local date printing. ': '%sld'.endsWith(\"Feb\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") \n");
        }
        operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new Object[]{new DateTime().withDate(1980, 3, 27)});
        param0 = "M\u00e4r";
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.endsWith(param0)) {
            throw new OFXTestSuitException("'Services.Strange behaviour of JAVA 11 on short local date printing. ': '%sld'.endsWith(\"M\u00e4r\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") \n");
        }
        operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new Object[]{new DateTime().withDate(1980, 4, 27)});
        param0 = "Apr";
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.endsWith(param0)) {
            throw new OFXTestSuitException("'Services.Strange behaviour of JAVA 11 on short local date printing. ': '%sld'.endsWith(\"Apr\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") \n");
        }
        operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new Object[]{new DateTime().withDate(1980, 5, 27)});
        param0 = "Mai";
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.endsWith(param0)) {
            throw new OFXTestSuitException("'Services.Strange behaviour of JAVA 11 on short local date printing. ': '%sld'.endsWith(\"Mai\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") \n");
        }
        operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new Object[]{new DateTime().withDate(1980, 6, 27)});
        param0 = "Jun";
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.endsWith(param0)) {
            throw new OFXTestSuitException("'Services.Strange behaviour of JAVA 11 on short local date printing. ': '%sld'.endsWith(\"Jun\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") \n");
        }
        operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new Object[]{new DateTime().withDate(1980, 7, 27)});
        param0 = "Jul";
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.endsWith(param0)) {
            throw new OFXTestSuitException("'Services.Strange behaviour of JAVA 11 on short local date printing. ': '%sld'.endsWith(\"Jul\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") \n");
        }
        operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new Object[]{new DateTime().withDate(1980, 8, 27)});
        param0 = "Aug";
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.endsWith(param0)) {
            throw new OFXTestSuitException("'Services.Strange behaviour of JAVA 11 on short local date printing. ': '%sld'.endsWith(\"Aug\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") \n");
        }
        operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new Object[]{new DateTime().withDate(1980, 9, 27)});
        param0 = "Sep";
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.endsWith(param0)) {
            throw new OFXTestSuitException("'Services.Strange behaviour of JAVA 11 on short local date printing. ': '%sld'.endsWith(\"Sep\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") \n");
        }
        operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new Object[]{new DateTime().withDate(1980, 10, 27)});
        param0 = "Okt";
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.endsWith(param0)) {
            throw new OFXTestSuitException("'Services.Strange behaviour of JAVA 11 on short local date printing. ': '%sld'.endsWith(\"Okt\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") \n");
        }
        operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new Object[]{new DateTime().withDate(1980, 11, 27)});
        param0 = "Nov";
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.endsWith(param0)) {
            throw new OFXTestSuitException("'Services.Strange behaviour of JAVA 11 on short local date printing. ': '%sld'.endsWith(\"Nov\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") \n");
        }
        operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new Object[]{new DateTime().withDate(1980, 12, 27)});
        param0 = "Dez";
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.endsWith(param0)) {
            throw new OFXTestSuitException("'Services.Strange behaviour of JAVA 11 on short local date printing. ': '%sld'.endsWith(\"Dez\")          ==>> '" + operand + "'.endsWith(" + textRepresentation + ") \n");
        }
    }

    @OFXTestMethod(id=34, name="Handling of null in OFXStringFormatter 2", debug=false, enabled=true, runAt="1/27/1980 4:30:0")
    public void __testmethod_34(IOFXSession __manMapSession, IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler) throws Exception {
        Object bd = null;
        Object dt = null;
        Object status = null;
        Object ld = null;
        Object intVal = null;
        Object floatVal = null;
        String operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%bd", new Object[]{bd});
        String param0 = this.NULL_STRING;
        StringBuilder textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.contains(param0)) {
            throw new OFXTestSuitException("'Services.Handling of null in OFXStringFormatter 2': '%bd'.contains( NULL_STRING )          ==>> '" + operand + "'.contains(" + textRepresentation + ") \n");
        }
        operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%dt", new Object[]{dt});
        param0 = this.NULL_STRING;
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.contains(param0)) {
            throw new OFXTestSuitException("'Services.Handling of null in OFXStringFormatter 2': '%dt'.contains( NULL_STRING )          ==>> '" + operand + "'.contains(" + textRepresentation + ") \n");
        }
        operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%tdt", new Object[]{dt});
        param0 = this.NULL_STRING;
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.contains(param0)) {
            throw new OFXTestSuitException("'Services.Handling of null in OFXStringFormatter 2': '%tdt'.contains( NULL_STRING )          ==>> '" + operand + "'.contains(" + textRepresentation + ") \n");
        }
        operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%ld", new Object[]{ld});
        param0 = this.NULL_STRING;
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.contains(param0)) {
            throw new OFXTestSuitException("'Services.Handling of null in OFXStringFormatter 2': '%ld'.contains( NULL_STRING )          ==>> '" + operand + "'.contains(" + textRepresentation + ") \n");
        }
        operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sld", new Object[]{ld});
        param0 = this.NULL_STRING;
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.contains(param0)) {
            throw new OFXTestSuitException("'Services.Handling of null in OFXStringFormatter 2': '%sld'.contains( NULL_STRING )          ==>> '" + operand + "'.contains(" + textRepresentation + ") \n");
        }
        operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%st", new Object[]{status});
        param0 = this.NULL_STRING;
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.contains(param0)) {
            throw new OFXTestSuitException("'Services.Handling of null in OFXStringFormatter 2': '%st'.contains( NULL_STRING )          ==>> '" + operand + "'.contains(" + textRepresentation + ") \n");
        }
        operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%sts", new Object[]{status});
        param0 = this.NULL_STRING;
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.contains(param0)) {
            throw new OFXTestSuitException("'Services.Handling of null in OFXStringFormatter 2': '%sts'.contains( NULL_STRING )          ==>> '" + operand + "'.contains(" + textRepresentation + ") \n");
        }
        operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%stdb", new Object[]{status});
        param0 = this.NULL_STRING;
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.contains(param0)) {
            throw new OFXTestSuitException("'Services.Handling of null in OFXStringFormatter 2': '%stdb'.contains( NULL_STRING )          ==>> '" + operand + "'.contains(" + textRepresentation + ") \n");
        }
        operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%d", new Object[]{intVal});
        param0 = this.NULL_STRING;
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.contains(param0)) {
            throw new OFXTestSuitException("'Services.Handling of null in OFXStringFormatter 2': '%d'.contains( NULL_STRING )          ==>> '" + operand + "'.contains(" + textRepresentation + ") \n");
        }
        operand = this.__runtimeIOFXTranslationProvider.translate(__manMapSession.getUserEnvironment().getLangIndex(), "%f", new Object[]{bd});
        param0 = this.NULL_STRING;
        textRepresentation = new StringBuilder();
        textRepresentation.append(param0 + ", ");
        textRepresentation.setLength(textRepresentation.length() - 2);
        if (!operand.contains(param0)) {
            throw new OFXTestSuitException("'Services.Handling of null in OFXStringFormatter 2': '%f'.contains( NULL_STRING )          ==>> '" + operand + "'.contains(" + textRepresentation + ") \n");
        }
    }

    public void onShutdown(IOFXTestSuit.IOFXTestSuitHandler __testSuitHandler, IOFXSession __manMapSession) {
    }

    public static void main(String[] args) {
        String[] allIncludedTest = new String[]{"org.modellwerkstatt.objectflow.tests.manmap.Tests.DBinit"};
        String[] includedTestToRun = new String[]{};
        OFXTestSuit.runAsMain((String)"org/modellwerkstatt/objectflow/tests/config/MPreisLolaCONFIG.xml", Services.class, (String[])allIncludedTest, (String[])includedTestToRun);
    }
}

