/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.tests.OrderDocument;

import java.math.BigDecimal;
import jetbrains.mps.references.Reference;
import org.modellwerkstatt.objectflow.runtime.IOFXMeta4Object;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaLength;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaRangeScale;
import org.modellwerkstatt.objectflow.runtime.IOFXRevertableObject;
import org.modellwerkstatt.objectflow.runtime.IOFXValueObject;
import org.modellwerkstatt.objectflow.runtime.OFXBigDecimal;
import org.modellwerkstatt.objectflow.runtime.OFXString;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;

public class MonetaryValue
implements IOFXValueObject<MonetaryValue>,
IOFXMeta4Object,
IOFXRevertableObject {
    protected boolean _enabled = true;
    protected OFXBigDecimal amount = new OFXBigDecimal();
    protected OFXString currency = new OFXString();

    public void setEnabled(boolean value) {
        this._enabled = value;
    }

    public boolean getEnabled() {
        return this._enabled;
    }

    public MonetaryValue _META() {
        return this;
    }

    public BigDecimal getAmount() {
        return this.amount.getValue();
    }

    private void _setAmount(BigDecimal value) {
        if (this.amount.setValue(value)) {
            // empty if block
        }
    }

    public BigDecimal setAmount(BigDecimal value) {
        this._setAmount(value);
        return value;
    }

    public Reference<BigDecimal> refToAmount() {
        return new Reference<BigDecimal>(){

            public BigDecimal get() {
                return MonetaryValue.this.getAmount();
            }

            public void set(BigDecimal value) {
                MonetaryValue.this._setAmount(value);
            }
        };
    }

    public String getCurrency() {
        return this.currency.getValue();
    }

    private void _setCurrency(String value) {
        if (this.currency.setValue(value)) {
            // empty if block
        }
    }

    public String setCurrency(String value) {
        this._setCurrency(value);
        return value;
    }

    public Reference<String> refToCurrency() {
        return new Reference<String>(){

            public String get() {
                return MonetaryValue.this.getCurrency();
            }

            public void set(String value) {
                MonetaryValue.this._setCurrency(value);
            }
        };
    }

    public MonetaryValue() {
    }

    public MonetaryValue(BigDecimal amnt) {
        this.setAmount(amnt);
        this.setCurrency("EUR");
    }

    public MonetaryValue(BigDecimal amnt, String cur) {
        this.setAmount(amnt);
        this.setCurrency(cur);
    }

    public MonetaryValue withAmount(BigDecimal val) {
        return new MonetaryValue(val, this.getCurrency());
    }

    public MonetaryValue withCurrency(String cur) {
        return new MonetaryValue(this.getAmount(), cur);
    }

    public IOFXMetaRangeScale<BigDecimal> getAmount_META() {
        return this.amount;
    }

    public IOFXMetaLength<String> getCurrency_META() {
        return this.currency;
    }

    public boolean isNullKey() {
        boolean isNullKey = true;
        isNullKey &= this.currency.getValue() == null || this.currency.getValue().equals("");
        return isNullKey &= this.amount.getValue() == null;
    }

    public MonetaryValue createNullKey() {
        MonetaryValue nullKey = new MonetaryValue();
        nullKey.currency.setValue("");
        nullKey.amount.setValue(null);
        return nullKey;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MonetaryValue)) {
            return false;
        }
        MonetaryValue that = (MonetaryValue)object;
        boolean result = true;
        result &= SaveObjectComperator.equalsBigDecimal((BigDecimal)this.amount.getValue(), (BigDecimal)that.amount.getValue());
        return result &= SaveObjectComperator.equals((Object)this.currency.getValue(), (Object)that.currency.getValue());
    }

    public int hashCode() {
        int result = 17;
        result = this.currency.getValue() != null ? 37 * result + this.currency.getValue().hashCode() : 37 * result;
        result = this.amount.getValue() != null ? 37 * result + this.amount.getValue().stripTrailingZeros().hashCode() : 37 * result;
        return result;
    }

    public String toString() {
        Object result = "MonetaryValue  ";
        result = (String)result + this.amount.getValue() + " ";
        result = (String)result + this.currency.getValue() + " ";
        return result;
    }

    public void load(IOFXRevertableObject param, boolean fullRevertNotMerge) {
        MonetaryValue val = (MonetaryValue)param;
        this.amount.load(val.amount, fullRevertNotMerge);
        this.currency.load(val.currency, fullRevertNotMerge);
        if (fullRevertNotMerge) {
            this._enabled = val._enabled;
        }
    }

    public MonetaryValue copy() {
        MonetaryValue valueObject = new MonetaryValue();
        valueObject.amount = this.amount.copy();
        valueObject.currency = this.currency.copy();
        valueObject._enabled = this._enabled;
        return valueObject;
    }
}

